/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.base.Function;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdUniqueKeys;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class HiveRelMdUniqueKeys {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.UNIQUE_KEYS.method, (Object)new HiveRelMdUniqueKeys());

    public Set<ImmutableBitSet> getUniqueKeys(Project rel, boolean ignoreNulls) {
        HiveTableScan tScan = HiveRelMdUniqueKeys.getTableScan(rel.getInput(), false);
        if (tScan == null) {
            Function fn = RelMdUniqueKeys.SOURCE.apply(rel.getClass(), BuiltInMetadata.UniqueKeys.class);
            return ((BuiltInMetadata.UniqueKeys)fn.apply((Object)rel)).getUniqueKeys(ignoreNulls);
        }
        HashMap<Integer, Integer> posMap = new HashMap<Integer, Integer>();
        int projectPos = 0;
        int colStatsPos = 0;
        BitSet projectedCols = new BitSet();
        for (RexNode r : rel.getProjects()) {
            if (r instanceof RexInputRef) {
                projectedCols.set(((RexInputRef)r).getIndex());
                posMap.put(colStatsPos, projectPos);
                ++colStatsPos;
            }
            ++projectPos;
        }
        double numRows = tScan.getRows();
        List<ColStatistics> colStats = tScan.getColStat((List<Integer>)BitSets.toList((BitSet)projectedCols));
        HashSet<ImmutableBitSet> keys = new HashSet<ImmutableBitSet>();
        colStatsPos = 0;
        for (ColStatistics cStat : colStats) {
            boolean isKey = false;
            if ((double)cStat.getCountDistint() >= numRows) {
                isKey = true;
            }
            if (!isKey && cStat.getRange() != null && cStat.getRange().maxValue != null && cStat.getRange().minValue != null) {
                double r = cStat.getRange().maxValue.doubleValue() - cStat.getRange().minValue.doubleValue() + 1.0;
                boolean bl = isKey = Math.abs(numRows - r) < 1.0E-5;
            }
            if (isKey) {
                ImmutableBitSet key = ImmutableBitSet.of((int[])new int[]{(Integer)posMap.get(colStatsPos)});
                keys.add(key);
            }
            ++colStatsPos;
        }
        return keys;
    }

    static HiveTableScan getTableScan(RelNode r, boolean traverseProject) {
        while (r != null && !(r instanceof HiveTableScan)) {
            if (r instanceof HepRelVertex) {
                r = ((HepRelVertex)r).getCurrentRel();
                continue;
            }
            if (r instanceof Filter) {
                r = ((Filter)r).getInput();
                continue;
            }
            if (traverseProject && r instanceof Project) {
                r = ((Project)r).getInput();
                continue;
            }
            r = null;
        }
        return r == null ? null : (HiveTableScan)r;
    }
}

