/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
@InterfaceStability.Evolving
public final class HiveAuthzContext {
    private final String userIpAddress;
    private final String commandString;

    private HiveAuthzContext(Builder builder) {
        this.userIpAddress = builder.userIpAddress;
        this.commandString = builder.commandString;
    }

    public String getIpAddress() {
        return this.userIpAddress;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public String toString() {
        return "HiveAuthzContext [userIpAddress=" + this.userIpAddress + ", commandString=" + this.commandString + "]";
    }

    public static class Builder {
        private String userIpAddress;
        private String commandString;

        public String getUserIpAddress() {
            return this.userIpAddress;
        }

        public void setUserIpAddress(String userIpAddress) {
            this.userIpAddress = userIpAddress;
        }

        public String getCommandString() {
            return this.commandString;
        }

        public void setCommandString(String commandString) {
            this.commandString = commandString;
        }

        public HiveAuthzContext build() {
            return new HiveAuthzContext(this);
        }
    }
}

