/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class Table
implements TBase<Table, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Table");
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField OWNER_FIELD_DESC = new TField("owner", 11, 3);
    private static final TField CREATE_TIME_FIELD_DESC = new TField("createTime", 8, 4);
    private static final TField LAST_ACCESS_TIME_FIELD_DESC = new TField("lastAccessTime", 8, 5);
    private static final TField RETENTION_FIELD_DESC = new TField("retention", 8, 6);
    private static final TField SD_FIELD_DESC = new TField("sd", 12, 7);
    private static final TField PARTITION_KEYS_FIELD_DESC = new TField("partitionKeys", 15, 8);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 9);
    private static final TField VIEW_ORIGINAL_TEXT_FIELD_DESC = new TField("viewOriginalText", 11, 10);
    private static final TField VIEW_EXPANDED_TEXT_FIELD_DESC = new TField("viewExpandedText", 11, 11);
    private static final TField TABLE_TYPE_FIELD_DESC = new TField("tableType", 11, 12);
    private static final TField PRIVILEGES_FIELD_DESC = new TField("privileges", 12, 13);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String tableName;
    private String dbName;
    private String owner;
    private int createTime;
    private int lastAccessTime;
    private int retention;
    private StorageDescriptor sd;
    private List<FieldSchema> partitionKeys;
    private Map<String, String> parameters;
    private String viewOriginalText;
    private String viewExpandedText;
    private String tableType;
    private PrincipalPrivilegeSet privileges;
    private static final int __CREATETIME_ISSET_ID = 0;
    private static final int __LASTACCESSTIME_ISSET_ID = 1;
    private static final int __RETENTION_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private _Fields[] optionals = new _Fields[]{_Fields.PRIVILEGES};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Table() {
    }

    public Table(String tableName, String dbName, String owner, int createTime, int lastAccessTime, int retention, StorageDescriptor sd, List<FieldSchema> partitionKeys, Map<String, String> parameters, String viewOriginalText, String viewExpandedText, String tableType) {
        this();
        this.tableName = tableName;
        this.dbName = dbName;
        this.owner = owner;
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
        this.retention = retention;
        this.setRetentionIsSet(true);
        this.sd = sd;
        this.partitionKeys = partitionKeys;
        this.parameters = parameters;
        this.viewOriginalText = viewOriginalText;
        this.viewExpandedText = viewExpandedText;
        this.tableType = tableType;
    }

    public Table(Table other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetOwner()) {
            this.owner = other.owner;
        }
        this.createTime = other.createTime;
        this.lastAccessTime = other.lastAccessTime;
        this.retention = other.retention;
        if (other.isSetSd()) {
            this.sd = new StorageDescriptor(other.sd);
        }
        if (other.isSetPartitionKeys()) {
            ArrayList<FieldSchema> __this__partitionKeys = new ArrayList<FieldSchema>();
            for (FieldSchema fieldSchema : other.partitionKeys) {
                __this__partitionKeys.add(new FieldSchema(fieldSchema));
            }
            this.partitionKeys = __this__partitionKeys;
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>();
            for (Map.Entry entry : other.parameters.entrySet()) {
                String other_element_key = (String)entry.getKey();
                String other_element_value = (String)entry.getValue();
                String __this__parameters_copy_key = other_element_key;
                String __this__parameters_copy_value = other_element_value;
                __this__parameters.put(__this__parameters_copy_key, __this__parameters_copy_value);
            }
            this.parameters = __this__parameters;
        }
        if (other.isSetViewOriginalText()) {
            this.viewOriginalText = other.viewOriginalText;
        }
        if (other.isSetViewExpandedText()) {
            this.viewExpandedText = other.viewExpandedText;
        }
        if (other.isSetTableType()) {
            this.tableType = other.tableType;
        }
        if (other.isSetPrivileges()) {
            this.privileges = new PrincipalPrivilegeSet(other.privileges);
        }
    }

    public Table deepCopy() {
        return new Table(this);
    }

    public void clear() {
        this.tableName = null;
        this.dbName = null;
        this.owner = null;
        this.setCreateTimeIsSet(false);
        this.createTime = 0;
        this.setLastAccessTimeIsSet(false);
        this.lastAccessTime = 0;
        this.setRetentionIsSet(false);
        this.retention = 0;
        this.sd = null;
        this.partitionKeys = null;
        this.parameters = null;
        this.viewOriginalText = null;
        this.viewExpandedText = null;
        this.tableType = null;
        this.privileges = null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void unsetOwner() {
        this.owner = null;
    }

    public boolean isSetOwner() {
        return this.owner != null;
    }

    public void setOwnerIsSet(boolean value) {
        if (!value) {
            this.owner = null;
        }
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(int createTime) {
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
    }

    public void unsetCreateTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetCreateTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setCreateTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
    }

    public void unsetLastAccessTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetLastAccessTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setLastAccessTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getRetention() {
        return this.retention;
    }

    public void setRetention(int retention) {
        this.retention = retention;
        this.setRetentionIsSet(true);
    }

    public void unsetRetention() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetRetention() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setRetentionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public StorageDescriptor getSd() {
        return this.sd;
    }

    public void setSd(StorageDescriptor sd) {
        this.sd = sd;
    }

    public void unsetSd() {
        this.sd = null;
    }

    public boolean isSetSd() {
        return this.sd != null;
    }

    public void setSdIsSet(boolean value) {
        if (!value) {
            this.sd = null;
        }
    }

    public int getPartitionKeysSize() {
        return this.partitionKeys == null ? 0 : this.partitionKeys.size();
    }

    public Iterator<FieldSchema> getPartitionKeysIterator() {
        return this.partitionKeys == null ? null : this.partitionKeys.iterator();
    }

    public void addToPartitionKeys(FieldSchema elem) {
        if (this.partitionKeys == null) {
            this.partitionKeys = new ArrayList<FieldSchema>();
        }
        this.partitionKeys.add(elem);
    }

    public List<FieldSchema> getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(List<FieldSchema> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public void unsetPartitionKeys() {
        this.partitionKeys = null;
    }

    public boolean isSetPartitionKeys() {
        return this.partitionKeys != null;
    }

    public void setPartitionKeysIsSet(boolean value) {
        if (!value) {
            this.partitionKeys = null;
        }
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, val);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setParametersIsSet(boolean value) {
        if (!value) {
            this.parameters = null;
        }
    }

    public String getViewOriginalText() {
        return this.viewOriginalText;
    }

    public void setViewOriginalText(String viewOriginalText) {
        this.viewOriginalText = viewOriginalText;
    }

    public void unsetViewOriginalText() {
        this.viewOriginalText = null;
    }

    public boolean isSetViewOriginalText() {
        return this.viewOriginalText != null;
    }

    public void setViewOriginalTextIsSet(boolean value) {
        if (!value) {
            this.viewOriginalText = null;
        }
    }

    public String getViewExpandedText() {
        return this.viewExpandedText;
    }

    public void setViewExpandedText(String viewExpandedText) {
        this.viewExpandedText = viewExpandedText;
    }

    public void unsetViewExpandedText() {
        this.viewExpandedText = null;
    }

    public boolean isSetViewExpandedText() {
        return this.viewExpandedText != null;
    }

    public void setViewExpandedTextIsSet(boolean value) {
        if (!value) {
            this.viewExpandedText = null;
        }
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void unsetTableType() {
        this.tableType = null;
    }

    public boolean isSetTableType() {
        return this.tableType != null;
    }

    public void setTableTypeIsSet(boolean value) {
        if (!value) {
            this.tableType = null;
        }
    }

    public PrincipalPrivilegeSet getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(PrincipalPrivilegeSet privileges) {
        this.privileges = privileges;
    }

    public void unsetPrivileges() {
        this.privileges = null;
    }

    public boolean isSetPrivileges() {
        return this.privileges != null;
    }

    public void setPrivilegesIsSet(boolean value) {
        if (!value) {
            this.privileges = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TABLE_NAME: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case OWNER: {
                if (value == null) {
                    this.unsetOwner();
                    break;
                }
                this.setOwner((String)value);
                break;
            }
            case CREATE_TIME: {
                if (value == null) {
                    this.unsetCreateTime();
                    break;
                }
                this.setCreateTime((Integer)value);
                break;
            }
            case LAST_ACCESS_TIME: {
                if (value == null) {
                    this.unsetLastAccessTime();
                    break;
                }
                this.setLastAccessTime((Integer)value);
                break;
            }
            case RETENTION: {
                if (value == null) {
                    this.unsetRetention();
                    break;
                }
                this.setRetention((Integer)value);
                break;
            }
            case SD: {
                if (value == null) {
                    this.unsetSd();
                    break;
                }
                this.setSd((StorageDescriptor)value);
                break;
            }
            case PARTITION_KEYS: {
                if (value == null) {
                    this.unsetPartitionKeys();
                    break;
                }
                this.setPartitionKeys((List)value);
                break;
            }
            case PARAMETERS: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
                break;
            }
            case VIEW_ORIGINAL_TEXT: {
                if (value == null) {
                    this.unsetViewOriginalText();
                    break;
                }
                this.setViewOriginalText((String)value);
                break;
            }
            case VIEW_EXPANDED_TEXT: {
                if (value == null) {
                    this.unsetViewExpandedText();
                    break;
                }
                this.setViewExpandedText((String)value);
                break;
            }
            case TABLE_TYPE: {
                if (value == null) {
                    this.unsetTableType();
                    break;
                }
                this.setTableType((String)value);
                break;
            }
            case PRIVILEGES: {
                if (value == null) {
                    this.unsetPrivileges();
                    break;
                }
                this.setPrivileges((PrincipalPrivilegeSet)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE_NAME: {
                return this.getTableName();
            }
            case DB_NAME: {
                return this.getDbName();
            }
            case OWNER: {
                return this.getOwner();
            }
            case CREATE_TIME: {
                return this.getCreateTime();
            }
            case LAST_ACCESS_TIME: {
                return this.getLastAccessTime();
            }
            case RETENTION: {
                return this.getRetention();
            }
            case SD: {
                return this.getSd();
            }
            case PARTITION_KEYS: {
                return this.getPartitionKeys();
            }
            case PARAMETERS: {
                return this.getParameters();
            }
            case VIEW_ORIGINAL_TEXT: {
                return this.getViewOriginalText();
            }
            case VIEW_EXPANDED_TEXT: {
                return this.getViewExpandedText();
            }
            case TABLE_TYPE: {
                return this.getTableType();
            }
            case PRIVILEGES: {
                return this.getPrivileges();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE_NAME: {
                return this.isSetTableName();
            }
            case DB_NAME: {
                return this.isSetDbName();
            }
            case OWNER: {
                return this.isSetOwner();
            }
            case CREATE_TIME: {
                return this.isSetCreateTime();
            }
            case LAST_ACCESS_TIME: {
                return this.isSetLastAccessTime();
            }
            case RETENTION: {
                return this.isSetRetention();
            }
            case SD: {
                return this.isSetSd();
            }
            case PARTITION_KEYS: {
                return this.isSetPartitionKeys();
            }
            case PARAMETERS: {
                return this.isSetParameters();
            }
            case VIEW_ORIGINAL_TEXT: {
                return this.isSetViewOriginalText();
            }
            case VIEW_EXPANDED_TEXT: {
                return this.isSetViewExpandedText();
            }
            case TABLE_TYPE: {
                return this.isSetTableType();
            }
            case PRIVILEGES: {
                return this.isSetPrivileges();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Table) {
            return this.equals((Table)that);
        }
        return false;
    }

    public boolean equals(Table that) {
        if (that == null) {
            return false;
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_owner = this.isSetOwner();
        boolean that_present_owner = that.isSetOwner();
        if (this_present_owner || that_present_owner) {
            if (!this_present_owner || !that_present_owner) {
                return false;
            }
            if (!this.owner.equals(that.owner)) {
                return false;
            }
        }
        boolean this_present_createTime = true;
        boolean that_present_createTime = true;
        if (this_present_createTime || that_present_createTime) {
            if (!this_present_createTime || !that_present_createTime) {
                return false;
            }
            if (this.createTime != that.createTime) {
                return false;
            }
        }
        boolean this_present_lastAccessTime = true;
        boolean that_present_lastAccessTime = true;
        if (this_present_lastAccessTime || that_present_lastAccessTime) {
            if (!this_present_lastAccessTime || !that_present_lastAccessTime) {
                return false;
            }
            if (this.lastAccessTime != that.lastAccessTime) {
                return false;
            }
        }
        boolean this_present_retention = true;
        boolean that_present_retention = true;
        if (this_present_retention || that_present_retention) {
            if (!this_present_retention || !that_present_retention) {
                return false;
            }
            if (this.retention != that.retention) {
                return false;
            }
        }
        boolean this_present_sd = this.isSetSd();
        boolean that_present_sd = that.isSetSd();
        if (this_present_sd || that_present_sd) {
            if (!this_present_sd || !that_present_sd) {
                return false;
            }
            if (!this.sd.equals(that.sd)) {
                return false;
            }
        }
        boolean this_present_partitionKeys = this.isSetPartitionKeys();
        boolean that_present_partitionKeys = that.isSetPartitionKeys();
        if (this_present_partitionKeys || that_present_partitionKeys) {
            if (!this_present_partitionKeys || !that_present_partitionKeys) {
                return false;
            }
            if (!((Object)this.partitionKeys).equals(that.partitionKeys)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!((Object)this.parameters).equals(that.parameters)) {
                return false;
            }
        }
        boolean this_present_viewOriginalText = this.isSetViewOriginalText();
        boolean that_present_viewOriginalText = that.isSetViewOriginalText();
        if (this_present_viewOriginalText || that_present_viewOriginalText) {
            if (!this_present_viewOriginalText || !that_present_viewOriginalText) {
                return false;
            }
            if (!this.viewOriginalText.equals(that.viewOriginalText)) {
                return false;
            }
        }
        boolean this_present_viewExpandedText = this.isSetViewExpandedText();
        boolean that_present_viewExpandedText = that.isSetViewExpandedText();
        if (this_present_viewExpandedText || that_present_viewExpandedText) {
            if (!this_present_viewExpandedText || !that_present_viewExpandedText) {
                return false;
            }
            if (!this.viewExpandedText.equals(that.viewExpandedText)) {
                return false;
            }
        }
        boolean this_present_tableType = this.isSetTableType();
        boolean that_present_tableType = that.isSetTableType();
        if (this_present_tableType || that_present_tableType) {
            if (!this_present_tableType || !that_present_tableType) {
                return false;
            }
            if (!this.tableType.equals(that.tableType)) {
                return false;
            }
        }
        boolean this_present_privileges = this.isSetPrivileges();
        boolean that_present_privileges = that.isSetPrivileges();
        if (this_present_privileges || that_present_privileges) {
            if (!this_present_privileges || !that_present_privileges) {
                return false;
            }
            if (!this.privileges.equals(that.privileges)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_tableName = this.isSetTableName();
        builder.append(present_tableName);
        if (present_tableName) {
            builder.append((Object)this.tableName);
        }
        boolean present_dbName = this.isSetDbName();
        builder.append(present_dbName);
        if (present_dbName) {
            builder.append((Object)this.dbName);
        }
        boolean present_owner = this.isSetOwner();
        builder.append(present_owner);
        if (present_owner) {
            builder.append((Object)this.owner);
        }
        boolean present_createTime = true;
        builder.append(present_createTime);
        if (present_createTime) {
            builder.append(this.createTime);
        }
        boolean present_lastAccessTime = true;
        builder.append(present_lastAccessTime);
        if (present_lastAccessTime) {
            builder.append(this.lastAccessTime);
        }
        boolean present_retention = true;
        builder.append(present_retention);
        if (present_retention) {
            builder.append(this.retention);
        }
        boolean present_sd = this.isSetSd();
        builder.append(present_sd);
        if (present_sd) {
            builder.append((Object)this.sd);
        }
        boolean present_partitionKeys = this.isSetPartitionKeys();
        builder.append(present_partitionKeys);
        if (present_partitionKeys) {
            builder.append(this.partitionKeys);
        }
        boolean present_parameters = this.isSetParameters();
        builder.append(present_parameters);
        if (present_parameters) {
            builder.append(this.parameters);
        }
        boolean present_viewOriginalText = this.isSetViewOriginalText();
        builder.append(present_viewOriginalText);
        if (present_viewOriginalText) {
            builder.append((Object)this.viewOriginalText);
        }
        boolean present_viewExpandedText = this.isSetViewExpandedText();
        builder.append(present_viewExpandedText);
        if (present_viewExpandedText) {
            builder.append((Object)this.viewExpandedText);
        }
        boolean present_tableType = this.isSetTableType();
        builder.append(present_tableType);
        if (present_tableType) {
            builder.append((Object)this.tableType);
        }
        boolean present_privileges = this.isSetPrivileges();
        builder.append(present_privileges);
        if (present_privileges) {
            builder.append((Object)this.privileges);
        }
        return builder.toHashCode();
    }

    public int compareTo(Table other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        Table typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetTableName()).compareTo(typedOther.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)typedOther.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDbName()).compareTo(typedOther.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)typedOther.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOwner()).compareTo(typedOther.isSetOwner());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwner() && (lastComparison = TBaseHelper.compareTo((String)this.owner, (String)typedOther.owner)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreateTime()).compareTo(typedOther.isSetCreateTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateTime() && (lastComparison = TBaseHelper.compareTo((int)this.createTime, (int)typedOther.createTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLastAccessTime()).compareTo(typedOther.isSetLastAccessTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastAccessTime() && (lastComparison = TBaseHelper.compareTo((int)this.lastAccessTime, (int)typedOther.lastAccessTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRetention()).compareTo(typedOther.isSetRetention());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRetention() && (lastComparison = TBaseHelper.compareTo((int)this.retention, (int)typedOther.retention)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSd()).compareTo(typedOther.isSetSd());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSd() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sd), (Comparable)((Object)typedOther.sd))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPartitionKeys()).compareTo(typedOther.isSetPartitionKeys());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionKeys() && (lastComparison = TBaseHelper.compareTo(this.partitionKeys, typedOther.partitionKeys)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParameters()).compareTo(typedOther.isSetParameters());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParameters() && (lastComparison = TBaseHelper.compareTo(this.parameters, typedOther.parameters)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetViewOriginalText()).compareTo(typedOther.isSetViewOriginalText());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetViewOriginalText() && (lastComparison = TBaseHelper.compareTo((String)this.viewOriginalText, (String)typedOther.viewOriginalText)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetViewExpandedText()).compareTo(typedOther.isSetViewExpandedText());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetViewExpandedText() && (lastComparison = TBaseHelper.compareTo((String)this.viewExpandedText, (String)typedOther.viewExpandedText)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTableType()).compareTo(typedOther.isSetTableType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableType() && (lastComparison = TBaseHelper.compareTo((String)this.tableType, (String)typedOther.tableType)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPrivileges()).compareTo(typedOther.isSetPrivileges());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrivileges() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.privileges), (Comparable)((Object)typedOther.privileges))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Table(");
        boolean first = true;
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("owner:");
        if (this.owner == null) {
            sb.append("null");
        } else {
            sb.append(this.owner);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("createTime:");
        sb.append(this.createTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lastAccessTime:");
        sb.append(this.lastAccessTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("retention:");
        sb.append(this.retention);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sd:");
        if (this.sd == null) {
            sb.append("null");
        } else {
            sb.append(this.sd);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("partitionKeys:");
        if (this.partitionKeys == null) {
            sb.append("null");
        } else {
            sb.append(this.partitionKeys);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("viewOriginalText:");
        if (this.viewOriginalText == null) {
            sb.append("null");
        } else {
            sb.append(this.viewOriginalText);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("viewExpandedText:");
        if (this.viewExpandedText == null) {
            sb.append("null");
        } else {
            sb.append(this.viewExpandedText);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableType:");
        if (this.tableType == null) {
            sb.append("null");
        } else {
            sb.append(this.tableType);
        }
        first = false;
        if (this.isSetPrivileges()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("privileges:");
            if (this.privileges == null) {
                sb.append("null");
            } else {
                sb.append(this.privileges);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.sd != null) {
            this.sd.validate();
        }
        if (this.privileges != null) {
            this.privileges.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TableStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TableTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OWNER, new FieldMetaData("owner", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATE_TIME, new FieldMetaData("createTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.LAST_ACCESS_TIME, new FieldMetaData("lastAccessTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.RETENTION, new FieldMetaData("retention", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SD, new FieldMetaData("sd", 3, (FieldValueMetaData)new StructMetaData(12, StorageDescriptor.class)));
        tmpMap.put(_Fields.PARTITION_KEYS, new FieldMetaData("partitionKeys", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, FieldSchema.class))));
        tmpMap.put(_Fields.PARAMETERS, new FieldMetaData("parameters", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.VIEW_ORIGINAL_TEXT, new FieldMetaData("viewOriginalText", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.VIEW_EXPANDED_TEXT, new FieldMetaData("viewExpandedText", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_TYPE, new FieldMetaData("tableType", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PRIVILEGES, new FieldMetaData("privileges", 2, (FieldValueMetaData)new StructMetaData(12, PrincipalPrivilegeSet.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Table.class, metaDataMap);
    }

    private static class TableTupleScheme
    extends TupleScheme<Table> {
        private TableTupleScheme() {
        }

        public void write(TProtocol prot, Table struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetTableName()) {
                optionals.set(0);
            }
            if (struct.isSetDbName()) {
                optionals.set(1);
            }
            if (struct.isSetOwner()) {
                optionals.set(2);
            }
            if (struct.isSetCreateTime()) {
                optionals.set(3);
            }
            if (struct.isSetLastAccessTime()) {
                optionals.set(4);
            }
            if (struct.isSetRetention()) {
                optionals.set(5);
            }
            if (struct.isSetSd()) {
                optionals.set(6);
            }
            if (struct.isSetPartitionKeys()) {
                optionals.set(7);
            }
            if (struct.isSetParameters()) {
                optionals.set(8);
            }
            if (struct.isSetViewOriginalText()) {
                optionals.set(9);
            }
            if (struct.isSetViewExpandedText()) {
                optionals.set(10);
            }
            if (struct.isSetTableType()) {
                optionals.set(11);
            }
            if (struct.isSetPrivileges()) {
                optionals.set(12);
            }
            oprot.writeBitSet(optionals, 13);
            if (struct.isSetTableName()) {
                oprot.writeString(struct.tableName);
            }
            if (struct.isSetDbName()) {
                oprot.writeString(struct.dbName);
            }
            if (struct.isSetOwner()) {
                oprot.writeString(struct.owner);
            }
            if (struct.isSetCreateTime()) {
                oprot.writeI32(struct.createTime);
            }
            if (struct.isSetLastAccessTime()) {
                oprot.writeI32(struct.lastAccessTime);
            }
            if (struct.isSetRetention()) {
                oprot.writeI32(struct.retention);
            }
            if (struct.isSetSd()) {
                struct.sd.write((TProtocol)oprot);
            }
            if (struct.isSetPartitionKeys()) {
                oprot.writeI32(struct.partitionKeys.size());
                for (FieldSchema fieldSchema : struct.partitionKeys) {
                    fieldSchema.write((TProtocol)oprot);
                }
            }
            if (struct.isSetParameters()) {
                oprot.writeI32(struct.parameters.size());
                for (Map.Entry entry : struct.parameters.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
            if (struct.isSetViewOriginalText()) {
                oprot.writeString(struct.viewOriginalText);
            }
            if (struct.isSetViewExpandedText()) {
                oprot.writeString(struct.viewExpandedText);
            }
            if (struct.isSetTableType()) {
                oprot.writeString(struct.tableType);
            }
            if (struct.isSetPrivileges()) {
                struct.privileges.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, Table struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(13);
            if (incoming.get(0)) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.dbName = iprot.readString();
                struct.setDbNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.owner = iprot.readString();
                struct.setOwnerIsSet(true);
            }
            if (incoming.get(3)) {
                struct.createTime = iprot.readI32();
                struct.setCreateTimeIsSet(true);
            }
            if (incoming.get(4)) {
                struct.lastAccessTime = iprot.readI32();
                struct.setLastAccessTimeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.retention = iprot.readI32();
                struct.setRetentionIsSet(true);
            }
            if (incoming.get(6)) {
                struct.sd = new StorageDescriptor();
                struct.sd.read((TProtocol)iprot);
                struct.setSdIsSet(true);
            }
            if (incoming.get(7)) {
                TList _list185 = new TList(12, iprot.readI32());
                struct.partitionKeys = new ArrayList(_list185.size);
                for (int _i186 = 0; _i186 < _list185.size; ++_i186) {
                    FieldSchema _elem187 = new FieldSchema();
                    _elem187.read((TProtocol)iprot);
                    struct.partitionKeys.add(_elem187);
                }
                struct.setPartitionKeysIsSet(true);
            }
            if (incoming.get(8)) {
                TMap _map188 = new TMap(11, 11, iprot.readI32());
                struct.parameters = new HashMap(2 * _map188.size);
                for (int _i189 = 0; _i189 < _map188.size; ++_i189) {
                    String _key190 = iprot.readString();
                    String _val191 = iprot.readString();
                    struct.parameters.put(_key190, _val191);
                }
                struct.setParametersIsSet(true);
            }
            if (incoming.get(9)) {
                struct.viewOriginalText = iprot.readString();
                struct.setViewOriginalTextIsSet(true);
            }
            if (incoming.get(10)) {
                struct.viewExpandedText = iprot.readString();
                struct.setViewExpandedTextIsSet(true);
            }
            if (incoming.get(11)) {
                struct.tableType = iprot.readString();
                struct.setTableTypeIsSet(true);
            }
            if (incoming.get(12)) {
                struct.privileges = new PrincipalPrivilegeSet();
                struct.privileges.read((TProtocol)iprot);
                struct.setPrivilegesIsSet(true);
            }
        }
    }

    private static class TableTupleSchemeFactory
    implements SchemeFactory {
        private TableTupleSchemeFactory() {
        }

        public TableTupleScheme getScheme() {
            return new TableTupleScheme();
        }
    }

    private static class TableStandardScheme
    extends StandardScheme<Table> {
        private TableStandardScheme() {
        }

        public void read(TProtocol iprot, Table struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.tableName = iprot.readString();
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.owner = iprot.readString();
                            struct.setOwnerIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.createTime = iprot.readI32();
                            struct.setCreateTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.lastAccessTime = iprot.readI32();
                            struct.setLastAccessTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.retention = iprot.readI32();
                            struct.setRetentionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.sd = new StorageDescriptor();
                            struct.sd.read(iprot);
                            struct.setSdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 15) {
                            TList _list174 = iprot.readListBegin();
                            struct.partitionKeys = new ArrayList(_list174.size);
                            for (int _i175 = 0; _i175 < _list174.size; ++_i175) {
                                FieldSchema _elem176 = new FieldSchema();
                                _elem176.read(iprot);
                                struct.partitionKeys.add(_elem176);
                            }
                            iprot.readListEnd();
                            struct.setPartitionKeysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 13) {
                            TMap _map177 = iprot.readMapBegin();
                            struct.parameters = new HashMap(2 * _map177.size);
                            for (int _i178 = 0; _i178 < _map177.size; ++_i178) {
                                String _key179 = iprot.readString();
                                String _val180 = iprot.readString();
                                struct.parameters.put(_key179, _val180);
                            }
                            iprot.readMapEnd();
                            struct.setParametersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.viewOriginalText = iprot.readString();
                            struct.setViewOriginalTextIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.viewExpandedText = iprot.readString();
                            struct.setViewExpandedTextIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.tableType = iprot.readString();
                            struct.setTableTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 12) {
                            struct.privileges = new PrincipalPrivilegeSet();
                            struct.privileges.read(iprot);
                            struct.setPrivilegesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, Table struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.tableName != null) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                oprot.writeString(struct.tableName);
                oprot.writeFieldEnd();
            }
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.owner != null) {
                oprot.writeFieldBegin(OWNER_FIELD_DESC);
                oprot.writeString(struct.owner);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(CREATE_TIME_FIELD_DESC);
            oprot.writeI32(struct.createTime);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(LAST_ACCESS_TIME_FIELD_DESC);
            oprot.writeI32(struct.lastAccessTime);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(RETENTION_FIELD_DESC);
            oprot.writeI32(struct.retention);
            oprot.writeFieldEnd();
            if (struct.sd != null) {
                oprot.writeFieldBegin(SD_FIELD_DESC);
                struct.sd.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.partitionKeys != null) {
                oprot.writeFieldBegin(PARTITION_KEYS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partitionKeys.size()));
                for (FieldSchema fieldSchema : struct.partitionKeys) {
                    fieldSchema.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.parameters != null) {
                oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.parameters.size()));
                for (Map.Entry entry : struct.parameters.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.viewOriginalText != null) {
                oprot.writeFieldBegin(VIEW_ORIGINAL_TEXT_FIELD_DESC);
                oprot.writeString(struct.viewOriginalText);
                oprot.writeFieldEnd();
            }
            if (struct.viewExpandedText != null) {
                oprot.writeFieldBegin(VIEW_EXPANDED_TEXT_FIELD_DESC);
                oprot.writeString(struct.viewExpandedText);
                oprot.writeFieldEnd();
            }
            if (struct.tableType != null) {
                oprot.writeFieldBegin(TABLE_TYPE_FIELD_DESC);
                oprot.writeString(struct.tableType);
                oprot.writeFieldEnd();
            }
            if (struct.privileges != null && struct.isSetPrivileges()) {
                oprot.writeFieldBegin(PRIVILEGES_FIELD_DESC);
                struct.privileges.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TableStandardSchemeFactory
    implements SchemeFactory {
        private TableStandardSchemeFactory() {
        }

        public TableStandardScheme getScheme() {
            return new TableStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE_NAME(1, "tableName"),
        DB_NAME(2, "dbName"),
        OWNER(3, "owner"),
        CREATE_TIME(4, "createTime"),
        LAST_ACCESS_TIME(5, "lastAccessTime"),
        RETENTION(6, "retention"),
        SD(7, "sd"),
        PARTITION_KEYS(8, "partitionKeys"),
        PARAMETERS(9, "parameters"),
        VIEW_ORIGINAL_TEXT(10, "viewOriginalText"),
        VIEW_EXPANDED_TEXT(11, "viewExpandedText"),
        TABLE_TYPE(12, "tableType"),
        PRIVILEGES(13, "privileges");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE_NAME;
                }
                case 2: {
                    return DB_NAME;
                }
                case 3: {
                    return OWNER;
                }
                case 4: {
                    return CREATE_TIME;
                }
                case 5: {
                    return LAST_ACCESS_TIME;
                }
                case 6: {
                    return RETENTION;
                }
                case 7: {
                    return SD;
                }
                case 8: {
                    return PARTITION_KEYS;
                }
                case 9: {
                    return PARAMETERS;
                }
                case 10: {
                    return VIEW_ORIGINAL_TEXT;
                }
                case 11: {
                    return VIEW_EXPANDED_TEXT;
                }
                case 12: {
                    return TABLE_TYPE;
                }
                case 13: {
                    return PRIVILEGES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

