/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.security.UserGroupInformation;

public class WebHCatJTShim23
implements HadoopShims.WebHCatJTShim {
    private JobClient jc;

    public WebHCatJTShim23(Configuration conf, UserGroupInformation ugi) throws IOException {
        this.jc = new JobClient(conf);
    }

    @Override
    public JobProfile getJobProfile(JobID jobid) throws IOException {
        RunningJob rj = this.jc.getJob(jobid);
        JobStatus jobStatus = rj.getJobStatus();
        JobProfile jobProfile = new JobProfile(jobStatus.getUsername(), (org.apache.hadoop.mapreduce.JobID)jobStatus.getJobID(), jobStatus.getJobFile(), jobStatus.getTrackingUrl(), jobStatus.getJobName());
        return jobProfile;
    }

    @Override
    public JobStatus getJobStatus(JobID jobid) throws IOException {
        RunningJob rj = this.jc.getJob(jobid);
        JobStatus jobStatus = rj.getJobStatus();
        return jobStatus;
    }

    @Override
    public void killJob(JobID jobid) throws IOException {
        RunningJob rj = this.jc.getJob(jobid);
        rj.killJob();
    }

    @Override
    public JobStatus[] getAllJobs() throws IOException {
        return this.jc.getAllJobs();
    }

    @Override
    public void close() {
        try {
            this.jc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

