/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.spdx.library.ModelCopyManager;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class DefaultModelStore {
    static IModelStore defaultModelStore = new InMemSpdxStore();
    static String defaultDocumentUri = "http://www.spdx.org/documents/default_doc_uri_for_SPDX_tools";
    static ModelCopyManager defaultCopyManager = new ModelCopyManager();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    private DefaultModelStore() {
    }

    public static IModelStore getDefaultModelStore() {
        return defaultModelStore;
    }

    public static String getDefaultDocumentUri() {
        lock.readLock().lock();
        try {
            String string = defaultDocumentUri;
            return string;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static final void reset() {
        lock.writeLock().lock();
        try {
            if (Objects.nonNull(defaultModelStore)) {
                try {
                    defaultModelStore.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            defaultModelStore = new InMemSpdxStore();
            defaultCopyManager = new ModelCopyManager();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static final void reset(IModelStore newModelStore, String newDefaultDocumentUri, ModelCopyManager newDefaultCopyManager) {
        Objects.requireNonNull(newModelStore, "Model store can not be null");
        Objects.requireNonNull(newDefaultDocumentUri, "Document URI can not be null");
        Objects.requireNonNull(newDefaultCopyManager, "Copy manager can not be null");
        lock.writeLock().lock();
        try {
            defaultModelStore = newModelStore;
            defaultDocumentUri = newDefaultDocumentUri;
            defaultCopyManager = newDefaultCopyManager;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static ModelCopyManager getDefaultCopyManager() {
        lock.readLock().lock();
        try {
            ModelCopyManager modelCopyManager = defaultCopyManager;
            return modelCopyManager;
        }
        finally {
            lock.readLock().unlock();
        }
    }
}

