/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.spdx.library.SpdxConstants;

public class Version {
    public static final String POINT_EIGHT_SPDX_VERSION = "SPDX-0.8";
    public static final String POINT_NINE_SPDX_VERSION = "SPDX-0.9";
    public static final String ONE_DOT_ZERO_SPDX_VERSION = "SPDX-1.0";
    public static final String ONE_DOT_ONE_SPDX_VERSION = "SPDX-1.1";
    public static final String ONE_DOT_TWO_SPDX_VERSION = "SPDX-1.2";
    public static final String TWO_POINT_ZERO_VERSION = "SPDX-2.0";
    public static final String TWO_POINT_ONE_VERSION = "SPDX-2.1";
    public static final String TWO_POINT_TWO_VERSION = "SPDX-2.2";
    public static final String CURRENT_SPDX_VERSION = "SPDX-2.2";
    public static final Set<String> SUPPORTED_SPDX_VERSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SPDX-1.0", "SPDX-1.1", "SPDX-1.2", "SPDX-2.0", "SPDX-2.1", "SPDX-2.2")));
    public static final String CURRENT_IMPLEMENTATION_VERSION = "1.0.8";

    public static String verifySpdxVersion(String spdxVersion) {
        if (!spdxVersion.startsWith("SPDX-")) {
            return "Invalid spdx version - must start with 'SPDX-'";
        }
        Matcher docSpecVersionMatcher = SpdxConstants.SPDX_VERSION_PATTERN.matcher(spdxVersion);
        if (!docSpecVersionMatcher.matches()) {
            return "Invalid spdx version format - must match 'SPDX-M.N'";
        }
        if (!SUPPORTED_SPDX_VERSIONS.contains(spdxVersion)) {
            return "Version " + spdxVersion + " is not supported by this version of the rdf parser";
        }
        return null;
    }

    private Version() {
    }
}

