/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.ModelCollection;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.enumerations.RelationshipType;

public class RelatedElementCollection
implements Collection<SpdxElement> {
    static final Logger logger = LoggerFactory.getLogger(RelatedElementCollection.class);
    ModelCollection<Relationship> relationshipCollection;
    private RelationshipType relationshipTypeFilter;
    private SpdxElement owningElement;

    public RelatedElementCollection(SpdxElement owningElement, @Nullable RelationshipType relationshipTypeFilter) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(owningElement, "Owning element can not be null");
        this.owningElement = owningElement;
        this.relationshipCollection = new ModelCollection(owningElement.getModelStore(), owningElement.getDocumentUri(), owningElement.getId(), "relationship", owningElement.getCopyManager(), Relationship.class);
        this.relationshipTypeFilter = relationshipTypeFilter;
    }

    public List<SpdxElement> toImmutableList() {
        ArrayList<SpdxElement> retval = new ArrayList<SpdxElement>();
        for (Object item : this.relationshipCollection.toImmutableList()) {
            if (!(item instanceof Relationship)) continue;
            Relationship relationship = (Relationship)item;
            try {
                Optional<SpdxElement> relatedElement;
                RelationshipType relationshipType = relationship.getRelationshipType();
                if (!Objects.isNull(this.relationshipTypeFilter) && !this.relationshipTypeFilter.equals(relationshipType) || !(relatedElement = relationship.getRelatedSpdxElement()).isPresent()) continue;
                retval.add(relatedElement.get());
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.warn("error getting relationship type - skipping relationship", (Throwable)e);
            }
        }
        return Collections.unmodifiableList(retval);
    }

    @Override
    public int size() {
        return this.toImmutableList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.toImmutableList().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.toImmutableList().contains(o);
    }

    @Override
    public Iterator<SpdxElement> iterator() {
        return this.toImmutableList().iterator();
    }

    public SpdxElement[] toArray() {
        List<SpdxElement> list = this.toImmutableList();
        return list.toArray(new SpdxElement[list.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toImmutableList().toArray(a);
    }

    @Override
    public boolean add(SpdxElement e) {
        if (Objects.isNull(this.relationshipTypeFilter)) {
            logger.error("Ambiguous relationship type - can not add element");
            throw new RuntimeException("Can not add element to RelatedElementCollection due to ambiguous relationship type.  Add a relationshipTypeFilter to resolve.");
        }
        if (Objects.isNull(e) || this.contains(e)) {
            return false;
        }
        try {
            Relationship relationship = this.owningElement.createRelationship(e, this.relationshipTypeFilter, "");
            return this.owningElement.addRelationship(relationship);
        }
        catch (InvalidSPDXAnalysisException e1) {
            logger.error("Error adding relationship", (Throwable)e1);
            throw new RuntimeException(e1);
        }
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Relationship) {
            return this.relationshipCollection.remove(o);
        }
        if (o instanceof SpdxElement) {
            if (Objects.isNull(this.relationshipTypeFilter)) {
                logger.error("Ambiguous relationship type - can not add element");
                throw new RuntimeException("Can not remove element from RelatedElementCollection due to ambiguous relationship type.  Add a relationshipTypeFilter to resolve.");
            }
            List<Object> relationships = this.relationshipCollection.toImmutableList();
            for (Object rel : relationships) {
                if (!(rel instanceof Relationship)) continue;
                Relationship relationship = (Relationship)rel;
                try {
                    Optional<SpdxElement> relatedElement = relationship.getRelatedSpdxElement();
                    if (!relatedElement.isPresent() || !relatedElement.get().equals(o) || !relationship.getRelationshipType().equals(this.relationshipTypeFilter)) continue;
                    return this.relationshipCollection.remove(relationship);
                }
                catch (InvalidSPDXAnalysisException e) {
                    logger.error("Error getting relationship properties - skipping removal of element", (Throwable)e);
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.toImmutableList().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends SpdxElement> c) {
        boolean modified = false;
        for (SpdxElement spdxElement : c) {
            if (!this.add(spdxElement)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object element : c) {
            if (!this.remove(element)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        List<SpdxElement> existingElements = this.toImmutableList();
        boolean modified = false;
        for (SpdxElement existingElement : existingElements) {
            if (c.contains(existingElement) || !this.remove(existingElement)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        if (Objects.isNull(this.relationshipTypeFilter)) {
            this.relationshipCollection.clear();
        } else {
            List<SpdxElement> existingElements = this.toImmutableList();
            for (SpdxElement existingElement : existingElements) {
                this.remove(existingElement);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RelatedElementCollection)) {
            return false;
        }
        RelatedElementCollection compare = (RelatedElementCollection)o;
        return Objects.equals(this.owningElement, compare.getOwningElement()) && Objects.equals(this.relationshipTypeFilter, compare.getRelationshipTypeFilter());
    }

    @Override
    public int hashCode() {
        if (Objects.isNull(this.relationshipTypeFilter)) {
            return 0x21 ^ this.owningElement.hashCode();
        }
        return 0x21 ^ this.owningElement.hashCode() ^ this.relationshipTypeFilter.hashCode();
    }

    public ModelCollection<Relationship> getRelationshipCollection() {
        return this.relationshipCollection;
    }

    public RelationshipType getRelationshipTypeFilter() {
        return this.relationshipTypeFilter;
    }

    public SpdxElement getOwningElement() {
        return this.owningElement;
    }
}

