/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.ModelObject;
import org.spdx.storage.IModelStore;

public class SpdxCreatorInformation
extends ModelObject {
    public SpdxCreatorInformation() throws InvalidSPDXAnalysisException {
    }

    public SpdxCreatorInformation(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public SpdxCreatorInformation(IModelStore modelStore, String documentUri, String id, ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public Collection<String> getCreators() throws InvalidSPDXAnalysisException {
        return this.getStringCollection("creator");
    }

    public Optional<String> getLicenseListVersion() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("licenseListVersion");
    }

    public SpdxCreatorInformation setLicenseListVersion(String licenseListVersion) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("licenseListVersion", licenseListVersion);
        return this;
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("comment");
    }

    public SpdxCreatorInformation setComment(String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("comment", comment);
        return this;
    }

    public String getCreated() throws InvalidSPDXAnalysisException {
        Optional<String> retval = this.getStringPropertyValue("created");
        if (retval.isPresent()) {
            return retval.get();
        }
        logger.warn("Missing created date");
        return "";
    }

    public SpdxCreatorInformation setCreated(String created) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (Objects.isNull(created)) {
                throw new InvalidSPDXAnalysisException("Can not set required created date to null");
            }
            String verify = SpdxVerificationHelper.verifyDate(created);
            if (Objects.nonNull(verify) && !verify.isEmpty()) {
                throw new InvalidSPDXAnalysisException(verify);
            }
        }
        this.setPropertyValue("created", created);
        return this;
    }

    @Override
    public String getType() {
        return "CreationInfo";
    }

    @Override
    public String toString() {
        Optional<String> comment;
        Optional<String> licenseListVerion;
        String created;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        try {
            for (String creator : this.getCreators()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(creator);
                first = false;
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting creators", (Throwable)e);
        }
        try {
            created = this.getCreated();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting created", (Throwable)e);
            created = "";
        }
        sb.append("; Created on ");
        sb.append(created);
        try {
            licenseListVerion = this.getLicenseListVersion();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting licenseListVerion", (Throwable)e);
            licenseListVerion = Optional.empty();
        }
        if (licenseListVerion.isPresent()) {
            sb.append("; License List Version=");
            sb.append(licenseListVerion.get());
        }
        try {
            comment = this.getComment();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting comment", (Throwable)e);
            comment = Optional.empty();
        }
        if (comment.isPresent()) {
            sb.append("; Comment: ");
            sb.append(comment.get());
        }
        return sb.toString();
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds) {
        String verify;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            int numCreators = 0;
            for (String creator : this.getCreators()) {
                String verify2 = SpdxVerificationHelper.verifyCreator(creator);
                if (verify2 != null) {
                    retval.add(verify2);
                }
                ++numCreators;
            }
            if (numCreators == 0) {
                retval.add("Missing required creators");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting creators: " + e.getMessage());
        }
        try {
            String creationDate = this.getCreated();
            if (creationDate.isEmpty()) {
                retval.add("Missing required created date");
            } else {
                verify = SpdxVerificationHelper.verifyDate(creationDate);
                if (verify != null) {
                    retval.add(verify);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting creation date: " + e.getMessage());
        }
        try {
            Optional<String> licenseListVersion = this.getLicenseListVersion();
            if (licenseListVersion.isPresent() && (verify = this.verifyLicenseListVersion(licenseListVersion.get())) != null) {
                retval.add(verify);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting license list version: " + e.getMessage());
        }
        return retval;
    }

    @Nullable
    private String verifyLicenseListVersion(String version) {
        if (Objects.isNull(version)) {
            return null;
        }
        if (SpdxConstants.LICENSE_LIST_VERSION_PATTERN.matcher(version).matches()) {
            return null;
        }
        return "License list version does not match the pattern M.N";
    }
}

