/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.spdx.library.SpdxConstants;

public class Version {
    public static final String POINT_EIGHT_SPDX_VERSION = "SPDX-0.8";
    public static final String POINT_NINE_SPDX_VERSION = "SPDX-0.9";
    public static final String ONE_DOT_ZERO_SPDX_VERSION = "SPDX-1.0";
    public static final String ONE_DOT_ONE_SPDX_VERSION = "SPDX-1.1";
    public static final String ONE_DOT_TWO_SPDX_VERSION = "SPDX-1.2";
    public static final String TWO_POINT_ZERO_VERSION = "SPDX-2.0";
    public static final String TWO_POINT_ONE_VERSION = "SPDX-2.1";
    public static final String TWO_POINT_TWO_VERSION = "SPDX-2.2";
    public static final String TWO_POINT_THREE_VERSION = "SPDX-2.3";
    public static final String CURRENT_SPDX_VERSION = "SPDX-2.3";
    public static final List<String> SUPPORTED_SPDX_VERSIONS = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("SPDX-1.0", "SPDX-1.1", "SPDX-1.2", "SPDX-2.0", "SPDX-2.1", "SPDX-2.2", "SPDX-2.3")));
    public static final String CURRENT_IMPLEMENTATION_VERSION = "1.1.0";

    public static String verifySpdxVersion(String spdxVersion) {
        if (!spdxVersion.startsWith("SPDX-")) {
            return "Invalid spdx version - must start with 'SPDX-'";
        }
        Matcher docSpecVersionMatcher = SpdxConstants.SPDX_VERSION_PATTERN.matcher(spdxVersion);
        if (!docSpecVersionMatcher.matches()) {
            return "Invalid spdx version format - must match 'SPDX-M.N'";
        }
        if (!SUPPORTED_SPDX_VERSIONS.contains(spdxVersion)) {
            return "Version " + spdxVersion + " is not supported by this version of the rdf parser";
        }
        return null;
    }

    private Version() {
    }

    public static boolean versionLessThan(String specVersion, String compareSpecVersion) {
        int i = SUPPORTED_SPDX_VERSIONS.indexOf(specVersion);
        if (i < 0) {
            return false;
        }
        int j = SUPPORTED_SPDX_VERSIONS.indexOf(compareSpecVersion);
        if (j < 0) {
            return false;
        }
        return i < j;
    }
}

