/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxItem;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.FileType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.storage.IModelStore;

public class SpdxFile
extends SpdxItem
implements Comparable<SpdxFile> {
    Collection<FileType> fileTypes = this.getObjectPropertyValueSet("fileType", FileType.class);
    Collection<Checksum> checksums = this.getObjectPropertyValueSet("checksum", Checksum.class);
    private Collection<String> fileContributors = this.getStringCollection("fileContributor");

    public SpdxFile() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous, DefaultModelStore.getDefaultDocumentUri()));
    }

    public SpdxFile(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    public SpdxFile(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    protected SpdxFile(SpdxFileBuilder spdxFileBuilder) throws InvalidSPDXAnalysisException {
        this(spdxFileBuilder.modelStore, spdxFileBuilder.documentUri, spdxFileBuilder.id, spdxFileBuilder.copyManager, true);
        this.setCopyrightText(spdxFileBuilder.copyrightText);
        this.setName(spdxFileBuilder.name);
        this.setLicenseConcluded(spdxFileBuilder.concludedLicense);
        this.addChecksum(spdxFileBuilder.sha1);
        this.getLicenseInfoFromFiles().addAll(spdxFileBuilder.licenseInfosFromFile);
        this.getAnnotations().addAll(spdxFileBuilder.annotations);
        this.getRelationships().addAll(spdxFileBuilder.relationships);
        this.setComment(spdxFileBuilder.comment);
        this.setLicenseComments(spdxFileBuilder.licenseComments);
        this.getAttributionText().addAll(spdxFileBuilder.attributionText);
        for (Checksum cksum : spdxFileBuilder.checksums) {
            if (cksum.equals(spdxFileBuilder.sha1)) continue;
            this.getChecksums().add(cksum);
        }
        this.getFileContributors().addAll(spdxFileBuilder.fileContributors);
        this.getFileTypes().addAll(spdxFileBuilder.fileTypes);
        this.setNoticeText(spdxFileBuilder.noticeText);
    }

    @Override
    public String getType() {
        return "File";
    }

    public String getSha1() throws InvalidSPDXAnalysisException {
        for (Checksum checksum : this.checksums) {
            if (!checksum.getAlgorithm().equals(ChecksumAlgorithm.SHA1) || checksum.getValue().isEmpty()) continue;
            return checksum.getValue();
        }
        return "";
    }

    @Override
    public SpdxFile setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
        super.setCopyrightText(copyrightText);
        return this;
    }

    @Override
    public SpdxFile setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        if (this.strict && (Objects.isNull(name) || name.isEmpty())) {
            throw new InvalidSPDXAnalysisException("Can not set required name to null or empty");
        }
        super.setName(name);
        return this;
    }

    @Override
    public SpdxFile setLicenseConcluded(@Nullable AnyLicenseInfo license) throws InvalidSPDXAnalysisException {
        super.setLicenseConcluded(license);
        return this;
    }

    @Override
    public SpdxFile setLicenseComments(String licenseComments) throws InvalidSPDXAnalysisException {
        super.setLicenseComments(licenseComments);
        return this;
    }

    @Override
    protected String getLicenseInfoFromFilesPropertyName() {
        return "licenseInfoInFile";
    }

    @Override
    protected String getNamePropertyName() {
        return "fileName";
    }

    public Collection<FileType> getFileTypes() throws InvalidSPDXAnalysisException {
        return this.fileTypes;
    }

    public boolean addFileType(FileType fileType) throws InvalidSPDXAnalysisException {
        return this.fileTypes.add(fileType);
    }

    public Collection<Checksum> getChecksums() {
        return this.checksums;
    }

    public boolean addChecksum(Checksum checksum) throws InvalidSPDXAnalysisException {
        return this.checksums.add(checksum);
    }

    public Collection<String> getFileContributors() {
        return this.fileContributors;
    }

    public boolean addFileContributor(String contributor) {
        if (Objects.nonNull(contributor)) {
            return this.fileContributors.add(contributor);
        }
        return false;
    }

    public Optional<String> getNoticeText() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("noticeText");
    }

    public SpdxFile setNoticeText(@Nullable String noticeText) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("noticeText", noticeText);
        return this;
    }

    @Deprecated
    public Collection<SpdxFile> getFileDependency() throws InvalidSPDXAnalysisException {
        return this.getObjectPropertyValueSet("fileDependency", SpdxFile.class);
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds, String specVersion) {
        List<String> retval = super._verify(verifiedIds, specVersion);
        String fileName = "UNKNOWN";
        try {
            Optional<String> myName = this.getName();
            if (myName.isPresent()) {
                fileName = myName.get();
            } else {
                retval.add("Missing required file name");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting file name");
        }
        for (Checksum checksum : this.checksums) {
            retval.addAll(this.addNameToWarnings(checksum.verify(verifiedIds, specVersion)));
        }
        try {
            String sha1 = this.getSha1();
            if (sha1 == null || sha1.isEmpty()) {
                retval.add("Missing required SHA1 hashcode value for " + fileName);
            } else {
                String warning = SpdxVerificationHelper.verifyChecksumString(sha1, ChecksumAlgorithm.SHA1, specVersion);
                if (warning != null) {
                    retval.add(warning + " for file " + fileName);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting sha1");
        }
        return retval;
    }

    @Override
    public int compareTo(SpdxFile o) {
        String name = "";
        try {
            Optional<String> myName = this.getName();
            if (myName.isPresent()) {
                name = myName.get();
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting my name on compare");
        }
        String compName = "";
        try {
            Optional<String> compareName = o.getName();
            if (compareName.isPresent()) {
                compName = compareName.get();
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting compare name on compare");
        }
        return name.compareTo(compName);
    }

    public static class SpdxFileBuilder {
        IModelStore modelStore;
        String documentUri;
        String id;
        ModelCopyManager copyManager;
        String name;
        AnyLicenseInfo concludedLicense;
        Collection<AnyLicenseInfo> licenseInfosFromFile;
        String copyrightText;
        Checksum sha1;
        Collection<Annotation> annotations = new ArrayList<Annotation>();
        Collection<Relationship> relationships = new ArrayList<Relationship>();
        String comment = null;
        String licenseComments = null;
        Collection<String> attributionText = new ArrayList<String>();
        Collection<Checksum> checksums = new ArrayList<Checksum>();
        Collection<String> fileContributors = new ArrayList<String>();
        Collection<FileType> fileTypes = new ArrayList<FileType>();
        String noticeText = null;

        public SpdxFileBuilder(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, String name, AnyLicenseInfo concludedLicense, Collection<AnyLicenseInfo> licenseInfosFromFile, String copyrightText, Checksum sha1) {
            Objects.requireNonNull(modelStore, "Model store can not be null");
            Objects.requireNonNull(documentUri, "Document URI can not be null");
            Objects.requireNonNull(id, "ID can not be null");
            Objects.requireNonNull(name, "Name can not be null");
            Objects.requireNonNull(licenseInfosFromFile, "License info from files can not be null");
            Objects.requireNonNull(sha1, "SHA1 can not be null");
            this.modelStore = modelStore;
            this.documentUri = documentUri;
            this.id = id;
            this.name = name;
            this.concludedLicense = concludedLicense;
            this.licenseInfosFromFile = licenseInfosFromFile;
            this.copyrightText = copyrightText;
            this.sha1 = sha1;
            this.copyManager = copyManager;
        }

        public SpdxFileBuilder setAnnotations(Collection<Annotation> annotations) {
            Objects.requireNonNull(annotations, "Annotations can not be null");
            this.annotations = annotations;
            return this;
        }

        public SpdxFileBuilder addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation, "Annotations can not be null");
            this.annotations.add(annotation);
            return this;
        }

        public SpdxFileBuilder setRelationship(Collection<Relationship> relationships) {
            Objects.requireNonNull(relationships, "Relationships can not be null");
            this.relationships = relationships;
            return this;
        }

        public SpdxFileBuilder addRelationship(Relationship relationship) {
            Objects.requireNonNull(relationship, "Relationships can not be null");
            this.relationships.add(relationship);
            return this;
        }

        public SpdxFileBuilder setComment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public SpdxFileBuilder setLicenseComments(@Nullable String licenseComments) {
            this.licenseComments = licenseComments;
            return this;
        }

        public SpdxFileBuilder setChecksums(Collection<Checksum> checksums) {
            Objects.requireNonNull(checksums, "Checksums can not be null");
            this.checksums = checksums;
            return this;
        }

        public SpdxFileBuilder addChecksum(Checksum checksum) {
            Objects.requireNonNull(checksum, "Checksum can not be null");
            this.checksums.add(checksum);
            return this;
        }

        public SpdxFileBuilder setFileContributors(Collection<String> fileContributors) {
            Objects.requireNonNull(fileContributors, "File contributors can not be null");
            this.fileContributors = fileContributors;
            return this;
        }

        public SpdxFileBuilder addFileContributor(String fileContributor) {
            Objects.requireNonNull(fileContributor, "File contributor can not be null");
            this.fileContributors.add(fileContributor);
            return this;
        }

        public SpdxFileBuilder setFileTypes(Collection<FileType> fileTypes) {
            Objects.requireNonNull(fileTypes, "File types can not be null");
            this.fileTypes = fileTypes;
            return this;
        }

        public SpdxFileBuilder addFileType(FileType fileType) {
            Objects.requireNonNull(fileType, "file type can not be null");
            this.fileTypes.add(fileType);
            return this;
        }

        public SpdxFileBuilder setNoticeText(@Nullable String noticeText) {
            this.noticeText = noticeText;
            return this;
        }

        public SpdxFileBuilder setAttributionText(Collection<String> attributionText) {
            Objects.requireNonNull(attributionText, "Attribution text collection can not be null");
            this.attributionText = attributionText;
            return this;
        }

        public SpdxFileBuilder addAttributionText(String attribution) {
            Objects.requireNonNull(attribution, "Attribution text can not be null");
            this.attributionText.add(attribution);
            return this;
        }

        public SpdxFile build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.modelStore.enterCriticalSection(this.documentUri, false);
            try {
                SpdxFile spdxFile = new SpdxFile(this);
                return spdxFile;
            }
            finally {
                this.modelStore.leaveCriticalSection(lock);
            }
        }
    }
}

