/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.storage.IModelStore;

public class SpdxPackageVerificationCode
extends ModelObject {
    public SpdxPackageVerificationCode() throws InvalidSPDXAnalysisException {
    }

    public SpdxPackageVerificationCode(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public SpdxPackageVerificationCode(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Override
    public String getType() {
        return "PackageVerificationCode";
    }

    public String getValue() throws InvalidSPDXAnalysisException {
        Optional<String> retval = this.getStringPropertyValue("packageVerificationCodeValue");
        if (retval.isPresent()) {
            return retval.get();
        }
        logger.warn("No value found - returning empty string");
        return "";
    }

    public void setValue(String value) throws InvalidSPDXAnalysisException {
        if (this.strict && (Objects.isNull(value) || value.isEmpty())) {
            throw new InvalidSPDXAnalysisException("Can not set required verification code value to null or empty string");
        }
        this.setPropertyValue("packageVerificationCodeValue", value);
    }

    public Collection<String> getExcludedFileNames() throws InvalidSPDXAnalysisException {
        return this.getStringCollection("packageVerificationCodeExcludedFile");
    }

    @Override
    protected List<String> _verify(List<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            String value = this.getValue();
            if (value.isEmpty()) {
                retval.add("Missing required verification code value");
            } else {
                String verify = SpdxVerificationHelper.verifyChecksumString(value, ChecksumAlgorithm.SHA1, specVersion);
                if (verify != null) {
                    retval.add(verify);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting verification code value: " + e.getMessage());
        }
        return retval;
    }
}

