/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.net.URI;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.spdx.library.SpdxConstants;
import org.spdx.library.Version;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;

public class SpdxVerificationHelper {
    static final Map<ChecksumAlgorithm, Integer> CHECKSUM_VALUE_LENGTH;
    static final Set<ChecksumAlgorithm> CHECKSUM_ALGORITHMS_ADDED_23;
    static final String[] VALID_CREATOR_PREFIXES;
    static final String[] VALID_ORIGINATOR_SUPPLIER_PREFIXES;

    public static String verifyNonStdLicenseid(String licenseId) {
        if (SpdxConstants.LICENSE_ID_PATTERN.matcher(licenseId).matches()) {
            return null;
        }
        return "Invalid license id '" + licenseId + "'.  Must start with 'LicenseRef-' and made up of the characters from the set 'a'-'z', 'A'-'Z', '0'-'9', '+', '_', '.', and '-'.";
    }

    public static String verifyCreator(String creator) {
        boolean ok = false;
        for (int i = 0; i < VALID_CREATOR_PREFIXES.length; ++i) {
            if (!creator.startsWith(VALID_CREATOR_PREFIXES[i])) continue;
            ok = true;
            break;
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder("Creator does not start with one of ");
            sb.append(VALID_CREATOR_PREFIXES[0]);
            for (int i = 1; i < VALID_CREATOR_PREFIXES.length; ++i) {
                sb.append(", ");
                sb.append(VALID_CREATOR_PREFIXES[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public static String verifyOriginator(String originator) {
        return SpdxVerificationHelper.verifyOriginatorOrSupplier(originator);
    }

    public static String verifySupplier(String supplier) {
        return SpdxVerificationHelper.verifyOriginatorOrSupplier(supplier);
    }

    private static String verifyOriginatorOrSupplier(String originatorOrSupplier) {
        boolean ok = false;
        for (int i = 0; i < VALID_ORIGINATOR_SUPPLIER_PREFIXES.length; ++i) {
            if (!originatorOrSupplier.startsWith(VALID_ORIGINATOR_SUPPLIER_PREFIXES[i])) continue;
            ok = true;
            break;
        }
        if (!ok) {
            StringBuilder sb = new StringBuilder("Value must start with one of ");
            sb.append(VALID_ORIGINATOR_SUPPLIER_PREFIXES[0]);
            for (int i = 1; i < VALID_ORIGINATOR_SUPPLIER_PREFIXES.length; ++i) {
                sb.append(", ");
                sb.append(VALID_ORIGINATOR_SUPPLIER_PREFIXES[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public static String verifyDate(String creationDate) {
        try {
            Instant.parse(creationDate);
        }
        catch (DateTimeParseException e) {
            return "Invalid date format: " + e.getMessage();
        }
        return null;
    }

    public static String verifyReviewer(String reviewer) {
        if (!(reviewer.startsWith("Person:") || reviewer.startsWith("Tool:") || reviewer.startsWith("Organization:"))) {
            return "Reviewer does not start with Person:, Organization:, or Tool:";
        }
        return null;
    }

    public static boolean equalsWithNull(Object s1, Object s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean equivalentArray(Object[] s1, Object[] s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            boolean found = false;
            for (int j = 0; j < s2.length; ++j) {
                if (!SpdxVerificationHelper.equalsWithNull(s1[i], s2[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static String verifyAnnotator(String annotator) {
        if (!(annotator.startsWith("Person:") || annotator.startsWith("Tool:") || annotator.startsWith("Organization:"))) {
            return "Annotator does not start with Person:, Organization:, or Tool";
        }
        return null;
    }

    public static boolean isValidExternalDocRef(String externalDocumentId) {
        return SpdxConstants.EXTERNAL_DOC_REF_PATTERN.matcher(externalDocumentId).matches();
    }

    public static boolean isValidUri(String uri) {
        try {
            URI.create(uri);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String verifyChecksumString(String checksum, ChecksumAlgorithm algorithm, String specVersion) {
        for (int i = 0; i < checksum.length(); ++i) {
            char c = checksum.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return "Invalid checksum string character at position " + String.valueOf(i);
        }
        Integer valueSize = CHECKSUM_VALUE_LENGTH.get(algorithm);
        if (Objects.nonNull(valueSize) && checksum.length() != valueSize.intValue()) {
            return "Invalid number of characters for checksum";
        }
        if (Version.versionLessThan(specVersion, "SPDX-2.3") && CHECKSUM_ALGORITHMS_ADDED_23.contains(algorithm)) {
            return "This algorithm is not supported in SPDX specification versions less than 2.3";
        }
        return null;
    }

    public static String verifyDownloadLocation(String downloadLocation) {
        if (Objects.isNull(downloadLocation)) {
            return "Download location is null";
        }
        if (SpdxConstants.DOWNLOAD_LOCATION_PATTERN.matcher(downloadLocation).matches()) {
            return null;
        }
        return "Invalid download location pattern " + downloadLocation + ".  Must match the pattern " + SpdxConstants.DOWNLOAD_LOCATION_PATTERN.pattern();
    }

    public static boolean verifySpdxId(String id) {
        return SpdxConstants.SPDX_ELEMENT_REF_PATTERN.matcher(id).matches();
    }

    static {
        HashMap<ChecksumAlgorithm, Integer> map = new HashMap<ChecksumAlgorithm, Integer>();
        map.put(ChecksumAlgorithm.ADLER32, 8);
        map.put(ChecksumAlgorithm.BLAKE2b_256, 64);
        map.put(ChecksumAlgorithm.BLAKE2b_384, 96);
        map.put(ChecksumAlgorithm.BLAKE2b_512, 128);
        map.put(ChecksumAlgorithm.BLAKE3, 64);
        map.put(ChecksumAlgorithm.MD2, 32);
        map.put(ChecksumAlgorithm.MD4, 32);
        map.put(ChecksumAlgorithm.MD5, 32);
        map.put(ChecksumAlgorithm.MD6, null);
        map.put(ChecksumAlgorithm.SHA1, 40);
        map.put(ChecksumAlgorithm.SHA224, 56);
        map.put(ChecksumAlgorithm.SHA256, 64);
        map.put(ChecksumAlgorithm.SHA384, 96);
        map.put(ChecksumAlgorithm.SHA3_256, 64);
        map.put(ChecksumAlgorithm.SHA3_384, 96);
        map.put(ChecksumAlgorithm.SHA3_512, 128);
        map.put(ChecksumAlgorithm.SHA512, 128);
        CHECKSUM_VALUE_LENGTH = Collections.unmodifiableMap(map);
        HashSet<ChecksumAlgorithm> set = new HashSet<ChecksumAlgorithm>();
        set.add(ChecksumAlgorithm.SHA3_256);
        set.add(ChecksumAlgorithm.SHA3_384);
        set.add(ChecksumAlgorithm.SHA3_512);
        set.add(ChecksumAlgorithm.BLAKE2b_256);
        set.add(ChecksumAlgorithm.BLAKE2b_384);
        set.add(ChecksumAlgorithm.BLAKE2b_512);
        set.add(ChecksumAlgorithm.BLAKE3);
        set.add(ChecksumAlgorithm.ADLER32);
        CHECKSUM_ALGORITHMS_ADDED_23 = Collections.unmodifiableSet(set);
        VALID_CREATOR_PREFIXES = new String[]{"Person:", "Organization:", "Tool:"};
        VALID_ORIGINATOR_SUPPLIER_PREFIXES = new String[]{SpdxConstants.NOASSERTION_VALUE, "Person:", "Organization:"};
    }
}

