/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.ModelCollection;
import org.spdx.library.model.ModelSet;
import org.spdx.library.model.ModelStorageClassConverter;
import org.spdx.library.model.ReferenceType;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SimpleUriValue;
import org.spdx.library.model.SpdxCreatorInformation;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxIdInUseException;
import org.spdx.library.model.SpdxIdNotFoundException;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxNoAssertionElement;
import org.spdx.library.model.SpdxNoneElement;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.library.model.SpdxSnippet;
import org.spdx.library.model.TypedValue;
import org.spdx.library.model.enumerations.AnnotationType;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.ReferenceCategory;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.enumerations.SpdxEnumFactory;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ConjunctiveLicenseSet;
import org.spdx.library.model.license.CrossRef;
import org.spdx.library.model.license.DisjunctiveLicenseSet;
import org.spdx.library.model.license.ListedLicenses;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.library.model.license.SpdxNoneLicense;
import org.spdx.library.model.pointer.ByteOffsetPointer;
import org.spdx.library.model.pointer.LineCharPointer;
import org.spdx.library.model.pointer.SinglePointer;
import org.spdx.library.model.pointer.StartEndPointer;
import org.spdx.storage.IModelStore;

public abstract class ModelObject {
    static final Logger logger = LoggerFactory.getLogger(ModelObject.class);
    private IModelStore modelStore;
    private String documentUri;
    private String id;
    private ModelCopyManager copyManager = null;
    protected boolean strict = true;
    NotEquivalentReason lastNotEquivalentReason = null;

    public ModelObject() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous, DefaultModelStore.getDefaultDocumentUri()));
    }

    public ModelObject(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    public ModelObject(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(modelStore, "Model Store can not be null");
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        Objects.requireNonNull(id, "ID can not be null");
        this.modelStore = modelStore;
        this.documentUri = documentUri;
        this.id = id;
        this.copyManager = copyManager;
        Optional<TypedValue> existing = modelStore.getTypedValue(documentUri, id);
        if (existing.isPresent()) {
            if (create && !existing.get().getType().equals(this.getType())) {
                throw new SpdxIdInUseException("Can not create " + id + ".  It is already in use with type " + existing.get().getType() + " which is incompatible with type " + this.getType());
            }
        } else if (create) {
            modelStore.create(documentUri, id, this.getType());
        } else {
            throw new SpdxIdNotFoundException(id + " does not exist in document " + documentUri);
        }
    }

    public abstract String getType();

    protected abstract List<String> _verify(Set<String> var1, String var2);

    public List<String> verify(Set<String> verifiedIElementds, String specVersion) {
        if (verifiedIElementds.contains(this.id)) {
            return new ArrayList<String>();
        }
        return this._verify(verifiedIElementds, specVersion);
    }

    public List<String> verify() {
        return this.verify("SPDX-2.3");
    }

    public List<String> verify(String specVersion) {
        return this.verify(new HashSet<String>(), specVersion);
    }

    public String getDocumentUri() {
        return this.documentUri;
    }

    public String getId() {
        return this.id;
    }

    public IModelStore getModelStore() {
        return this.modelStore;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public IModelStore.IModelStoreLock enterCriticalSection(boolean readLockRequested) throws InvalidSPDXAnalysisException {
        return this.getModelStore().enterCriticalSection(this.getDocumentUri(), readLockRequested);
    }

    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        this.getModelStore().leaveCriticalSection(lock);
    }

    public List<String> getPropertyValueNames() throws InvalidSPDXAnalysisException {
        return this.modelStore.getPropertyValueNames(this.documentUri, this.id);
    }

    protected Optional<Object> getObjectPropertyValue(String propertyName) throws InvalidSPDXAnalysisException {
        Optional<Object> retval = ModelObject.getObjectPropertyValue(this.modelStore, this.documentUri, this.id, propertyName, this.copyManager);
        if (retval.isPresent() && retval.get() instanceof ModelObject && !this.strict) {
            ((ModelObject)retval.get()).setStrict(this.strict);
        }
        return retval;
    }

    protected static Optional<Object> getObjectPropertyValue(IModelStore stModelStore, String stDocumentUri, String stId, String propertyName, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (!stModelStore.exists(stDocumentUri, stId)) {
            return Optional.empty();
        }
        if (stModelStore.isCollectionProperty(stDocumentUri, stId, propertyName)) {
            return Optional.of(new ModelCollection(stModelStore, stDocumentUri, stId, propertyName, copyManager, null));
        }
        return ModelStorageClassConverter.optionalStoredObjectToModelObject(stModelStore.getValue(stDocumentUri, stId, propertyName), stDocumentUri, stModelStore, copyManager);
    }

    protected static void setPropertyValue(IModelStore stModelStore, String stDocumentUri, String stId, String propertyName, @Nullable Object value, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(stModelStore, "Model Store can not be null");
        Objects.requireNonNull(stDocumentUri, "Document Uri can not be null");
        Objects.requireNonNull(stId, "ID can not be null");
        Objects.requireNonNull(propertyName, "Property name can not be null");
        if (value == null) {
            ModelObject.removeProperty(stModelStore, stDocumentUri, stId, propertyName);
        } else if (value instanceof Collection) {
            ModelObject.replacePropertyValueCollection(stModelStore, stDocumentUri, stId, propertyName, (Collection)value, copyManager);
        } else {
            stModelStore.setValue(stDocumentUri, stId, propertyName, ModelStorageClassConverter.modelObjectToStoredObject(value, stDocumentUri, stModelStore, copyManager));
        }
    }

    protected void setPropertyValue(String propertyName, @Nullable Object value) throws InvalidSPDXAnalysisException {
        if (this instanceof IndividualUriValue) {
            throw new InvalidSPDXAnalysisException("Can not set a property for the literal value " + ((IndividualUriValue)((Object)this)).getIndividualURI());
        }
        ModelObject.setPropertyValue(this.modelStore, this.documentUri, this.id, propertyName, value, this.copyManager);
    }

    protected IModelStore.ModelUpdate updatePropertyValue(String propertyName, Object value) {
        return () -> ModelObject.setPropertyValue(this.modelStore, this.documentUri, this.id, propertyName, value, this.copyManager);
    }

    protected Optional<String> getStringPropertyValue(String propertyName) throws InvalidSPDXAnalysisException {
        Optional<Object> result = this.getObjectPropertyValue(propertyName);
        if (result.isPresent()) {
            if (result.get() instanceof String) {
                return Optional.of((String)result.get());
            }
            if (result.get() instanceof IndividualUriValue) {
                String uri = ((IndividualUriValue)result.get()).getIndividualURI();
                if ("http://spdx.org/rdf/terms#none".equals(uri)) {
                    return Optional.of(SpdxConstants.NONE_VALUE);
                }
                if ("http://spdx.org/rdf/terms#noassertion".equals(uri)) {
                    return Optional.of(SpdxConstants.NOASSERTION_VALUE);
                }
                logger.error("Can not convert a URI value to String: " + uri);
                throw new SpdxInvalidTypeException("Can not convert a URI value to String: " + uri);
            }
            logger.error("Property " + propertyName + " is not of type String");
            throw new SpdxInvalidTypeException("Property " + propertyName + " is not of type String");
        }
        return Optional.empty();
    }

    protected Optional<Integer> getIntegerPropertyValue(String propertyName) throws InvalidSPDXAnalysisException {
        Optional<Integer> retval;
        Optional<Object> result = this.getObjectPropertyValue(propertyName);
        if (result.isPresent()) {
            if (!(result.get() instanceof Integer)) {
                throw new SpdxInvalidTypeException("Property " + propertyName + " is not of type Integer");
            }
            retval = Optional.of((Integer)result.get());
        } else {
            retval = Optional.empty();
        }
        return retval;
    }

    protected Optional<Enum<?>> getEnumPropertyValue(String propertyName) throws InvalidSPDXAnalysisException {
        Optional<Object> result = this.getObjectPropertyValue(propertyName);
        if (!result.isPresent()) {
            return Optional.empty();
        }
        if (result.get() instanceof Enum) {
            return result;
        }
        if (!(result.get() instanceof IndividualUriValue)) {
            throw new SpdxInvalidTypeException("Property " + propertyName + " is not of type Individual Value or enum");
        }
        Enum<?> retval = SpdxEnumFactory.uriToEnum.get(((IndividualUriValue)result.get()).getIndividualURI());
        if (Objects.isNull(retval)) {
            logger.error("Unknown individual value for enum: " + ((IndividualUriValue)result.get()).getIndividualURI());
            throw new InvalidSPDXAnalysisException("Unknown individual value for enum: " + ((IndividualUriValue)result.get()).getIndividualURI());
        }
        return Optional.of(retval);
    }

    protected Optional<Boolean> getBooleanPropertyValue(String propertyName) throws InvalidSPDXAnalysisException {
        Optional<Object> result = this.getObjectPropertyValue(propertyName);
        if (result.isPresent()) {
            if (result.get() instanceof Boolean) {
                return Optional.of((Boolean)result.get());
            }
            if (result.get() instanceof String) {
                String sResult = ((String)result.get()).toLowerCase();
                if ("true".equals(sResult)) {
                    return Optional.of(true);
                }
                if ("false".equals(sResult)) {
                    return Optional.of(false);
                }
                throw new SpdxInvalidTypeException("Property " + propertyName + " is not of type Boolean");
            }
            throw new SpdxInvalidTypeException("Property " + propertyName + " is not of type Boolean");
        }
        return Optional.empty();
    }

    protected Optional<AnyLicenseInfo> getAnyLicenseInfoPropertyValue(String propertyName) throws InvalidSPDXAnalysisException {
        Optional<Object> result = this.getObjectPropertyValue(propertyName);
        if (!result.isPresent()) {
            return Optional.empty();
        }
        if (result.get() instanceof AnyLicenseInfo) {
            return result;
        }
        if (result.get() instanceof IndividualUriValue) {
            String uri = ((IndividualUriValue)result.get()).getIndividualURI();
            if ("http://spdx.org/rdf/terms#none".equals(uri)) {
                return Optional.of(new SpdxNoneLicense());
            }
            if ("http://spdx.org/rdf/terms#noassertion".equals(uri)) {
                return Optional.of(new SpdxNoAssertionLicense());
            }
            logger.error("Can not convert a URI value to a license: " + uri);
            throw new SpdxInvalidTypeException("Can not convert a URI value to a license: " + uri);
        }
        logger.error("Invalid type for AnyLicenseInfo property: " + result.get().getClass().toString());
        throw new SpdxInvalidTypeException("Invalid type for AnyLicenseInfo property: " + result.get().getClass().toString());
    }

    protected Optional<SpdxElement> getElementPropertyValue(String propertyName) throws InvalidSPDXAnalysisException {
        Optional<Object> result = this.getObjectPropertyValue(propertyName);
        if (!result.isPresent()) {
            return Optional.empty();
        }
        if (result.get() instanceof SpdxElement) {
            return result;
        }
        if (result.get() instanceof IndividualUriValue) {
            String uri = ((IndividualUriValue)result.get()).getIndividualURI();
            if ("http://spdx.org/rdf/terms#none".equals(uri)) {
                return Optional.of(new SpdxNoneElement());
            }
            if ("http://spdx.org/rdf/terms#noassertion".equals(uri)) {
                return Optional.of(new SpdxNoAssertionElement());
            }
            logger.error("Can not convert a URI value to an SPDX element: " + uri);
            throw new SpdxInvalidTypeException("Can not convert a URI value to an SPDX element: " + uri);
        }
        logger.error("Invalid type for SpdxElement property: " + result.get().getClass().toString());
        throw new SpdxInvalidTypeException("Invalid type for SpdxElement property: " + result.get().getClass().toString());
    }

    protected static void removeProperty(IModelStore stModelStore, String stDocumentUri, String stId, String propertyName) throws InvalidSPDXAnalysisException {
        stModelStore.removeProperty(stDocumentUri, stId, propertyName);
    }

    protected void removeProperty(String propertyName) throws InvalidSPDXAnalysisException {
        ModelObject.removeProperty(this.modelStore, this.documentUri, this.id, propertyName);
    }

    protected IModelStore.ModelUpdate updateRemoveProperty(String propertyName) {
        return () -> ModelObject.removeProperty(this.modelStore, this.documentUri, this.id, propertyName);
    }

    protected static void clearValueCollection(IModelStore stModelStore, String stDocumentUri, String stId, String propertyName) throws InvalidSPDXAnalysisException {
        stModelStore.clearValueCollection(stDocumentUri, stId, propertyName);
    }

    protected void clearValueCollection(String propertyName) throws InvalidSPDXAnalysisException {
        ModelObject.clearValueCollection(this.modelStore, this.documentUri, this.id, propertyName);
    }

    protected IModelStore.ModelUpdate updateClearValueCollection(String propertyName) {
        return () -> ModelObject.clearValueCollection(this.modelStore, this.documentUri, this.id, propertyName);
    }

    protected static void addValueToCollection(IModelStore stModelStore, String stDocumentUri, String stId, String propertyName, Object value, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(value, "Value can not be null");
        stModelStore.addValueToCollection(stDocumentUri, stId, propertyName, ModelStorageClassConverter.modelObjectToStoredObject(value, stDocumentUri, stModelStore, copyManager));
    }

    protected void addPropertyValueToCollection(String propertyName, Object value) throws InvalidSPDXAnalysisException {
        ModelObject.addValueToCollection(this.modelStore, this.documentUri, this.id, propertyName, value, this.copyManager);
    }

    protected IModelStore.ModelUpdate updateAddPropertyValueToCollection(String propertyName, Object value) {
        return () -> ModelObject.addValueToCollection(this.modelStore, this.documentUri, this.id, propertyName, value, this.copyManager);
    }

    protected static void replacePropertyValueCollection(IModelStore stModelStore, String stDocumentUri, String stId, String propertyName, Collection<?> values, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        ModelObject.clearValueCollection(stModelStore, stDocumentUri, stId, propertyName);
        for (Object value : values) {
            ModelObject.addValueToCollection(stModelStore, stDocumentUri, stId, propertyName, value, copyManager);
        }
    }

    protected static void removePropertyValueFromCollection(IModelStore stModelStore, String stDocumentUri, String stId, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        stModelStore.removeValueFromCollection(stDocumentUri, stId, propertyName, ModelStorageClassConverter.modelObjectToStoredObject(value, stDocumentUri, stModelStore, null));
    }

    protected void removePropertyValueFromCollection(String propertyName, Object value) throws InvalidSPDXAnalysisException {
        ModelObject.removePropertyValueFromCollection(this.modelStore, this.documentUri, this.id, propertyName, value);
    }

    protected IModelStore.ModelUpdate updateRemovePropertyValueFromCollection(String propertyName, Object value) {
        return () -> ModelObject.removePropertyValueFromCollection(this.modelStore, this.documentUri, this.id, propertyName, value);
    }

    protected ModelSet<?> getObjectPropertyValueSet(String propertyName, Class<?> type) throws InvalidSPDXAnalysisException {
        return new ModelSet(this.modelStore, this.documentUri, this.id, propertyName, this.copyManager, type);
    }

    protected ModelCollection<?> getObjectPropertyValueCollection(String propertyName, Class<?> type) throws InvalidSPDXAnalysisException {
        return new ModelCollection(this.modelStore, this.documentUri, this.id, propertyName, this.copyManager, type);
    }

    protected Collection<String> getStringCollection(String propertyName) throws InvalidSPDXAnalysisException {
        if (!this.isCollectionMembersAssignableTo(propertyName, String.class)) {
            throw new SpdxInvalidTypeException("Property " + propertyName + " does not contain a collection of Strings");
        }
        return this.getObjectPropertyValueSet(propertyName, String.class);
    }

    protected boolean isCollectionMembersAssignableTo(String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.modelStore.isCollectionMembersAssignableTo(this.documentUri, this.id, propertyName, ModelStorageClassConverter.modelClassToStoredClass(clazz));
    }

    public boolean equivalent(ModelObject compare) throws InvalidSPDXAnalysisException {
        return this.equivalent(compare, false);
    }

    public boolean equivalent(ModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        if (!this.getClass().equals(compare.getClass())) {
            this.lastNotEquivalentReason = new NotEquivalentReason(NotEquivalent.DIFFERENT_CLASS);
            return false;
        }
        List<String> propertyValueNames = this.getPropertyValueNames();
        ArrayList<String> comparePropertyValueNames = new ArrayList<String>(compare.getPropertyValueNames());
        for (String propertyName : propertyValueNames) {
            Object propertyValue;
            if (ignoreRelatedElements && this.isRelatedElement(propertyName)) continue;
            if (comparePropertyValueNames.contains(propertyName)) {
                if (!this.propertyValuesEquivalent(propertyName, this.getObjectPropertyValue(propertyName), compare.getObjectPropertyValue(propertyName), ignoreRelatedElements)) {
                    this.lastNotEquivalentReason = new NotEquivalentReason(NotEquivalent.PROPERTY_NOT_EQUIVALENT, propertyName);
                    return false;
                }
                comparePropertyValueNames.remove(propertyName);
                continue;
            }
            Optional<Object> propertyValueOptional = this.getObjectPropertyValue(propertyName);
            if (!propertyValueOptional.isPresent() || this.isEquivalentToNull(propertyValue = propertyValueOptional.get(), propertyName)) continue;
            this.lastNotEquivalentReason = new NotEquivalentReason(NotEquivalent.COMPARE_PROPERTY_MISSING, propertyName);
            return false;
        }
        for (String propertyName : comparePropertyValueNames) {
            Object comparePropertyValue;
            Optional<Object> comparePropertyValueOptional;
            if (ignoreRelatedElements && this.isRelatedElement(propertyName) || !(comparePropertyValueOptional = compare.getObjectPropertyValue(propertyName)).isPresent() || this.isEquivalentToNull(comparePropertyValue = comparePropertyValueOptional.get(), propertyName)) continue;
            this.lastNotEquivalentReason = new NotEquivalentReason(NotEquivalent.MISSING_PROPERTY, propertyName);
            return false;
        }
        return true;
    }

    private boolean isEquivalentToNull(Object propertyValue, String propertyName) {
        if (propertyValue instanceof ModelCollection) {
            return ((ModelCollection)propertyValue).size() == 0;
        }
        if (this.isNoAssertion(propertyValue)) {
            return true;
        }
        if ("filesAnalyzed".equals(propertyName)) {
            return propertyValue instanceof Boolean && (Boolean)propertyValue != false;
        }
        return false;
    }

    private boolean isRelatedElement(String propertyName) {
        return "relatedSpdxElement".equals(propertyName);
    }

    private boolean isEmptyModelCollection(Object value) {
        return value instanceof ModelCollection && ((ModelCollection)value).size() == 0;
    }

    private boolean isNoAssertion(Object propertyValue) {
        return propertyValue instanceof SpdxNoAssertionLicense || propertyValue.equals(SpdxConstants.NOASSERTION_VALUE);
    }

    private boolean propertyValuesEquivalent(String propertyName, Optional<Object> valueA, Optional<Object> valueB, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        if (!valueA.isPresent()) {
            if (valueB.isPresent()) {
                return this.isEmptyModelCollection(valueB.get());
            }
        } else {
            List<Object> compareList;
            List<Object> myList;
            if (!valueB.isPresent()) {
                return this.isEmptyModelCollection(valueA.get());
            }
            if (valueA.get() instanceof ModelCollection && valueB.get() instanceof ModelCollection ? !this.areEquivalent(myList = ((ModelCollection)valueA.get()).toImmutableList(), compareList = ((ModelCollection)valueB.get()).toImmutableList(), ignoreRelatedElements) : (valueA.get() instanceof List && valueB.get() instanceof List ? !this.areEquivalent((List)valueA.get(), (List)valueB.get(), ignoreRelatedElements) : (valueA.get() instanceof IndividualUriValue && valueB.get() instanceof IndividualUriValue ? !Objects.equals(((IndividualUriValue)valueA.get()).getIndividualURI(), ((IndividualUriValue)valueB.get()).getIndividualURI()) : (valueA.get() instanceof ModelObject && valueB.get() instanceof ModelObject ? !((ModelObject)valueA.get()).equivalent((ModelObject)valueB.get(), this.isRelatedElement(propertyName) ? true : ignoreRelatedElements) : !this.OptionalObjectsEquivalent(valueA, valueB))))) {
                return false;
            }
        }
        return true;
    }

    private boolean OptionalObjectsEquivalent(Optional<Object> valueA, Optional<Object> valueB) {
        if (Objects.equals(valueA, valueB)) {
            return true;
        }
        if (!valueA.isPresent()) {
            return false;
        }
        if (!valueB.isPresent()) {
            return false;
        }
        if (valueA.get() instanceof IndividualUriValue) {
            if ("http://spdx.org/rdf/terms#none".equals(((IndividualUriValue)valueA.get()).getIndividualURI()) && SpdxConstants.NONE_VALUE.equals(valueB.get())) {
                return true;
            }
            if ("http://spdx.org/rdf/terms#noassertion".equals(((IndividualUriValue)valueA.get()).getIndividualURI()) && SpdxConstants.NOASSERTION_VALUE.equals(valueB.get())) {
                return true;
            }
        }
        if (valueB.get() instanceof IndividualUriValue) {
            if ("http://spdx.org/rdf/terms#none".equals(((IndividualUriValue)valueB.get()).getIndividualURI()) && SpdxConstants.NONE_VALUE.equals(valueA.get())) {
                return true;
            }
            if ("http://spdx.org/rdf/terms#noassertion".equals(((IndividualUriValue)valueB.get()).getIndividualURI()) && SpdxConstants.NOASSERTION_VALUE.equals(valueA.get())) {
                return true;
            }
        }
        if (valueA.get() instanceof String && valueB.get() instanceof String) {
            return this.normalizeString((String)valueA.get()).equals(this.normalizeString((String)valueB.get()));
        }
        return false;
    }

    private Object normalizeString(String s) {
        return s.replaceAll("\r\n", "\n").trim();
    }

    private boolean areEquivalent(List<?> firstList, List<?> secondList, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        for (Object item : firstList) {
            if (this.containsEqualOrEquivalentItem(secondList, item, ignoreRelatedElements)) continue;
            return false;
        }
        for (Object item : secondList) {
            if (this.containsEqualOrEquivalentItem(firstList, item, ignoreRelatedElements)) continue;
            return false;
        }
        return true;
    }

    private boolean containsEqualOrEquivalentItem(List<?> list, Object itemToFind, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        if (list.contains(itemToFind)) {
            return true;
        }
        if (itemToFind instanceof IndividualUriValue && list.contains(new SimpleUriValue((IndividualUriValue)itemToFind))) {
            return true;
        }
        if (!(itemToFind instanceof ModelObject)) {
            return false;
        }
        ModelObject objectToFind = (ModelObject)itemToFind;
        for (Object objectToCompare : list) {
            if (!(objectToCompare instanceof ModelObject) || !objectToFind.equivalent((ModelObject)objectToCompare, ignoreRelatedElements)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.id != null) {
            return this.id.toLowerCase().hashCode() ^ this.documentUri.hashCode();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelObject)) {
            return false;
        }
        ModelObject comp = (ModelObject)o;
        if (this.getModelStore().getIdType(this.id).equals((Object)IModelStore.IdType.Anonymous)) {
            return Objects.equals(this.modelStore, comp.getModelStore()) && Objects.equals(this.id, comp.getId()) && Objects.equals(this.documentUri, comp.getDocumentUri());
        }
        return Objects.equals(this.id, comp.getId()) && Objects.equals(this.documentUri, comp.getDocumentUri());
    }

    public ModelObject clone(IModelStore modelStore) {
        if (Objects.isNull(this.copyManager)) {
            throw new IllegalStateException("A copy manager must be provided to clone");
        }
        if (this.modelStore.equals(modelStore)) {
            throw new IllegalStateException("Can not clone to the same model store");
        }
        Objects.requireNonNull(modelStore, "Model store for clone must not be null");
        if (modelStore.exists(this.documentUri, this.id)) {
            throw new IllegalStateException("Can not clone - " + this.id + " already exists.");
        }
        try {
            ModelObject retval = SpdxModelFactory.createModelObject(modelStore, this.documentUri, this.id, this.getType(), this.copyManager);
            retval.copyFrom(this);
            return retval;
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyFrom(ModelObject source) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(this.copyManager)) {
            throw new InvalidSPDXAnalysisException("Copying is not enabled for " + this.id);
        }
        this.copyManager.copy(this.modelStore, this.documentUri, this.id, source.getModelStore(), source.getDocumentUri(), source.getId(), this.getType());
    }

    public void setCopyManager(ModelCopyManager copyManager) {
        this.copyManager = copyManager;
    }

    public ModelCopyManager getCopyManager() {
        return this.copyManager;
    }

    protected IModelStore.IdType idToIdType(String id) {
        if (id.startsWith(SpdxConstants.NON_STD_LICENSE_ID_PRENUM)) {
            return IModelStore.IdType.LicenseRef;
        }
        if (id.startsWith(SpdxConstants.SPDX_ELEMENT_REF_PRENUM)) {
            return IModelStore.IdType.SpdxId;
        }
        if (id.startsWith(SpdxConstants.EXTERNAL_DOC_REF_PRENUM)) {
            return IModelStore.IdType.DocumentRef;
        }
        if (ListedLicenses.getListedLicenses().isSpdxListedLicenseId(id)) {
            return IModelStore.IdType.ListedLicense;
        }
        if ("none".equalsIgnoreCase(id) || "noassertion".equalsIgnoreCase(id)) {
            return IModelStore.IdType.Literal;
        }
        return IModelStore.IdType.Anonymous;
    }

    protected TypedValue toTypedValue() throws InvalidSPDXAnalysisException {
        return new TypedValue(this.id, this.getType());
    }

    protected List<String> verifyCollection(Collection<? extends ModelObject> collection, String warningPrefix, Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        for (ModelObject modelObject : collection) {
            for (String warning : modelObject.verify(verifiedIds, specVersion)) {
                if (Objects.nonNull(warningPrefix)) {
                    retval.add(warningPrefix + warning);
                    continue;
                }
                retval.add(warning);
            }
        }
        return retval;
    }

    public Annotation createAnnotation(String annotator, AnnotationType annotationType, String date, String comment) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(annotator, "Annotator can not be null");
        Objects.requireNonNull(annotationType, "AnnotationType can not be null");
        Objects.requireNonNull(date, "Date can not be null");
        Objects.requireNonNull(comment, "Comment can not be null");
        Annotation retval = new Annotation(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setAnnotationDate(date);
        retval.setAnnotationType(annotationType);
        retval.setAnnotator(annotator);
        retval.setComment(comment);
        return retval;
    }

    public Relationship createRelationship(SpdxElement relatedElement, RelationshipType relationshipType, @Nullable String comment) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(relatedElement, "Related Element can not be null");
        Objects.requireNonNull(relationshipType, "Relationship type can not be null");
        Relationship retval = new Relationship(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setRelatedSpdxElement(relatedElement);
        retval.setRelationshipType(relationshipType);
        if (Objects.nonNull(comment)) {
            retval.setComment(comment);
        }
        return retval;
    }

    public Checksum createChecksum(ChecksumAlgorithm algorithm, String value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(algorithm, "Algorithm can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        Checksum retval = new Checksum(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setAlgorithm(algorithm);
        retval.setValue(value);
        return retval;
    }

    public SpdxPackageVerificationCode createPackageVerificationCode(String value, Collection<String> excludedFileNames) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(value, "Value can not be null");
        Objects.requireNonNull(excludedFileNames, "Excluded Files can not be null");
        SpdxPackageVerificationCode retval = new SpdxPackageVerificationCode(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setValue(value);
        retval.getExcludedFileNames().addAll(excludedFileNames);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalDocumentRef createExternalDocumentRef(String externalDocumentId, String externalDocumentUri, Checksum checksum) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(externalDocumentUri, "External document URI can not be null");
        Objects.requireNonNull(checksum, "Checksum can not be null");
        Objects.requireNonNull(externalDocumentId, "External document ID can not be null");
        if (!SpdxVerificationHelper.isValidExternalDocRef(externalDocumentId)) {
            throw new InvalidSPDXAnalysisException("Invalid external document reference ID " + externalDocumentId + ".  Must be of the format " + SpdxConstants.EXTERNAL_DOC_REF_PATTERN.pattern());
        }
        if (!SpdxVerificationHelper.isValidUri(externalDocumentUri)) {
            throw new InvalidSPDXAnalysisException("Invalid external document URI: " + externalDocumentUri);
        }
        IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(this.getDocumentUri(), false);
        try {
            if (this.getModelStore().exists(this.getDocumentUri(), externalDocumentId)) {
                ExternalDocumentRef externalDocumentRef = new ExternalDocumentRef(this.getModelStore(), this.getDocumentUri(), externalDocumentId, this.copyManager, false);
                return externalDocumentRef;
            }
            ExternalDocumentRef retval = new ExternalDocumentRef(this.getModelStore(), this.getDocumentUri(), externalDocumentId, this.copyManager, true);
            retval.setChecksum(checksum);
            retval.setSpdxDocumentNamespace(externalDocumentUri);
            ModelObject.addValueToCollection(this.getModelStore(), this.getDocumentUri(), "SPDXRef-DOCUMENT", "externalDocumentRef", retval, this.copyManager);
            ExternalDocumentRef externalDocumentRef = retval;
            return externalDocumentRef;
        }
        finally {
            this.getModelStore().leaveCriticalSection(lock);
        }
    }

    public SpdxCreatorInformation createCreationInfo(List<String> creators, String date) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(creators, "Creators can not be null");
        Objects.requireNonNull(date, "Date can not be null");
        SpdxCreatorInformation retval = new SpdxCreatorInformation(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.getCreators().addAll(creators);
        retval.setCreated(date);
        return retval;
    }

    public ExternalRef createExternalRef(ReferenceCategory category, ReferenceType referenceType, String locator, @Nullable String comment) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(category, "Category can not be null");
        Objects.requireNonNull(referenceType, "Reference type can not be null");
        Objects.requireNonNull(locator, "Locator can not be null");
        ExternalRef retval = new ExternalRef(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setReferenceCategory(category);
        retval.setReferenceType(referenceType);
        retval.setReferenceLocator(locator);
        retval.setComment(comment);
        return retval;
    }

    public SpdxFile.SpdxFileBuilder createSpdxFile(String id, String name, AnyLicenseInfo concludedLicense, Collection<AnyLicenseInfo> seenLicense, String copyrightText, Checksum sha1) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "ID can not be null");
        Objects.requireNonNull(name, "Name can not be null");
        Objects.requireNonNull(sha1, "Sha1 can not be null");
        return new SpdxFile.SpdxFileBuilder(this.modelStore, this.documentUri, id, this.copyManager, name, concludedLicense, seenLicense, copyrightText, sha1);
    }

    public SpdxPackage.SpdxPackageBuilder createPackage(String id, String name, AnyLicenseInfo concludedLicense, String copyrightText, AnyLicenseInfo licenseDeclared) {
        Objects.requireNonNull(id, "ID can not be null");
        Objects.requireNonNull(name, "Name can not be null");
        return new SpdxPackage.SpdxPackageBuilder(this.modelStore, this.documentUri, id, this.copyManager, name, concludedLicense, copyrightText, licenseDeclared);
    }

    public ByteOffsetPointer createByteOffsetPointer(SpdxElement referencedElement, int offset) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(referencedElement, "Referenced element can not be null");
        ByteOffsetPointer retval = new ByteOffsetPointer(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setReference(referencedElement);
        retval.setOffset(offset);
        return retval;
    }

    public LineCharPointer createLineCharPointer(SpdxElement referencedElement, int lineNumber) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(referencedElement, "Referenced element can not be null");
        LineCharPointer retval = new LineCharPointer(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setReference(referencedElement);
        retval.setLineNumber(lineNumber);
        return retval;
    }

    public StartEndPointer createStartEndPointer(SinglePointer startPointer, SinglePointer endPointer) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(startPointer, "Start pointer can not be null");
        Objects.requireNonNull(endPointer, "End pointer can not be null");
        StartEndPointer retval = new StartEndPointer(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setStartPointer(startPointer);
        retval.setEndPointer(endPointer);
        return retval;
    }

    public SpdxSnippet.SpdxSnippetBuilder createSpdxSnippet(String id, String name, AnyLicenseInfo concludedLicense, Collection<AnyLicenseInfo> seenLicense, String copyrightText, SpdxFile snippetFromFile, int startByte, int endByte) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "ID can not be null");
        Objects.requireNonNull(name, "Name can not be null");
        return new SpdxSnippet.SpdxSnippetBuilder(this.modelStore, this.documentUri, id, this.copyManager, name, concludedLicense, seenLicense, copyrightText, snippetFromFile, startByte, endByte);
    }

    public ConjunctiveLicenseSet createConjunctiveLicenseSet(Collection<AnyLicenseInfo> members) throws InvalidSPDXAnalysisException {
        ConjunctiveLicenseSet retval = new ConjunctiveLicenseSet(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setMembers(members);
        return retval;
    }

    public DisjunctiveLicenseSet createDisjunctiveLicenseSet(Collection<AnyLicenseInfo> members) throws InvalidSPDXAnalysisException {
        DisjunctiveLicenseSet retval = new DisjunctiveLicenseSet(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
        retval.setMembers(members);
        return retval;
    }

    public CrossRef.CrossRefBuilder createCrossRef(String url) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(url, "URL can not be null");
        return new CrossRef.CrossRefBuilder(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, url);
    }

    public String toString() {
        return this.getType() + " " + this.id;
    }

    static class NotEquivalentReason {
        NotEquivalent reason;
        String property = null;

        public NotEquivalentReason(NotEquivalent reason) {
            this.reason = reason;
        }

        public NotEquivalentReason(NotEquivalent reason, String property) {
            this(reason);
            this.property = property;
        }

        public NotEquivalent getReason() {
            return this.reason;
        }

        public void setReason(NotEquivalent reason) {
            this.reason = reason;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }
    }

    static enum NotEquivalent {
        DIFFERENT_CLASS,
        MISSING_PROPERTY,
        PROPERTY_NOT_EQUIVALENT,
        COMPARE_PROPERTY_MISSING;

    }
}

