/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.SimpleUriValue;
import org.spdx.library.model.TypedValue;
import org.spdx.storage.IModelStore;

public class ModelCopyManager {
    static final Logger logger = LoggerFactory.getLogger(ModelCopyManager.class);
    private ConcurrentHashMap<IModelStore, ConcurrentHashMap<IModelStore, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, String>>>>> COPIED_IDS = new ConcurrentHashMap();

    public String getCopiedId(IModelStore fromStore, String fromDocumentUri, String fromId, IModelStore toStore, String toDocumentUri) {
        ConcurrentHashMap<IModelStore, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, String>>>> fromStoreMap = this.COPIED_IDS.get(fromStore);
        if (Objects.isNull(fromStoreMap)) {
            return null;
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, String>>> toStoreMap = fromStoreMap.get(toStore);
        if (Objects.isNull(toStoreMap)) {
            return null;
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, String>> fromDocumentMap = toStoreMap.get(fromDocumentUri);
        if (Objects.isNull(fromDocumentMap)) {
            return null;
        }
        ConcurrentHashMap<String, String> idMap = fromDocumentMap.get(toDocumentUri);
        if (Objects.isNull(idMap)) {
            return null;
        }
        return idMap.get(fromId);
    }

    public String putCopiedId(IModelStore fromStore, String fromDocumentUri, String fromId, IModelStore toStore, String toDocumentUri, String toId) {
        ConcurrentHashMap<IModelStore, ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, String>>>> fromStoreMap = this.COPIED_IDS.get(fromStore);
        while (Objects.isNull(fromStoreMap)) {
            fromStoreMap = this.COPIED_IDS.putIfAbsent(fromStore, new ConcurrentHashMap());
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, String>>> toStoreMap = fromStoreMap.get(toStore);
        while (Objects.isNull(toStoreMap)) {
            toStoreMap = fromStoreMap.putIfAbsent(toStore, new ConcurrentHashMap());
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, String>> fromDocumentMap = toStoreMap.get(fromDocumentUri);
        while (Objects.isNull(fromDocumentMap)) {
            fromDocumentMap = toStoreMap.putIfAbsent(fromDocumentUri, new ConcurrentHashMap());
        }
        ConcurrentHashMap<String, String> idMap = fromDocumentMap.get(toDocumentUri);
        while (Objects.isNull(idMap)) {
            idMap = fromDocumentMap.putIfAbsent(toDocumentUri, new ConcurrentHashMap());
        }
        if (idMap.containsKey(fromId)) {
            logger.warn("ID already exists for the originating " + fromDocumentUri + "#" + fromId + ":" + toDocumentUri + "#");
        }
        return idMap.put(fromId, toId);
    }

    public void copy(IModelStore toStore, String toDocumentUri, String toId, IModelStore fromStore, String fromDocumentUri, String fromId, String type) throws InvalidSPDXAnalysisException {
        this.copy(toStore, toDocumentUri, toId, fromStore, fromDocumentUri, fromId, type, false);
    }

    public void copy(IModelStore toStore, String toDocumentUri, String toId, IModelStore fromStore, String fromDocumentUri, String fromId, String type, boolean excludeLicenseDetails) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(toStore, "ToStore can not be null");
        Objects.requireNonNull(toDocumentUri, "To Document URI can not be null");
        Objects.requireNonNull(fromStore, "FromStore can not be null");
        Objects.requireNonNull(fromDocumentUri, "From Document URI can not be null");
        Objects.requireNonNull(fromId, "From ID can not be null");
        Objects.requireNonNull(toId, "To ID can not be null");
        Objects.requireNonNull(type, "Type can not be null");
        if (fromStore.equals(toStore) && fromDocumentUri.equals(toDocumentUri) && fromId.equals(toId)) {
            return;
        }
        if (!toStore.exists(toDocumentUri, toId)) {
            toStore.create(toDocumentUri, toId, type);
        }
        this.putCopiedId(fromStore, fromDocumentUri, fromId, toStore, toDocumentUri, toId);
        if (!excludeLicenseDetails || !"ListedLicense".equals(type) && !"ListedLicenseException".equals(type)) {
            List<String> propertyNames = fromStore.getPropertyValueNames(fromDocumentUri, fromId);
            for (String propName : propertyNames) {
                if (fromStore.isCollectionProperty(fromDocumentUri, fromId, propName)) {
                    this.copyCollectionProperty(toStore, toDocumentUri, toId, fromStore, fromDocumentUri, fromId, propName, excludeLicenseDetails);
                    continue;
                }
                this.copyIndividualProperty(toStore, toDocumentUri, toId, fromStore, fromDocumentUri, fromId, propName, excludeLicenseDetails);
            }
        }
    }

    private void copyIndividualProperty(IModelStore toStore, String toDocumentUri, String toId, IModelStore fromStore, String fromDocumentUri, String fromId, String propName, boolean excludeLicenseDetails) throws InvalidSPDXAnalysisException {
        if (fromStore.isCollectionProperty(fromDocumentUri, fromId, propName)) {
            throw new InvalidSPDXAnalysisException("Property " + propName + " is a collection type");
        }
        Optional<Object> result = fromStore.getValue(fromDocumentUri, fromId, propName);
        if (result.isPresent()) {
            if (result.get() instanceof IndividualUriValue) {
                toStore.setValue(toDocumentUri, toId, propName, new SimpleUriValue((IndividualUriValue)result.get()));
            } else if (result.get() instanceof TypedValue) {
                TypedValue tv = (TypedValue)result.get();
                if (fromStore.equals(toStore) && fromDocumentUri.equals(toDocumentUri)) {
                    toStore.setValue(toDocumentUri, toId, propName, tv);
                } else {
                    toStore.setValue(toDocumentUri, toId, propName, this.copy(toStore, toDocumentUri, fromStore, fromDocumentUri, tv.getId(), tv.getType(), excludeLicenseDetails));
                }
            } else {
                toStore.setValue(toDocumentUri, toId, propName, result.get());
            }
        }
    }

    private void copyCollectionProperty(IModelStore toStore, String toDocumentUri, String toId, IModelStore fromStore, String fromDocumentUri, String fromId, String propName, boolean excludeLicenseDetails) throws InvalidSPDXAnalysisException {
        if (!fromStore.isCollectionProperty(fromDocumentUri, fromId, propName)) {
            throw new InvalidSPDXAnalysisException("Property " + propName + " is not a collection type");
        }
        Iterator<Object> fromListIter = fromStore.listValues(fromDocumentUri, fromId, propName);
        while (fromListIter.hasNext()) {
            Object toStoreItem;
            Object listItem = fromListIter.next();
            if (listItem instanceof IndividualUriValue) {
                toStoreItem = new SimpleUriValue((IndividualUriValue)listItem);
            } else if (listItem instanceof TypedValue) {
                TypedValue listItemTv = (TypedValue)listItem;
                toStoreItem = toStore.equals(fromStore) && toDocumentUri.equals(fromDocumentUri) ? listItemTv : this.copy(toStore, toDocumentUri, fromStore, fromDocumentUri, listItemTv.getId(), listItemTv.getType(), excludeLicenseDetails);
            } else {
                toStoreItem = listItem;
            }
            toStore.addValueToCollection(toDocumentUri, toId, propName, toStoreItem);
        }
    }

    public TypedValue copy(IModelStore toStore, String toDocumentUri, IModelStore fromStore, String fromDocumentUri, String sourceId, String type) throws InvalidSPDXAnalysisException {
        return this.copy(toStore, toDocumentUri, fromStore, fromDocumentUri, sourceId, type, false);
    }

    public TypedValue copy(IModelStore toStore, String toDocumentUri, IModelStore fromStore, String fromDocumentUri, String sourceId, String type, boolean excludeLicenseDetails) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(toStore, "To Store can not be null");
        Objects.requireNonNull(toDocumentUri, "To Document URI can not be null");
        Objects.requireNonNull(fromStore, "From Store can not be null");
        Objects.requireNonNull(fromDocumentUri, "From Document URI can not be null");
        Objects.requireNonNull(sourceId, "Source ID can not be null");
        Objects.requireNonNull(type, "Type can not be null");
        String toId = this.getCopiedId(fromStore, fromDocumentUri, sourceId, toStore, toDocumentUri);
        if (Objects.isNull(toId)) {
            if (fromStore.getIdType(sourceId) == IModelStore.IdType.Anonymous || toStore.exists(toDocumentUri, sourceId)) {
                if ("ExternalDocumentRef".equals(type)) {
                    toId = toStore.getNextId(IModelStore.IdType.DocumentRef, toDocumentUri);
                } else {
                    switch (fromStore.getIdType(sourceId)) {
                        case Anonymous: {
                            toId = toStore.getNextId(IModelStore.IdType.Anonymous, toDocumentUri);
                            break;
                        }
                        case LicenseRef: {
                            toId = toStore.getNextId(IModelStore.IdType.LicenseRef, toDocumentUri);
                            break;
                        }
                        case DocumentRef: {
                            toId = toStore.getNextId(IModelStore.IdType.DocumentRef, toDocumentUri);
                            break;
                        }
                        case SpdxId: {
                            toId = toStore.getNextId(IModelStore.IdType.SpdxId, toDocumentUri);
                            break;
                        }
                        default: {
                            toId = sourceId;
                            break;
                        }
                    }
                }
            } else {
                toId = sourceId;
            }
            this.copy(toStore, toDocumentUri, toId, fromStore, fromDocumentUri, sourceId, type, excludeLicenseDetails);
        }
        return new TypedValue(toId, type);
    }
}

