/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SimpleUriValue;
import org.spdx.library.model.SpdxElement;
import org.spdx.storage.IModelStore;

public class ExternalSpdxElement
extends SpdxElement
implements IndividualUriValue {
    public ExternalSpdxElement(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    public ExternalSpdxElement(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
        if (!SpdxConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(id).matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        this.getExternalSpdxElementURI();
    }

    public String getExternalDocumentId() throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(this.getId());
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        return matcher.group(1);
    }

    public String getExternalElementId() throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(this.getId());
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        return matcher.group(2);
    }

    @Override
    public String getType() {
        return "ExternalSpdxElement";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getId();
        Matcher matcher = SpdxConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(id);
        if (!matcher.matches()) {
            retval.add("Invalid id format for an external document reference.  Must be of the form " + SpdxConstants.EXTERNAL_ELEMENT_REF_PATTERN.pattern());
        } else {
            try {
                ExternalSpdxElement.externalDocumentIdToNamespace(matcher.group(1), this.getModelStore(), this.getDocumentUri(), this.getCopyManager());
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add(e.getMessage());
            }
        }
        return retval;
    }

    public String getExternalSpdxElementURI() throws InvalidSPDXAnalysisException {
        return ExternalSpdxElement.externalSpdxElementIdToURI(this.getId(), this.getModelStore(), this.getDocumentUri(), this.getCopyManager());
    }

    public static String externalSpdxElementIdToURI(String externalSpdxElementId, IModelStore stModelStore, String stDocumentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstants.EXTERNAL_ELEMENT_REF_PATTERN.matcher(externalSpdxElementId);
        if (!matcher.matches()) {
            logger.error("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        String externalDocumentUri = ExternalSpdxElement.externalDocumentIdToNamespace(matcher.group(1), stModelStore, stDocumentUri, copyManager);
        if (externalDocumentUri.endsWith("#")) {
            return externalDocumentUri + matcher.group(2);
        }
        return externalDocumentUri + "#" + matcher.group(2);
    }

    public static String uriToExternalSpdxElementId(String uri, IModelStore stModelStore, String stDocumentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(uri, "URI can not be null");
        Matcher matcher = SpdxConstants.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(uri);
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid URI format: " + uri + ".  Expects namespace#SPDXRef-XXX");
        }
        Optional<ExternalDocumentRef> externalDocRef = ExternalDocumentRef.getExternalDocRefByDocNamespace(stModelStore, stDocumentUri, matcher.group(1), copyManager);
        if (!externalDocRef.isPresent()) {
            logger.error("Could not find or create the external document reference for document namespace " + matcher.group(1));
            throw new InvalidSPDXAnalysisException("Could not find or create the external document reference for document namespace " + matcher.group(1));
        }
        return externalDocRef.get().getId() + ":" + matcher.group(2);
    }

    public static ExternalSpdxElement uriToExternalSpdxElement(String uri, IModelStore stModelStore, String stDocumentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        return new ExternalSpdxElement(stModelStore, stDocumentUri, ExternalSpdxElement.uriToExternalSpdxElementId(uri, stModelStore, stDocumentUri, copyManager), copyManager, true);
    }

    public static String externalDocumentIdToNamespace(String externalDocumentId, IModelStore stModelStore, String stDocumentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Optional<Object> retval = ExternalSpdxElement.getObjectPropertyValue(stModelStore, stDocumentUri, externalDocumentId, "spdxDocument", copyManager);
        if (!retval.isPresent()) {
            throw new InvalidSPDXAnalysisException("No external document reference exists for document ID " + externalDocumentId);
        }
        if (!(retval.get() instanceof IndividualUriValue)) {
            logger.error("Invalid type returned for external document.  Expected IndividualValue, actual " + retval.get().getClass().toString());
            throw new InvalidSPDXAnalysisException("Invalid type returned for external document.");
        }
        return ((IndividualUriValue)retval.get()).getIndividualURI();
    }

    @Override
    public boolean equivalent(ModelObject compare) {
        if (!(compare instanceof ExternalSpdxElement)) {
            return false;
        }
        return this.getId().equals(compare.getId());
    }

    @Override
    public String getIndividualURI() {
        try {
            return this.getExternalSpdxElementURI();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting external SPDX element URI", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean addAnnotation(Annotation annotation) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not add annotations to an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public boolean addRelationship(Relationship relationship) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not add relationshps to an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public void setComment(String comment) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set comment on an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public ExternalSpdxElement setName(String name) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set the name on an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public Collection<Annotation> getAnnotations() throws InvalidSPDXAnalysisException {
        return new ArrayList<Annotation>();
    }

    @Override
    public SpdxElement setAnnotations(Collection<Annotation> annotations) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set annotations to an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public boolean removeAnnotation(Annotation annotation) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can remove set annotations to an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public Collection<Relationship> getRelationships() throws InvalidSPDXAnalysisException {
        return new ArrayList<Relationship>();
    }

    @Override
    public SpdxElement setRelationships(Collection<Relationship> relationships) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set relationships on an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public boolean removeRelationship(Relationship relationship) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not remove relationships on an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return Optional.empty();
    }

    @Override
    public Optional<String> getName() throws InvalidSPDXAnalysisException {
        return Optional.empty();
    }

    @Override
    public boolean equals(Object comp) {
        return SimpleUriValue.isIndividualUriValueEquals(this, comp);
    }

    @Override
    public int hashCode() {
        return SimpleUriValue.getIndividualUriValueHash(this);
    }
}

