/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxPackage;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;

public class Read {
    public static void serialize(ISerializableModelStore modelStore, String documentUri, OutputStream stream) throws InvalidSPDXAnalysisException, IOException {
        IModelStore.IModelStoreLock lock = modelStore.enterCriticalSection(documentUri, true);
        try {
            modelStore.serialize(documentUri, stream);
        }
        finally {
            modelStore.leaveCriticalSection(lock);
        }
    }

    public static void writeToFile(ISerializableModelStore modelStore, String documentUri, Path filePath) throws InvalidSPDXAnalysisException, IOException {
        Objects.requireNonNull(modelStore, "Model store can not be null");
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        Objects.requireNonNull(filePath, "File path can not be null");
        Files.createFile(filePath, new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(filePath.toFile());){
            modelStore.serialize(documentUri, fos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Stream<? extends ModelObject> getAllItems(IModelStore modelStore, String documentUri, String typeFilter) throws InvalidSPDXAnalysisException {
        return modelStore.getAllItems(documentUri, typeFilter).map(tv -> {
            try {
                return SpdxModelFactory.createModelObject(modelStore, documentUri, tv.getId(), tv.getType(), null);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Stream<SpdxPackage> getAllPackages(IModelStore modelStore, String documentUri) throws InvalidSPDXAnalysisException {
        return Read.getAllItems(modelStore, documentUri, "Package");
    }

    public static class Document {
        public static List<SpdxDocument> get(IModelStore modelStore) throws InvalidSPDXAnalysisException, IOException {
            List<String> documentUris = modelStore.getDocumentUris();
            ArrayList<SpdxDocument> retval = new ArrayList<SpdxDocument>();
            for (String documentUri : documentUris) {
                retval.add(new SpdxDocument(modelStore, documentUri, null, false));
            }
            return retval;
        }

        public static SpdxDocument get(IModelStore modelStore, String documentUri) throws InvalidSPDXAnalysisException, IOException {
            IModelStore.IModelStoreLock lock = modelStore.enterCriticalSection(documentUri, true);
            try {
                SpdxDocument spdxDocument = new SpdxDocument(modelStore, documentUri, null, false);
                return spdxDocument;
            }
            finally {
                modelStore.leaveCriticalSection(lock);
            }
        }

        public static boolean documentExists(IModelStore modelStore, String documentUri) {
            return modelStore.exists(documentUri, "SPDXRef-DOCUMENT");
        }
    }
}

