/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;

public class Write {
    public static void applyUpdatesInOneTransaction(String documentUri, IModelStore modelStore, IModelStore.ModelUpdate ... updates) throws InvalidSPDXAnalysisException, IOException {
        Write.applyUpdatesInOneTransaction(documentUri, modelStore, Arrays.asList(updates));
    }

    public static void applyUpdatesInOneTransaction(String documentUri, IModelStore modelStore, Iterable<? extends IModelStore.ModelUpdate> updates) throws InvalidSPDXAnalysisException, IOException {
        IModelStore.IModelStoreLock lock = modelStore.enterCriticalSection(documentUri, false);
        try {
            for (IModelStore.ModelUpdate modelUpdate : updates) {
                modelUpdate.apply();
            }
        }
        finally {
            modelStore.leaveCriticalSection(lock);
        }
    }

    public static void deSerialize(ISerializableModelStore modelStore, String documentUri, InputStream stream) throws InvalidSPDXAnalysisException, IOException {
        IModelStore.IModelStoreLock lock = modelStore.enterCriticalSection(documentUri, false);
        try {
            modelStore.deSerialize(stream, false);
        }
        finally {
            modelStore.leaveCriticalSection(lock);
        }
    }

    public static void readFile(ISerializableModelStore modelStore, String documentUri, Path filePath) throws InvalidSPDXAnalysisException, IOException {
        Objects.requireNonNull(modelStore, "Model store can not be null");
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        Objects.requireNonNull(filePath, "File path can not be null");
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = Files.newInputStream(filePath, new OpenOption[0]);){
            Write.deSerialize(modelStore, documentUri, is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

