/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.spdx.library.SpdxConstants;
import org.spdx.library.SpdxInvalidIdException;
import org.spdx.library.model.SpdxInvalidTypeException;

public class TypedValue {
    static Set<String> SPDX_CLASSES = new HashSet<String>(Arrays.asList(SpdxConstants.ALL_SPDX_CLASSES));
    String id;
    String type;

    public TypedValue(String id, String type) throws SpdxInvalidIdException, SpdxInvalidTypeException {
        if (id == null) {
            throw new SpdxInvalidIdException("Null value Id");
        }
        if (type == null) {
            throw new SpdxInvalidTypeException("Null type");
        }
        if (!(SPDX_CLASSES.contains(type) || "GenericModelObject".equals(type) || "GenericSpdxElement".equals(type) || "GenericSpdxItem".equals(type))) {
            throw new SpdxInvalidTypeException(String.valueOf(type) + " is not a valid SPDX class");
        }
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TypedValue)) {
            return false;
        }
        TypedValue tv = (TypedValue)o;
        return tv.getId().equals(this.id) && tv.getType().equals(this.type);
    }

    public int hashCode() {
        return 0xB5 ^ this.id.hashCode() ^ this.type.hashCode();
    }
}

