/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.ExternalSpdxElement;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.SimpleUriValue;
import org.spdx.library.model.license.AbstractExtractedLicenseInfo;
import org.spdx.storage.IModelStore;

public class ExternalExtractedLicenseInfo
extends AbstractExtractedLicenseInfo
implements IndividualUriValue {
    public ExternalExtractedLicenseInfo(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    public ExternalExtractedLicenseInfo(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
        if (!SpdxConstants.EXTERNAL_EXTRACTED_LICENSE_PATTERN.matcher(id).matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:LicenseRef-XXX");
        }
        this.getExternalExtractedLicenseURI();
    }

    public String getExternalDocumentId() throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstants.EXTERNAL_EXTRACTED_LICENSE_PATTERN.matcher(this.getId());
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:LicenseRef-XXX");
        }
        return matcher.group(1);
    }

    public String getExternalLicenseRef() throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstants.EXTERNAL_EXTRACTED_LICENSE_PATTERN.matcher(this.getId());
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:LicenseRef-XXX");
        }
        return matcher.group(2);
    }

    @Override
    public String getType() {
        return "ExternalExtractedLicenseInfo";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        String id = this.getId();
        Matcher matcher = SpdxConstants.EXTERNAL_EXTRACTED_LICENSE_PATTERN.matcher(id);
        if (!matcher.matches()) {
            retval.add("Invalid id format for an external document reference.  Must be of the form " + SpdxConstants.EXTERNAL_ELEMENT_REF_PATTERN.pattern());
        } else {
            try {
                ExternalSpdxElement.externalDocumentIdToNamespace(matcher.group(1), this.getModelStore(), this.getDocumentUri(), this.getCopyManager());
            }
            catch (InvalidSPDXAnalysisException e) {
                retval.add(e.getMessage());
            }
        }
        return retval;
    }

    public String getExternalExtractedLicenseURI() throws InvalidSPDXAnalysisException {
        return ExternalExtractedLicenseInfo.externalExtractedLicenseIdToURI(this.getId(), this.getModelStore(), this.getDocumentUri(), this.getCopyManager());
    }

    public static String externalExtractedLicenseIdToURI(String externalExtractedLicenseId, IModelStore stModelStore, String stDocumentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstants.EXTERNAL_EXTRACTED_LICENSE_PATTERN.matcher(externalExtractedLicenseId);
        if (!matcher.matches()) {
            logger.error("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:LicenseRef-XXX");
            throw new InvalidSPDXAnalysisException("Invalid id format for an external document reference.  Must be of the form ExternalSPDXRef:LicenseRef-XXX");
        }
        String externalDocumentUri = ExternalSpdxElement.externalDocumentIdToNamespace(matcher.group(1), stModelStore, stDocumentUri, copyManager);
        if (externalDocumentUri.endsWith("#")) {
            return String.valueOf(externalDocumentUri) + matcher.group(2);
        }
        return String.valueOf(externalDocumentUri) + "#" + matcher.group(2);
    }

    public static ExternalExtractedLicenseInfo uriToExternalExtractedLicense(String externalLicenseUri, IModelStore stModelStore, String stDocumentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        return new ExternalExtractedLicenseInfo(stModelStore, stDocumentUri, ExternalExtractedLicenseInfo.uriToExternalExtractedLicenseId(externalLicenseUri, stModelStore, stDocumentUri, copyManager), copyManager, true);
    }

    public static String uriToExternalExtractedLicenseId(String uri, IModelStore stModelStore, String stDocumentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(uri, "URI can not be null");
        Matcher matcher = SpdxConstants.EXTERNAL_EXTRACTED_LICENSE_URI_PATTERN.matcher(uri);
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid URI format: " + uri + ".  Expects namespace#LicenseRef-XXXX");
        }
        Optional<ExternalDocumentRef> externalDocRef = ExternalDocumentRef.getExternalDocRefByDocNamespace(stModelStore, stDocumentUri, matcher.group(1), copyManager);
        if (!externalDocRef.isPresent()) {
            logger.error("Could not find or create the external document reference for document namespace " + matcher.group(1));
            throw new InvalidSPDXAnalysisException("Could not find or create the external document reference for document namespace " + matcher.group(1));
        }
        return String.valueOf(externalDocRef.get().getId()) + ":" + matcher.group(2);
    }

    @Override
    public boolean equivalent(ModelObject compare) {
        if (!(compare instanceof ExternalExtractedLicenseInfo)) {
            return false;
        }
        return this.getId().equals(compare.getId());
    }

    @Override
    public boolean equivalent(ModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        return this.equivalent(compare);
    }

    @Override
    public String getIndividualURI() {
        try {
            return this.getExternalExtractedLicenseURI();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Error getting external LicenseRef URI", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExtractedText() throws InvalidSPDXAnalysisException {
        return "The text for this license can be found in the external document " + this.getExternalDocumentId() + " license Ref " + this.getExternalLicenseRef() + ".";
    }

    @Override
    public String getComment() throws InvalidSPDXAnalysisException {
        return "This is an external LicenseRef - see the document containing the license for any comments";
    }

    @Override
    public void setComment(String comment) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set comment for an external LicenseRef.  Changes to the license need to be made within the document containing the license.");
    }

    @Override
    public Collection<String> getSeeAlso() throws InvalidSPDXAnalysisException {
        return new ArrayList<String>();
    }

    @Override
    public void setSeeAlso(Collection<String> seeAlsoUrl) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set seeAlso for an external LicenseRef.  Changes to the license need to be made within the document containing the license.");
    }

    @Override
    public String getName() throws InvalidSPDXAnalysisException {
        return "";
    }

    @Override
    public void setName(String name) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set name for an external LicenseRef.  Changes to the license need to be made within the document containing the license.");
    }

    @Override
    public boolean equals(Object comp) {
        return SimpleUriValue.isIndividualUriValueEquals(this, comp);
    }

    @Override
    public int hashCode() {
        return SimpleUriValue.getIndividualUriValueHash(this);
    }
}

