/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenseTemplate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.spdx.licenseTemplate.HtmlTemplateOutputHandler;
import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseParserException;
import org.spdx.licenseTemplate.LicenseTemplateRule;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.TextTemplateOutputHandler;

public class SpdxLicenseTemplateHelper {
    static final String START_RULE = "<<";
    static final String END_RULE = ">>";
    public static final Pattern RULE_PATTERN = Pattern.compile("<<\\s*(beginOptional|endOptional|var)");
    public static final Pattern END_RULE_PATTERN = Pattern.compile(">>");
    private static final int SPACES_PER_TAB = 5;
    private static final int MAX_TABS = 4;
    private static final int[] PIXELS_PER_TAB = new int[]{20, 40, 60, 70};

    public static void parseTemplate(String licenseTemplate, ILicenseTemplateOutputHandler templateOutputHandler) throws LicenseTemplateRuleException, LicenseParserException {
        Matcher ruleMatcher = RULE_PATTERN.matcher(licenseTemplate);
        Matcher endRuleMatcher = END_RULE_PATTERN.matcher(licenseTemplate);
        int end = 0;
        int optionalNestLevel = 0;
        int start = 0;
        while (ruleMatcher.find(start)) {
            String upToTheFind = licenseTemplate.substring(end, ruleMatcher.start());
            if (!upToTheFind.trim().isEmpty()) {
                templateOutputHandler.text(upToTheFind);
            }
            if (!endRuleMatcher.find(ruleMatcher.end())) {
                throw new LicenseTemplateRuleException("Missing end of rule '>>' after text '" + upToTheFind + "'");
            }
            end = endRuleMatcher.end();
            String ruleString = licenseTemplate.substring(ruleMatcher.start() + START_RULE.length(), end - END_RULE.length());
            start = end;
            LicenseTemplateRule rule = new LicenseTemplateRule(ruleString);
            if (rule.getType() == LicenseTemplateRule.RuleType.VARIABLE) {
                templateOutputHandler.variableRule(rule);
                continue;
            }
            if (rule.getType() == LicenseTemplateRule.RuleType.BEGIN_OPTIONAL) {
                templateOutputHandler.beginOptional(rule);
                ++optionalNestLevel;
                continue;
            }
            if (rule.getType() == LicenseTemplateRule.RuleType.END_OPTIONAL) {
                if (--optionalNestLevel < 0) {
                    throw new LicenseTemplateRuleException("End optional rule found without a matching begin optional rule after text '" + upToTheFind + "'");
                }
                templateOutputHandler.endOptional(rule);
                continue;
            }
            throw new LicenseTemplateRuleException("Unrecognized rule: " + rule.getType().toString() + " after text '" + upToTheFind + "'");
        }
        if (optionalNestLevel > 0) {
            throw new LicenseTemplateRuleException("Missing EndOptional rule and end of text");
        }
        String restOfTemplate = licenseTemplate.substring(end);
        if (!restOfTemplate.isEmpty()) {
            templateOutputHandler.text(restOfTemplate);
        }
        templateOutputHandler.completeParsing();
    }

    public static String templateTextToHtml(String licenseTemplate) throws LicenseTemplateRuleException {
        HtmlTemplateOutputHandler htmlOutput = new HtmlTemplateOutputHandler();
        try {
            SpdxLicenseTemplateHelper.parseTemplate(licenseTemplate, htmlOutput);
        }
        catch (LicenseParserException e) {
            throw new LicenseTemplateRuleException("Parsing error parsing license template", e);
        }
        return htmlOutput.getHtml();
    }

    public static String templateToText(String template) throws LicenseTemplateRuleException {
        TextTemplateOutputHandler textOutput = new TextTemplateOutputHandler();
        try {
            SpdxLicenseTemplateHelper.parseTemplate(template, textOutput);
        }
        catch (LicenseParserException e) {
            throw new LicenseTemplateRuleException("Parsing error parsing license template", e);
        }
        return textOutput.getText();
    }

    public static String formatEscapeHTML(String text) {
        return SpdxLicenseTemplateHelper.formatEscapeHTML(text, false);
    }

    public static String formatEscapeHTML(String text, boolean inParagraph) {
        String retval = StringEscapeUtils.escapeXml11((String)text);
        return SpdxLicenseTemplateHelper.addHtmlFormatting(retval, inParagraph);
    }

    public static String addHtmlFormatting(String text) {
        return SpdxLicenseTemplateHelper.addHtmlFormatting(text, false);
    }

    public static String addHtmlFormatting(String text, boolean inParagraph) {
        String[] lines = text.split("\n");
        StringBuilder result = new StringBuilder();
        result.append(lines[0]);
        int i = 1;
        while (i < lines.length) {
            if (lines[i].trim().isEmpty()) {
                if (inParagraph) {
                    result.append("</p>");
                }
                result.append("\n");
                if (++i < lines.length) {
                    String paragraphTag = SpdxLicenseTemplateHelper.getParagraphTagConsideringTags(lines[i]);
                    result.append(paragraphTag);
                    result.append(lines[i++]);
                } else {
                    result.append("<p>");
                }
                inParagraph = true;
                continue;
            }
            result.append("<br/>");
            result.append("\n");
            result.append(lines[i++]);
        }
        if (inParagraph) {
            result.append("</p>");
        } else if (text.endsWith("\n")) {
            result.append("<br/>\n");
        }
        return result.toString();
    }

    private static String getParagraphTagConsideringTags(String line) {
        int numSpaces = SpdxLicenseTemplateHelper.countLeadingSpaces(line);
        StringBuilder result = new StringBuilder();
        if (numSpaces >= 5) {
            int numTabs = numSpaces / 5;
            if (numTabs > 4) {
                numTabs = 4;
            }
            int pixels = PIXELS_PER_TAB[numTabs - 1];
            result.append("<p style=\"margin-left: ");
            result.append(String.valueOf(pixels));
            result.append("px;\">");
        } else {
            result.append("<p>");
        }
        return result.toString();
    }

    private static int countLeadingSpaces(String string) {
        char[] charArray = string.toCharArray();
        int retval = 0;
        while (retval < charArray.length && charArray[retval] == ' ') {
            ++retval;
        }
        return retval;
    }

    public static String htmlToText(String html) {
        String newlineString = "NewLineGoesHere";
        String replaceBrs = html.replaceAll("(?i)<br[^>]*>", newlineString);
        String replaceBrsAndPs = replaceBrs.replaceAll("(?i)<p[^>]*>", newlineString);
        Document doc = Jsoup.parse((String)replaceBrsAndPs);
        String retval = doc.text();
        retval = retval.replace(newlineString, "\n");
        return retval;
    }
}

