/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.TypedValue;

public interface IModelStore
extends AutoCloseable {
    public boolean exists(String var1, String var2);

    public void create(String var1, String var2, String var3) throws InvalidSPDXAnalysisException;

    public List<String> getPropertyValueNames(String var1, String var2) throws InvalidSPDXAnalysisException;

    public void setValue(String var1, String var2, String var3, Object var4) throws InvalidSPDXAnalysisException;

    public Optional<Object> getValue(String var1, String var2, String var3) throws InvalidSPDXAnalysisException;

    public String getNextId(IdType var1, String var2) throws InvalidSPDXAnalysisException;

    public void removeProperty(String var1, String var2, String var3) throws InvalidSPDXAnalysisException;

    public List<String> getDocumentUris();

    public Stream<TypedValue> getAllItems(String var1, @Nullable String var2) throws InvalidSPDXAnalysisException;

    public IModelStoreLock enterCriticalSection(String var1, boolean var2) throws InvalidSPDXAnalysisException;

    public void leaveCriticalSection(IModelStoreLock var1);

    public boolean removeValueFromCollection(String var1, String var2, String var3, Object var4) throws InvalidSPDXAnalysisException;

    public int collectionSize(String var1, String var2, String var3) throws InvalidSPDXAnalysisException;

    public boolean collectionContains(String var1, String var2, String var3, Object var4) throws InvalidSPDXAnalysisException;

    public void clearValueCollection(String var1, String var2, String var3) throws InvalidSPDXAnalysisException;

    public boolean addValueToCollection(String var1, String var2, String var3, Object var4) throws InvalidSPDXAnalysisException;

    public Iterator<Object> listValues(String var1, String var2, String var3) throws InvalidSPDXAnalysisException;

    public boolean isCollectionMembersAssignableTo(String var1, String var2, String var3, Class<?> var4) throws InvalidSPDXAnalysisException;

    public boolean isPropertyValueAssignableTo(String var1, String var2, String var3, Class<?> var4) throws InvalidSPDXAnalysisException;

    public boolean isCollectionProperty(String var1, String var2, String var3) throws InvalidSPDXAnalysisException;

    public IdType getIdType(String var1);

    public Optional<String> getCaseSensisitiveId(String var1, String var2);

    public Optional<TypedValue> getTypedValue(String var1, String var2) throws InvalidSPDXAnalysisException;

    public void delete(String var1, String var2) throws InvalidSPDXAnalysisException;

    public static interface IModelStoreLock {
        public void unlock();
    }

    public static enum IdType {
        LicenseRef,
        DocumentRef,
        SpdxId,
        ListedLicense,
        Literal,
        Anonymous,
        Unkown;

    }

    @FunctionalInterface
    public static interface ModelUpdate {
        public void apply() throws InvalidSPDXAnalysisException;
    }
}

