/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.InvalidSpdxPropertyException;
import org.spdx.library.model.license.CrossRef;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.licenseTemplate.InvalidLicenseTemplateException;
import org.spdx.storage.listedlicense.CrossRefJson;

public class LicenseJson {
    static final List<String> PROPERTY_VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("licenseText", "licenseTextHtml", "name", "standardLicenseHeader", "standardLicenseHeaderTemplate", "standardLicenseHeaderHtml", "standardLicenseTemplate", "isOsiApproved", "isFsfLibre", "example", "isDeprecatedLicenseId", "deprecatedVersion", "comment", "licenseId", "seeAlso", "crossRef"));
    Boolean isDeprecatedLicenseId;
    Boolean isFsfLibre;
    String licenseText;
    String standardLicenseHeaderTemplate;
    String standardLicenseTemplate;
    String name;
    String licenseComments;
    String comment;
    String licenseId;
    String standardLicenseHeader;
    List<CrossRefJson> crossRef = new ArrayList<CrossRefJson>();
    List<String> seeAlso = new ArrayList<String>();
    Boolean isOsiApproved;
    String licenseTextHtml;
    String standardLicenseHeaderHtml;
    String example;
    String deprecatedVersion;

    public LicenseJson(String id) {
        this.licenseId = id;
    }

    public LicenseJson() {
    }

    public List<String> getPropertyValueNames() {
        return PROPERTY_VALUE_NAMES;
    }

    public void setTypedProperty(String propertyName, String valueId, String type) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException("Invalid type for Listed License SPDX Property: " + type);
    }

    public void setPrimativeValue(String propertyName, Object value) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "licenseText": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.licenseText = (String)value;
                break;
            }
            case "licenseTextHtml": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.licenseTextHtml = (String)value;
                break;
            }
            case "name": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.name = (String)value;
                break;
            }
            case "seeAlso": 
            case "crossRef": {
                throw new InvalidSpdxPropertyException("Expected list type for " + propertyName);
            }
            case "standardLicenseHeader": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.standardLicenseHeader = (String)value;
                break;
            }
            case "standardLicenseHeaderTemplate": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.standardLicenseHeaderTemplate = (String)value;
                break;
            }
            case "standardLicenseHeaderHtml": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.standardLicenseHeaderHtml = (String)value;
                break;
            }
            case "standardLicenseTemplate": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.standardLicenseTemplate = (String)value;
                break;
            }
            case "isOsiApproved": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected Boolean type for " + propertyName);
                }
                this.isOsiApproved = (Boolean)value;
                break;
            }
            case "isFsfLibre": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected Boolean type for " + propertyName);
                }
                this.isFsfLibre = (Boolean)value;
                break;
            }
            case "example": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.example = (String)value;
                break;
            }
            case "isDeprecatedLicenseId": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected Boolean type for " + propertyName);
                }
                this.isDeprecatedLicenseId = (Boolean)value;
                break;
            }
            case "deprecatedVersion": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.deprecatedVersion = (String)value;
                break;
            }
            case "comment": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.licenseComments = (String)value;
                this.comment = (String)value;
                break;
            }
            case "licenseId": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
                }
                this.licenseId = (String)value;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
            }
        }
    }

    public void clearPropertyValueList(String propertyName) throws InvalidSpdxPropertyException {
        if ("seeAlso".equals(propertyName)) {
            this.seeAlso.clear();
        } else if ("crossRef".equals(propertyName)) {
            this.crossRef.clear();
        } else {
            throw new InvalidSpdxPropertyException(String.valueOf(propertyName) + "is not a list type");
        }
    }

    public boolean addCrossRefValueToList(String propertyName, CrossRefJson value) throws InvalidSPDXAnalysisException {
        if ("crossRef".equals(propertyName)) {
            return this.crossRef.add(value);
        }
        throw new InvalidSpdxPropertyException(String.valueOf(propertyName) + "is not a crossRef list type");
    }

    public boolean addPrimitiveValueToList(String propertyName, Object value) throws InvalidSPDXAnalysisException {
        if ("seeAlso".equals(propertyName)) {
            if (!(value instanceof String)) {
                throw new InvalidSpdxPropertyException("Expected string type for " + propertyName);
            }
            return this.seeAlso.add((String)value);
        }
        if ("crossRef".equals(propertyName)) {
            if (!(value instanceof CrossRefJson)) {
                throw new InvalidSpdxPropertyException("Expected CrossRefJson type for " + propertyName);
            }
            return this.crossRef.add((CrossRefJson)value);
        }
        throw new InvalidSpdxPropertyException(String.valueOf(propertyName) + "is not a list type");
    }

    public boolean removePrimitiveValueToList(String propertyName, Object value) throws InvalidSpdxPropertyException {
        if ("seeAlso".equals(propertyName)) {
            return this.seeAlso.remove(value);
        }
        if ("crossRef".equals(propertyName)) {
            return this.crossRef.remove(value);
        }
        throw new InvalidSpdxPropertyException(String.valueOf(propertyName) + "is not a list type");
    }

    public List<?> getValueList(String propertyName) throws InvalidSpdxPropertyException {
        if ("seeAlso".equals(propertyName)) {
            return this.seeAlso;
        }
        if ("crossRef".equals(propertyName)) {
            return this.crossRef;
        }
        throw new InvalidSpdxPropertyException(String.valueOf(propertyName) + "is not a list type");
    }

    public Object getValue(String propertyName) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "licenseText": {
                return this.licenseText;
            }
            case "licenseTextHtml": {
                return this.licenseTextHtml;
            }
            case "name": {
                return this.name;
            }
            case "seeAlso": {
                return this.seeAlso;
            }
            case "crossRef": {
                return this.crossRef;
            }
            case "standardLicenseHeader": {
                return this.standardLicenseHeader;
            }
            case "standardLicenseHeaderTemplate": {
                return this.standardLicenseHeaderTemplate;
            }
            case "standardLicenseHeaderHtml": {
                return this.standardLicenseHeaderHtml;
            }
            case "standardLicenseTemplate": {
                return this.standardLicenseTemplate;
            }
            case "isOsiApproved": {
                return this.isOsiApproved;
            }
            case "isFsfLibre": {
                return this.isFsfLibre;
            }
            case "example": {
                return this.example;
            }
            case "isDeprecatedLicenseId": {
                return this.isDeprecatedLicenseId;
            }
            case "deprecatedVersion": {
                return this.deprecatedVersion;
            }
            case "comment": {
                if (this.comment != null) {
                    return this.comment;
                }
                return this.licenseComments;
            }
            case "licenseId": {
                return this.licenseId;
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
    }

    public void removeProperty(String propertyName) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "licenseText": {
                this.licenseText = null;
                break;
            }
            case "licenseTextHtml": {
                this.licenseTextHtml = null;
                break;
            }
            case "name": {
                this.name = null;
                break;
            }
            case "seeAlso": {
                this.seeAlso.clear();
                break;
            }
            case "crossRef": {
                this.crossRef.clear();
                break;
            }
            case "standardLicenseHeader": {
                this.standardLicenseHeader = null;
                break;
            }
            case "standardLicenseHeaderTemplate": {
                this.standardLicenseHeaderTemplate = null;
                break;
            }
            case "standardLicenseHeaderHtml": {
                this.standardLicenseHeaderHtml = null;
                break;
            }
            case "standardLicenseTemplate": {
                this.standardLicenseTemplate = null;
                break;
            }
            case "isOsiApproved": {
                this.isOsiApproved = null;
                break;
            }
            case "isFsfLibre": {
                this.isFsfLibre = null;
                break;
            }
            case "example": {
                this.example = null;
                break;
            }
            case "isDeprecatedLicenseId": {
                this.isDeprecatedLicenseId = null;
                break;
            }
            case "deprecatedVersion": {
                this.deprecatedVersion = null;
                break;
            }
            case "comment": {
                this.comment = null;
                this.licenseComments = null;
                break;
            }
            case "licenseId": {
                this.licenseId = null;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
            }
        }
    }

    public void copyFrom(SpdxListedLicense fromLicense) throws InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        this.comment = null;
        this.licenseComments = fromLicense.getComment();
        if (Objects.nonNull(this.licenseComments) && this.licenseComments.isEmpty()) {
            this.licenseComments = null;
        }
        this.deprecatedVersion = fromLicense.getDeprecatedVersion();
        if (Objects.nonNull(this.deprecatedVersion) && this.deprecatedVersion.isEmpty()) {
            this.deprecatedVersion = null;
        }
        this.example = null;
        this.isDeprecatedLicenseId = fromLicense.isDeprecated();
        this.isFsfLibre = fromLicense.getFsfLibre();
        this.licenseId = fromLicense.getId();
        this.licenseText = fromLicense.getLicenseText();
        if (Objects.nonNull(this.licenseText) && this.licenseText.isEmpty()) {
            this.licenseText = null;
        }
        this.licenseTextHtml = fromLicense.getLicenseTextHtml();
        if (Objects.nonNull(this.licenseTextHtml) && this.licenseTextHtml.isEmpty()) {
            this.licenseTextHtml = null;
        }
        this.name = fromLicense.getName();
        if (Objects.nonNull(this.name) && this.name.isEmpty()) {
            this.name = null;
        }
        this.isOsiApproved = fromLicense.isOsiApproved();
        this.seeAlso = new ArrayList<String>(fromLicense.getSeeAlso());
        this.standardLicenseHeader = fromLicense.getStandardLicenseHeader();
        if (Objects.nonNull(this.standardLicenseHeader) && this.standardLicenseHeader.isEmpty()) {
            this.standardLicenseHeader = null;
        }
        this.standardLicenseHeaderHtml = fromLicense.getLicenseHeaderHtml();
        if (Objects.nonNull(this.standardLicenseHeaderHtml) && this.standardLicenseHeaderHtml.isEmpty()) {
            this.standardLicenseHeaderHtml = null;
        }
        this.standardLicenseHeaderTemplate = fromLicense.getStandardLicenseHeaderTemplate();
        if (Objects.nonNull(this.standardLicenseHeaderTemplate) && this.standardLicenseHeaderTemplate.isEmpty()) {
            this.standardLicenseHeaderTemplate = null;
        }
        this.standardLicenseTemplate = fromLicense.getStandardLicenseTemplate();
        if (Objects.nonNull(this.standardLicenseTemplate) && this.standardLicenseTemplate.isEmpty()) {
            this.standardLicenseTemplate = null;
        }
        this.crossRef.clear();
        for (CrossRef crossRef : fromLicense.getCrossRef()) {
            this.crossRef.add(new CrossRefJson(crossRef));
        }
    }

    public boolean isPropertyValueAssignableTo(String propertyName, Class<?> clazz) throws InvalidSpdxPropertyException {
        switch (propertyName) {
            case "example": 
            case "licenseTextHtml": 
            case "licenseText": 
            case "standardLicenseHeader": 
            case "standardLicenseTemplate": 
            case "standardLicenseHeaderTemplate": 
            case "name": 
            case "deprecatedVersion": 
            case "comment": 
            case "licenseId": 
            case "standardLicenseHeaderHtml": {
                return String.class.isAssignableFrom(clazz);
            }
            case "seeAlso": 
            case "crossRef": {
                return false;
            }
            case "isFsfLibre": 
            case "isDeprecatedLicenseId": 
            case "isOsiApproved": {
                return Boolean.class.isAssignableFrom(clazz);
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyName);
    }

    public boolean isCollectionMembersAssignableTo(String propertyName, Class<?> clazz) {
        if ("seeAlso".equals(propertyName)) {
            return String.class.isAssignableFrom(clazz);
        }
        if ("crossRef".equals(propertyName)) {
            return CrossRef.class.isAssignableFrom(clazz);
        }
        return false;
    }

    public boolean isCollectionProperty(String propertyName) {
        return "seeAlso".equals(propertyName) || "crossRef".equals(propertyName);
    }
}

