/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ConjunctiveLicenseSet;
import org.spdx.library.model.license.DisjunctiveLicenseSet;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.library.model.license.License;
import org.spdx.library.model.license.LicenseException;
import org.spdx.library.model.license.LicenseSet;
import org.spdx.library.model.license.ListedLicenseException;
import org.spdx.library.model.license.ListedLicenses;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.licenseTemplate.LicenseParserException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.utility.compare.CompareTemplateOutputHandler;
import org.spdx.utility.compare.FilterTemplateOutputHandler;
import org.spdx.utility.compare.LineColumn;
import org.spdx.utility.compare.SpdxCompareException;

public class LicenseCompareHelper {
    static final Logger logger = LoggerFactory.getLogger(LicenseCompareHelper.class);
    protected static final String TOKEN_SPLIT_REGEX = "(^|[^\\s\\.,?'();:\"/\\[\\]]{1,100})((\\s|\\.|,|\\?|'|\"|\\(|\\)|;|:|/|\\[|\\]|$){1,100})";
    protected static final Pattern TOKEN_SPLIT_PATTERN = Pattern.compile("(^|[^\\s\\.,?'();:\"/\\[\\]]{1,100})((\\s|\\.|,|\\?|'|\"|\\(|\\)|;|:|/|\\[|\\]|$){1,100})");
    protected static final Set<String> PUNCTUATION = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".", ",", "?", "\"", "'", "(", ")", ";", ":", "/", "[", "]")));
    protected static final Set<String> SKIPPABLE_TOKENS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("//", "/*", "*/", "/**", "#", "##", "*", "**", "\"\"\"", "/", "=begin", "=end")));
    protected static final Map<String, String> NORMALIZE_TOKENS = new HashMap<String, String>();
    protected static final Integer CROSS_REF_NUM_WORDS_MATCH = 80;
    protected static final Pattern REGEX_QUANTIFIER_PATTERN = Pattern.compile(".*\\.\\{(\\d+),(\\d+)\\}$");
    static final String DASHES_REGEX = "[\\u2012\\u2013\\u2014\\u2015]";
    static final Pattern SPACE_PATTERN;
    static final Pattern COMMA_PATTERN;
    static final Pattern PER_CENT_PATTERN;
    static final Pattern COPYRIGHT_HOLDER_PATTERN;
    static final Pattern COPYRIGHT_HOLDERS_PATTERN;
    static final Pattern COPYRIGHT_OWNERS_PATTERN;
    static final Pattern COPYRIGHT_OWNER_PATTERN;
    static final Pattern PER_CENT_PATTERN_LF;
    static final Pattern COPYRIGHT_HOLDERS_PATTERN_LF;
    static final Pattern COPYRIGHT_HOLDER_PATTERN_LF;
    static final Pattern COPYRIGHT_OWNERS_PATTERN_LF;
    static final Pattern COPYRIGHT_OWNER_PATTERN_LF;
    static final Pattern COPYRIGHT_SYMBOL_PATTERN;
    static final String START_COMMENT_CHAR_PATTERN = "(//|/\\*|\\*|#|' |REM |<!--|--|;|\\(\\*|\\{-)|\\.\\\\\"";

    static {
        NORMALIZE_TOKENS.put("&", "and");
        NORMALIZE_TOKENS.put("acknowledgment", "acknowledgement");
        NORMALIZE_TOKENS.put("analogue", "analog");
        NORMALIZE_TOKENS.put("analyse", "analyze");
        NORMALIZE_TOKENS.put("artefact", "artifact");
        NORMALIZE_TOKENS.put("authorisation", "authorization");
        NORMALIZE_TOKENS.put("authorised", "authorized");
        NORMALIZE_TOKENS.put("calibre", "caliber");
        NORMALIZE_TOKENS.put("cancelled", "canceled");
        NORMALIZE_TOKENS.put("apitalisations", "apitalizations");
        NORMALIZE_TOKENS.put("catalogue", "catalog");
        NORMALIZE_TOKENS.put("categorise", "categorize");
        NORMALIZE_TOKENS.put("centre", "center");
        NORMALIZE_TOKENS.put("emphasised", "emphasized");
        NORMALIZE_TOKENS.put("favour", "favor");
        NORMALIZE_TOKENS.put("favourite", "favorite");
        NORMALIZE_TOKENS.put("fulfil", "fulfill");
        NORMALIZE_TOKENS.put("fulfilment", "fulfillment");
        NORMALIZE_TOKENS.put("initialise", "initialize");
        NORMALIZE_TOKENS.put("judgment", "judgement");
        NORMALIZE_TOKENS.put("labelling", "labeling");
        NORMALIZE_TOKENS.put("labour", "labor");
        NORMALIZE_TOKENS.put("licence", "license");
        NORMALIZE_TOKENS.put("maximise", "maximize");
        NORMALIZE_TOKENS.put("modelled", "modeled");
        NORMALIZE_TOKENS.put("modelling", "modeling");
        NORMALIZE_TOKENS.put("offence", "offense");
        NORMALIZE_TOKENS.put("optimise", "optimize");
        NORMALIZE_TOKENS.put("organisation", "organization");
        NORMALIZE_TOKENS.put("organise", "organize");
        NORMALIZE_TOKENS.put("practise", "practice");
        NORMALIZE_TOKENS.put("programme", "program");
        NORMALIZE_TOKENS.put("realise", "realize");
        NORMALIZE_TOKENS.put("recognise", "recognize");
        NORMALIZE_TOKENS.put("signalling", "signaling");
        NORMALIZE_TOKENS.put("utilisation", "utilization");
        NORMALIZE_TOKENS.put("whilst", "while");
        NORMALIZE_TOKENS.put("wilful", "wilfull");
        NORMALIZE_TOKENS.put("non-commercial", "noncommercial");
        NORMALIZE_TOKENS.put("copyright-owner", "copyright-holder");
        NORMALIZE_TOKENS.put("sublicense", "sub-license");
        NORMALIZE_TOKENS.put("non-infringement", "noninfringement");
        NORMALIZE_TOKENS.put("(c)", "-c-");
        NORMALIZE_TOKENS.put("\u00a9", "-c-");
        NORMALIZE_TOKENS.put("copyright", "-c-");
        NORMALIZE_TOKENS.put("\"", "'");
        NORMALIZE_TOKENS.put("merchantability", "merchantability");
        SPACE_PATTERN = Pattern.compile("[\\u202F\\u2007\\u2060\\u2009]");
        COMMA_PATTERN = Pattern.compile("[\\uFF0C\\uFE10\\uFE50]");
        PER_CENT_PATTERN = Pattern.compile("per cent", 2);
        COPYRIGHT_HOLDER_PATTERN = Pattern.compile("copyright holder", 2);
        COPYRIGHT_HOLDERS_PATTERN = Pattern.compile("copyright holders", 2);
        COPYRIGHT_OWNERS_PATTERN = Pattern.compile("copyright owners", 2);
        COPYRIGHT_OWNER_PATTERN = Pattern.compile("copyright owner", 2);
        PER_CENT_PATTERN_LF = Pattern.compile("per\\s{0,100}\\n{1,10}\\s{0,100}cent", 2);
        COPYRIGHT_HOLDERS_PATTERN_LF = Pattern.compile("copyright\\s{0,100}\\n{1,10}\\s{0,100}holders", 2);
        COPYRIGHT_HOLDER_PATTERN_LF = Pattern.compile("copyright\\s{0,100}\\n{1,10}\\s{0,100}holder", 2);
        COPYRIGHT_OWNERS_PATTERN_LF = Pattern.compile("copyright\\s{0,100}\\n{1,10}\\s{0,100}owners", 2);
        COPYRIGHT_OWNER_PATTERN_LF = Pattern.compile("copyright\\s{0,100}\\n{1,10}\\s{0,100}owner", 2);
        COPYRIGHT_SYMBOL_PATTERN = Pattern.compile("\\(c\\)", 2);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isLicenseTextEquivalent(String licenseTextA, String licenseTextB) {
        if (licenseTextA == null) {
            return licenseTextB == null || licenseTextB.isEmpty() != false;
        }
        if (licenseTextB == null) {
            return licenseTextA.isEmpty();
        }
        if (licenseTextA.equals(licenseTextB)) {
            return true;
        }
        tokenToLocationA = new HashMap<Integer, LineColumn>();
        tokenToLocationB = new HashMap<Integer, LineColumn>();
        licenseATokens = LicenseCompareHelper.tokenizeLicenseText(licenseTextA, tokenToLocationA);
        licenseBTokens = LicenseCompareHelper.tokenizeLicenseText(licenseTextB, tokenToLocationB);
        bTokenCounter = 0;
        aTokenCounter = 0;
        nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
        nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        while (nextAToken != null) {
            if (nextBToken == null) {
                while (nextAToken != null && LicenseCompareHelper.canSkip(nextAToken)) {
                    nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
                }
                if (nextAToken == null) continue;
                return false;
            }
            if (!LicenseCompareHelper.tokensEquivalent(nextAToken, nextBToken)) ** GOTO lbl27
            nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
            nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
            continue;
lbl-1000:
            // 1 sources

            {
                nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
lbl27:
                // 2 sources

                ** while (nextBToken != null && LicenseCompareHelper.canSkip((String)nextBToken))
            }
lbl28:
            // 2 sources

            while (nextAToken != null && LicenseCompareHelper.canSkip(nextAToken)) {
                nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
            }
            if (!LicenseCompareHelper.tokensEquivalent(nextAToken, nextBToken)) {
                return false;
            }
            nextAToken = LicenseCompareHelper.getTokenAt(licenseATokens, aTokenCounter++);
            nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        }
        while (nextBToken != null && LicenseCompareHelper.canSkip(nextBToken)) {
            nextBToken = LicenseCompareHelper.getTokenAt(licenseBTokens, bTokenCounter++);
        }
        return nextBToken == null;
    }

    public static String removeLineSeparators(String s) {
        return s.replaceAll("(-|=|\\*){3,}\\s*$", "");
    }

    public static String removeCommentChars(String s) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new StringReader(s));
            String line = reader.readLine();
            while (line != null) {
                line = line.replaceAll("(\\*/|-->|-\\}|\\*\\)|\\s\\*)\\s*$", "");
                line = line.replaceAll("^\\s*(//|/\\*|\\*|#|' |REM |<!--|--|;|\\(\\*|\\{-)|\\.\\\\\"", "");
                line = line.replaceAll("^\\s*<<beginOptional>>\\s*(//|/\\*|\\*|#|' |REM |<!--|--|;|\\(\\*|\\{-)|\\.\\\\\"", "<<beginOptional>>");
                sb.append(line);
                sb.append("\n");
                line = reader.readLine();
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.warn("IO error reading strings?!?");
            String string = s;
            return string;
        }
        finally {
            if (Objects.nonNull(reader)) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warn("IO error closing a string reader?!?");
                }
            }
        }
    }

    public static String normalizeText(String s) {
        return s.replaceAll("\u2018|\u2019|\u201b|\u201a|`", "'").replaceAll("http://", "https://").replaceAll("''", "\"").replaceAll("\u201c|\u201d|\u201f|\u201e", "\"").replaceAll("\\u00A0", " ").replaceAll("\u2014|\u2013", "-").replaceAll("\\u2028", "\n");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String locateOriginalText(String fullLicenseText, int startToken, int endToken, Map<Integer, LineColumn> tokenToLocation, String[] tokens) {
        if (startToken > endToken) {
            return "";
        }
        start = tokenToLocation.get(startToken);
        if (start == null) {
            return "";
        }
        end = tokenToLocation.get(endToken);
        reader = null;
        try {
            block32: {
                reader = new BufferedReader(new StringReader(fullLicenseText));
                currentLine = 1;
                line = reader.readLine();
                while (true) {
                    if (line == null || currentLine >= start.getLine()) {
                        if (line != null) break;
                        return "";
                    }
                    ++currentLine;
                    line = reader.readLine();
                }
                if (end != null) break block32;
                sb = new StringBuilder(line.substring(start.getColumn(), line.length()));
                ++currentLine;
                line = reader.readLine();
                if (true) ** GOTO lbl72
            }
            if (end.getLine() == currentLine) {
                var12_21 = line.substring(start.getColumn(), end.getColumn() + end.getLen());
                return var12_21;
            }
            sb = new StringBuilder(line.substring(start.getColumn(), line.length()));
            ++currentLine;
            line = reader.readLine();
            while (true) {
                if (line == null || currentLine >= end.getLine()) {
                    if (line != null && end.getColumn() + end.getLen() > 0) {
                        sb.append("\n");
                        sb.append(line.substring(0, end.getColumn() + end.getLen()));
                    }
                    var12_22 = sb.toString();
                    return var12_22;
                }
                sb.append("\n");
                sb.append(line);
                ++currentLine;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            sb = new StringBuilder(tokens[startToken]);
            i = startToken + 1;
            while (true) {
                if (i > endToken) {
                    var12_23 = sb.toString();
                    return var12_23;
                }
                sb.append(' ');
                sb.append(tokens[i]);
                ++i;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException var13_15) {}
            }
        }
        do {
            sb.append(line);
            ++currentLine;
            line = reader.readLine();
lbl72:
            // 2 sources

        } while (line != null);
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String[] tokenizeLicenseText(String licenseText, Map<Integer, LineColumn> tokenToLocation) {
        block18: {
            textToTokenize = LicenseCompareHelper.normalizeText(LicenseCompareHelper.replaceMultWord(LicenseCompareHelper.replaceSpaceComma(licenseText))).toLowerCase();
            tokens = new ArrayList<String>();
            reader = null;
            try {
                try {
                    reader = new BufferedReader(new StringReader(textToTokenize));
                    currentLine = 1;
                    currentToken = 0;
                    line = reader.readLine();
                    while (line != null) {
                        line = LicenseCompareHelper.removeLineSeparators(line);
                        lineMatcher = LicenseCompareHelper.TOKEN_SPLIT_PATTERN.matcher(line);
                        while (lineMatcher.find()) {
                            token = lineMatcher.group(1).trim();
                            if (!token.isEmpty()) {
                                tokens.add(token);
                                tokenToLocation.put(currentToken, new LineColumn(currentLine, lineMatcher.start(), token.length()));
                                ++currentToken;
                            }
                            fullMatch = lineMatcher.group(0);
                            i = lineMatcher.group(1).length();
                            while (i < fullMatch.length()) {
                                possiblePunctuation = fullMatch.substring(i, i + 1);
                                if (LicenseCompareHelper.PUNCTUATION.contains(possiblePunctuation)) {
                                    tokens.add(possiblePunctuation);
                                    tokenToLocation.put(currentToken, new LineColumn(currentLine, lineMatcher.start() + i, 1));
                                    ++currentToken;
                                }
                                ++i;
                            }
                        }
                        ++currentLine;
                        line = reader.readLine();
                    }
                    break block18;
                }
                catch (IOException e) {
                    m = LicenseCompareHelper.TOKEN_SPLIT_PATTERN.matcher(textToTokenize);
                    ** while (m.find())
                }
lbl-1000:
                // 1 sources

                {
                    word = m.group(1).trim();
                    seperator = m.group(2).trim();
                    tokens.add(word);
                    if (!LicenseCompareHelper.PUNCTUATION.contains(seperator)) continue;
                    tokens.add(seperator);
                    continue;
lbl49:
                    // 1 sources

                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException var14_19) {}
                }
            }
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String getFirstLicenseToken(String text) {
        String textToTokenize = LicenseCompareHelper.normalizeText(LicenseCompareHelper.replaceMultWord(LicenseCompareHelper.replaceSpaceComma(LicenseCompareHelper.removeLineSeparators(LicenseCompareHelper.removeCommentChars(text))))).toLowerCase();
        Matcher m = TOKEN_SPLIT_PATTERN.matcher(textToTokenize);
        while (m.find()) {
            if (m.group(1).trim().isEmpty()) continue;
            return m.group(1).trim();
        }
        return null;
    }

    public static boolean isSingleTokenString(String text) {
        if (text.contains("\n")) {
            return false;
        }
        Matcher m = TOKEN_SPLIT_PATTERN.matcher(text);
        boolean found = false;
        while (m.find()) {
            if (m.group(1).trim().isEmpty()) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return true;
    }

    static String replaceSpaceComma(String s) {
        Matcher spaceMatcher = SPACE_PATTERN.matcher(s);
        Matcher commaMatcher = COMMA_PATTERN.matcher(spaceMatcher.replaceAll(" "));
        return commaMatcher.replaceAll(",");
    }

    static String replaceMultWord(String s) {
        Matcher m = COPYRIGHT_HOLDERS_PATTERN.matcher(s);
        String retval = m.replaceAll("copyright-holders");
        m = COPYRIGHT_HOLDERS_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-holders\n");
        m = COPYRIGHT_OWNERS_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-owners");
        m = COPYRIGHT_OWNERS_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-owners\n");
        m = COPYRIGHT_HOLDER_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-holder");
        m = COPYRIGHT_HOLDER_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-holder\n");
        m = COPYRIGHT_OWNER_PATTERN.matcher(retval);
        retval = m.replaceAll("copyright-owner");
        m = COPYRIGHT_OWNER_PATTERN_LF.matcher(retval);
        retval = m.replaceAll("copyright-owner\n");
        m = PER_CENT_PATTERN.matcher(retval);
        retval = m.replaceAll("percent");
        m = PER_CENT_PATTERN.matcher(retval);
        retval = m.replaceAll("percent\n");
        m = COPYRIGHT_SYMBOL_PATTERN.matcher(retval);
        retval = m.replaceAll("-c-");
        return retval;
    }

    static String getTokenAt(String[] tokens, int tokenIndex) {
        if (tokenIndex >= tokens.length) {
            return null;
        }
        return tokens[tokenIndex];
    }

    static boolean tokensEquivalent(String tokenA, String tokenB) {
        String ns2;
        String s2;
        if (tokenA == null) {
            return tokenB == null;
        }
        if (tokenB == null) {
            return false;
        }
        String s1 = tokenA.trim().toLowerCase().replaceAll(DASHES_REGEX, "-");
        if (s1.equals(s2 = tokenB.trim().toLowerCase().replaceAll(DASHES_REGEX, "-"))) {
            return true;
        }
        String ns1 = NORMALIZE_TOKENS.get(s1);
        if (ns1 == null) {
            ns1 = s1;
        }
        if ((ns2 = NORMALIZE_TOKENS.get(s2)) == null) {
            ns2 = s2;
        }
        return ns1.equals(ns2);
    }

    static boolean canSkip(String token) {
        if (token == null) {
            return false;
        }
        if (token.trim().isEmpty()) {
            return true;
        }
        return SKIPPABLE_TOKENS.contains(token.trim().toLowerCase());
    }

    public static boolean isLicenseEqual(AnyLicenseInfo license1, AnyLicenseInfo license2, Map<String, String> xlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        if (license1 instanceof ConjunctiveLicenseSet) {
            if (!(license2 instanceof ConjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((ConjunctiveLicenseSet)license1, (ConjunctiveLicenseSet)license2, xlationMap);
        }
        if (license1 instanceof DisjunctiveLicenseSet) {
            if (!(license2 instanceof DisjunctiveLicenseSet)) {
                return false;
            }
            return LicenseCompareHelper.isLicenseSetsEqual((DisjunctiveLicenseSet)license1, (DisjunctiveLicenseSet)license2, xlationMap);
        }
        if (license1 instanceof ExtractedLicenseInfo) {
            if (!(license2 instanceof ExtractedLicenseInfo)) {
                return false;
            }
            String licenseid1 = ((ExtractedLicenseInfo)license1).getLicenseId();
            String licenseid2 = ((ExtractedLicenseInfo)license2).getLicenseId();
            String xlatedLicenseId = xlationMap.get(licenseid1);
            if (xlatedLicenseId == null) {
                return false;
            }
            return xlatedLicenseId.equals(licenseid2);
        }
        return license1.equals(license2);
    }

    private static boolean isLicenseSetsEqual(LicenseSet license1, LicenseSet license2, Map<String, String> xlationMap) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Collection<AnyLicenseInfo> licenseInfos1 = license1.getMembers();
        Collection<AnyLicenseInfo> licenseInfos2 = license2.getMembers();
        if (licenseInfos1 == null) {
            return licenseInfos2 == null;
        }
        if (licenseInfos2 == null) {
            return false;
        }
        if (licenseInfos1.size() != licenseInfos2.size()) {
            return false;
        }
        for (AnyLicenseInfo ali1 : licenseInfos1) {
            boolean found = false;
            for (AnyLicenseInfo ali2 : licenseInfos2) {
                if (!LicenseCompareHelper.isLicenseEqual(ali1, ali2, xlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static List<String> getNonOptionalLicenseText(String licenseTemplate, boolean includeVarText) throws SpdxCompareException {
        return LicenseCompareHelper.getNonOptionalLicenseText(licenseTemplate, includeVarText ? FilterTemplateOutputHandler.VarTextHandling.ORIGINAL : FilterTemplateOutputHandler.VarTextHandling.OMIT);
    }

    public static List<String> getNonOptionalLicenseText(String licenseTemplate, FilterTemplateOutputHandler.VarTextHandling varTextHandling) throws SpdxCompareException {
        FilterTemplateOutputHandler filteredOutput = new FilterTemplateOutputHandler(varTextHandling);
        try {
            SpdxLicenseTemplateHelper.parseTemplate(licenseTemplate, filteredOutput);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during filter: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during filter: " + e.getMessage(), e);
        }
        return filteredOutput.getFilteredText();
    }

    public static Pattern nonOptionalTextToStartPattern(List<String> nonOptionalText, int numberOfWords) {
        int lastRegexMax;
        if (Objects.isNull(nonOptionalText) || nonOptionalText.size() == 0 || numberOfWords < 1) {
            return Pattern.compile("");
        }
        int startWordCount = 0;
        int startTextIndex = 0;
        int wordsInLastLine = 0;
        StringBuilder patternBuilder = new StringBuilder();
        String regexLimit = "," + Integer.toString(numberOfWords * 10) + "}";
        String lastRegex = "";
        while (startWordCount < numberOfWords && startTextIndex < nonOptionalText.size()) {
            String line = nonOptionalText.get(startTextIndex++);
            if (patternBuilder.length() > 0 && line.trim().length() > 0 && !patternBuilder.toString().endsWith("}")) {
                patternBuilder.append(".{0,5}");
            }
            String[] regexSplits = line.trim().split("~~~");
            boolean inRegex = false;
            String[] stringArray = regexSplits;
            int n = regexSplits.length;
            int n2 = 0;
            while (n2 < n) {
                String regexSplit = stringArray[n2];
                if (inRegex && startWordCount < numberOfWords) {
                    String regexToAppend = regexSplit.endsWith(".+") ? String.valueOf(regexSplit.substring(0, regexSplit.length() - 1)) + "{1" + regexLimit : (regexSplit.endsWith(".*") ? String.valueOf(regexSplit.substring(0, regexSplit.length() - 1)) + "{0" + regexLimit : regexSplit);
                    if (patternBuilder.toString().endsWith("}") && regexToAppend.endsWith("}")) {
                        Matcher lastRegexMatch = REGEX_QUANTIFIER_PATTERN.matcher(lastRegex);
                        Matcher regexToAppendMatch = REGEX_QUANTIFIER_PATTERN.matcher(regexToAppend);
                        if (lastRegexMatch.matches() && regexToAppendMatch.matches()) {
                            int thisRegexMax;
                            lastRegexMax = Integer.parseInt(lastRegexMatch.group(2));
                            if (lastRegexMax >= (thisRegexMax = Integer.parseInt(regexToAppendMatch.group(2)))) {
                                regexToAppend = "";
                            } else {
                                patternBuilder.setLength(patternBuilder.length() - (lastRegexMatch.group(2).length() + 1));
                                regexToAppend = regexToAppend.substring(regexToAppend.indexOf(44) + 1);
                            }
                        }
                    }
                    patternBuilder.append(regexToAppend);
                    lastRegex = regexToAppend;
                    ++startWordCount;
                    inRegex = false;
                } else {
                    String[] tokens = LicenseCompareHelper.normalizeText(regexSplit.trim()).split("\\s");
                    int tokenIndex = 0;
                    wordsInLastLine = 0;
                    while (tokenIndex < tokens.length && startWordCount < numberOfWords) {
                        String token;
                        if ((token = tokens[tokenIndex++].trim()).length() <= 0) continue;
                        if (NORMALIZE_TOKENS.containsKey(token.toLowerCase())) {
                            token = NORMALIZE_TOKENS.get(token.toLowerCase());
                        }
                        patternBuilder.append(Pattern.quote(token));
                        patternBuilder.append("\\s*");
                        ++startWordCount;
                        ++wordsInLastLine;
                    }
                    inRegex = true;
                }
                ++n2;
            }
        }
        patternBuilder.append(".{0,36000}");
        ArrayList<String> endTextReversePattern = new ArrayList<String>();
        int endTextIndex = nonOptionalText.size() - 1;
        int endWordCount = 0;
        int lastProcessedStartLine = startTextIndex - 1;
        while (endWordCount < numberOfWords && (endTextIndex > lastProcessedStartLine || endTextIndex == lastProcessedStartLine && numberOfWords - endWordCount < nonOptionalText.get(endTextIndex).length() - wordsInLastLine)) {
            ArrayList<String> nonEmptyTokens = new ArrayList<String>();
            String line = nonOptionalText.get(endTextIndex);
            String[] regexSplits = line.trim().split("~~~");
            boolean inRegex = false;
            String[] stringArray = regexSplits;
            lastRegexMax = regexSplits.length;
            int token = 0;
            while (token < lastRegexMax) {
                String regexSplit = stringArray[token];
                if (inRegex) {
                    if (!regexSplit.isEmpty()) {
                        nonEmptyTokens.add("~~~" + regexSplit);
                    }
                    inRegex = false;
                } else {
                    String[] tokens;
                    String[] stringArray2 = tokens = LicenseCompareHelper.normalizeText(regexSplit.trim()).split("\\s");
                    int n = tokens.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String token2 = stringArray2[n3];
                        String trimmedToken = token2.trim();
                        if (!trimmedToken.isEmpty()) {
                            nonEmptyTokens.add(trimmedToken);
                        }
                        ++n3;
                    }
                    inRegex = true;
                }
                ++token;
            }
            int remainingTokens = endTextIndex == lastProcessedStartLine && nonEmptyTokens.size() - wordsInLastLine > numberOfWords - endWordCount ? numberOfWords - endWordCount : nonEmptyTokens.size() - wordsInLastLine;
            --endTextIndex;
            int tokenIndex = nonEmptyTokens.size() - 1;
            while (tokenIndex >= 0 && remainingTokens > 0) {
                String token3;
                if ((token3 = (String)nonEmptyTokens.get(tokenIndex--)).startsWith("~~~")) {
                    endTextReversePattern.add(token3.substring("~~~".length()));
                } else {
                    endTextReversePattern.add("\\s*");
                    endTextReversePattern.add(Pattern.quote(token3));
                }
                --remainingTokens;
                ++endWordCount;
            }
        }
        int revPatternIndex = endTextReversePattern.size() - 1;
        while (revPatternIndex >= 0) {
            patternBuilder.append((String)endTextReversePattern.get(revPatternIndex--));
        }
        return Pattern.compile(patternBuilder.toString(), 34);
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardLicense(License license, String compareText) throws SpdxCompareException, InvalidSPDXAnalysisException {
        String licenseTemplate = license.getStandardLicenseTemplate();
        if (licenseTemplate == null || licenseTemplate.trim().isEmpty()) {
            licenseTemplate = license.getLicenseText();
        }
        CompareTemplateOutputHandler compareTemplateOutputHandler = null;
        try {
            compareTemplateOutputHandler = new CompareTemplateOutputHandler(LicenseCompareHelper.removeLineSeparators(LicenseCompareHelper.removeCommentChars(compareText)));
        }
        catch (IOException e1) {
            throw new SpdxCompareException("IO Error reading the compare text: " + e1.getMessage(), e1);
        }
        try {
            SpdxLicenseTemplateHelper.parseTemplate(LicenseCompareHelper.removeCommentChars(licenseTemplate), compareTemplateOutputHandler);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during compare: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during compare: " + e.getMessage(), e);
        }
        return compareTemplateOutputHandler.getDifferences();
    }

    public static CompareTemplateOutputHandler.DifferenceDescription isTextStandardException(LicenseException exception, String compareText) throws SpdxCompareException, InvalidSPDXAnalysisException {
        String exceptionTemplate = exception.getLicenseExceptionTemplate();
        if (exceptionTemplate == null || exceptionTemplate.trim().isEmpty()) {
            exceptionTemplate = exception.getLicenseExceptionText();
        }
        CompareTemplateOutputHandler compareTemplateOutputHandler = null;
        try {
            compareTemplateOutputHandler = new CompareTemplateOutputHandler(LicenseCompareHelper.removeLineSeparators(LicenseCompareHelper.removeCommentChars(compareText)));
        }
        catch (IOException e1) {
            throw new SpdxCompareException("IO Error reading the compare text: " + e1.getMessage(), e1);
        }
        try {
            SpdxLicenseTemplateHelper.parseTemplate(LicenseCompareHelper.removeCommentChars(exceptionTemplate), compareTemplateOutputHandler);
        }
        catch (LicenseTemplateRuleException e) {
            throw new SpdxCompareException("Invalid template rule found during compare: " + e.getMessage(), e);
        }
        catch (LicenseParserException e) {
            throw new SpdxCompareException("Invalid template found during compare: " + e.getMessage(), e);
        }
        return compareTemplateOutputHandler.getDifferences();
    }

    private static String normalizeTokensForRegex(String licenseText, List<Pair<Integer, Integer>> charPositions) throws IOException {
        StringBuilder result = new StringBuilder();
        BufferedReader reader = null;
        Pattern spaceSplitter = Pattern.compile("(.+?)\\s+");
        try {
            reader = new BufferedReader(new StringReader(licenseText));
            int originalCurrentLinePosition = 0;
            String line = reader.readLine();
            while (line != null) {
                int lineCharPosition = 0;
                Matcher lineMatcher = spaceSplitter.matcher(line);
                while (lineMatcher.find()) {
                    String token = lineMatcher.group(1).trim();
                    if (token.isEmpty() || !NORMALIZE_TOKENS.containsKey(token.toLowerCase())) continue;
                    result.append(line.substring(lineCharPosition, lineMatcher.start(1)));
                    int normalizedPosition = result.length();
                    token = NORMALIZE_TOKENS.get(token.toLowerCase());
                    result.append(token);
                    charPositions.add((Pair<Integer, Integer>)new ImmutablePair((Object)normalizedPosition, (Object)(originalCurrentLinePosition + lineMatcher.start(1))));
                    charPositions.add((Pair<Integer, Integer>)new ImmutablePair((Object)result.length(), (Object)(originalCurrentLinePosition + lineMatcher.end(1))));
                    lineCharPosition = lineMatcher.end(1);
                }
                result.append(line.substring(lineCharPosition));
                originalCurrentLinePosition = originalCurrentLinePosition + line.length() + "\n".length();
                line = reader.readLine();
                if (line == null) continue;
                result.append("\n");
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result.toString();
    }

    private static int findOriginalStart(int position, List<Pair<Integer, Integer>> charPositions) {
        if (charPositions == null || charPositions.isEmpty()) {
            return position;
        }
        Pair<Integer, Integer> lastPair = charPositions.get(0);
        int i = 1;
        while (i < charPositions.size() && (Integer)lastPair.getKey() < position) {
            lastPair = charPositions.get(i);
            ++i;
        }
        return (Integer)lastPair.getValue() + (position - (Integer)lastPair.getKey());
    }

    private static String findTemplateWithinText(String text, String template) throws SpdxCompareException {
        String compareText;
        String firstLine;
        String result = null;
        int startIndex = -1;
        int endIndex = -1;
        if (text == null || text.isEmpty() || template == null) {
            return null;
        }
        List<String> templateNonOptionalText = LicenseCompareHelper.getNonOptionalLicenseText(LicenseCompareHelper.removeCommentChars(template), FilterTemplateOutputHandler.VarTextHandling.REGEX);
        if (templateNonOptionalText.size() > 0 && templateNonOptionalText.get(0).startsWith("~~~.") && !(firstLine = templateNonOptionalText.get(0)).startsWith("~~~.?")) {
            firstLine = "~~~.?" + firstLine.substring(4);
            templateNonOptionalText.set(0, firstLine);
        }
        Pattern matchPattern = LicenseCompareHelper.nonOptionalTextToStartPattern(templateNonOptionalText, CROSS_REF_NUM_WORDS_MATCH);
        ArrayList<Pair<Integer, Integer>> charPositions = new ArrayList<Pair<Integer, Integer>>();
        String normalizedText = LicenseCompareHelper.removeCommentChars(LicenseCompareHelper.normalizeText(text));
        normalizedText = normalizedText.replaceAll("(-|=|\\*){3,}", "");
        try {
            compareText = LicenseCompareHelper.normalizeTokensForRegex(normalizedText, charPositions);
        }
        catch (IOException e1) {
            compareText = LicenseCompareHelper.normalizeText(text);
            charPositions.add((Pair<Integer, Integer>)new ImmutablePair((Object)0, (Object)0));
        }
        Matcher matcher = matchPattern.matcher(compareText);
        if (matcher.find()) {
            startIndex = LicenseCompareHelper.findOriginalStart(matcher.start(), charPositions);
            endIndex = LicenseCompareHelper.findOriginalStart(matcher.end(), charPositions);
            result = normalizedText.substring(startIndex, endIndex);
        }
        return result;
    }

    public static boolean isStandardLicenseWithinText(String text, SpdxListedLicense license) {
        boolean result = false;
        if (text == null || text.isEmpty() || license == null) {
            return false;
        }
        try {
            String completeText = LicenseCompareHelper.findTemplateWithinText(text, license.getStandardLicenseTemplate());
            if (completeText != null) {
                result = !LicenseCompareHelper.isTextStandardLicense(license, completeText).isDifferenceFound();
            }
        }
        catch (SpdxCompareException e) {
            logger.warn("Error getting optional text for license ID " + license.getLicenseId(), (Throwable)e);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting optional text for license ID " + license.getLicenseId(), (Throwable)e);
        }
        return result;
    }

    public static boolean isStandardLicenseExceptionWithinText(String text, ListedLicenseException exception) {
        boolean result = false;
        if (text == null || text.isEmpty() || exception == null) {
            return false;
        }
        try {
            String completeText = LicenseCompareHelper.findTemplateWithinText(text, exception.getLicenseExceptionTemplate());
            if (completeText != null) {
                result = !LicenseCompareHelper.isTextStandardException(exception, completeText).isDifferenceFound();
            }
        }
        catch (SpdxCompareException e) {
            logger.warn("Error getting optional text for license exception ID " + exception.getLicenseExceptionId(), (Throwable)e);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting optional text for license exception ID " + exception.getLicenseExceptionId(), (Throwable)e);
        }
        return result;
    }

    public static String[] matchingStandardLicenseIds(String licenseText) throws InvalidSPDXAnalysisException, SpdxCompareException {
        List<String> stdLicenseIds = ListedLicenses.getListedLicenses().getSpdxListedLicenseIds();
        ArrayList<String> matchingIds = new ArrayList<String>();
        for (String stdLicId : stdLicenseIds) {
            SpdxListedLicense license = ListedLicenses.getListedLicenses().getListedLicenseById(stdLicId);
            if (LicenseCompareHelper.isTextStandardLicense(license, licenseText).isDifferenceFound()) continue;
            matchingIds.add(license.getLicenseId());
        }
        return matchingIds.toArray(new String[matchingIds.size()]);
    }

    public static List<String> matchingStandardLicenseIdsWithinText(String text, List<String> licenseIds) throws InvalidSPDXAnalysisException, SpdxCompareException {
        ArrayList<String> result = new ArrayList<String>();
        if (text != null && !text.isEmpty() && licenseIds != null && !licenseIds.isEmpty()) {
            for (String stdLicId : licenseIds) {
                SpdxListedLicense license = ListedLicenses.getListedLicenses().getListedLicenseById(stdLicId);
                if (!LicenseCompareHelper.isStandardLicenseWithinText(text, license)) continue;
                result.add(license.getLicenseId());
            }
        }
        return result;
    }

    public static List<String> matchingStandardLicenseIdsWithinText(String text) throws InvalidSPDXAnalysisException, SpdxCompareException {
        return LicenseCompareHelper.matchingStandardLicenseIdsWithinText(text, ListedLicenses.getListedLicenses().getSpdxListedLicenseIds());
    }

    public static List<String> matchingStandardLicenseExceptionIdsWithinText(String text, List<String> licenseExceptionIds) throws InvalidSPDXAnalysisException, SpdxCompareException {
        ArrayList<String> result = new ArrayList<String>();
        if (text != null && !text.isEmpty() && licenseExceptionIds != null && !licenseExceptionIds.isEmpty()) {
            for (String stdLicExcId : licenseExceptionIds) {
                ListedLicenseException licenseException = ListedLicenses.getListedLicenses().getListedExceptionById(stdLicExcId);
                if (!LicenseCompareHelper.isStandardLicenseExceptionWithinText(text, licenseException)) continue;
                result.add(licenseException.getLicenseExceptionId());
            }
        }
        return result;
    }

    public static List<String> matchingStandardLicenseExceptionIdsWithinText(String text) throws InvalidSPDXAnalysisException, SpdxCompareException {
        return LicenseCompareHelper.matchingStandardLicenseExceptionIdsWithinText(text, ListedLicenses.getListedLicenses().getSpdxListedExceptionIds());
    }

    private static <T> boolean contains(T[] array, T value) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (Objects.equals(t, value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isLicensePassBlackList(AnyLicenseInfo license, String ... blackList) throws InvalidSPDXAnalysisException {
        if (license == null) {
            return true;
        }
        if (blackList == null || blackList.length == 0) {
            return true;
        }
        if (license instanceof ConjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((ConjunctiveLicenseSet)license).getMembers()) {
                if (LicenseCompareHelper.isLicensePassBlackList(member, blackList)) continue;
                return false;
            }
            return true;
        }
        if (license instanceof DisjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((DisjunctiveLicenseSet)license).getMembers()) {
                if (!LicenseCompareHelper.isLicensePassBlackList(member, blackList)) continue;
                return true;
            }
            return false;
        }
        return !LicenseCompareHelper.contains(blackList, license.toString());
    }

    public static boolean isLicensePassWhiteList(AnyLicenseInfo license, String ... whiteList) throws InvalidSPDXAnalysisException {
        if (license == null) {
            return false;
        }
        if (whiteList == null || whiteList.length == 0) {
            return false;
        }
        if (license instanceof ConjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((ConjunctiveLicenseSet)license).getMembers()) {
                if (LicenseCompareHelper.isLicensePassWhiteList(member, whiteList)) continue;
                return false;
            }
            return true;
        }
        if (license instanceof DisjunctiveLicenseSet) {
            for (AnyLicenseInfo member : ((DisjunctiveLicenseSet)license).getMembers()) {
                if (!LicenseCompareHelper.isLicensePassWhiteList(member, whiteList)) continue;
                return true;
            }
            return false;
        }
        return LicenseCompareHelper.contains(whiteList, license.toString());
    }
}

