/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.license.SpdxListedLicense;

public class LicenseJsonTOC {
    private String licenseListVersion;
    private List<LicenseJson> licenses;
    private String releaseDate;

    public LicenseJsonTOC(String version, String releaseDate) {
        this.licenseListVersion = version;
        this.releaseDate = releaseDate;
        this.licenses = new ArrayList<LicenseJson>();
    }

    public LicenseJsonTOC() {
        this.licenseListVersion = null;
        this.releaseDate = null;
        this.licenses = new ArrayList<LicenseJson>();
    }

    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public List<LicenseJson> getLicenses() {
        return this.licenses;
    }

    public Map<String, String> getLicenseIds() {
        HashMap<String, String> retval = new HashMap<String, String>();
        if (this.licenses == null) {
            return retval;
        }
        for (LicenseJson license : this.licenses) {
            retval.put(license.licenseId.toLowerCase(), license.licenseId);
        }
        return retval;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void addLicense(SpdxListedLicense license, String licHTMLReference, String licJSONReference, boolean deprecated) throws InvalidSPDXAnalysisException {
        LicenseJson lj = new LicenseJson();
        lj.setDeprecatedLicenseId(deprecated);
        lj.setDetailsUrl(LicenseJsonTOC.toAbsoluteURL(licJSONReference));
        lj.setLicenseId(license.getId());
        lj.setName(license.getName());
        lj.setOsiApproved(license.isOsiApproved());
        lj.setFsfLibre(license.getFsfLibre());
        lj.setReference(LicenseJsonTOC.toAbsoluteURL(licHTMLReference));
        int referenceNumber = -1;
        for (LicenseJson existing : this.licenses) {
            if (existing.getReferenceNumber() <= referenceNumber) continue;
            referenceNumber = existing.getReferenceNumber();
        }
        lj.setReferenceNumber(++referenceNumber);
        ArrayList<String> seeAlso = new ArrayList<String>();
        for (String sa : license.getSeeAlso()) {
            seeAlso.add(sa);
        }
        lj.setSeeAlso(seeAlso);
        this.licenses.add(lj);
    }

    public void setLicenseListVersion(String licenseListVersion) {
        this.licenseListVersion = licenseListVersion;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    private static String toAbsoluteURL(String relURL) {
        String retval = relURL.startsWith("./") ? relURL.substring(2) : relURL;
        return "https://spdx.org/licenses/" + retval;
    }

    public static class LicenseJson {
        private String reference;
        private boolean isDeprecatedLicenseId;
        private String detailsUrl;
        private int referenceNumber;
        private String name;
        private String licenseId;
        private List<String> seeAlso;
        private boolean isOsiApproved;
        private Boolean isFsfLibre;

        public String getReference() {
            return this.reference;
        }

        public boolean isDeprecatedLicenseId() {
            return this.isDeprecatedLicenseId;
        }

        public String getDetailsUrl() {
            return this.detailsUrl;
        }

        public int getReferenceNumber() {
            return this.referenceNumber;
        }

        public String getName() {
            return this.name;
        }

        public String getLicenseId() {
            return this.licenseId;
        }

        public List<String> getSeeAlso() {
            return this.seeAlso;
        }

        public boolean isOsiApproved() {
            return this.isOsiApproved;
        }

        @Nullable
        public Boolean getFsfLibre() {
            return this.isFsfLibre;
        }

        public void setFsfLibre(@Nullable Boolean fsfLibre) {
            this.isFsfLibre = fsfLibre;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public void setDeprecatedLicenseId(boolean isDeprecatedLicenseId) {
            this.isDeprecatedLicenseId = isDeprecatedLicenseId;
        }

        public void setDetailsUrl(String detailsUrl) {
            this.detailsUrl = detailsUrl;
        }

        public void setReferenceNumber(int referenceNumber) {
            this.referenceNumber = referenceNumber;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLicenseId(String licenseId) {
            this.licenseId = licenseId;
        }

        public void setSeeAlso(List<String> seeAlso) {
            this.seeAlso = seeAlso;
        }

        public void setOsiApproved(boolean isOsiApproved) {
            this.isOsiApproved = isOsiApproved;
        }
    }
}

