/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.ArrayList;
import java.util.List;
import org.spdx.licenseTemplate.ILicenseTemplateOutputHandler;
import org.spdx.licenseTemplate.LicenseTemplateRule;

public class FilterTemplateOutputHandler
implements ILicenseTemplateOutputHandler {
    public static final String REGEX_ESCAPE = "~~~";
    private VarTextHandling varTextHandling;
    private List<String> filteredText = new ArrayList<String>();
    StringBuilder currentString = new StringBuilder();
    private int optionalDepth = 0;

    @Deprecated
    public FilterTemplateOutputHandler(boolean includeVarText) {
        this(includeVarText ? VarTextHandling.ORIGINAL : VarTextHandling.OMIT);
    }

    public FilterTemplateOutputHandler(VarTextHandling varTextHandling) {
        this.varTextHandling = varTextHandling;
    }

    @Override
    public void text(String text) {
        if (this.optionalDepth <= 0) {
            this.currentString.append(text);
        }
    }

    @Override
    public void variableRule(LicenseTemplateRule rule) {
        if (VarTextHandling.REGEX.equals((Object)this.varTextHandling) && this.optionalDepth <= 0) {
            this.currentString.append(REGEX_ESCAPE);
            this.currentString.append(rule.getMatch());
            this.currentString.append(REGEX_ESCAPE);
        } else if (VarTextHandling.ORIGINAL.equals((Object)this.varTextHandling) && this.optionalDepth <= 0) {
            this.currentString.append(rule.getOriginal());
        } else if (this.currentString.length() > 0) {
            this.filteredText.add(this.currentString.toString());
            this.currentString.setLength(0);
        }
    }

    @Override
    public void beginOptional(LicenseTemplateRule rule) {
        ++this.optionalDepth;
    }

    @Override
    public void endOptional(LicenseTemplateRule rule) {
        --this.optionalDepth;
        if (this.optionalDepth == 0 && this.currentString.length() > 0) {
            this.filteredText.add(this.currentString.toString());
            this.currentString.setLength(0);
        }
    }

    @Override
    public void completeParsing() {
        if (this.currentString.length() > 0) {
            this.filteredText.add(this.currentString.toString());
            this.currentString.setLength(0);
        }
    }

    public boolean isIncludeVarText() {
        return VarTextHandling.ORIGINAL.equals((Object)this.varTextHandling);
    }

    public VarTextHandling getVarTextHandling() {
        return this.varTextHandling;
    }

    public List<String> getFilteredText() {
        return this.filteredText;
    }

    public static enum VarTextHandling {
        OMIT,
        ORIGINAL,
        REGEX;

    }
}

