/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.example;

import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v3_0_1.SpdxModelClassFactoryV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.software.Sbom;
import org.spdx.library.model.v3_0_1.software.SpdxPackage;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class Spdx3Example {
    public static Sbom createSbomFromScratch() throws InvalidSPDXAnalysisException {
        SpdxModelFactory.init();
        InMemSpdxStore modelStore = new InMemSpdxStore();
        ModelCopyManager copyManager = new ModelCopyManager();
        String prefix = "https://org.spdx.spdxdata/899b1918-f72a-4755-9215-6262b3c346df/";
        CreationInfo creationInfo = SpdxModelClassFactoryV3.createCreationInfo((IModelStore)modelStore, (String)(prefix + "Agent/Gary01123"), (String)"Gary O'Neall", (IModelCopyManager)copyManager);
        Sbom sbom = creationInfo.createSbom(prefix + "sbom/mysbom").setName("My SBOM").build();
        SpdxPackage pkg = sbom.createSpdxPackage(prefix + "package/mypackage").setName("Package Name").build();
        sbom.getElements().add(pkg);
        sbom.getRootElements().add(pkg);
        return sbom;
    }
}

