/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.DefaultStoreNotInitializedException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ListedLicenses;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.InvalidLicenseStringException;
import org.spdx.library.model.v2.license.LicenseParserException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException;
import org.spdx.storage.IModelStore;
import org.spdx.utility.license.LicenseExpressionParser;

public class LicenseInfoFactory {
    static final Logger logger = LoggerFactory.getLogger((String)LicenseInfoFactory.class.getName());
    public static final String NOASSERTION_LICENSE_NAME = "NOASSERTION";
    public static final String NONE_LICENSE_NAME = "NONE";

    public static ListedLicense getListedLicenseById(String licenseId) throws InvalidSPDXAnalysisException {
        return ListedLicenses.getListedLicenses().getListedLicenseById(licenseId);
    }

    public static SpdxListedLicense getListedLicenseByIdCompatV2(String licenseId) throws InvalidSPDXAnalysisException {
        return ListedLicenses.getListedLicenses().getListedLicenseByIdCompatV2(licenseId);
    }

    public static AnyLicenseInfo parseSPDXLicenseStringCompatV2(String licenseString, @Nullable IModelStore store, @Nullable String documentUri, @Nullable IModelCopyManager copyManager) throws InvalidLicenseStringException, DefaultStoreNotInitializedException {
        if (Objects.isNull(store)) {
            store = DefaultModelStore.getDefaultModelStore();
        }
        if (Objects.isNull(documentUri)) {
            documentUri = DefaultModelStore.getDefaultDocumentUri();
        }
        if (Objects.isNull(copyManager)) {
            copyManager = DefaultModelStore.getDefaultCopyManager();
        }
        try {
            return LicenseExpressionParser.parseLicenseExpressionCompatV2(licenseString, store, documentUri, copyManager);
        }
        catch (LicenseParserException e) {
            throw new InvalidLicenseStringException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new InvalidLicenseStringException("Unexpected SPDX error parsing license string", (Throwable)e);
        }
    }

    public static org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo parseSPDXLicenseString(String licenseString, @Nullable IModelStore store, @Nullable String customLicensePrefix, @Nullable IModelCopyManager copyManager, @Nullable List<DictionaryEntry> customIdToUri) throws InvalidLicenseStringException, DefaultStoreNotInitializedException {
        if (Objects.isNull(store)) {
            store = DefaultModelStore.getDefaultModelStore();
        }
        if (Objects.isNull(customLicensePrefix)) {
            customLicensePrefix = DefaultModelStore.getDefaultDocumentUri() + "#";
        }
        if (Objects.isNull(copyManager)) {
            copyManager = DefaultModelStore.getDefaultCopyManager();
        }
        try {
            return LicenseExpressionParser.parseLicenseExpression(licenseString, store, customLicensePrefix, copyManager, customIdToUri);
        }
        catch (LicenseParserException e) {
            throw new InvalidLicenseStringException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new InvalidLicenseStringException("Unexpected SPDX error parsing license string", (Throwable)e);
        }
    }

    public static org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo parseSPDXLicenseString(String licenseString) throws InvalidLicenseStringException, DefaultStoreNotInitializedException {
        return LicenseInfoFactory.parseSPDXLicenseString(licenseString, null, null, null, null);
    }

    public static AnyLicenseInfo parseSPDXLicenseStringCompatV2(String licenseString) throws InvalidLicenseStringException, DefaultStoreNotInitializedException {
        return LicenseInfoFactory.parseSPDXLicenseStringCompatV2(licenseString, null, null, null);
    }

    public static boolean isSpdxListedLicenseId(String licenseID) {
        return ListedLicenses.getListedLicenses().isSpdxListedLicenseId(licenseID);
    }

    public static List<String> getSpdxListedLicenseIds() {
        return ListedLicenses.getListedLicenses().getSpdxListedLicenseIds();
    }

    public static String getLicenseListVersion() {
        return ListedLicenses.getListedLicenses().getLicenseListVersion();
    }

    public static boolean isSpdxListedExceptionId(String id) {
        return ListedLicenses.getListedLicenses().isSpdxListedExceptionId(id);
    }

    public static ListedLicenseException getListedExceptionById(String id) throws InvalidSPDXAnalysisException {
        return ListedLicenses.getListedLicenses().getListedExceptionById(id);
    }

    public static org.spdx.library.model.v2.license.ListedLicenseException getListedExceptionV2ById(String id) throws InvalidSPDXAnalysisException {
        return ListedLicenses.getListedLicenses().getListedExceptionByIdCompatV2(id);
    }

    public static Optional<String> listedLicenseIdCaseSensitive(String licenseId) {
        return ListedLicenses.getListedLicenses().listedLicenseIdCaseSensitive(licenseId);
    }

    public static Optional<String> listedExceptionIdCaseSensitive(String exceptionId) {
        return ListedLicenses.getListedLicenses().listedExceptionIdCaseSensitive(exceptionId);
    }

    public static CreationInfo getListedLicenseCreationInfo() throws InvalidSPDXAnalysisException {
        return ListedLicenses.getListedLicenses().getListedLicenseCreationInfo();
    }
}

