/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxModelFactoryCompatV2;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException;
import org.spdx.storage.IModelStore;
import org.spdx.storage.listedlicense.IListedLicenseStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseLocalStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseModelStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseWebStore;
import org.spdx.storage.listedlicense.SpdxV2ListedLicenseModelStore;
import org.spdx.storage.listedlicense.SpdxV3ListedLicenseModelStore;

public class ListedLicenses {
    static final Logger logger = LoggerFactory.getLogger((String)ListedLicenses.class.getName());
    private static final String PROPERTIES_DIR = "resources";
    private static final String LISTED_LICENSE_PROPERTIES_FILENAME = "resources/licenses.properties";
    Properties licenseProperties = ListedLicenses.loadLicenseProperties();
    boolean onlyUseLocalLicenses = Boolean.parseBoolean(System.getProperty("SPDXParser.OnlyUseLocalLicenses", this.licenseProperties.getProperty("OnlyUseLocalLicenses", "false")));
    private IListedLicenseStore baseModelStore;
    private SpdxV2ListedLicenseModelStore licenseStoreV2;
    private SpdxV3ListedLicenseModelStore licenseStoreV3;
    private static ListedLicenses listedLicenses = null;
    private Map<String, SpdxListedLicense> spdxListedLicenseMapCompatV2;
    private Map<String, ListedLicense> spdxListedLicenseMap;
    private Map<String, org.spdx.library.model.v2.license.ListedLicenseException> spdxListedExceptionMapCompatV2;
    private Map<String, ListedLicenseException> spdxListedExceptionMap;
    private static final ReadWriteLock listedLicenseModificationLock = new ReentrantReadWriteLock();

    private ListedLicenses() {
        this.initializeLicenseModelStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadLicenseProperties() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            Properties licenseProperties = new Properties();
            InputStream in = null;
            try {
                in = ListedLicenses.class.getResourceAsStream("/resources/licenses.properties");
                if (in != null) {
                    licenseProperties.load(in);
                }
            }
            catch (IOException e) {
                logger.warn("IO Exception reading listed license properties file: {}", (Object)e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close listed license properties file: {}", (Object)e.getMessage());
                    }
                }
            }
            Properties properties = licenseProperties;
            return properties;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    private void initializeLicenseModelStore() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            if (!this.onlyUseLocalLicenses) {
                try {
                    this.baseModelStore = new SpdxListedLicenseWebStore();
                }
                catch (InvalidSPDXAnalysisException ex) {
                    logger.warn("Unable to access the most current listed licenses from https://spdx.org/licenses - using locally cached licenses: {} Note: you can set the org.spdx.useJARLicenseInfoOnly property to true to avoid this warning.", (Object)ex.getMessage(), (Object)ex);
                    this.baseModelStore = null;
                }
            }
            if (this.baseModelStore == null) {
                try {
                    this.baseModelStore = new SpdxListedLicenseLocalStore();
                }
                catch (InvalidSPDXAnalysisException ex) {
                    logger.error("Error loading cached SPDX licenses", (Throwable)ex);
                    throw new RuntimeException("Unexpected error loading SPDX Listed Licenses", ex);
                }
            }
            this.licenseStoreV2 = new SpdxV2ListedLicenseModelStore(this.baseModelStore);
            this.licenseStoreV3 = new SpdxV3ListedLicenseModelStore(this.baseModelStore);
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public static ListedLicenses getListedLicenses() {
        ListedLicenses retval;
        listedLicenseModificationLock.readLock().lock();
        try {
            retval = listedLicenses;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
        if (Objects.isNull(retval)) {
            listedLicenseModificationLock.writeLock().lock();
            try {
                if (listedLicenses == null) {
                    listedLicenses = new ListedLicenses();
                }
                retval = listedLicenses;
            }
            finally {
                listedLicenseModificationLock.writeLock().unlock();
            }
        }
        return retval;
    }

    public static ListedLicenses resetListedLicenses() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            ListedLicenses listedLicenses = ListedLicenses.listedLicenses = new ListedLicenses();
            return listedLicenses;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public boolean isSpdxListedLicenseId(String licenseId) {
        return this.baseModelStore.isSpdxListedLicenseId("http://spdx.org/licenses/", licenseId);
    }

    public boolean isSpdxListedExceptionId(String exceptionId) {
        return this.baseModelStore.isSpdxListedExceptionId("http://spdx.org/licenses/", exceptionId);
    }

    public SpdxListedLicense getListedLicenseByIdCompatV2(String licenseId) throws InvalidSPDXAnalysisException {
        return this.getSpdxListedLicensesCompatV2().get(licenseId);
    }

    public org.spdx.library.model.v2.license.ListedLicenseException getListedExceptionByIdCompatV2(String exceptionId) throws InvalidSPDXAnalysisException {
        return this.getSpdxListedLicenseExceptionsCompatV2().get(exceptionId);
    }

    public ListedLicense getListedLicenseById(String licenseId) throws InvalidSPDXAnalysisException {
        return this.getSpdxListedLicenses().get(licenseId);
    }

    public ListedLicenseException getListedExceptionById(String exceptionId) throws InvalidSPDXAnalysisException {
        return this.getSpdxListedLicenseExceptions().get(exceptionId);
    }

    public List<String> getSpdxListedLicenseIds() {
        listedLicenseModificationLock.readLock().lock();
        try {
            List<String> list = this.baseModelStore.getSpdxListedLicenseIds();
            return list;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ListedLicense> getSpdxListedLicenses() throws InvalidSPDXAnalysisException {
        listedLicenseModificationLock.readLock().lock();
        try {
            if (Objects.nonNull(this.spdxListedLicenseMap)) {
                Map<String, ListedLicense> map = this.spdxListedLicenseMap;
                return map;
            }
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
        listedLicenseModificationLock.writeLock().lock();
        try {
            if (Objects.nonNull(this.spdxListedLicenseMap)) {
                Map<String, ListedLicense> map = this.spdxListedLicenseMap;
                return map;
            }
            HashMap<String, ListedLicense> allListedLicenses = new HashMap<String, ListedLicense>();
            for (String licenseId : this.baseModelStore.getSpdxListedLicenseIds()) {
                allListedLicenses.put(licenseId, new ListedLicense((IModelStore)this.licenseStoreV3, SpdxListedLicenseModelStore.licenseOrExceptionIdToObjectUri(licenseId), null, false, "http://spdx.org/licenses/"));
            }
            this.spdxListedLicenseMap = Collections.unmodifiableMap(allListedLicenses);
            Map<String, ListedLicense> map = this.spdxListedLicenseMap;
            return map;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ListedLicenseException> getSpdxListedLicenseExceptions() throws InvalidSPDXAnalysisException {
        listedLicenseModificationLock.readLock().lock();
        try {
            if (Objects.nonNull(this.spdxListedExceptionMap)) {
                Map<String, ListedLicenseException> map = this.spdxListedExceptionMap;
                return map;
            }
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
        listedLicenseModificationLock.writeLock().lock();
        try {
            if (Objects.nonNull(this.spdxListedExceptionMap)) {
                Map<String, ListedLicenseException> map = this.spdxListedExceptionMap;
                return map;
            }
            HashMap<String, ListedLicenseException> allListedExceptions = new HashMap<String, ListedLicenseException>();
            for (String exceptionId : this.baseModelStore.getSpdxListedExceptionIds()) {
                allListedExceptions.put(exceptionId, new ListedLicenseException((IModelStore)this.licenseStoreV3, SpdxListedLicenseModelStore.licenseOrExceptionIdToObjectUri(exceptionId), null, false, "http://spdx.org/licenses/"));
            }
            this.spdxListedExceptionMap = Collections.unmodifiableMap(allListedExceptions);
            Map<String, ListedLicenseException> map = this.spdxListedExceptionMap;
            return map;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, SpdxListedLicense> getSpdxListedLicensesCompatV2() throws InvalidSPDXAnalysisException {
        listedLicenseModificationLock.readLock().lock();
        try {
            if (Objects.nonNull(this.spdxListedLicenseMapCompatV2)) {
                Map<String, SpdxListedLicense> map = this.spdxListedLicenseMapCompatV2;
                return map;
            }
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
        listedLicenseModificationLock.writeLock().lock();
        try {
            if (Objects.nonNull(this.spdxListedLicenseMapCompatV2)) {
                Map<String, SpdxListedLicense> map = this.spdxListedLicenseMapCompatV2;
                return map;
            }
            HashMap<String, SpdxListedLicense> allListedLicenses = new HashMap<String, SpdxListedLicense>();
            for (String licenseId : this.baseModelStore.getSpdxListedLicenseIds()) {
                allListedLicenses.put(licenseId, (SpdxListedLicense)SpdxModelFactoryCompatV2.getModelObjectV2((IModelStore)this.licenseStoreV2, (String)"http://spdx.org/licenses/", (String)licenseId, (String)"ListedLicense", null, (boolean)false));
            }
            this.spdxListedLicenseMapCompatV2 = Collections.unmodifiableMap(allListedLicenses);
            Map<String, SpdxListedLicense> map = this.spdxListedLicenseMapCompatV2;
            return map;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, org.spdx.library.model.v2.license.ListedLicenseException> getSpdxListedLicenseExceptionsCompatV2() throws InvalidSPDXAnalysisException {
        listedLicenseModificationLock.readLock().lock();
        try {
            if (Objects.nonNull(this.spdxListedExceptionMapCompatV2)) {
                Map<String, org.spdx.library.model.v2.license.ListedLicenseException> map = this.spdxListedExceptionMapCompatV2;
                return map;
            }
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
        listedLicenseModificationLock.writeLock().lock();
        try {
            if (Objects.nonNull(this.spdxListedExceptionMapCompatV2)) {
                Map<String, org.spdx.library.model.v2.license.ListedLicenseException> map = this.spdxListedExceptionMapCompatV2;
                return map;
            }
            HashMap<String, org.spdx.library.model.v2.license.ListedLicenseException> allListedExceptions = new HashMap<String, org.spdx.library.model.v2.license.ListedLicenseException>();
            for (String exceptionId : this.baseModelStore.getSpdxListedExceptionIds()) {
                allListedExceptions.put(exceptionId, (org.spdx.library.model.v2.license.ListedLicenseException)SpdxModelFactoryCompatV2.getModelObjectV2((IModelStore)this.licenseStoreV2, (String)"http://spdx.org/licenses/", (String)exceptionId, (String)"ListedLicenseException", null, (boolean)false));
            }
            this.spdxListedExceptionMapCompatV2 = Collections.unmodifiableMap(allListedExceptions);
            Map<String, org.spdx.library.model.v2.license.ListedLicenseException> map = this.spdxListedExceptionMapCompatV2;
            return map;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public String getLicenseListVersion() {
        return this.baseModelStore.getLicenseListVersion();
    }

    public List<String> getSpdxListedExceptionIds() {
        return this.baseModelStore.getSpdxListedExceptionIds();
    }

    public Optional<String> listedLicenseIdCaseSensitive(String licenseId) {
        return this.baseModelStore.listedLicenseIdCaseSensitive(licenseId);
    }

    public Optional<String> listedExceptionIdCaseSensitive(String exceptionId) {
        return this.baseModelStore.listedExceptionIdCaseSensitive(exceptionId);
    }

    public IModelStore getLicenseModelStore() {
        return this.licenseStoreV3;
    }

    public IModelStore getLicenseModelStoreCompatV2() {
        return this.licenseStoreV2;
    }

    public CreationInfo getListedLicenseCreationInfo() throws InvalidSPDXAnalysisException {
        return this.licenseStoreV3.getListedLicenseCreationInfo();
    }
}

