/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.conversion;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.SpdxModelClassFactoryV3;
import org.spdx.library.model.v3_0_1.core.ExternalMap;
import org.spdx.library.model.v3_0_1.core.Hash;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.storage.IModelStore;

public class ExternalMapInfo {
    private final String docRefId;
    private final String externalDocumentUri;
    private final Optional<Hash> externalDocumentHash;
    private final Collection<ExternalMap> docImports;
    private final Map<String, ExternalMap> existingExternalMap = Collections.synchronizedMap(new HashMap());

    public ExternalMapInfo(String docRefId, String externalDocumentUri, Optional<Hash> externalDocumentHash, Collection<ExternalMap> docImports) {
        this.docRefId = docRefId;
        this.externalDocumentUri = externalDocumentUri;
        this.externalDocumentHash = externalDocumentHash;
        this.docImports = docImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalMap addExternalMap(String externalUri, IModelStore modelStore) throws InvalidSPDXAnalysisException {
        Map<String, ExternalMap> map = this.existingExternalMap;
        synchronized (map) {
            ExternalMap retval = this.existingExternalMap.get(externalUri);
            if (Objects.isNull(retval)) {
                retval = (ExternalMap)SpdxModelClassFactoryV3.getModelObject((IModelStore)modelStore, (String)modelStore.getNextId(IModelStore.IdType.Anonymous), (String)"Core.ExternalMap", null, (boolean)true, null);
                retval.setExternalSpdxId(externalUri);
                retval.setLocationHint(this.externalDocumentUri);
                if (this.externalDocumentHash.isPresent()) {
                    retval.getVerifiedUsings().add((IntegrityMethod)this.externalDocumentHash.get());
                }
                this.docImports.add(retval);
                this.existingExternalMap.put(externalUri, retval);
            }
            return retval;
        }
    }

    public String getDocRefId() {
        return this.docRefId;
    }

    public String getExternalDocumentUri() {
        return this.externalDocumentUri;
    }

    public Optional<Hash> getExternalDocumentHash() {
        return this.externalDocumentHash;
    }

    public Collection<ExternalMap> getDocImports() {
        return this.docImports;
    }
}

