/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.conversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ListedLicenses;
import org.spdx.library.conversion.ExternalMapInfo;
import org.spdx.library.conversion.ISpdxConverter;
import org.spdx.library.model.v2.Checksum;
import org.spdx.library.model.v2.ExternalDocumentRef;
import org.spdx.library.model.v2.ExternalRef;
import org.spdx.library.model.v2.ExternalSpdxElement;
import org.spdx.library.model.v2.ReferenceType;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxCreatorInformation;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.library.model.v2.SpdxItem;
import org.spdx.library.model.v2.SpdxNoAssertionElement;
import org.spdx.library.model.v2.SpdxNoneElement;
import org.spdx.library.model.v2.SpdxPackageVerificationCode;
import org.spdx.library.model.v2.SpdxSnippet;
import org.spdx.library.model.v2.enumerations.AnnotationType;
import org.spdx.library.model.v2.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.v2.enumerations.FileType;
import org.spdx.library.model.v2.enumerations.Purpose;
import org.spdx.library.model.v2.enumerations.ReferenceCategory;
import org.spdx.library.model.v2.enumerations.RelationshipType;
import org.spdx.library.model.v2.license.ExternalExtractedLicenseInfo;
import org.spdx.library.model.v2.license.ExtractedLicenseInfo;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v2.license.SpdxNoAssertionLicense;
import org.spdx.library.model.v2.license.SpdxNoneLicense;
import org.spdx.library.model.v2.license.WithExceptionOperator;
import org.spdx.library.model.v2.pointer.ByteOffsetPointer;
import org.spdx.library.model.v2.pointer.LineCharPointer;
import org.spdx.library.model.v2.pointer.StartEndPointer;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxModelClassFactoryV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.Annotation;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalElement;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifierType;
import org.spdx.library.model.v3_0_1.core.ExternalMap;
import org.spdx.library.model.v3_0_1.core.ExternalRefType;
import org.spdx.library.model.v3_0_1.core.Hash;
import org.spdx.library.model.v3_0_1.core.HashAlgorithm;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.LifecycleScopeType;
import org.spdx.library.model.v3_0_1.core.LifecycleScopedRelationship;
import org.spdx.library.model.v3_0_1.core.NamespaceMap;
import org.spdx.library.model.v3_0_1.core.NoAssertionElement;
import org.spdx.library.model.v3_0_1.core.NoneElement;
import org.spdx.library.model.v3_0_1.core.Organization;
import org.spdx.library.model.v3_0_1.core.PackageVerificationCode;
import org.spdx.library.model.v3_0_1.core.Person;
import org.spdx.library.model.v3_0_1.core.Relationship;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.Tool;
import org.spdx.library.model.v3_0_1.expandedlicensing.ConjunctiveLicenseSet;
import org.spdx.library.model.v3_0_1.expandedlicensing.CustomLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.CustomLicenseAddition;
import org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet;
import org.spdx.library.model.v3_0_1.expandedlicensing.ExtendableLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ExternalCustomLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.License;
import org.spdx.library.model.v3_0_1.expandedlicensing.LicenseAddition;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.NoAssertionLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.NoneLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.OrLaterOperator;
import org.spdx.library.model.v3_0_1.expandedlicensing.WithAdditionOperator;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.library.model.v3_0_1.simplelicensing.LicenseExpression;
import org.spdx.library.model.v3_0_1.software.ContentIdentifierType;
import org.spdx.library.model.v3_0_1.software.Snippet;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.library.model.v3_0_1.software.SpdxPackage;
import org.spdx.storage.IModelStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseModelStore;

public class Spdx2to3Converter
implements ISpdxConverter {
    static final Logger logger = LoggerFactory.getLogger(Spdx2to3Converter.class);
    static final Pattern SPDX_2_CREATOR_PATTERN = Pattern.compile("(Person|Organization):\\s*([^(]+)\\s*(\\(([^)]*)\\))?");
    public static final Map<RelationshipType, org.spdx.library.model.v3_0_1.core.RelationshipType> RELATIONSHIP_TYPE_MAP;
    public static final Map<RelationshipType, LifecycleScopeType> LIFECYCLE_SCOPE_MAP;
    public static final Set<RelationshipType> SWAP_TO_FROM_REL_TYPES;
    public static final Map<AnnotationType, org.spdx.library.model.v3_0_1.core.AnnotationType> ANNOTATION_TYPE_MAP;
    public static final Map<ChecksumAlgorithm, HashAlgorithm> HASH_ALGORITH_MAP;
    public static final Map<String, ContentIdentifierType> CONTENT_IDENTIFIER_TYPE_MAP;
    public static final Map<String, ExternalIdentifierType> EXTERNAL_IDENTIFIER_TYPE_MAP;
    public static final Map<String, ExternalRefType> EXTERNAL_REF_TYPE_MAP;
    public static final Map<Purpose, SoftwarePurpose> PURPOSE_MAP;
    String toSpecVersion;
    IModelStore toModelStore;
    Map<String, String> alreadyConverted = Collections.synchronizedMap(new HashMap());
    CreationInfo defaultCreationInfo;
    String defaultUriPrefix;
    Map<String, Map<Collection<ExternalMap>, ExternalMapInfo>> docUriToExternalMap = Collections.synchronizedMap(new HashMap());
    private final IModelCopyManager copyManager;
    private int documentIndex = 0;
    private final boolean complexLicenses;

    public static CreationInfo convertCreationInfo(SpdxCreatorInformation creationInfoV2, IModelStore modelStore, String uriPrefix) throws InvalidSPDXAnalysisException {
        CreationInfo retval = new CreationInfo.CreationInfoBuilder(modelStore, modelStore.getNextId(IModelStore.IdType.Anonymous), null).setCreated(creationInfoV2.getCreated()).setSpecVersion("3.0.1").build();
        retval.setIdPrefix(uriPrefix);
        for (String docCreator : creationInfoV2.getCreators()) {
            if (docCreator.startsWith("Tool:")) {
                Tool tool = (Tool)SpdxModelClassFactoryV3.getModelObject((IModelStore)modelStore, (String)(uriPrefix + "additionalTool" + modelStore.getNextId(IModelStore.IdType.SpdxId)), (String)"Core.Tool", null, (boolean)true, (String)uriPrefix);
                tool.setCreationInfo(retval).setName(docCreator.substring("Tool:".length()).trim()).setIdPrefix(uriPrefix);
                retval.getCreatedUsings().add(tool);
                continue;
            }
            retval.getCreatedBys().add(Spdx2to3Converter.stringToAgent(docCreator, retval));
        }
        return retval;
    }

    public static Agent stringToAgent(String spdx2personOrgString, CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(spdx2personOrgString, "Person/org string can not be null");
        Objects.requireNonNull(creationInfo, "Creation info required for stringToAgent");
        String idPrefix = creationInfo.getIdPrefix();
        Objects.requireNonNull(idPrefix, "Creation info must have an idPrefix to accurately generate SPDX IDs");
        Matcher matcher = SPDX_2_CREATOR_PATTERN.matcher(spdx2personOrgString);
        if (!matcher.matches()) {
            Agent agent = (Agent)SpdxModelClassFactoryV3.getModelObject((IModelStore)creationInfo.getModelStore(), (String)(creationInfo.getIdPrefix() + creationInfo.getModelStore().getNextId(IModelStore.IdType.SpdxId)), (String)"Core.Agent", (IModelCopyManager)creationInfo.getCopyManager(), (boolean)true, (String)creationInfo.getIdPrefix());
            agent.setCreationInfo(creationInfo);
            agent.setName(spdx2personOrgString);
            return agent;
        }
        if (matcher.group(1).trim().equals("Person")) {
            String email;
            Person person = (Person)SpdxModelClassFactoryV3.getModelObject((IModelStore)creationInfo.getModelStore(), (String)(idPrefix + creationInfo.getModelStore().getNextId(IModelStore.IdType.SpdxId)), (String)"Core.Person", (IModelCopyManager)creationInfo.getCopyManager(), (boolean)true, (String)creationInfo.getIdPrefix());
            person.setCreationInfo(creationInfo);
            if (matcher.groupCount() > 1) {
                String personName = matcher.group(2).trim();
                person.setName(personName);
            } else {
                logger.warn("Missing person name in createdBy");
                person.setName("[MISSING]");
            }
            if (matcher.groupCount() > 3 && Objects.nonNull(email = matcher.group(4)) && !email.isEmpty()) {
                person.getExternalIdentifiers().add(person.createExternalIdentifier(creationInfo.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setExternalIdentifierType(ExternalIdentifierType.EMAIL).setIdentifier(email).build());
            }
            return person;
        }
        if (matcher.group(1).trim().equals("Organization")) {
            String email;
            Organization organization = (Organization)SpdxModelClassFactoryV3.getModelObject((IModelStore)creationInfo.getModelStore(), (String)(creationInfo.getIdPrefix() + creationInfo.getModelStore().getNextId(IModelStore.IdType.SpdxId)), (String)"Core.Organization", (IModelCopyManager)creationInfo.getCopyManager(), (boolean)true, (String)creationInfo.getIdPrefix());
            organization.setCreationInfo(creationInfo);
            if (matcher.groupCount() > 1) {
                String organizationName = matcher.group(2).trim();
                organization.setName(organizationName);
            } else {
                logger.warn("Missing organization name");
                organization.setName("[MISSING]");
            }
            if (matcher.groupCount() > 3 && Objects.nonNull(email = matcher.group(4)) && !email.isEmpty()) {
                organization.getExternalIdentifiers().add(organization.createExternalIdentifier(creationInfo.getModelStore().getNextId(IModelStore.IdType.Anonymous)).setExternalIdentifierType(ExternalIdentifierType.EMAIL).setIdentifier(email).build());
            }
            return organization;
        }
        logger.warn("Incorrect person or organization format: {}", (Object)spdx2personOrgString);
        Agent agent = (Agent)SpdxModelClassFactoryV3.getModelObject((IModelStore)creationInfo.getModelStore(), (String)(creationInfo.getIdPrefix() + creationInfo.getModelStore().getNextId(IModelStore.IdType.SpdxId)), (String)"Core.Agent", (IModelCopyManager)creationInfo.getCopyManager(), (boolean)true, (String)creationInfo.getIdPrefix());
        agent.setCreationInfo(creationInfo);
        agent.setName(spdx2personOrgString);
        return agent;
    }

    public Spdx2to3Converter(IModelStore toModelStore, IModelCopyManager copyManager, CreationInfo defaultCreationInfo, String toSpecVersion, String defaultUriPrefix) {
        this(toModelStore, copyManager, defaultCreationInfo, toSpecVersion, defaultUriPrefix, true);
    }

    public Spdx2to3Converter(IModelStore toModelStore, IModelCopyManager copyManager, CreationInfo defaultCreationInfo, String toSpecVersion, String defaultUriPrefix, boolean complexLicenses) {
        this.toModelStore = toModelStore;
        this.defaultCreationInfo = defaultCreationInfo;
        this.toSpecVersion = toSpecVersion;
        this.defaultUriPrefix = defaultUriPrefix;
        this.copyManager = copyManager;
        this.complexLicenses = complexLicenses;
    }

    public boolean alreadyCopied(String fromObjectUri) {
        return this.alreadyConverted.containsKey(fromObjectUri);
    }

    private boolean equivalentCreationInfo(SpdxCreatorInformation spdx2CreatorInfo, CreationInfo spdx3CreationInfo) throws InvalidSPDXAnalysisException {
        if (!Objects.equals(spdx2CreatorInfo.getCreated(), spdx3CreationInfo.getCreated())) {
            return false;
        }
        ArrayList tools = new ArrayList(spdx3CreationInfo.getCreatedUsings());
        ArrayList agents = new ArrayList(spdx3CreationInfo.getCreatedBys());
        for (String creator : spdx2CreatorInfo.getCreators()) {
            if (creator.startsWith("Tool:")) {
                String toolName = creator.substring("Tool:".length()).trim();
                boolean found = false;
                for (Tool tool : tools) {
                    if (!tool.getName().isPresent() || !((String)tool.getName().get()).equals(toolName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            String name = creator;
            String type = "Core.Agent";
            String email = null;
            Matcher matcher = SPDX_2_CREATOR_PATTERN.matcher(creator);
            if (matcher.matches()) {
                if (matcher.group(1).trim().equals("Person")) {
                    type = "Core.Person";
                } else if (matcher.group(1).trim().equals("Organization")) {
                    type = "Core.Organization";
                }
                name = matcher.groupCount() > 1 ? matcher.group(2).trim() : "[MISSING]";
                if (matcher.groupCount() > 3) {
                    email = matcher.group(4);
                }
            }
            boolean found = false;
            for (Agent agent : agents) {
                if (!agent.getType().equals(type) || !agent.getName().isPresent() || !((String)agent.getName().get()).equals(name) || !Objects.nonNull(email)) continue;
                boolean foundEmail = false;
                for (ExternalIdentifier ei : agent.getExternalIdentifiers()) {
                    if (!ExternalIdentifierType.EMAIL.equals((Object)ei.getExternalIdentifierType()) || !email.equals(ei.getIdentifier())) continue;
                    foundEmail = true;
                    break;
                }
                if (!foundEmail) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private void convertElementProperties(SpdxElement fromElement, Element toElement) throws InvalidSPDXAnalysisException {
        toElement.setCreationInfo(this.defaultCreationInfo);
        for (org.spdx.library.model.v2.Annotation fromAnnotation : fromElement.getAnnotations()) {
            this.convertAndStore(fromAnnotation, toElement);
        }
        toElement.setComment((String)fromElement.getComment().orElse(null));
        toElement.setName((String)fromElement.getName().orElse(null));
        for (org.spdx.library.model.v2.Relationship fromRelationship : fromElement.getRelationships()) {
            this.convertAndStore(fromRelationship, toElement);
        }
    }

    protected Optional<ModelObjectV3> getExistingObject(String fromObjectUri, String toType) throws InvalidSPDXAnalysisException {
        String toObjectUri = this.alreadyConverted.get(fromObjectUri);
        if (Objects.isNull(toObjectUri)) {
            return Optional.empty();
        }
        return Optional.of(SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)toType, (IModelCopyManager)this.copyManager, (boolean)false, (String)this.defaultUriPrefix));
    }

    public Relationship convertAndStore(org.spdx.library.model.v2.Relationship fromRelationship, Element containingElement) throws InvalidSPDXAnalysisException {
        String relationshipType;
        RelationshipType fromRelationshipType = fromRelationship.getRelationshipType();
        LifecycleScopeType scope = LIFECYCLE_SCOPE_MAP.get(fromRelationshipType);
        String fromUri = fromRelationship.getObjectUri();
        Optional<ModelObjectV3> existing = this.getExistingObject(fromUri, relationshipType = Objects.isNull(scope) ? "Core.Relationship" : "Core.LifecycleScopedRelationship");
        if (existing.isPresent()) {
            return (Relationship)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String exitingUri = this.alreadyConverted.putIfAbsent(fromUri, toObjectUri);
        if (Objects.nonNull(exitingUri)) {
            return (Relationship)this.getExistingObject(fromUri, relationshipType).get();
        }
        Object toRelationship = Objects.isNull(scope) ? (Relationship)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"Core.Relationship", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix) : (LifecycleScopedRelationship)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"Core.LifecycleScopedRelationship", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        toRelationship.setCreationInfo(this.defaultCreationInfo);
        toRelationship.setRelationshipType(RELATIONSHIP_TYPE_MAP.get(fromRelationshipType));
        if (SWAP_TO_FROM_REL_TYPES.contains(fromRelationshipType)) {
            toRelationship.getTos().add(containingElement);
        } else {
            toRelationship.setFrom(containingElement);
        }
        toRelationship.setFrom(containingElement);
        toRelationship.setComment((String)fromRelationship.getComment().orElse(null));
        Optional relatedSpdxElement = fromRelationship.getRelatedSpdxElement();
        RelationshipCompleteness completeness = RelationshipCompleteness.NO_ASSERTION;
        if (relatedSpdxElement.isPresent() && relatedSpdxElement.get() instanceof SpdxNoneElement) {
            completeness = RelationshipCompleteness.COMPLETE;
        }
        toRelationship.setCompleteness(completeness);
        if (relatedSpdxElement.isPresent() && !(relatedSpdxElement.get() instanceof SpdxNoneElement) && !(relatedSpdxElement.get() instanceof SpdxNoAssertionElement)) {
            if (SWAP_TO_FROM_REL_TYPES.contains(fromRelationshipType)) {
                toRelationship.setFrom(this.convertAndStore((SpdxElement)relatedSpdxElement.get()));
            } else {
                toRelationship.getTos().add(this.convertAndStore((SpdxElement)relatedSpdxElement.get()));
            }
        }
        if (Objects.nonNull(scope)) {
            ((LifecycleScopedRelationship)toRelationship).setScope(scope);
        }
        toRelationship.setCreationInfo(this.defaultCreationInfo);
        return toRelationship;
    }

    public Annotation convertAndStore(org.spdx.library.model.v2.Annotation fromAnnotation, Element toElement) throws InvalidSPDXAnalysisException {
        String fromUri = fromAnnotation.getObjectUri();
        Optional<ModelObjectV3> existing = this.getExistingObject(fromUri, "Core.Annotation");
        if (existing.isPresent()) {
            return (Annotation)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String exitingUri = this.alreadyConverted.putIfAbsent(fromUri, toObjectUri);
        if (Objects.nonNull(exitingUri)) {
            return (Annotation)this.getExistingObject(fromUri, "Core.Annotation").get();
        }
        Annotation toAnnotation = (Annotation)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"Core.Annotation", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        toAnnotation.setAnnotationType(ANNOTATION_TYPE_MAP.get(fromAnnotation.getAnnotationType()));
        toAnnotation.setStatement(fromAnnotation.getComment());
        toAnnotation.setSubject(toElement);
        CreationInfo creationInfo = new CreationInfo.CreationInfoBuilder(this.toModelStore, this.toModelStore.getNextId(IModelStore.IdType.Anonymous), null).setCreated(fromAnnotation.getAnnotationDate()).setSpecVersion("3.0.1").addAllCreatedUsing(this.defaultCreationInfo.getCreatedUsings()).build();
        creationInfo.setIdPrefix(this.defaultUriPrefix);
        creationInfo.getCreatedBys().add(Spdx2to3Converter.stringToAgent(fromAnnotation.getAnnotator(), creationInfo));
        toAnnotation.setCreationInfo(creationInfo);
        return toAnnotation;
    }

    public org.spdx.library.model.v3_0_1.core.SpdxDocument convertAndStore(SpdxDocument fromDoc) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(fromDoc.getObjectUri(), "Core.SpdxDocument");
        if (existing.isPresent()) {
            return (org.spdx.library.model.v3_0_1.core.SpdxDocument)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + "document" + this.documentIndex++;
        String existingUri = this.alreadyConverted.putIfAbsent(fromDoc.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (org.spdx.library.model.v3_0_1.core.SpdxDocument)this.getExistingObject(fromDoc.getObjectUri(), "Core.SpdxDocument").get();
        }
        org.spdx.library.model.v3_0_1.core.SpdxDocument toDoc = (org.spdx.library.model.v3_0_1.core.SpdxDocument)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"Core.SpdxDocument", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        for (ExternalDocumentRef externalDocRef : fromDoc.getExternalDocumentRefs()) {
            toDoc.getNamespaceMaps().add(this.convertAndStore(externalDocRef, toDoc.getSpdxImports()));
        }
        this.convertElementProperties((SpdxElement)fromDoc, (Element)toDoc);
        if (!this.equivalentCreationInfo(Objects.requireNonNull(fromDoc.getCreationInfo()), this.defaultCreationInfo)) {
            toDoc.setCreationInfo(Spdx2to3Converter.convertCreationInfo(fromDoc.getCreationInfo(), this.toModelStore, this.defaultUriPrefix));
        }
        toDoc.setDataLicense(this.convertAndStore(fromDoc.getDataLicense()));
        toDoc.getRootElements().addAll(fromDoc.getDocumentDescribes().stream().map(spdxElement -> {
            try {
                return this.convertAndStore((SpdxElement)spdxElement);
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Error converting SPDX elements from spec version 2 to spec version 3", (Throwable)e);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList()));
        for (ExtractedLicenseInfo extractedLicense : fromDoc.getExtractedLicenseInfos()) {
            this.convertAndStore(extractedLicense);
        }
        return toDoc;
    }

    public NamespaceMap convertAndStore(ExternalDocumentRef externalDocRef, Collection<ExternalMap> docImports) throws InvalidSPDXAnalysisException {
        Optional docChecksum = externalDocRef.getChecksum();
        Optional<Hash> externalDocumentHash = docChecksum.isPresent() ? Optional.of(this.convertAndStore((Checksum)docChecksum.get())) : Optional.empty();
        this.docUriToExternalMap.putIfAbsent(externalDocRef.getSpdxDocumentNamespace(), Collections.synchronizedMap(new HashMap()));
        Map<Collection<ExternalMap>, ExternalMapInfo> externalMapInfoMap = this.docUriToExternalMap.get(externalDocRef.getSpdxDocumentNamespace());
        externalMapInfoMap.put(docImports, new ExternalMapInfo(externalDocRef.getId(), externalDocRef.getSpdxDocumentNamespace(), externalDocumentHash, docImports));
        Optional<ModelObjectV3> existing = this.getExistingObject(externalDocRef.getObjectUri(), "Core.NamespaceMap");
        if (existing.isPresent()) {
            return (NamespaceMap)existing.get();
        }
        String toObjectUri = this.toModelStore.getNextId(IModelStore.IdType.Anonymous);
        String existingUri = this.alreadyConverted.putIfAbsent(externalDocRef.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (NamespaceMap)this.getExistingObject(externalDocRef.getObjectUri(), "Core.NamespaceMap").get();
        }
        NamespaceMap toNamespaceMap = (NamespaceMap)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"Core.NamespaceMap", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        toNamespaceMap.setPrefix(externalDocRef.getId());
        toNamespaceMap.setNamespace(externalDocRef.getSpdxDocumentNamespace() + "#");
        return toNamespaceMap;
    }

    public ConjunctiveLicenseSet convertAndStore(org.spdx.library.model.v2.license.ConjunctiveLicenseSet fromConjunctiveLicenseSet) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(fromConjunctiveLicenseSet.getObjectUri(), "ExpandedLicensing.ConjunctiveLicenseSet");
        if (existing.isPresent()) {
            return (ConjunctiveLicenseSet)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(fromConjunctiveLicenseSet.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (ConjunctiveLicenseSet)this.getExistingObject(fromConjunctiveLicenseSet.getObjectUri(), "ExpandedLicensing.ConjunctiveLicenseSet").get();
        }
        ConjunctiveLicenseSet toConjunctiveLicenseSet = (ConjunctiveLicenseSet)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"ExpandedLicensing.ConjunctiveLicenseSet", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        for (org.spdx.library.model.v2.license.AnyLicenseInfo fromMember : fromConjunctiveLicenseSet.getMembers()) {
            toConjunctiveLicenseSet.getMembers().add(this.convertAndStore(fromMember));
        }
        toConjunctiveLicenseSet.setCreationInfo(this.defaultCreationInfo);
        return toConjunctiveLicenseSet;
    }

    public DisjunctiveLicenseSet convertAndStore(org.spdx.library.model.v2.license.DisjunctiveLicenseSet fromDisjunctiveLicenseSet) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(fromDisjunctiveLicenseSet.getObjectUri(), "ExpandedLicensing.DisjunctiveLicenseSet");
        if (existing.isPresent()) {
            return (DisjunctiveLicenseSet)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(fromDisjunctiveLicenseSet.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (DisjunctiveLicenseSet)this.getExistingObject(fromDisjunctiveLicenseSet.getObjectUri(), "ExpandedLicensing.DisjunctiveLicenseSet").get();
        }
        DisjunctiveLicenseSet toDisjunctiveLicenseSet = (DisjunctiveLicenseSet)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"ExpandedLicensing.DisjunctiveLicenseSet", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        for (org.spdx.library.model.v2.license.AnyLicenseInfo fromMember : fromDisjunctiveLicenseSet.getMembers()) {
            toDisjunctiveLicenseSet.getMembers().add(this.convertAndStore(fromMember));
        }
        toDisjunctiveLicenseSet.setCreationInfo(this.defaultCreationInfo);
        return toDisjunctiveLicenseSet;
    }

    public CustomLicense convertAndStore(ExtractedLicenseInfo fromExtractedLicenseInfo) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(fromExtractedLicenseInfo.getObjectUri(), "ExpandedLicensing.CustomLicense");
        if (existing.isPresent()) {
            return (CustomLicense)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(fromExtractedLicenseInfo.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (CustomLicense)this.getExistingObject(fromExtractedLicenseInfo.getObjectUri(), "ExpandedLicensing.CustomLicense").get();
        }
        CustomLicense toCustomLicense = (CustomLicense)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"ExpandedLicensing.CustomLicense", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        toCustomLicense.setCreationInfo(this.defaultCreationInfo);
        toCustomLicense.setLicenseText(fromExtractedLicenseInfo.getExtractedText());
        toCustomLicense.setName(fromExtractedLicenseInfo.getName());
        toCustomLicense.getSeeAlsos().addAll(fromExtractedLicenseInfo.getSeeAlso());
        toCustomLicense.setComment(fromExtractedLicenseInfo.getComment());
        return toCustomLicense;
    }

    public OrLaterOperator convertAndStore(org.spdx.library.model.v2.license.OrLaterOperator fromOrLaterOperator) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(fromOrLaterOperator.getObjectUri(), "ExpandedLicensing.OrLaterOperator");
        if (existing.isPresent()) {
            return (OrLaterOperator)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(fromOrLaterOperator.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (OrLaterOperator)this.getExistingObject(fromOrLaterOperator.getObjectUri(), "ExpandedLicensing.OrLaterOperator").get();
        }
        OrLaterOperator toOrLaterOperator = (OrLaterOperator)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"ExpandedLicensing.OrLaterOperator", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        toOrLaterOperator.setCreationInfo(this.defaultCreationInfo);
        toOrLaterOperator.setSubjectLicense((License)this.convertAndStore((org.spdx.library.model.v2.license.AnyLicenseInfo)fromOrLaterOperator.getLicense()));
        return toOrLaterOperator;
    }

    public ListedLicense convertAndStore(SpdxListedLicense fromSpdxListedLicense) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(fromSpdxListedLicense.getObjectUri(), "ExpandedLicensing.ListedLicense");
        if (existing.isPresent()) {
            return (ListedLicense)existing.get();
        }
        String existingUri = this.alreadyConverted.putIfAbsent(fromSpdxListedLicense.getObjectUri(), fromSpdxListedLicense.getObjectUri());
        if (Objects.nonNull(existingUri)) {
            return (ListedLicense)this.getExistingObject(fromSpdxListedLicense.getObjectUri(), "ExpandedLicensing.ListedLicense").get();
        }
        String licenseId = SpdxListedLicenseModelStore.objectUriToLicenseOrExceptionId(fromSpdxListedLicense.getObjectUri());
        if (ListedLicenses.getListedLicenses().isSpdxListedLicenseId(licenseId)) {
            ListedLicense retval = ListedLicenses.getListedLicenses().getListedLicenseById(licenseId);
            if (this.complexLicenses) {
                this.copyManager.copy(this.toModelStore, fromSpdxListedLicense.getObjectUri(), retval.getModelStore(), fromSpdxListedLicense.getObjectUri(), this.toSpecVersion, null);
            }
            return retval;
        }
        ListedLicense toListedLicense = (ListedLicense)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)fromSpdxListedLicense.getObjectUri(), (String)"ExpandedLicensing.ListedLicense", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        toListedLicense.setCreationInfo(this.defaultCreationInfo);
        toListedLicense.setComment(fromSpdxListedLicense.getComment());
        toListedLicense.setDeprecatedVersion(fromSpdxListedLicense.getDeprecatedVersion());
        toListedLicense.setIsFsfLibre(fromSpdxListedLicense.getFsfLibre());
        toListedLicense.setLicenseText(fromSpdxListedLicense.getLicenseText());
        toListedLicense.setName(fromSpdxListedLicense.getName());
        toListedLicense.getSeeAlsos().addAll(fromSpdxListedLicense.getSeeAlso());
        toListedLicense.setStandardLicenseHeader(fromSpdxListedLicense.getStandardLicenseHeader());
        toListedLicense.setStandardLicenseTemplate(fromSpdxListedLicense.getStandardLicenseTemplate());
        toListedLicense.setIsDeprecatedLicenseId(Boolean.valueOf(fromSpdxListedLicense.isDeprecated()));
        toListedLicense.setIsOsiApproved(Boolean.valueOf(fromSpdxListedLicense.isOsiApproved()));
        return toListedLicense;
    }

    public WithAdditionOperator convertAndStore(WithExceptionOperator fromWithExceptionOperator) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(fromWithExceptionOperator.getObjectUri(), "ExpandedLicensing.WithAdditionOperator");
        if (existing.isPresent()) {
            return (WithAdditionOperator)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(fromWithExceptionOperator.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (WithAdditionOperator)this.getExistingObject(fromWithExceptionOperator.getObjectUri(), "ExpandedLicensing.WithAdditionOperator").get();
        }
        WithAdditionOperator toWithAdditionOperator = (WithAdditionOperator)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"ExpandedLicensing.WithAdditionOperator", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        toWithAdditionOperator.setCreationInfo(this.defaultCreationInfo);
        toWithAdditionOperator.setSubjectAddition(this.convertAndStore(fromWithExceptionOperator.getException()));
        toWithAdditionOperator.setSubjectExtendableLicense((ExtendableLicense)this.convertAndStore(fromWithExceptionOperator.getLicense()));
        return toWithAdditionOperator;
    }

    public LicenseAddition convertAndStore(LicenseException fromException) throws InvalidSPDXAnalysisException {
        if (fromException instanceof ListedLicenseException) {
            return this.convertAndStore((ListedLicenseException)fromException);
        }
        Optional<ModelObjectV3> existing = this.getExistingObject(fromException.getObjectUri(), "ExpandedLicensing.CustomLicenseAddition");
        if (existing.isPresent()) {
            return (CustomLicenseAddition)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(fromException.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (CustomLicenseAddition)this.getExistingObject(fromException.getObjectUri(), "ExpandedLicensing.CustomLicenseAddition").get();
        }
        CustomLicenseAddition toCustomAddition = (CustomLicenseAddition)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"ExpandedLicensing.CustomLicenseAddition", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        this.convertLicenseAdditionProperties(fromException, (LicenseAddition)toCustomAddition);
        return toCustomAddition;
    }

    private void convertLicenseAdditionProperties(LicenseException fromException, LicenseAddition toAddition) throws InvalidSPDXAnalysisException {
        toAddition.setCreationInfo(this.defaultCreationInfo);
        toAddition.setAdditionText(fromException.getLicenseExceptionText());
        toAddition.setComment(fromException.getComment());
        toAddition.setName(fromException.getName());
        toAddition.setStandardAdditionTemplate(fromException.getLicenseExceptionTemplate());
        toAddition.getSeeAlsos().addAll(fromException.getSeeAlso());
    }

    public org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException convertAndStore(ListedLicenseException fromException) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(fromException.getObjectUri(), "ExpandedLicensing.ListedLicenseException");
        if (existing.isPresent()) {
            return (org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException)existing.get();
        }
        String existingUri = this.alreadyConverted.putIfAbsent(fromException.getObjectUri(), fromException.getObjectUri());
        if (Objects.nonNull(existingUri)) {
            return (org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException)this.getExistingObject(fromException.getObjectUri(), "ExpandedLicensing.ListedLicenseException").get();
        }
        String exceptionId = SpdxListedLicenseModelStore.objectUriToLicenseOrExceptionId(fromException.getObjectUri());
        if (ListedLicenses.getListedLicenses().isSpdxListedExceptionId(exceptionId)) {
            org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException retval = ListedLicenses.getListedLicenses().getListedExceptionById(exceptionId);
            if (this.complexLicenses) {
                this.copyManager.copy(this.toModelStore, fromException.getObjectUri(), retval.getModelStore(), fromException.getObjectUri(), this.toSpecVersion, null);
            }
            return retval;
        }
        org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException toListedException = (org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)fromException.getObjectUri(), (String)"ExpandedLicensing.ListedLicenseException", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        this.convertLicenseAdditionProperties((LicenseException)fromException, (LicenseAddition)toListedException);
        toListedException.setDeprecatedVersion(fromException.getDeprecatedVersion());
        toListedException.setIsDeprecatedAdditionId(Boolean.valueOf(fromException.isDeprecated()));
        return toListedException;
    }

    public LicenseExpression convertToLicenseExpression(org.spdx.library.model.v2.license.AnyLicenseInfo fromLicense) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(fromLicense.getObjectUri(), "SimpleLicensing.LicenseExpression");
        if (existing.isPresent()) {
            return (LicenseExpression)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(fromLicense.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (LicenseExpression)this.getExistingObject(fromLicense.getObjectUri(), "SimpleLicensing.LicenseExpression").get();
        }
        LicenseExpression licenseExpression = (LicenseExpression)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"SimpleLicensing.LicenseExpression", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        licenseExpression.setCreationInfo(this.defaultCreationInfo);
        String expression = fromLicense.toString();
        licenseExpression.setLicenseExpression(expression);
        StringTokenizer tokenizer = new StringTokenizer(expression, "() ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (!token.startsWith(SpdxConstantsCompatV2.NON_STD_LICENSE_ID_PRENUM)) continue;
            licenseExpression.getCustomIdToUris().add(licenseExpression.createDictionaryEntry(this.toModelStore.getNextId(IModelStore.IdType.Anonymous)).setKey(token).setValue(this.defaultUriPrefix + token).build());
        }
        return licenseExpression;
    }

    public AnyLicenseInfo convertAndStore(org.spdx.library.model.v2.license.AnyLicenseInfo fromLicense) throws InvalidSPDXAnalysisException {
        if (!this.complexLicenses) {
            return this.convertToLicenseExpression(fromLicense);
        }
        if (fromLicense instanceof org.spdx.library.model.v2.license.ConjunctiveLicenseSet) {
            return this.convertAndStore((org.spdx.library.model.v2.license.ConjunctiveLicenseSet)fromLicense);
        }
        if (fromLicense instanceof org.spdx.library.model.v2.license.DisjunctiveLicenseSet) {
            return this.convertAndStore((org.spdx.library.model.v2.license.DisjunctiveLicenseSet)fromLicense);
        }
        if (fromLicense instanceof ExternalExtractedLicenseInfo) {
            String externalUri = ((ExternalExtractedLicenseInfo)fromLicense).getIndividualURI();
            logger.warn("Referencing an external SPDX 2 element with URI {} while converting from SPDX 2 to 3", (Object)externalUri);
            this.addExternalMapInfo(externalUri);
            return new ExternalCustomLicense(externalUri);
        }
        if (fromLicense instanceof ExtractedLicenseInfo) {
            return this.convertAndStore((ExtractedLicenseInfo)fromLicense);
        }
        if (fromLicense instanceof org.spdx.library.model.v2.license.OrLaterOperator) {
            return this.convertAndStore((org.spdx.library.model.v2.license.OrLaterOperator)fromLicense);
        }
        if (fromLicense instanceof SpdxListedLicense) {
            return this.convertAndStore((SpdxListedLicense)fromLicense);
        }
        if (fromLicense instanceof SpdxNoneLicense) {
            return new NoneLicense();
        }
        if (fromLicense instanceof SpdxNoAssertionLicense) {
            return new NoAssertionLicense();
        }
        if (fromLicense instanceof WithExceptionOperator) {
            return this.convertAndStore((WithExceptionOperator)fromLicense);
        }
        throw new InvalidSPDXAnalysisException("Can not convert the from AnyLicenseInfo type " + fromLicense.getType());
    }

    public Element convertAndStore(SpdxElement fromElement) throws InvalidSPDXAnalysisException {
        if (fromElement instanceof SpdxFile) {
            return this.convertAndStore((SpdxFile)fromElement);
        }
        if (fromElement instanceof org.spdx.library.model.v2.SpdxPackage) {
            return this.convertAndStore((org.spdx.library.model.v2.SpdxPackage)fromElement);
        }
        if (fromElement instanceof SpdxSnippet) {
            return this.convertAndStore((SpdxSnippet)fromElement);
        }
        if (fromElement instanceof SpdxNoAssertionElement) {
            return new NoAssertionElement();
        }
        if (fromElement instanceof SpdxNoneElement) {
            return new NoneElement();
        }
        if (fromElement instanceof ExternalSpdxElement) {
            String externalUri = ((ExternalSpdxElement)fromElement).getIndividualURI();
            logger.warn("Referencing an external SPDX 2 element with URI {} while converting from SPDX 2 to 3", (Object)externalUri);
            this.addExternalMapInfo(externalUri);
            return new ExternalElement(externalUri);
        }
        if (fromElement instanceof SpdxDocument) {
            return this.convertAndStore((SpdxDocument)fromElement);
        }
        throw new InvalidSPDXAnalysisException("Conversion of SPDX 2 type" + fromElement.getType() + " is not currently supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExternalMapInfo(String externalUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(externalUri, "External URI can not be null");
        String[] parts = externalUri.split("#");
        if (parts.length != 2) {
            logger.warn("{} is not a valid SPDX Spec version 2 external referenced - should have a document uri + '#' + ID", (Object)externalUri);
            return;
        }
        Map<Collection<ExternalMap>, ExternalMapInfo> externalMapMap = this.docUriToExternalMap.get(parts[0]);
        if (Objects.isNull(externalMapMap)) {
            logger.warn("No corresponding ExternalDocumentRefs for {}", (Object)externalUri);
            return;
        }
        Map<Collection<ExternalMap>, ExternalMapInfo> map = externalMapMap;
        synchronized (map) {
            for (ExternalMapInfo mapInfo : externalMapMap.values()) {
                mapInfo.addExternalMap(externalUri, this.toModelStore);
            }
        }
    }

    public org.spdx.library.model.v3_0_1.software.SpdxFile convertAndStore(SpdxFile spdxFile) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(spdxFile.getObjectUri(), "Software.SpdxFile");
        if (existing.isPresent()) {
            return (org.spdx.library.model.v3_0_1.software.SpdxFile)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(spdxFile.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (org.spdx.library.model.v3_0_1.software.SpdxFile)this.getExistingObject(spdxFile.getObjectUri(), "Software.SpdxFile").get();
        }
        org.spdx.library.model.v3_0_1.software.SpdxFile toFile = (org.spdx.library.model.v3_0_1.software.SpdxFile)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"Software.SpdxFile", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        this.convertItemProperties((SpdxItem)spdxFile, (SoftwareArtifact)toFile);
        for (Checksum checksum : spdxFile.getChecksums()) {
            toFile.getVerifiedUsings().add(this.convertAndStore(checksum));
        }
        for (FileType fileType : spdxFile.getFileTypes()) {
            this.convertAndAddFileType(fileType, toFile);
        }
        Optional noticeText = spdxFile.getNoticeText();
        noticeText.ifPresent(s -> toFile.getAttributionTexts().add(s));
        return toFile;
    }

    public Hash convertAndStore(Checksum checksum) throws InvalidSPDXAnalysisException {
        Optional<ModelObjectV3> existing = this.getExistingObject(checksum.getObjectUri(), "Core.Hash");
        if (existing.isPresent()) {
            return (Hash)existing.get();
        }
        String toObjectUri = this.toModelStore.getNextId(IModelStore.IdType.Anonymous);
        String existingUri = this.alreadyConverted.putIfAbsent(checksum.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (Hash)this.getExistingObject(checksum.getObjectUri(), "Core.Hash").get();
        }
        Hash toHash = (Hash)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"Core.Hash", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        toHash.setAlgorithm(HASH_ALGORITH_MAP.get(checksum.getAlgorithm()));
        toHash.setHashValue(checksum.getValue());
        return toHash;
    }

    private void convertAndAddFileType(FileType fileType, org.spdx.library.model.v3_0_1.software.SpdxFile file) throws InvalidSPDXAnalysisException {
        switch (fileType) {
            case ARCHIVE: {
                this.addSoftwarePurpose(SoftwarePurpose.ARCHIVE, (SoftwareArtifact)file);
                break;
            }
            case BINARY: {
                file.setContentType("application/octet-stream");
                break;
            }
            case SOURCE: {
                this.addSoftwarePurpose(SoftwarePurpose.SOURCE, (SoftwareArtifact)file);
                break;
            }
            case TEXT: {
                file.setContentType("text/plain");
                break;
            }
            case APPLICATION: {
                this.addSoftwarePurpose(SoftwarePurpose.APPLICATION, (SoftwareArtifact)file);
                break;
            }
            case AUDIO: {
                file.setContentType("audio/*");
                break;
            }
            case IMAGE: {
                file.setContentType("image/*");
                break;
            }
            case VIDEO: {
                file.setContentType("video/*");
                break;
            }
            case DOCUMENTATION: {
                this.addSoftwarePurpose(SoftwarePurpose.DOCUMENTATION, (SoftwareArtifact)file);
                break;
            }
            case SPDX: {
                file.setContentType("text/spdx");
                break;
            }
            case OTHER: {
                this.addSoftwarePurpose(SoftwarePurpose.OTHER, (SoftwareArtifact)file);
                break;
            }
            default: {
                throw new InvalidSPDXAnalysisException("Unknown file type " + fileType);
            }
        }
    }

    private void addSoftwarePurpose(SoftwarePurpose purpose, SoftwareArtifact artifact) throws InvalidSPDXAnalysisException {
        if (artifact.getPrimaryPurpose().isPresent()) {
            artifact.getAdditionalPurposes().add(purpose);
        } else {
            artifact.setPrimaryPurpose(purpose);
        }
    }

    private void convertItemProperties(SpdxItem fromItem, SoftwareArtifact toArtifact) throws InvalidSPDXAnalysisException {
        org.spdx.library.model.v2.license.AnyLicenseInfo concludedLicense;
        this.convertElementProperties((SpdxElement)fromItem, (Element)toArtifact);
        toArtifact.getAttributionTexts().addAll(fromItem.getAttributionText());
        toArtifact.setCopyrightText(fromItem.getCopyrightText());
        Optional licenseComments = fromItem.getLicenseComments();
        if (licenseComments.isPresent()) {
            Optional existingComment = toArtifact.getComment();
            toArtifact.setComment(existingComment.map(s -> s + ";" + (String)licenseComments.get()).orElseGet(licenseComments::get));
        }
        if (Objects.nonNull(concludedLicense = fromItem.getLicenseConcluded())) {
            Relationship concludedRelationship = (Relationship)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)(this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId)), (String)"Core.Relationship", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
            concludedRelationship.setCreationInfo(this.defaultCreationInfo);
            concludedRelationship.setFrom((Element)toArtifact);
            concludedRelationship.getTos().add(this.convertAndStore(concludedLicense));
            concludedRelationship.setRelationshipType(org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_CONCLUDED_LICENSE);
        }
        if (!(fromItem instanceof org.spdx.library.model.v2.SpdxPackage)) {
            for (org.spdx.library.model.v2.license.AnyLicenseInfo declaredLicense : fromItem.getLicenseInfoFromFiles()) {
                Relationship declaredRelationship = (Relationship)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)(this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId)), (String)"Core.Relationship", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
                declaredRelationship.setCreationInfo(this.defaultCreationInfo);
                declaredRelationship.setFrom((Element)toArtifact);
                declaredRelationship.getTos().add(this.convertAndStore(declaredLicense));
                declaredRelationship.setRelationshipType(org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_DECLARED_LICENSE);
            }
        }
    }

    public SpdxPackage convertAndStore(org.spdx.library.model.v2.SpdxPackage spdxPackage) throws InvalidSPDXAnalysisException {
        Optional primaryPurpose;
        Optional pkgVerificationCode;
        Optional packageFileName;
        Optional<ModelObjectV3> existing = this.getExistingObject(spdxPackage.getObjectUri(), "Software.SpdxPackage");
        if (existing.isPresent()) {
            return (SpdxPackage)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(spdxPackage.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (SpdxPackage)this.getExistingObject(spdxPackage.getObjectUri(), "Software.SpdxPackage").get();
        }
        SpdxPackage toPackage = (SpdxPackage)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"Software.SpdxPackage", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        this.convertItemProperties((SpdxItem)spdxPackage, (SoftwareArtifact)toPackage);
        toPackage.setBuiltTime((String)spdxPackage.getBuiltDate().orElse(null));
        toPackage.setDescription((String)spdxPackage.getDescription().orElse(null));
        toPackage.setDownloadLocation((String)spdxPackage.getDownloadLocation().orElse(null));
        for (ExternalRef externalRef : spdxPackage.getExternalRefs()) {
            this.addExternalRefToArtifact(externalRef, (SoftwareArtifact)toPackage);
        }
        toPackage.setHomePage((String)spdxPackage.getHomepage().orElse(null));
        Optional originator = spdxPackage.getOriginator();
        if (originator.isPresent()) {
            toPackage.getOriginatedBys().add(Spdx2to3Converter.stringToAgent((String)originator.get(), toPackage.getCreationInfo()));
        }
        if ((packageFileName = spdxPackage.getPackageFileName()).isPresent()) {
            this.addPackageFileNameToPackage((String)packageFileName.get(), toPackage, spdxPackage.getChecksums());
        }
        if ((pkgVerificationCode = spdxPackage.getPackageVerificationCode()).isPresent()) {
            toPackage.getVerifiedUsings().add(this.convertAndStore((SpdxPackageVerificationCode)pkgVerificationCode.get()));
        }
        if ((primaryPurpose = spdxPackage.getPrimaryPurpose()).isPresent()) {
            if (toPackage.getPrimaryPurpose().isPresent()) {
                toPackage.getAdditionalPurposes().add((SoftwarePurpose)toPackage.getPrimaryPurpose().get());
            }
            toPackage.setPrimaryPurpose(PURPOSE_MAP.get(primaryPurpose.get()));
        }
        toPackage.setReleaseTime((String)spdxPackage.getReleaseDate().orElse(null));
        toPackage.setSourceInfo((String)spdxPackage.getSourceInfo().orElse(null));
        toPackage.setSummary((String)spdxPackage.getSummary().orElse(null));
        Optional supplier = spdxPackage.getSupplier();
        if (supplier.isPresent()) {
            toPackage.setSuppliedBy(Spdx2to3Converter.stringToAgent((String)supplier.get(), toPackage.getCreationInfo()));
        }
        toPackage.setValidUntilTime((String)spdxPackage.getValidUntilDate().orElse(null));
        toPackage.setPackageVersion((String)spdxPackage.getVersionInfo().orElse(null));
        org.spdx.library.model.v2.license.AnyLicenseInfo declaredLicense = spdxPackage.getLicenseDeclared();
        if (Objects.nonNull(declaredLicense)) {
            Relationship declaredRelationship = (Relationship)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)(this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId)), (String)"Core.Relationship", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
            declaredRelationship.setCreationInfo(this.defaultCreationInfo);
            declaredRelationship.setFrom((Element)toPackage);
            declaredRelationship.getTos().add(this.convertAndStore(declaredLicense));
            declaredRelationship.setRelationshipType(org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_DECLARED_LICENSE);
        }
        return toPackage;
    }

    public IntegrityMethod convertAndStore(SpdxPackageVerificationCode spdxPackageVerificationCode) throws InvalidSPDXAnalysisException {
        PackageVerificationCode pkgVerificationCode = (PackageVerificationCode)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)this.toModelStore.getNextId(IModelStore.IdType.Anonymous), (String)"Core.PackageVerificationCode", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        pkgVerificationCode.setAlgorithm(HashAlgorithm.SHA1);
        pkgVerificationCode.setHashValue(spdxPackageVerificationCode.getValue());
        pkgVerificationCode.getPackageVerificationCodeExcludedFiles().addAll(spdxPackageVerificationCode.getExcludedFileNames());
        return pkgVerificationCode;
    }

    private void addPackageFileNameToPackage(String fileName, SpdxPackage toPackage, Collection<Checksum> fileChecksums) throws InvalidSPDXAnalysisException {
        org.spdx.library.model.v3_0_1.software.SpdxFile file = toPackage.createSpdxFile(this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId)).setName(fileName).build();
        for (Checksum checksum : fileChecksums) {
            file.getVerifiedUsings().add(this.convertAndStore(checksum));
        }
        toPackage.createRelationship(this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId)).setRelationshipType(org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_DISTRIBUTION_ARTIFACT).setFrom((Element)toPackage).addTo((Element)file).setCompleteness(RelationshipCompleteness.COMPLETE).build();
    }

    private void addExternalRefToArtifact(ExternalRef externalRef, SoftwareArtifact artifact) throws InvalidSPDXAnalysisException {
        Spdx2to3Converter.addExternalRefToArtifact(externalRef, artifact, this.toModelStore);
    }

    public static void addExternalRefToArtifact(ExternalRef externalRef, SoftwareArtifact artifact, IModelStore modelStore) throws InvalidSPDXAnalysisException {
        Spdx2to3Converter.addExternalRefToArtifact(externalRef.getReferenceCategory(), externalRef.getReferenceType(), externalRef.getReferenceLocator(), externalRef.getComment().orElse(null), artifact, modelStore);
    }

    public static void addExternalRefToArtifact(ReferenceCategory referenceCategory, ReferenceType referenceType, String referenceLocator, @Nullable String comment, SoftwareArtifact artifact, IModelStore modelStore) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(referenceType);
        switch (referenceType.getIndividualURI()) {
            case "http://spdx.org/rdf/references/cpe22Type": 
            case "http://spdx.org/rdf/references/cpe23Type": 
            case "http://spdx.org/rdf/references/swid": {
                artifact.getExternalIdentifiers().add(artifact.createExternalIdentifier(modelStore.getNextId(IModelStore.IdType.Anonymous)).setExternalIdentifierType(EXTERNAL_IDENTIFIER_TYPE_MAP.get(referenceType.getIndividualURI())).setIdentifier(referenceLocator).setComment(comment).build());
                break;
            }
            case "http://spdx.org/rdf/references/purl": {
                if (artifact instanceof SpdxPackage) {
                    ((SpdxPackage)artifact).setPackageUrl(referenceLocator);
                    break;
                }
                artifact.getExternalIdentifiers().add(artifact.createExternalIdentifier(modelStore.getNextId(IModelStore.IdType.Anonymous)).setExternalIdentifierType(EXTERNAL_IDENTIFIER_TYPE_MAP.get(referenceType.getIndividualURI())).setIdentifier(referenceLocator).setComment(comment).build());
                break;
            }
            case "http://spdx.org/rdf/references/swh": 
            case "http://spdx.org/rdf/references/gitoid": {
                artifact.getContentIdentifiers().add(artifact.createContentIdentifier(modelStore.getNextId(IModelStore.IdType.Anonymous)).setContentIdentifierType(CONTENT_IDENTIFIER_TYPE_MAP.get(referenceType.getIndividualURI())).setContentIdentifierValue(referenceLocator).setComment(comment).build());
                break;
            }
            default: {
                ExternalRefType externalRefType = EXTERNAL_REF_TYPE_MAP.get(referenceType.getIndividualURI());
                if (Objects.isNull(externalRefType)) {
                    switch (referenceCategory) {
                        case PACKAGE_MANAGER: {
                            externalRefType = ExternalRefType.BUILD_SYSTEM;
                            break;
                        }
                        case SECURITY: {
                            externalRefType = ExternalRefType.SECURITY_OTHER;
                            break;
                        }
                        default: {
                            externalRefType = ExternalRefType.OTHER;
                        }
                    }
                }
                artifact.getExternalRefs().add(artifact.createExternalRef(modelStore.getNextId(IModelStore.IdType.Anonymous)).setExternalRefType(externalRefType).addLocator(referenceLocator).setComment(comment).build());
            }
        }
    }

    public Snippet convertAndStore(SpdxSnippet fromSnippet) throws InvalidSPDXAnalysisException {
        Optional fromLineRange;
        Optional<ModelObjectV3> existing = this.getExistingObject(fromSnippet.getObjectUri(), "Software.Snippet");
        if (existing.isPresent()) {
            return (Snippet)existing.get();
        }
        String toObjectUri = this.defaultUriPrefix + this.toModelStore.getNextId(IModelStore.IdType.SpdxId);
        String existingUri = this.alreadyConverted.putIfAbsent(fromSnippet.getObjectUri(), toObjectUri);
        if (Objects.nonNull(existingUri)) {
            return (Snippet)this.getExistingObject(fromSnippet.getObjectUri(), "Software.Snippet").get();
        }
        Snippet toSnippet = (Snippet)SpdxModelClassFactoryV3.getModelObject((IModelStore)this.toModelStore, (String)toObjectUri, (String)"Software.Snippet", (IModelCopyManager)this.copyManager, (boolean)true, (String)this.defaultUriPrefix);
        this.convertItemProperties((SpdxItem)fromSnippet, (SoftwareArtifact)toSnippet);
        StartEndPointer fromByteRange = fromSnippet.getByteRange();
        if (Objects.nonNull(fromByteRange)) {
            ByteOffsetPointer startPointer = (ByteOffsetPointer)fromByteRange.getStartPointer();
            ByteOffsetPointer endPointer = (ByteOffsetPointer)fromByteRange.getEndPointer();
            if (Objects.nonNull(startPointer) && Objects.nonNull(endPointer)) {
                toSnippet.setByteRange(toSnippet.createPositiveIntegerRange(this.toModelStore.getNextId(IModelStore.IdType.Anonymous)).setBeginIntegerRange(Integer.valueOf(startPointer.getOffset())).setEndIntegerRange(Integer.valueOf(endPointer.getOffset())).build());
            }
        }
        if ((fromLineRange = fromSnippet.getLineRange()).isPresent()) {
            LineCharPointer startPointer = (LineCharPointer)((StartEndPointer)fromLineRange.get()).getStartPointer();
            LineCharPointer endPointer = (LineCharPointer)((StartEndPointer)fromLineRange.get()).getEndPointer();
            if (Objects.nonNull(startPointer) && Objects.nonNull(endPointer)) {
                toSnippet.setLineRange(toSnippet.createPositiveIntegerRange(this.toModelStore.getNextId(IModelStore.IdType.Anonymous)).setBeginIntegerRange(Integer.valueOf(startPointer.getLineNumber())).setEndIntegerRange(Integer.valueOf(endPointer.getLineNumber())).build());
            }
        }
        toSnippet.setSnippetFromFile(this.convertAndStore(Objects.requireNonNull(fromSnippet.getSnippetFromFile())));
        return toSnippet;
    }

    static {
        HashMap<RelationshipType, org.spdx.library.model.v3_0_1.core.RelationshipType> relationshipTypeMap = new HashMap<RelationshipType, org.spdx.library.model.v3_0_1.core.RelationshipType>();
        HashMap<RelationshipType, LifecycleScopeType> lifecycleScopeMap = new HashMap<RelationshipType, LifecycleScopeType>();
        HashSet<RelationshipType> swapToFromRelTypes = new HashSet<RelationshipType>();
        HashMap<ChecksumAlgorithm, HashAlgorithm> hashAlgorithmMap = new HashMap<ChecksumAlgorithm, HashAlgorithm>();
        relationshipTypeMap.put(RelationshipType.DESCRIBES, org.spdx.library.model.v3_0_1.core.RelationshipType.DESCRIBES);
        relationshipTypeMap.put(RelationshipType.DESCRIBED_BY, org.spdx.library.model.v3_0_1.core.RelationshipType.DESCRIBES);
        swapToFromRelTypes.add(RelationshipType.DESCRIBED_BY);
        relationshipTypeMap.put(RelationshipType.ANCESTOR_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.ANCESTOR_OF);
        relationshipTypeMap.put(RelationshipType.BUILD_TOOL_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.USES_TOOL);
        lifecycleScopeMap.put(RelationshipType.BUILD_TOOL_OF, LifecycleScopeType.BUILD);
        swapToFromRelTypes.add(RelationshipType.BUILD_TOOL_OF);
        relationshipTypeMap.put(RelationshipType.CONTAINED_BY, org.spdx.library.model.v3_0_1.core.RelationshipType.CONTAINS);
        swapToFromRelTypes.add(RelationshipType.CONTAINED_BY);
        relationshipTypeMap.put(RelationshipType.CONTAINS, org.spdx.library.model.v3_0_1.core.RelationshipType.CONTAINS);
        relationshipTypeMap.put(RelationshipType.COPY_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.COPIED_TO);
        swapToFromRelTypes.add(RelationshipType.COPY_OF);
        relationshipTypeMap.put(RelationshipType.DATA_FILE_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_DATA_FILE);
        swapToFromRelTypes.add(RelationshipType.DATA_FILE_OF);
        relationshipTypeMap.put(RelationshipType.DESCENDANT_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.DESCENDANT_OF);
        relationshipTypeMap.put(RelationshipType.DISTRIBUTION_ARTIFACT, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_DISTRIBUTION_ARTIFACT);
        relationshipTypeMap.put(RelationshipType.DOCUMENTATION_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_DOCUMENTATION);
        swapToFromRelTypes.add(RelationshipType.DOCUMENTATION_OF);
        relationshipTypeMap.put(RelationshipType.DYNAMIC_LINK, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_DYNAMIC_LINK);
        swapToFromRelTypes.add(RelationshipType.DYNAMIC_LINK);
        relationshipTypeMap.put(RelationshipType.EXPANDED_FROM_ARCHIVE, org.spdx.library.model.v3_0_1.core.RelationshipType.EXPANDS_TO);
        swapToFromRelTypes.add(RelationshipType.EXPANDED_FROM_ARCHIVE);
        relationshipTypeMap.put(RelationshipType.FILE_ADDED, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_ADDED_FILE);
        swapToFromRelTypes.add(RelationshipType.FILE_ADDED);
        relationshipTypeMap.put(RelationshipType.FILE_DELETED, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_DELETED_FILE);
        swapToFromRelTypes.add(RelationshipType.FILE_DELETED);
        relationshipTypeMap.put(RelationshipType.FILE_MODIFIED, org.spdx.library.model.v3_0_1.core.RelationshipType.MODIFIED_BY);
        relationshipTypeMap.put(RelationshipType.GENERATED_FROM, org.spdx.library.model.v3_0_1.core.RelationshipType.GENERATES);
        swapToFromRelTypes.add(RelationshipType.GENERATED_FROM);
        relationshipTypeMap.put(RelationshipType.GENERATES, org.spdx.library.model.v3_0_1.core.RelationshipType.GENERATES);
        relationshipTypeMap.put(RelationshipType.METAFILE_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_METADATA);
        swapToFromRelTypes.add(RelationshipType.METAFILE_OF);
        relationshipTypeMap.put(RelationshipType.OPTIONAL_COMPONENT_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_OPTIONAL_COMPONENT);
        swapToFromRelTypes.add(RelationshipType.OPTIONAL_COMPONENT_OF);
        relationshipTypeMap.put(RelationshipType.OTHER, org.spdx.library.model.v3_0_1.core.RelationshipType.OTHER);
        relationshipTypeMap.put(RelationshipType.PACKAGE_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.PACKAGED_BY);
        swapToFromRelTypes.add(RelationshipType.PACKAGE_OF);
        relationshipTypeMap.put(RelationshipType.PATCH_APPLIED, org.spdx.library.model.v3_0_1.core.RelationshipType.PATCHED_BY);
        swapToFromRelTypes.add(RelationshipType.PATCH_APPLIED);
        relationshipTypeMap.put(RelationshipType.PATCH_FOR, org.spdx.library.model.v3_0_1.core.RelationshipType.PATCHED_BY);
        swapToFromRelTypes.add(RelationshipType.PATCH_FOR);
        relationshipTypeMap.put(RelationshipType.AMENDS, org.spdx.library.model.v3_0_1.core.RelationshipType.AMENDED_BY);
        swapToFromRelTypes.add(RelationshipType.AMENDS);
        relationshipTypeMap.put(RelationshipType.STATIC_LINK, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_STATIC_LINK);
        relationshipTypeMap.put(RelationshipType.TEST_CASE_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_TEST_CASE);
        swapToFromRelTypes.add(RelationshipType.TEST_CASE_OF);
        relationshipTypeMap.put(RelationshipType.PREREQUISITE_FOR, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_PREREQUISITE);
        swapToFromRelTypes.add(RelationshipType.PREREQUISITE_FOR);
        relationshipTypeMap.put(RelationshipType.HAS_PREREQUISITE, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_PREREQUISITE);
        relationshipTypeMap.put(RelationshipType.VARIANT_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_VARIANT);
        swapToFromRelTypes.add(RelationshipType.VARIANT_OF);
        relationshipTypeMap.put(RelationshipType.BUILD_DEPENDENCY_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.DEPENDS_ON);
        swapToFromRelTypes.add(RelationshipType.BUILD_DEPENDENCY_OF);
        relationshipTypeMap.put(RelationshipType.DEPENDENCY_MANIFEST_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_DEPENDENCY_MANIFEST);
        swapToFromRelTypes.add(RelationshipType.DEPENDENCY_MANIFEST_OF);
        relationshipTypeMap.put(RelationshipType.DEPENDENCY_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.DEPENDS_ON);
        swapToFromRelTypes.add(RelationshipType.DEPENDENCY_OF);
        relationshipTypeMap.put(RelationshipType.DEPENDS_ON, org.spdx.library.model.v3_0_1.core.RelationshipType.DEPENDS_ON);
        lifecycleScopeMap.put(RelationshipType.DEPENDS_ON, LifecycleScopeType.BUILD);
        relationshipTypeMap.put(RelationshipType.DEV_DEPENDENCY_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.DEPENDS_ON);
        swapToFromRelTypes.add(RelationshipType.DEV_DEPENDENCY_OF);
        lifecycleScopeMap.put(RelationshipType.DEV_DEPENDENCY_OF, LifecycleScopeType.DEVELOPMENT);
        relationshipTypeMap.put(RelationshipType.DEV_TOOL_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.USES_TOOL);
        swapToFromRelTypes.add(RelationshipType.DEV_TOOL_OF);
        lifecycleScopeMap.put(RelationshipType.DEV_TOOL_OF, LifecycleScopeType.DEVELOPMENT);
        relationshipTypeMap.put(RelationshipType.EXAMPLE_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_EXAMPLE);
        swapToFromRelTypes.add(RelationshipType.EXAMPLE_OF);
        relationshipTypeMap.put(RelationshipType.OPTIONAL_DEPENDENCY_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_OPTIONAL_DEPENDENCY);
        swapToFromRelTypes.add(RelationshipType.OPTIONAL_DEPENDENCY_OF);
        relationshipTypeMap.put(RelationshipType.PROVIDED_DEPENDENCY_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_PROVIDED_DEPENDENCY);
        swapToFromRelTypes.add(RelationshipType.PROVIDED_DEPENDENCY_OF);
        relationshipTypeMap.put(RelationshipType.RUNTIME_DEPENDENCY_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.DEPENDS_ON);
        swapToFromRelTypes.add(RelationshipType.RUNTIME_DEPENDENCY_OF);
        lifecycleScopeMap.put(RelationshipType.RUNTIME_DEPENDENCY_OF, LifecycleScopeType.RUNTIME);
        relationshipTypeMap.put(RelationshipType.TEST_DEPENDENCY_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.DEPENDS_ON);
        lifecycleScopeMap.put(RelationshipType.TEST_DEPENDENCY_OF, LifecycleScopeType.TEST);
        swapToFromRelTypes.add(RelationshipType.TEST_DEPENDENCY_OF);
        relationshipTypeMap.put(RelationshipType.TEST_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_TEST);
        swapToFromRelTypes.add(RelationshipType.TEST_OF);
        relationshipTypeMap.put(RelationshipType.TEST_TOOL_OF, org.spdx.library.model.v3_0_1.core.RelationshipType.USES_TOOL);
        swapToFromRelTypes.add(RelationshipType.TEST_TOOL_OF);
        lifecycleScopeMap.put(RelationshipType.TEST_TOOL_OF, LifecycleScopeType.TEST);
        relationshipTypeMap.put(RelationshipType.REQUIREMENT_DESCRIPTION_FOR, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_REQUIREMENT);
        swapToFromRelTypes.add(RelationshipType.REQUIREMENT_DESCRIPTION_FOR);
        relationshipTypeMap.put(RelationshipType.SPECIFICATION_FOR, org.spdx.library.model.v3_0_1.core.RelationshipType.HAS_SPECIFICATION);
        swapToFromRelTypes.add(RelationshipType.SPECIFICATION_FOR);
        RELATIONSHIP_TYPE_MAP = Collections.unmodifiableMap(relationshipTypeMap);
        SWAP_TO_FROM_REL_TYPES = Collections.unmodifiableSet(swapToFromRelTypes);
        LIFECYCLE_SCOPE_MAP = Collections.unmodifiableMap(lifecycleScopeMap);
        HashMap<AnnotationType, org.spdx.library.model.v3_0_1.core.AnnotationType> annotationTypeMap = new HashMap<AnnotationType, org.spdx.library.model.v3_0_1.core.AnnotationType>();
        annotationTypeMap.put(AnnotationType.OTHER, org.spdx.library.model.v3_0_1.core.AnnotationType.OTHER);
        annotationTypeMap.put(AnnotationType.REVIEW, org.spdx.library.model.v3_0_1.core.AnnotationType.REVIEW);
        ANNOTATION_TYPE_MAP = Collections.unmodifiableMap(annotationTypeMap);
        hashAlgorithmMap.put(ChecksumAlgorithm.ADLER32, HashAlgorithm.OTHER);
        hashAlgorithmMap.put(ChecksumAlgorithm.BLAKE2b_256, HashAlgorithm.BLAKE2B256);
        hashAlgorithmMap.put(ChecksumAlgorithm.BLAKE2b_384, HashAlgorithm.BLAKE2B384);
        hashAlgorithmMap.put(ChecksumAlgorithm.BLAKE2b_512, HashAlgorithm.BLAKE2B512);
        hashAlgorithmMap.put(ChecksumAlgorithm.BLAKE3, HashAlgorithm.BLAKE3);
        hashAlgorithmMap.put(ChecksumAlgorithm.MD2, HashAlgorithm.MD2);
        hashAlgorithmMap.put(ChecksumAlgorithm.MD4, HashAlgorithm.MD4);
        hashAlgorithmMap.put(ChecksumAlgorithm.MD5, HashAlgorithm.MD5);
        hashAlgorithmMap.put(ChecksumAlgorithm.MD6, HashAlgorithm.MD6);
        hashAlgorithmMap.put(ChecksumAlgorithm.SHA1, HashAlgorithm.SHA1);
        hashAlgorithmMap.put(ChecksumAlgorithm.SHA224, HashAlgorithm.SHA224);
        hashAlgorithmMap.put(ChecksumAlgorithm.SHA256, HashAlgorithm.SHA256);
        hashAlgorithmMap.put(ChecksumAlgorithm.SHA384, HashAlgorithm.SHA384);
        hashAlgorithmMap.put(ChecksumAlgorithm.SHA3_256, HashAlgorithm.SHA3_256);
        hashAlgorithmMap.put(ChecksumAlgorithm.SHA3_384, HashAlgorithm.SHA3_384);
        hashAlgorithmMap.put(ChecksumAlgorithm.SHA3_512, HashAlgorithm.SHA3_512);
        hashAlgorithmMap.put(ChecksumAlgorithm.SHA512, HashAlgorithm.SHA512);
        HASH_ALGORITH_MAP = Collections.unmodifiableMap(hashAlgorithmMap);
        HashMap<String, ContentIdentifierType> contentIdentifierTypeMap = new HashMap<String, ContentIdentifierType>();
        contentIdentifierTypeMap.put("http://spdx.org/rdf/references/gitoid", ContentIdentifierType.GITOID);
        contentIdentifierTypeMap.put("http://spdx.org/rdf/references/swh", ContentIdentifierType.SWHID);
        CONTENT_IDENTIFIER_TYPE_MAP = Collections.unmodifiableMap(contentIdentifierTypeMap);
        HashMap<String, ExternalIdentifierType> externalIdentifierTypeMap = new HashMap<String, ExternalIdentifierType>();
        externalIdentifierTypeMap.put("http://spdx.org/rdf/references/cpe22Type", ExternalIdentifierType.CPE22);
        externalIdentifierTypeMap.put("http://spdx.org/rdf/references/cpe23Type", ExternalIdentifierType.CPE23);
        externalIdentifierTypeMap.put("http://spdx.org/rdf/references/swid", ExternalIdentifierType.SWID);
        externalIdentifierTypeMap.put("http://spdx.org/rdf/references/purl", ExternalIdentifierType.PACKAGE_URL);
        EXTERNAL_IDENTIFIER_TYPE_MAP = Collections.unmodifiableMap(externalIdentifierTypeMap);
        HashMap<String, ExternalRefType> externalRefTypeMap = new HashMap<String, ExternalRefType>();
        externalRefTypeMap.put("http://spdx.org/rdf/references/maven-central", ExternalRefType.MAVEN_CENTRAL);
        externalRefTypeMap.put("http://spdx.org/rdf/references/npm", ExternalRefType.NPM);
        externalRefTypeMap.put("http://spdx.org/rdf/references/nuget", ExternalRefType.NUGET);
        externalRefTypeMap.put("http://spdx.org/rdf/references/bower", ExternalRefType.BOWER);
        externalRefTypeMap.put("http://spdx.org/rdf/references/advisory", ExternalRefType.SECURITY_ADVISORY);
        externalRefTypeMap.put("http://spdx.org/rdf/references/fix", ExternalRefType.SECURITY_FIX);
        externalRefTypeMap.put("http://spdx.org/rdf/references/url", ExternalRefType.SECURITY_OTHER);
        EXTERNAL_REF_TYPE_MAP = Collections.unmodifiableMap(externalRefTypeMap);
        HashMap<Purpose, SoftwarePurpose> purposeMap = new HashMap<Purpose, SoftwarePurpose>();
        purposeMap.put(Purpose.APPLICATION, SoftwarePurpose.APPLICATION);
        purposeMap.put(Purpose.ARCHIVE, SoftwarePurpose.ARCHIVE);
        purposeMap.put(Purpose.CONTAINER, SoftwarePurpose.CONTAINER);
        purposeMap.put(Purpose.DEVICE, SoftwarePurpose.DEVICE);
        purposeMap.put(Purpose.FILE, SoftwarePurpose.FILE);
        purposeMap.put(Purpose.FIRMWARE, SoftwarePurpose.FIRMWARE);
        purposeMap.put(Purpose.FRAMEWORK, SoftwarePurpose.FRAMEWORK);
        purposeMap.put(Purpose.INSTALL, SoftwarePurpose.INSTALL);
        purposeMap.put(Purpose.LIBRARY, SoftwarePurpose.LIBRARY);
        purposeMap.put(Purpose.OPERATING_SYSTEM, SoftwarePurpose.OPERATING_SYSTEM);
        purposeMap.put(Purpose.OTHER, SoftwarePurpose.OTHER);
        purposeMap.put(Purpose.SOURCE, SoftwarePurpose.SOURCE);
        PURPOSE_MAP = Collections.unmodifiableMap(purposeMap);
    }
}

