/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.InvalidSpdxPropertyException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.Tool;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.listedlicense.SpdxListedLicenseModelStore;

public class ExceptionJson {
    public static final List<PropertyDescriptor> ALL_PROPERTY_DESCRIPTORS;
    public static final Map<PropertyDescriptor, String> PROPERTY_DESCRIPTOR_TO_VALUE_NAME;
    static final Set<PropertyDescriptor> COLLECTION_PROPERTIES;
    Boolean isDeprecatedLicenseId;
    String licenseExceptionText;
    String name;
    String licenseComments;
    String comment;
    List<String> seeAlso = new ArrayList<String>();
    String licenseExceptionId;
    String licenseExceptionTemplate;
    String example;
    String deprecatedVersion;
    String exceptionTextHtml;
    String licenseXml;
    String obsoletedBy;
    String listVersionAdded;

    public ExceptionJson(String id) {
        this.licenseExceptionId = id;
    }

    public ExceptionJson() {
    }

    public void setTypedProperty(String propertyName, String valueId, String type) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException("Invalid type for Listed License SPDX Property: " + type);
    }

    public void setPrimitiveValue(PropertyDescriptor propertyDescriptor, Object value) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed exception:" + propertyDescriptor.getName());
        }
        switch (propertyName) {
            case "licenseExceptionText": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseExceptionText = (String)value;
                break;
            }
            case "name": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.name = (String)value;
                break;
            }
            case "seeAlso": {
                throw new InvalidSpdxPropertyException("Expected list type for " + propertyDescriptor);
            }
            case "licenseExceptionTemplate": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseExceptionTemplate = (String)value;
                break;
            }
            case "example": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.example = (String)value;
                break;
            }
            case "isDeprecatedLicenseId": {
                if (!(value instanceof Boolean)) {
                    throw new InvalidSpdxPropertyException("Expected Boolean type for " + propertyDescriptor);
                }
                this.isDeprecatedLicenseId = (Boolean)value;
                break;
            }
            case "deprecatedVersion": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.deprecatedVersion = (String)value;
                break;
            }
            case "comment": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseComments = (String)value;
                this.comment = (String)value;
                break;
            }
            case "licenseExceptionId": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseExceptionId = (String)value;
                break;
            }
            case "exceptionTextHtml": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.exceptionTextHtml = (String)value;
                break;
            }
            case "obsoletedBy": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.obsoletedBy = (String)value;
                break;
            }
            case "licenseXml": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.licenseXml = (String)value;
                break;
            }
            case "listVersionAdded": {
                if (!(value instanceof String)) {
                    throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
                }
                this.listVersionAdded = (String)value;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor);
            }
        }
    }

    public void clearPropertyValueList(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        if (!"seeAlso".equals(PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor))) {
            throw new InvalidSpdxPropertyException(propertyDescriptor + "is not a list type");
        }
        this.seeAlso.clear();
    }

    public void addValueToList(String propertyName, String valueId, String type) throws InvalidSpdxPropertyException {
        throw new InvalidSpdxPropertyException("Invalid type for Listed License SPDX Property: " + type);
    }

    public boolean addPrimitiveValueToList(PropertyDescriptor propertyDescriptor, Object value) throws InvalidSpdxPropertyException {
        if (!"seeAlso".equals(PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor))) {
            throw new InvalidSpdxPropertyException(propertyDescriptor + "is not a list type");
        }
        if (!(value instanceof String)) {
            throw new InvalidSpdxPropertyException("Expected string type for " + propertyDescriptor);
        }
        return this.seeAlso.add((String)value);
    }

    public List<?> getValueList(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        if ("seeAlso".equals(PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor))) {
            return this.seeAlso;
        }
        if (COLLECTION_PROPERTIES.contains(propertyDescriptor)) {
            return new ArrayList();
        }
        throw new InvalidSpdxPropertyException(propertyDescriptor + "is not a list type");
    }

    public Object getValue(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            return null;
        }
        switch (propertyName) {
            case "licenseExceptionText": {
                return this.licenseExceptionText;
            }
            case "name": {
                return this.name;
            }
            case "seeAlso": {
                return this.seeAlso;
            }
            case "licenseExceptionTemplate": {
                return this.licenseExceptionTemplate;
            }
            case "example": {
                return this.example;
            }
            case "isDeprecatedLicenseId": {
                return this.isDeprecatedLicenseId;
            }
            case "deprecatedVersion": {
                return this.deprecatedVersion;
            }
            case "comment": {
                if (this.comment != null) {
                    return this.comment;
                }
                return this.licenseComments;
            }
            case "licenseExceptionId": {
                return this.licenseExceptionId;
            }
            case "exceptionTextHtml": {
                return this.exceptionTextHtml;
            }
            case "licenseXml": {
                return this.licenseXml;
            }
            case "obsoletedBy": {
                return this.obsoletedBy;
            }
            case "listVersionAdded": {
                return this.listVersionAdded;
            }
        }
        return null;
    }

    public void removeProperty(PropertyDescriptor propertyDescriptor) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed exception:" + propertyDescriptor.getName());
        }
        switch (propertyName) {
            case "licenseExceptionText": {
                this.licenseExceptionText = null;
                break;
            }
            case "name": {
                this.name = null;
                break;
            }
            case "seeAlso": {
                this.seeAlso.clear();
                break;
            }
            case "licenseExceptionTemplate": {
                this.licenseExceptionTemplate = null;
                break;
            }
            case "example": {
                this.example = null;
                break;
            }
            case "isDeprecatedLicenseId": {
                this.isDeprecatedLicenseId = null;
                break;
            }
            case "deprecatedVersion": {
                this.deprecatedVersion = null;
                break;
            }
            case "comment": {
                this.comment = null;
                this.licenseComments = null;
                break;
            }
            case "licenseExceptionId": {
                this.licenseExceptionId = null;
                break;
            }
            case "exceptionTextHtml": {
                this.exceptionTextHtml = null;
                break;
            }
            case "licenseXml": {
                this.licenseXml = null;
                break;
            }
            case "obsoletedBy": {
                this.obsoletedBy = null;
                break;
            }
            case "listVersionAdded": {
                this.listVersionAdded = null;
                break;
            }
            default: {
                throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor);
            }
        }
    }

    public void copyFrom(ListedLicenseException fromException) throws InvalidSPDXAnalysisException {
        Optional comment = fromException.getComment();
        this.comment = comment.orElse(null);
        this.deprecatedVersion = fromException.getDeprecatedVersion().orElse(null);
        this.isDeprecatedLicenseId = fromException.getIsDeprecatedAdditionId().orElse(false);
        this.licenseExceptionId = SpdxListedLicenseModelStore.objectUriToLicenseOrExceptionId(fromException.getObjectUri());
        this.licenseExceptionTemplate = fromException.getStandardAdditionTemplate().orElse(null);
        this.licenseExceptionText = fromException.getAdditionText();
        this.name = fromException.getName().orElse(null);
        this.seeAlso = new ArrayList<String>(fromException.getSeeAlsos());
        this.obsoletedBy = fromException.getObsoletedBy().orElse(null);
        this.listVersionAdded = fromException.getListVersionAdded().orElse(null);
        this.licenseXml = fromException.getLicenseXml().orElse(null);
    }

    public void copyFrom(org.spdx.library.model.v2.license.ListedLicenseException fromException) throws InvalidSPDXAnalysisException {
        this.comment = null;
        this.licenseComments = fromException.getComment();
        if (Objects.nonNull(this.licenseComments) && this.licenseComments.isEmpty()) {
            this.licenseComments = null;
        }
        this.deprecatedVersion = fromException.getDeprecatedVersion();
        if (Objects.nonNull(this.deprecatedVersion) && this.deprecatedVersion.isEmpty()) {
            this.deprecatedVersion = null;
        }
        this.example = fromException.getExample();
        if (Objects.nonNull(this.example) && this.example.isEmpty()) {
            this.example = null;
        }
        this.isDeprecatedLicenseId = fromException.isDeprecated();
        this.licenseExceptionId = fromException.getId();
        this.licenseExceptionTemplate = fromException.getLicenseExceptionTemplate();
        if (Objects.nonNull(this.licenseExceptionTemplate) && this.licenseExceptionTemplate.isEmpty()) {
            this.licenseExceptionTemplate = null;
        }
        this.licenseExceptionText = fromException.getLicenseExceptionText();
        if (Objects.nonNull(this.licenseExceptionText) && this.licenseExceptionText.isEmpty()) {
            this.licenseExceptionText = null;
        }
        this.name = fromException.getName();
        if (Objects.nonNull(this.name) && this.name.isEmpty()) {
            this.name = null;
        }
        this.seeAlso = new ArrayList<String>(fromException.getSeeAlso());
        this.exceptionTextHtml = fromException.getExceptionTextHtml();
        if (Objects.nonNull(this.exceptionTextHtml) && this.exceptionTextHtml.isEmpty()) {
            this.exceptionTextHtml = null;
        }
    }

    public boolean removePrimitiveValueToList(PropertyDescriptor propertyDescriptor, Object value) throws InvalidSpdxPropertyException {
        if (!"seeAlso".equals(PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor))) {
            throw new InvalidSpdxPropertyException(propertyDescriptor + "is not a list type");
        }
        return this.seeAlso.remove(value);
    }

    public boolean isPropertyValueAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSpdxPropertyException {
        String propertyName = PROPERTY_DESCRIPTOR_TO_VALUE_NAME.get(propertyDescriptor);
        if (Objects.isNull(propertyName)) {
            throw new InvalidSpdxPropertyException("Invalid property for SPDX listed exception:" + propertyDescriptor.getName());
        }
        switch (propertyName) {
            case "licenseExceptionText": 
            case "name": 
            case "licenseExceptionTemplate": 
            case "example": 
            case "comment": 
            case "deprecatedVersion": 
            case "exceptionTextHtml": 
            case "obsoletedBy": 
            case "licenseXml": 
            case "listVersionAdded": 
            case "licenseExceptionId": {
                return String.class.isAssignableFrom(clazz);
            }
            case "seeAlso": {
                return false;
            }
            case "isDeprecatedLicenseId": {
                return Boolean.class.isAssignableFrom(clazz);
            }
        }
        throw new InvalidSpdxPropertyException("Invalid property for SPDX listed license:" + propertyDescriptor);
    }

    public static boolean isCollectionMembersAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) {
        if (SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO.equals((Object)propertyDescriptor) || SpdxConstantsV3.PROP_SEE_ALSO.equals((Object)propertyDescriptor)) {
            return String.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTERNAL_REF.equals((Object)propertyDescriptor)) {
            return ExternalRef.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_VERIFIED_USING.equals((Object)propertyDescriptor)) {
            return IntegrityMethod.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTENSION.equals((Object)propertyDescriptor)) {
            return Extension.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER.equals((Object)propertyDescriptor)) {
            return ExternalIdentifier.class.isAssignableFrom(clazz);
        }
        if (SpdxConstantsV3.PROP_CREATED_USING.equals((Object)propertyDescriptor)) {
            return Tool.class.isAssignableFrom(clazz);
        }
        return false;
    }

    public boolean isCollectionProperty(PropertyDescriptor propertyDescriptor) {
        return COLLECTION_PROPERTIES.contains(propertyDescriptor);
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors() {
        ArrayList<PropertyDescriptor> retval = new ArrayList<PropertyDescriptor>();
        ALL_PROPERTY_DESCRIPTORS.forEach(propDescriptor -> {
            try {
                if (Objects.nonNull(this.getValue((PropertyDescriptor)propDescriptor))) {
                    retval.add((PropertyDescriptor)propDescriptor);
                }
            }
            catch (InvalidSpdxPropertyException invalidSpdxPropertyException) {
                // empty catch block
            }
        });
        return retval;
    }

    static {
        HashMap<PropertyDescriptor, String> descriptorsToValue = new HashMap<PropertyDescriptor, String>();
        HashSet<PropertyDescriptor> collectionProperties = new HashSet<PropertyDescriptor>();
        descriptorsToValue.put(SpdxConstantsV3.PROP_ADDITION_TEXT, "licenseExceptionText");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_EXCEPTION_TEXT, "licenseExceptionText");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_EXCEPTION_TEXT_HTML, "exceptionTextHtml");
        descriptorsToValue.put(SpdxConstantsV3.PROP_NAME, "name");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_NAME, "name");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LICENSE_EXCEPTION_ID, "licenseExceptionId");
        descriptorsToValue.put(SpdxConstantsV3.PROP_STANDARD_ADDITION_TEMPLATE, "licenseExceptionTemplate");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_EXCEPTION_TEMPLATE, "licenseExceptionTemplate");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_EXAMPLE, "example");
        descriptorsToValue.put(SpdxConstantsV3.PROP_IS_DEPRECATED_ADDITION_ID, "isDeprecatedLicenseId");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LIC_ID_DEPRECATED, "isDeprecatedLicenseId");
        descriptorsToValue.put(SpdxConstantsV3.PROP_DEPRECATED_VERSION, "deprecatedVersion");
        descriptorsToValue.put(SpdxConstantsCompatV2.PROP_LIC_DEPRECATED_VERSION, "deprecatedVersion");
        descriptorsToValue.put(SpdxConstantsV3.PROP_COMMENT, "comment");
        descriptorsToValue.put(SpdxConstantsCompatV2.RDFS_PROP_COMMENT, "comment");
        descriptorsToValue.put(SpdxConstantsV3.PROP_SEE_ALSO, "seeAlso");
        collectionProperties.add(SpdxConstantsV3.PROP_SEE_ALSO);
        descriptorsToValue.put(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO, "seeAlso");
        collectionProperties.add(SpdxConstantsCompatV2.RDFS_PROP_SEE_ALSO);
        descriptorsToValue.put(SpdxConstantsV3.PROP_LICENSE_XML, "licenseXml");
        descriptorsToValue.put(SpdxConstantsV3.PROP_OBSOLETED_BY, "obsoletedBy");
        descriptorsToValue.put(SpdxConstantsV3.PROP_LIST_VERSION_ADDED, "listVersionAdded");
        descriptorsToValue.put(SpdxConstantsV3.PROP_EXTERNAL_REF, "externalRef");
        collectionProperties.add(SpdxConstantsV3.PROP_EXTERNAL_REF);
        descriptorsToValue.put(SpdxConstantsV3.PROP_VERIFIED_USING, "verifiedUsing");
        collectionProperties.add(SpdxConstantsV3.PROP_VERIFIED_USING);
        descriptorsToValue.put(SpdxConstantsV3.PROP_EXTENSION, "extension");
        collectionProperties.add(SpdxConstantsV3.PROP_EXTENSION);
        descriptorsToValue.put(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER, "externalIdentifier");
        collectionProperties.add(SpdxConstantsV3.PROP_EXTERNAL_IDENTIFIER);
        descriptorsToValue.put(SpdxConstantsV3.PROP_CREATED_USING, "createdUsing");
        collectionProperties.add(SpdxConstantsV3.PROP_CREATED_USING);
        descriptorsToValue.put(SpdxConstantsV3.PROP_DESCRIPTION, "description");
        descriptorsToValue.put(SpdxConstantsV3.PROP_SUMMARY, "summary");
        PROPERTY_DESCRIPTOR_TO_VALUE_NAME = Collections.unmodifiableMap(descriptorsToValue);
        ALL_PROPERTY_DESCRIPTORS = Collections.unmodifiableList(new ArrayList(descriptorsToValue.keySet()));
        COLLECTION_PROPERTIES = Collections.unmodifiableSet(collectionProperties);
    }
}

