/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.storage.listedlicense.LicenseJsonTOC;

public class ExceptionJsonTOC {
    private String licenseListVersion;
    private final List<ExceptionJson> exceptions;
    private String releaseDate;

    public ExceptionJsonTOC(String version, String releaseDate) {
        this.licenseListVersion = version;
        this.releaseDate = releaseDate;
        this.exceptions = new ArrayList<ExceptionJson>();
    }

    public ExceptionJsonTOC() {
        this.licenseListVersion = null;
        this.exceptions = new ArrayList<ExceptionJson>();
        this.releaseDate = null;
    }

    @Nullable
    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public List<ExceptionJson> getExceptions() {
        return this.exceptions;
    }

    public Map<String, String> getExceptionIds() {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (ExceptionJson licenseException : this.exceptions) {
            retval.put(licenseException.licenseExceptionId.toLowerCase(), licenseException.licenseExceptionId);
        }
        return retval;
    }

    @Nullable
    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void addException(ListedLicenseException exception, String exceptionHTMLReference, String exceptionJSONReference, boolean deprecated) throws InvalidSPDXAnalysisException {
        ExceptionJson ej = new ExceptionJson();
        ej.setLicenseExceptionId(exception.getId());
        ej.setDeprecatedLicenseId(deprecated);
        ej.setDetailsUrl(LicenseJsonTOC.toAbsoluteURL(exceptionJSONReference));
        ej.setName(exception.getName());
        ej.setReference(LicenseJsonTOC.toAbsoluteURL(exceptionHTMLReference));
        int referenceNumber = 0;
        for (ExceptionJson existing : this.exceptions) {
            if (existing.getReferenceNumber() <= referenceNumber) continue;
            referenceNumber = existing.getReferenceNumber();
        }
        ej.setReferenceNumber(++referenceNumber);
        ej.setSeeAlso(new ArrayList<String>(exception.getSeeAlso()));
        this.exceptions.add(ej);
    }

    public void setLicenseListVersion(String licenseListVersion) {
        this.licenseListVersion = licenseListVersion;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public static class ExceptionJson {
        private String reference;
        private boolean isDeprecatedLicenseId;
        private String detailsUrl;
        private int referenceNumber;
        private String name;
        private String licenseExceptionId;
        private List<String> seeAlso;

        public String getLicenseExceptionId() {
            return this.licenseExceptionId;
        }

        public String getReference() {
            return this.reference;
        }

        public boolean isDeprecatedLicenseId() {
            return this.isDeprecatedLicenseId;
        }

        public String getDetailsUrl() {
            return this.detailsUrl;
        }

        public int getReferenceNumber() {
            return this.referenceNumber;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getSeeAlso() {
            return this.seeAlso;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public void setDeprecatedLicenseId(boolean isDeprecatedLicenseId) {
            this.isDeprecatedLicenseId = isDeprecatedLicenseId;
        }

        public void setDetailsUrl(String detailsUrl) {
            this.detailsUrl = detailsUrl;
        }

        public void setReferenceNumber(int referenceNumber) {
            this.referenceNumber = referenceNumber;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLicenseExceptionId(String licenseExceptionId) {
            this.licenseExceptionId = licenseExceptionId;
        }

        public void setSeeAlso(List<String> seeAlso) {
            this.seeAlso = seeAlso;
        }
    }
}

