/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.DuplicateSpdxIdException;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxIdNotFoundException;
import org.spdx.core.TypedValue;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.license.SpdxListedLicenseException;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.listedlicense.CrossRefJson;
import org.spdx.storage.listedlicense.ExceptionJson;
import org.spdx.storage.listedlicense.ExceptionJsonTOC;
import org.spdx.storage.listedlicense.IListedLicenseStore;
import org.spdx.storage.listedlicense.LicenseCreationInfo;
import org.spdx.storage.listedlicense.LicenseCreatorAgent;
import org.spdx.storage.listedlicense.LicenseJson;
import org.spdx.storage.listedlicense.LicenseJsonTOC;

public abstract class SpdxListedLicenseModelStore
implements IListedLicenseStore {
    static final Logger logger = LoggerFactory.getLogger((String)SpdxListedLicenseModelStore.class.getName());
    static final String DEFAULT_LICENSE_LIST_VERSION = "3.24";
    static final String LICENSE_TOC_FILENAME = "licenses.json";
    static final String EXCEPTION_TOC_FILENAME = "exceptions.json";
    static final String JSON_SUFFIX = ".json";
    private static final String ANONYMOUS_ID_PREFIX = "SpdxLicenseGeneratedId-";
    public static final String LISTED_LICENSE_NAMESPACE = "http://spdx.org/licenses/";
    Map<String, String> licenseIds = new HashMap<String, String>();
    Map<String, String> exceptionIds = new HashMap<String, String>();
    Map<String, LicenseJson> listedLicenseCache = null;
    Map<String, ExceptionJson> listedExceptionCache = null;
    Map<String, CrossRefJson> crossRefs = new HashMap<String, CrossRefJson>();
    String licenseListVersion = "3.24";
    String licenseListReleaseDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date());
    LicenseCreationInfo licenseCreationInfo;
    LicenseCreatorAgent licenseCreator;
    private int nextId = 0;
    private final ReadWriteLock listedLicenseModificationLock = new ReentrantReadWriteLock();
    private final IModelStore.IModelStoreLock readLock = () -> this.listedLicenseModificationLock.readLock().unlock();
    private final IModelStore.IModelStoreLock writeLock = () -> this.listedLicenseModificationLock.writeLock().unlock();
    Gson gson = new Gson();

    public static String objectUriToLicenseOrExceptionId(String objectUri) {
        return objectUri.substring(LISTED_LICENSE_NAMESPACE.length());
    }

    public static String licenseOrExceptionIdToObjectUri(String id) {
        return LISTED_LICENSE_NAMESPACE + id;
    }

    public SpdxListedLicenseModelStore() throws InvalidSPDXAnalysisException {
        this.loadIds();
        this.licenseCreator = new LicenseCreatorAgent(this.getLicenseListVersion());
        this.licenseCreationInfo = new LicenseCreationInfo(this.licenseCreator, this.getLicenseListReleaseDate());
    }

    public abstract InputStream getTocInputStream() throws IOException;

    public abstract InputStream getExceptionTocInputStream() throws IOException;

    public abstract InputStream getLicenseInputStream(String var1) throws IOException;

    public abstract InputStream getExceptionInputStream(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIds() throws InvalidSPDXAnalysisException {
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            this.listedLicenseCache = new HashMap<String, LicenseJson>();
            this.listedExceptionCache = new HashMap<String, ExceptionJson>();
            this.licenseIds = new HashMap<String, String>();
            BufferedReader reader = null;
            try {
                String line;
                InputStream tocStream = this.getTocInputStream();
                reader = new BufferedReader(new InputStreamReader(tocStream, StandardCharsets.UTF_8));
                StringBuilder tocJsonStr = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    tocJsonStr.append(line);
                }
                LicenseJsonTOC jsonToc = (LicenseJsonTOC)this.gson.fromJson(tocJsonStr.toString(), LicenseJsonTOC.class);
                this.licenseIds = jsonToc.getLicenseIds();
                this.licenseListVersion = jsonToc.getLicenseListVersion();
                this.licenseListReleaseDate = jsonToc.getReleaseDate();
                tocStream = this.getExceptionTocInputStream();
                reader = new BufferedReader(new InputStreamReader(tocStream, StandardCharsets.UTF_8));
                tocJsonStr = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    tocJsonStr.append(line);
                }
                ExceptionJsonTOC exceptionToc = (ExceptionJsonTOC)this.gson.fromJson(tocJsonStr.toString(), ExceptionJsonTOC.class);
                this.exceptionIds = exceptionToc.getExceptionIds();
            }
            catch (MalformedURLException e) {
                logger.error("License TOC URL invalid", (Throwable)e);
                throw new SpdxListedLicenseException("License TOC URL invalid", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("I/O error reading license TOC", (Throwable)e);
                throw new SpdxListedLicenseException("I/O error reading license TOC", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close JSON TOC reader", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String objectUri) {
        String id;
        Objects.requireNonNull(objectUri, "Object URI can not be null");
        if (objectUri.startsWith(LISTED_LICENSE_NAMESPACE)) {
            id = objectUri.substring(LISTED_LICENSE_NAMESPACE.length());
        } else if (this.getIdType(objectUri) == IModelStore.IdType.Anonymous || "__creation_info".equals(objectUri) || this.licenseCreator.getObjectUri().equals(objectUri)) {
            id = objectUri;
        } else {
            return false;
        }
        this.listedLicenseModificationLock.readLock().lock();
        try {
            boolean bl = this.licenseIds.containsKey(id.toLowerCase()) || this.exceptionIds.containsKey(id.toLowerCase()) || this.crossRefs.containsKey(id) || "__creation_info".equals(objectUri) || this.licenseCreator.getObjectUri().equals(objectUri);
            return bl;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    private String objectUriToId(String objectUri) throws InvalidSPDXAnalysisException {
        String id;
        Objects.requireNonNull(objectUri, "Object URI can not be null");
        if (objectUri.startsWith(LISTED_LICENSE_NAMESPACE)) {
            id = objectUri.substring(LISTED_LICENSE_NAMESPACE.length());
        } else if (objectUri.startsWith("https://spdx.org/licenses/")) {
            logger.warn("SPDX listed license URL was used instead of the required namespace ('https:' rather than 'http:'");
            id = objectUri.substring("https://spdx.org/licenses/".length());
        } else if (this.getIdType(objectUri) == IModelStore.IdType.Anonymous || this.licenseCreator.getObjectUri().equals(objectUri) || "__creation_info".equals(objectUri)) {
            id = objectUri;
        } else {
            logger.error("Namespace for SPDX listed licenses is expected to be http://spdx.org/licenses/.  Supplied URI was {}", (Object)objectUri);
            throw new SpdxIdNotFoundException("Namespace for SPDX listed licenses is expected to be http://spdx.org/licenses/.  Supplied URI was " + objectUri);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(TypedValue typedValue) throws InvalidSPDXAnalysisException {
        boolean isSpdx3 = typedValue.getSpecVersion().startsWith("3.");
        String id = this.objectUriToId(typedValue.getObjectUri());
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if ("CrossRef".equals(typedValue.getType())) {
                CrossRefJson crossRef = new CrossRefJson();
                crossRef.setId(id);
                this.crossRefs.put(id, crossRef);
            } else if (isSpdx3 && "ExpandedLicensing.ListedLicense".equals(typedValue.getType()) || !isSpdx3 && "ListedLicense".equals(typedValue.getType())) {
                if (this.licenseIds.containsKey(id.toLowerCase()) || this.exceptionIds.containsKey(id.toLowerCase())) {
                    logger.error("Duplicate SPDX ID on create: {}", (Object)id);
                    throw new DuplicateSpdxIdException("ID " + id + " already exists.");
                }
                this.licenseIds.put(id.toLowerCase(), id);
                this.listedLicenseCache.put(id, new LicenseJson(id));
            } else if (isSpdx3 && "ExpandedLicensing.ListedLicenseException".equals(typedValue.getType()) || !isSpdx3 && "ListedLicenseException".equals(typedValue.getType())) {
                if (this.licenseIds.containsKey(id.toLowerCase()) || this.exceptionIds.containsKey(id.toLowerCase())) {
                    logger.error("Duplicate SPDX ID on create: {}", (Object)id);
                    throw new DuplicateSpdxIdException("ID " + id + " already exists.");
                }
                this.exceptionIds.put(id.toLowerCase(), id);
                this.listedExceptionCache.put(id, new ExceptionJson(id));
            } else if (this.licenseCreationInfo.getTypedValue().equals((Object)typedValue)) {
                logger.warn("Ignoring the creation of a creationInfo for the listed license store");
            } else if (this.licenseCreator.getTypedValue().equals((Object)typedValue)) {
                logger.warn("Ignoring the creation of the creator for the listed license store");
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors(String objectUri) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            return LicenseCreationInfo.ALL_PROPERTY_DESCRIPTORS;
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            return LicenseCreatorAgent.ALL_PROPERTY_DESCRIPTORS;
        }
        String id = this.objectUriToId(objectUri);
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                LicenseJson license = this.fetchLicenseJson(this.licenseIds.get(id.toLowerCase()));
                List<PropertyDescriptor> list = license.getPropertyValueDescriptors();
                return list;
            }
            if (this.exceptionIds.containsKey(id.toLowerCase())) {
                ExceptionJson exc = this.fetchExceptionJson(this.exceptionIds.get(id.toLowerCase()));
                List<PropertyDescriptor> list = exc.getPropertyValueDescriptors();
                return list;
            }
            if (this.crossRefs.containsKey(id)) {
                List<PropertyDescriptor> list = this.crossRefs.get(id).getPropertyValueDescriptors();
                return list;
            }
            logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
            throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID. crossRef ID nor a listed exception ID");
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseJson fetchLicenseJson(String idCaseInsensitive) throws InvalidSPDXAnalysisException {
        String id;
        String idLowerCase = idCaseInsensitive.toLowerCase();
        this.listedLicenseModificationLock.readLock().lock();
        try {
            id = this.licenseIds.get(idLowerCase);
            if (Objects.isNull(id)) {
                logger.error("Attempting to get property values on non-existent ID {}", (Object)idCaseInsensitive);
                throw new SpdxIdNotFoundException("ID " + idCaseInsensitive + " not found.");
            }
            if (this.listedLicenseCache.containsKey(id)) {
                LicenseJson licenseJson = this.listedLicenseCache.get(id);
                return licenseJson;
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            id = this.licenseIds.get(idLowerCase);
            if (Objects.isNull(id)) {
                logger.error("Attempting to get property values on non-existent ID {}", (Object)idCaseInsensitive);
                throw new SpdxIdNotFoundException("ID " + idCaseInsensitive + " not found.");
            }
            if (!this.listedLicenseCache.containsKey(id)) {
                InputStream jsonStream = null;
                BufferedReader reader = null;
                try {
                    String line;
                    jsonStream = this.getLicenseInputStream(id);
                    reader = new BufferedReader(new InputStreamReader(jsonStream, StandardCharsets.UTF_8));
                    StringBuilder licenseJsonStr = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        licenseJsonStr.append(line);
                    }
                    LicenseJson license = (LicenseJson)this.gson.fromJson(licenseJsonStr.toString(), LicenseJson.class);
                    this.listedLicenseCache.put(id, license);
                }
                catch (MalformedURLException e) {
                    logger.error("Json license invalid for ID {}", (Object)id, (Object)e);
                    throw new SpdxListedLicenseException("JSON license URL invalid for ID " + id, (Throwable)e);
                }
                catch (IOException e) {
                    logger.error("I/O error opening Json license URL", (Throwable)e);
                    throw new SpdxListedLicenseException("I/O Error reading license data for ID " + id, (Throwable)e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close JSON TOC reader", (Throwable)e);
                        }
                    } else if (jsonStream != null) {
                        try {
                            jsonStream.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close JSON TOC input stream", (Throwable)e);
                        }
                    }
                }
            }
            LicenseJson licenseJson = this.listedLicenseCache.get(id);
            return licenseJson;
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExceptionJson fetchExceptionJson(String idCaseInsensitive) throws InvalidSPDXAnalysisException {
        String id;
        String idLower = idCaseInsensitive.toLowerCase();
        this.listedLicenseModificationLock.readLock().lock();
        try {
            id = this.exceptionIds.get(idLower);
            if (Objects.isNull(id)) {
                logger.error("Attempting to get property values on non-existent ID {}", (Object)idCaseInsensitive);
                throw new SpdxIdNotFoundException("ID " + idCaseInsensitive + " not found.");
            }
            if (this.listedExceptionCache.containsKey(id)) {
                ExceptionJson exceptionJson = this.listedExceptionCache.get(id);
                return exceptionJson;
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            id = this.exceptionIds.get(idLower);
            if (Objects.isNull(id)) {
                logger.error("Attempting to get property values on non-existent ID {}", (Object)idCaseInsensitive);
                throw new SpdxIdNotFoundException("ID " + idCaseInsensitive + " not found.");
            }
            if (!this.listedExceptionCache.containsKey(id)) {
                InputStream jsonStream = null;
                BufferedReader reader = null;
                try {
                    String line;
                    jsonStream = this.getExceptionInputStream(id);
                    reader = new BufferedReader(new InputStreamReader(jsonStream, StandardCharsets.UTF_8));
                    StringBuilder exceptionJsonStr = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        exceptionJsonStr.append(line);
                    }
                    ExceptionJson exc = (ExceptionJson)this.gson.fromJson(exceptionJsonStr.toString(), ExceptionJson.class);
                    this.listedExceptionCache.put(id, exc);
                }
                catch (MalformedURLException e) {
                    logger.error("Json license invalid for ID {}", (Object)id);
                    throw new SpdxListedLicenseException("JSON license URL invalid for ID " + id, (Throwable)e);
                }
                catch (IOException e) {
                    logger.error("I/O error opening Json license URL");
                    throw new SpdxListedLicenseException("I/O Error reading license data for ID " + id, (Throwable)e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close JSON TOC reader", (Throwable)e);
                        }
                    } else if (jsonStream != null) {
                        try {
                            jsonStream.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close JSON TOC input stream", (Throwable)e);
                        }
                    }
                }
            }
            ExceptionJson exceptionJson = this.listedExceptionCache.get(id);
            return exceptionJson;
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            logger.warn("Ignoring the setting of {} for license list creation info", (Object)propertyDescriptor.getName());
            return;
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            logger.warn("Ignoring the setting of {} for license list creator info", (Object)propertyDescriptor.getName());
            return;
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            license.setPrimitiveValue(propertyDescriptor, value);
        } else if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            exc.setPrimitiveValue(propertyDescriptor, value);
        } else if (Objects.nonNull(crossRef)) {
            crossRef.setPrimitiveValue(propertyDescriptor, value);
        } else {
            logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
            throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearValueCollection(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            logger.warn("Ignoring the clearing of collection for license list creation info");
            return;
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            logger.warn("Ignoring the clearing of collection for license list creator");
            return;
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            license.clearPropertyValueList(propertyDescriptor);
        } else if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            exc.clearPropertyValueList(propertyDescriptor);
        } else if (Objects.nonNull(crossRef)) {
            crossRef.clearPropertyValueList(propertyDescriptor);
        } else {
            logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
            throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addValueToCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            logger.warn("Ignoring the adding to collection for license list creation info");
            return false;
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            logger.warn("Ignoring the adding to collection for license list creator");
            return false;
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            if (SpdxConstantsCompatV2.PROP_CROSS_REF.equals((Object)propertyDescriptor)) {
                if (!(value instanceof TypedValue)) {
                    logger.error("Invalid class for CrossRef - expected TypedValue, was supplied type {}", value.getClass());
                    throw new InvalidSPDXAnalysisException("Invalid type for CrossRef - expected TypedValue, was supplied type " + value.getClass());
                }
                TypedValue tv = (TypedValue)value;
                if (!"CrossRef".equals(tv.getType())) {
                    logger.error("Invalid type for CrossRef - expectedCrossRef, was supplied type {}", value.getClass());
                    throw new InvalidSPDXAnalysisException("Invalid type for CrossRef - expectedCrossRef, was supplied type " + value.getClass());
                }
                CrossRefJson crj = this.crossRefs.get(tv.getObjectUri());
                if (Objects.isNull(crj)) {
                    logger.error("CrossRef with ID {} does not exist in the store.", (Object)tv.getObjectUri());
                    throw new InvalidSPDXAnalysisException("CrossRef with ID " + tv.getObjectUri() + " does not exist in the store.");
                }
                return license.addCrossRefValueToList(propertyDescriptor, crj);
            }
            return license.addPrimitiveValueToList(propertyDescriptor, value);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.addPrimitiveValueToList(propertyDescriptor, value);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.addPrimitiveValueToList(propertyDescriptor, value);
        }
        logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeValueFromCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            logger.warn("Ignoring the removing from collection for license list creation info");
            return false;
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            logger.warn("Ignoring the removing from collection for license list creator");
            return false;
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            if (SpdxConstantsCompatV2.PROP_CROSS_REF.equals((Object)propertyDescriptor)) {
                if (!(value instanceof TypedValue)) {
                    logger.error("Invalid class for CrossRef - expected TypedValue, was supplied type {}", value.getClass());
                    throw new InvalidSPDXAnalysisException("Invalid type for CrossRef - expected TypedValue, was supplied type " + value.getClass());
                }
                TypedValue tv = (TypedValue)value;
                if (!"CrossRef".equals(tv.getType())) {
                    logger.error("Invalid type for CrossRef - expectedCrossRef, was supplied type {}", value.getClass());
                    throw new InvalidSPDXAnalysisException("Invalid type for CrossRef - expectedCrossRef, was supplied type " + value.getClass());
                }
                CrossRefJson crj = this.crossRefs.get(tv.getObjectUri());
                if (Objects.isNull(crj)) {
                    logger.error("CrossRef with ID {} does not exist in the store.", (Object)tv.getObjectUri());
                    throw new InvalidSPDXAnalysisException("CrossRef with ID " + tv.getObjectUri() + " does not exist in the store.");
                }
                return license.removePrimitiveValueToList(propertyDescriptor, crj);
            }
            return license.removePrimitiveValueToList(propertyDescriptor, value);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.removePrimitiveValueToList(propertyDescriptor, value);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.removePrimitiveValueToList(propertyDescriptor, value);
        }
        logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Object> listValues(String objectUri, final PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            return this.licenseCreationInfo.getValueList(propertyDescriptor).iterator();
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            return this.licenseCreator.getValueList(propertyDescriptor).iterator();
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            List<?> valueList = license.getValueList(propertyDescriptor);
            if (SpdxConstantsCompatV2.PROP_CROSS_REF.equals((Object)propertyDescriptor)) {
                final Iterator<?> crossRefJsonIter = valueList.iterator();
                return new Iterator<Object>(){
                    final /* synthetic */ SpdxListedLicenseModelStore this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public boolean hasNext() {
                        return crossRefJsonIter.hasNext();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object next() {
                        String crossRefId;
                        block9: {
                            Object nextVal = crossRefJsonIter.next();
                            if (Objects.isNull(nextVal)) {
                                return null;
                            }
                            if (!(nextVal instanceof CrossRefJson)) {
                                throw new RuntimeException(new InvalidSPDXAnalysisException("Invalid type for " + propertyDescriptor + ".  Must be of type CrossRefJson"));
                            }
                            CrossRefJson nextCrossRef = (CrossRefJson)nextVal;
                            crossRefId = nextCrossRef.getId();
                            this.this$0.listedLicenseModificationLock.writeLock().lock();
                            try {
                                if (!Objects.isNull(crossRefId)) break block9;
                                try {
                                    crossRefId = this.this$0.getNextId(IModelStore.IdType.Anonymous);
                                }
                                catch (InvalidSPDXAnalysisException e) {
                                    logger.error("Error getting next Anonymous ID", (Throwable)e);
                                    throw new RuntimeException(e);
                                }
                                nextCrossRef.setId(crossRefId);
                                this.this$0.crossRefs.put(crossRefId, nextCrossRef);
                            }
                            finally {
                                this.this$0.listedLicenseModificationLock.writeLock().unlock();
                            }
                        }
                        try {
                            return new TypedValue(crossRefId, "CrossRef", "SPDX-2.3");
                        }
                        catch (InvalidSPDXAnalysisException e) {
                            logger.error("Error creating TypedValue for CrossRef", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            return valueList.iterator();
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.getValueList(propertyDescriptor).iterator();
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.getValueList(propertyDescriptor).iterator();
        }
        logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Object> getValue(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            return Optional.ofNullable(this.licenseCreationInfo.getValue(propertyDescriptor));
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            return Optional.ofNullable(this.licenseCreator.getValue(propertyDescriptor));
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (SpdxConstantsV3.PROP_CREATION_INFO.equals((Object)propertyDescriptor) && (isLicenseId || isExceptionId)) {
            return Optional.of(this.licenseCreationInfo.getTypedValue());
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            return Optional.ofNullable(license.getValue(propertyDescriptor));
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return Optional.ofNullable(exc.getValue(propertyDescriptor));
        }
        if (Objects.nonNull(crossRef)) {
            return Optional.ofNullable(crossRef.getValue(propertyDescriptor));
        }
        logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    public String getNextId(IModelStore.IdType idType) throws InvalidSPDXAnalysisException {
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (IModelStore.IdType.Anonymous.equals((Object)idType)) {
                String string = ANONYMOUS_ID_PREFIX + this.nextId++;
                return string;
            }
            String string = "http://spdx.org/licenses//listedLicenseId_" + this.nextId++;
            return string;
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    @Override
    public List<String> getSpdxListedLicenseIds() {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.licenseIds.values());
            return arrayList;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    @Override
    public String getLicenseListVersion() {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            String string = this.licenseListVersion;
            return string;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    public String getLicenseListReleaseDate() {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            String string = this.licenseListReleaseDate;
            return string;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    @Override
    public List<String> getSpdxListedExceptionIds() {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.exceptionIds.values());
            return arrayList;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSpdxListedLicenseId(String listedLicenseDocumentUri, String licenseId) {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            boolean bl = this.licenseIds.containsKey(licenseId.toLowerCase());
            return bl;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSpdxListedExceptionId(String listedLicenseDocumentUri, String exceptionId) {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            boolean bl = this.exceptionIds.containsKey(exceptionId.toLowerCase());
            return bl;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TypedValue> getTypedValue(String objectUri) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            return Optional.of(this.licenseCreationInfo.getTypedValue());
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            return Optional.of(this.licenseCreator.getTypedValue());
        }
        String id = this.objectUriToId(objectUri);
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                Optional<TypedValue> optional = Optional.of(new TypedValue(objectUri, "ExpandedLicensing.ListedLicense", "3.0.1"));
                return optional;
            }
            if (this.exceptionIds.containsKey(id.toLowerCase())) {
                Optional<TypedValue> optional = Optional.of(new TypedValue(objectUri, "ExpandedLicensing.ListedLicenseException", "3.0.1"));
                return optional;
            }
            if (this.crossRefs.containsKey(id)) {
                Optional<TypedValue> optional = Optional.of(new TypedValue(objectUri, "CrossRef", "SPDX-2.3"));
                return optional;
            }
            Optional<TypedValue> optional = Optional.empty();
            return optional;
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            logger.warn("Ignoring remove property {} for license list creation info", (Object)propertyDescriptor.getName());
            return;
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            logger.warn("Ignoring remove property {} for license list creator", (Object)propertyDescriptor.getName());
            return;
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            license.removeProperty(propertyDescriptor);
        } else if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            exc.removeProperty(propertyDescriptor);
        } else if (Objects.nonNull(crossRef)) {
            crossRef.removeProperty(propertyDescriptor);
        } else {
            logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
            throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<TypedValue> getAllItems(@Nullable String documentUri, @Nullable String typeFilter) throws InvalidSPDXAnalysisException {
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            ArrayList<TypedValue> allItems = new ArrayList<TypedValue>();
            if ("ListedLicense".equals(typeFilter)) {
                for (String licenseId : this.licenseIds.values()) {
                    allItems.add(new TypedValue(licenseId, "ListedLicense", "SPDX-2.3"));
                }
            }
            if (Objects.isNull(typeFilter) || "ExpandedLicensing.ListedLicense".equals(typeFilter)) {
                for (String licenseId : this.licenseIds.values()) {
                    allItems.add(new TypedValue(licenseId, "ExpandedLicensing.ListedLicense", "3.0.1"));
                }
            }
            if ("ListedLicenseException".equals(typeFilter)) {
                for (String exceptionId : this.exceptionIds.values()) {
                    allItems.add(new TypedValue(exceptionId, "ListedLicenseException", "SPDX-2.3"));
                }
            }
            if (Objects.isNull(typeFilter) || "ListedLicenseException".equals(typeFilter)) {
                for (String exceptionId : this.exceptionIds.values()) {
                    allItems.add(new TypedValue(exceptionId, "ExpandedLicensing.ListedLicenseException", "3.0.1"));
                }
            }
            if (Objects.isNull(typeFilter) || "CrossRef".equals(typeFilter)) {
                for (String crossRefId : this.crossRefs.keySet()) {
                    allItems.add(new TypedValue(crossRefId, "CrossRef", "SPDX-2.3"));
                }
            }
            if (Objects.isNull(typeFilter) || "Core.CreationInfo".equals(typeFilter)) {
                allItems.add(this.licenseCreationInfo.typedValue);
            }
            if (Objects.isNull(typeFilter) || "Core.Agent".equals(typeFilter)) {
                allItems.add(this.licenseCreator.getTypedValue());
            }
            Stream stream = Collections.unmodifiableList(allItems).stream();
            return stream;
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int collectionSize(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            return this.licenseCreationInfo.getValueList(propertyDescriptor).size();
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            return this.licenseCreator.getValueList(propertyDescriptor).size();
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            return license.getValueList(propertyDescriptor).size();
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.getValueList(propertyDescriptor).size();
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.getValueList(propertyDescriptor).size();
        }
        logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectionContains(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            return this.licenseCreationInfo.getValueList(propertyDescriptor).contains(value);
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            return this.licenseCreator.getValueList(propertyDescriptor).contains(value);
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            List<?> valueList = license.getValueList(propertyDescriptor);
            if (value instanceof TypedValue && "CrossRef".equals(((TypedValue)value).getType())) {
                CrossRefJson compareValue = this.crossRefs.get(((TypedValue)value).getObjectUri());
                if (Objects.isNull(compareValue)) {
                    return false;
                }
                return valueList.contains(compareValue);
            }
            return valueList.contains(value);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.getValueList(propertyDescriptor).contains(value);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.getValueList(propertyDescriptor).contains(value);
        }
        logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollectionMembersAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            return this.licenseCreationInfo.isCollectionMembersAssignableTo(propertyDescriptor, clazz);
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            return this.licenseCreator.isCollectionMembersAssignableTo(propertyDescriptor, clazz);
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            return LicenseJson.isCollectionMembersAssignableTo(propertyDescriptor, clazz);
        }
        if (isExceptionId) {
            return ExceptionJson.isCollectionMembersAssignableTo(propertyDescriptor, clazz);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.isCollectionMembersAssignableTo(propertyDescriptor, clazz);
        }
        logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPropertyValueAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz, String specVersion) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            return this.licenseCreationInfo.isPropertyValueAssignableTo(propertyDescriptor, clazz);
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            return this.licenseCreator.isPropertyValueAssignableTo(propertyDescriptor, clazz);
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            return license.isPropertyValueAssignableTo(propertyDescriptor, clazz);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.isPropertyValueAssignableTo(propertyDescriptor, clazz);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.isPropertyValueAssignableTo(propertyDescriptor, clazz);
        }
        logger.error("ID {} is not a listed license ID, CrossRef ID nor a listed exception ID", (Object)id);
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, CrossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollectionProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        if ("__creation_info".equals(objectUri)) {
            return this.licenseCreationInfo.isCollectionProperty(propertyDescriptor);
        }
        if (this.licenseCreator.getObjectUri().equals(objectUri)) {
            return this.licenseCreator.isCollectionProperty(propertyDescriptor);
        }
        String id = this.objectUriToId(objectUri);
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            return license.isCollectionProperty(propertyDescriptor);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.isCollectionProperty(propertyDescriptor);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.isCollectionProperty(propertyDescriptor.getName());
        }
        logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    public IModelStore.IdType getIdType(String objectUri) {
        Objects.requireNonNull(objectUri, "Object URI must not be null");
        if (objectUri.startsWith(LISTED_LICENSE_NAMESPACE)) {
            return IModelStore.IdType.ListedLicense;
        }
        if (objectUri.startsWith(ANONYMOUS_ID_PREFIX) || "__creation_info".equals(objectUri)) {
            return IModelStore.IdType.Anonymous;
        }
        if (objectUri.startsWith("https://spdx.org/licenses/creatoragent/")) {
            return IModelStore.IdType.SpdxId;
        }
        return IModelStore.IdType.Unknown;
    }

    public boolean isAnon(String objectUri) {
        return objectUri.startsWith(ANONYMOUS_ID_PREFIX);
    }

    public IModelStore.IModelStoreLock enterCriticalSection(boolean readLockRequested) {
        if (readLockRequested) {
            this.listedLicenseModificationLock.readLock().lock();
            return this.readLock;
        }
        this.listedLicenseModificationLock.writeLock().lock();
        return this.writeLock;
    }

    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        lock.unlock();
    }

    @Override
    public Optional<String> listedLicenseIdCaseSensitive(String licenseId) {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            Optional<String> optional = Optional.ofNullable(this.licenseIds.get(licenseId.toLowerCase()));
            return optional;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    @Override
    public Optional<String> listedExceptionIdCaseSensitive(String exceptionId) {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            Optional<String> optional = Optional.ofNullable(this.exceptionIds.get(exceptionId.toLowerCase()));
            return optional;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    public Optional<String> getCaseSensitiveId(String documentUri, String caseInsensitiveId) {
        Optional<String> retval = this.listedLicenseIdCaseSensitive(caseInsensitiveId);
        if (retval.isPresent()) {
            return retval;
        }
        return this.listedExceptionIdCaseSensitive(caseInsensitiveId);
    }

    public void delete(String objectUri) throws InvalidSPDXAnalysisException {
        block8: {
            if ("__creation_info".equals(objectUri)) {
                logger.warn("Ignoring the removal of the creation info for the license list");
                return;
            }
            if (this.licenseCreator.getObjectUri().equals(objectUri)) {
                logger.warn("Ignoring the removal of the creator for the license list");
                return;
            }
            String id = this.objectUriToId(objectUri);
            this.listedLicenseModificationLock.writeLock().lock();
            try {
                if (this.licenseIds.containsKey(id.toLowerCase())) {
                    this.listedLicenseCache.remove(id);
                    this.licenseIds.remove(id.toLowerCase());
                    break block8;
                }
                if (this.exceptionIds.containsKey(id.toLowerCase())) {
                    this.listedExceptionCache.remove(id);
                    this.exceptionIds.remove(id.toLowerCase());
                    break block8;
                }
                if (this.crossRefs.containsKey(id)) {
                    this.crossRefs.remove(id);
                    break block8;
                }
                logger.error("ID {} is not a listed license ID, crossRef ID nor a listed exception ID", (Object)id);
                throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
            }
            finally {
                this.listedLicenseModificationLock.writeLock().unlock();
            }
        }
    }

    @Override
    public CreationInfo getListedLicenseCreationInfo() throws InvalidSPDXAnalysisException {
        return (CreationInfo)SpdxModelFactory.inflateModelObject(this, "__creation_info", "Core.CreationInfo", null, "3.0.1", false, null);
    }

    public void close() throws Exception {
    }
}

