/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.simple;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.TypedValue;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;

public abstract class ExtendedSpdxStore
implements IModelStore {
    private final IModelStore baseStore;

    public ExtendedSpdxStore(IModelStore baseStore) {
        this.baseStore = baseStore;
    }

    public boolean exists(String objectUri) {
        return this.baseStore.exists(objectUri);
    }

    public void create(TypedValue typedValue) throws InvalidSPDXAnalysisException {
        this.baseStore.create(typedValue);
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors(String objectUri) throws InvalidSPDXAnalysisException {
        return this.baseStore.getPropertyValueDescriptors(objectUri);
    }

    public void setValue(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        this.baseStore.setValue(objectUri, propertyDescriptor, value);
    }

    public Optional<Object> getValue(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.baseStore.getValue(objectUri, propertyDescriptor);
    }

    public String getNextId(IModelStore.IdType idType) throws InvalidSPDXAnalysisException {
        return this.baseStore.getNextId(idType);
    }

    public void removeProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.baseStore.removeProperty(objectUri, propertyDescriptor);
    }

    public Stream<TypedValue> getAllItems(@Nullable String documentUri, @Nullable String typeFilter) throws InvalidSPDXAnalysisException {
        return this.baseStore.getAllItems(documentUri, typeFilter);
    }

    public IModelStore.IModelStoreLock enterCriticalSection(boolean readLockRequested) throws InvalidSPDXAnalysisException {
        return this.baseStore.enterCriticalSection(readLockRequested);
    }

    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        this.baseStore.leaveCriticalSection(lock);
    }

    public boolean removeValueFromCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.baseStore.removeValueFromCollection(objectUri, propertyDescriptor, value);
    }

    public int collectionSize(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.baseStore.collectionSize(objectUri, propertyDescriptor);
    }

    public boolean collectionContains(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.baseStore.collectionContains(objectUri, propertyDescriptor, value);
    }

    public void clearValueCollection(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.baseStore.clearValueCollection(objectUri, propertyDescriptor);
    }

    public boolean addValueToCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.baseStore.addValueToCollection(objectUri, propertyDescriptor, value);
    }

    public Iterator<Object> listValues(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.baseStore.listValues(objectUri, propertyDescriptor);
    }

    public boolean isCollectionMembersAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.baseStore.isCollectionMembersAssignableTo(objectUri, propertyDescriptor, clazz);
    }

    public boolean isPropertyValueAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz, String specVersion) throws InvalidSPDXAnalysisException {
        return this.baseStore.isPropertyValueAssignableTo(objectUri, propertyDescriptor, clazz, specVersion);
    }

    public boolean isCollectionProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.baseStore.isCollectionProperty(objectUri, propertyDescriptor);
    }

    public IModelStore.IdType getIdType(String id) {
        return this.baseStore.getIdType(id);
    }

    public boolean isAnon(String objectUri) {
        return this.baseStore.isAnon(objectUri);
    }

    public Optional<String> getCaseSensitiveId(String documentUri, String caseInsensitiveId) {
        return this.baseStore.getCaseSensitiveId(documentUri, caseInsensitiveId);
    }

    public Optional<TypedValue> getTypedValue(String objectUri) throws InvalidSPDXAnalysisException {
        return this.baseStore.getTypedValue(objectUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() throws InvalidSPDXAnalysisException {
        IModelStore.IModelStoreLock lock = this.enterCriticalSection(false);
        try {
            for (TypedValue item : this.getAllItems(null, null).collect(Collectors.toList())) {
                for (PropertyDescriptor propertyDescriptor : this.getPropertyValueDescriptors(item.getObjectUri())) {
                    this.removeProperty(item.getObjectUri(), propertyDescriptor);
                }
                this.delete(item.getObjectUri());
            }
        }
        finally {
            this.leaveCriticalSection(lock);
        }
    }

    public void delete(String objectUri) throws InvalidSPDXAnalysisException {
        this.baseStore.delete(objectUri);
    }

    public void close() throws Exception {
        this.baseStore.close();
    }
}

