/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.DuplicateSpdxIdException;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelCollection;
import org.spdx.core.SpdxIdInUseException;
import org.spdx.core.SpdxIdNotFoundException;
import org.spdx.core.TypedValue;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;
import org.spdx.storage.simple.StoredTypedItem;

public class InMemSpdxStore
implements IModelStore {
    static final Logger logger = LoggerFactory.getLogger((String)InMemSpdxStore.class.getName());
    static final String GENERATED = "gnrtd";
    public static Pattern LICENSE_ID_PATTERN_GENERATED = Pattern.compile(".*" + SpdxConstantsCompatV2.NON_STD_LICENSE_ID_PRENUM + "gnrtd" + "(\\d+)$");
    static Pattern DOCUMENT_ID_PATTERN_GENERATED = Pattern.compile(".*" + SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PRENUM + "gnrtd" + "(\\d+)$");
    static Pattern SPDX_ID_PATTERN_GENERATED = Pattern.compile(".*" + SpdxConstantsCompatV2.SPDX_ELEMENT_REF_PRENUM + "gnrtd" + "(\\d+)$");
    public static final String ANON_PREFIX = "__anon__";
    static Pattern ANON_ID_PATTERN_GENERATED = Pattern.compile("__anon__gnrtd(\\d+)$");
    protected Map<String, StoredTypedItem> typedValueMap = Collections.synchronizedMap(new LinkedHashMap());
    private int nextNextLicenseId = 0;
    private int nextNextDocumentId = 0;
    private int nextNextSpdxId = 0;
    private int nextAnonId = 0;
    private final ReadWriteLock transactionLock = new ReentrantReadWriteLock();
    private final ReadWriteLock referenceCountLock = new ReentrantReadWriteLock();
    private final IModelStore.IModelStoreLock readLock = () -> this.transactionLock.readLock().unlock();
    private final IModelStore.IModelStoreLock writeLock = () -> this.transactionLock.writeLock().unlock();

    public boolean exists(String objectUri) {
        return this.typedValueMap.containsKey(objectUri.toLowerCase());
    }

    public void create(TypedValue typedValue) throws InvalidSPDXAnalysisException {
        StoredTypedItem value = new StoredTypedItem(typedValue.getObjectUri(), typedValue.getType(), typedValue.getSpecVersion());
        this.updateNextIds(typedValue.getObjectUri());
        if (Objects.nonNull((Object)this.typedValueMap.putIfAbsent(typedValue.getObjectUri().toLowerCase(), value))) {
            throw new DuplicateSpdxIdException("Object URI " + typedValue.getObjectUri() + " already exists.");
        }
    }

    void updateNextIds(String objectUri) {
        if (objectUri == null) {
            return;
        }
        Matcher licenseRefMatcher = LICENSE_ID_PATTERN_GENERATED.matcher(objectUri);
        if (licenseRefMatcher.matches()) {
            this.checkUpdateNextLicenseId(licenseRefMatcher);
            return;
        }
        Matcher documentRefMatcher = DOCUMENT_ID_PATTERN_GENERATED.matcher(objectUri);
        if (documentRefMatcher.matches()) {
            this.checkUpdateNextDocumentId(documentRefMatcher);
            return;
        }
        Matcher spdxRefMatcher = SPDX_ID_PATTERN_GENERATED.matcher(objectUri);
        if (spdxRefMatcher.matches()) {
            this.checkUpdateNextSpdxId(spdxRefMatcher);
            return;
        }
        Matcher anonRefMatcher = ANON_ID_PATTERN_GENERATED.matcher(objectUri);
        if (anonRefMatcher.matches()) {
            this.checkUpdateNextAnonId(anonRefMatcher);
            return;
        }
    }

    private synchronized void checkUpdateNextAnonId(Matcher anonRefMatcher) {
        String strNum = anonRefMatcher.group(1);
        int num = Integer.parseInt(strNum);
        if (num >= this.nextAnonId) {
            this.nextAnonId = num + 1;
        }
    }

    private synchronized void checkUpdateNextSpdxId(Matcher spdxRefMatcher) {
        String strNum = spdxRefMatcher.group(1);
        int num = Integer.parseInt(strNum);
        if (num >= this.nextNextSpdxId) {
            this.nextNextSpdxId = num + 1;
        }
    }

    private synchronized void checkUpdateNextDocumentId(Matcher documentRefMatcher) {
        String strNum = documentRefMatcher.group(1);
        int num = Integer.parseInt(strNum);
        if (num >= this.nextNextDocumentId) {
            this.nextNextDocumentId = num + 1;
        }
    }

    private synchronized void checkUpdateNextLicenseId(Matcher licenseRefMatcher) {
        String strNum = licenseRefMatcher.group(1);
        int num = Integer.parseInt(strNum);
        if (num >= this.nextNextLicenseId) {
            this.nextNextLicenseId = num + 1;
        }
    }

    protected StoredTypedItem getItem(String objectUri) throws InvalidSPDXAnalysisException {
        StoredTypedItem item = this.typedValueMap.get(objectUri.toLowerCase());
        if (item == null) {
            throw new SpdxIdNotFoundException("Object URI " + objectUri + " was not found in the memory store.  The ID must first be created before getting or setting property values.");
        }
        return item;
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors(String objectUri) throws InvalidSPDXAnalysisException {
        return this.getItem(objectUri).getPropertyValueDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if (value instanceof TypedValue) {
            this.referenceCountLock.writeLock().lock();
            try {
                StoredTypedItem itemToBeStored = this.getItem(((TypedValue)value).getObjectUri());
                this.getItem(objectUri).setValue(propertyDescriptor, value);
                itemToBeStored.incReferenceCount();
            }
            finally {
                this.referenceCountLock.writeLock().unlock();
            }
        } else {
            this.getItem(objectUri).setValue(propertyDescriptor, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearValueCollection(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.referenceCountLock.writeLock().lock();
        try {
            ArrayList<StoredTypedItem> removedItems = new ArrayList<StoredTypedItem>();
            Iterator<Object> iter = this.getItem(objectUri).getValueList(propertyDescriptor);
            while (iter.hasNext()) {
                Object nextItem = iter.next();
                if (!(nextItem instanceof TypedValue)) continue;
                removedItems.add(this.getItem(((TypedValue)nextItem).getObjectUri()));
            }
            this.getItem(objectUri).clearPropertyValueList(propertyDescriptor);
            for (StoredTypedItem item : removedItems) {
                item.decReferenceCount();
            }
        }
        finally {
            this.referenceCountLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addValueToCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if (value instanceof TypedValue) {
            this.referenceCountLock.writeLock().lock();
            try {
                StoredTypedItem itemToBeStored = this.getItem(((TypedValue)value).getObjectUri());
                boolean result = this.getItem(objectUri).addValueToList(propertyDescriptor, value);
                itemToBeStored.incReferenceCount();
                boolean bl = result;
                return bl;
            }
            finally {
                this.referenceCountLock.writeLock().unlock();
            }
        }
        return this.getItem(objectUri).addValueToList(propertyDescriptor, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeValueFromCollection(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        if (value instanceof TypedValue) {
            this.referenceCountLock.writeLock().lock();
            try {
                StoredTypedItem itemToBeStored = this.getItem(((TypedValue)value).getObjectUri());
                boolean result = this.getItem(objectUri).removeValueFromList(propertyDescriptor, value);
                itemToBeStored.decReferenceCount();
                boolean bl = result;
                return bl;
            }
            finally {
                this.referenceCountLock.writeLock().unlock();
            }
        }
        return this.getItem(objectUri).removeValueFromList(propertyDescriptor, value);
    }

    public Iterator<Object> listValues(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.getItem(objectUri).getValueList(propertyDescriptor);
    }

    public Optional<Object> getValue(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        StoredTypedItem item = this.getItem(objectUri);
        if (item.isCollectionProperty(propertyDescriptor)) {
            logger.warn("Returning a collection for a getValue call for property {}", (Object)propertyDescriptor.getName());
            return Optional.of(new ModelCollection((IModelStore)this, objectUri, propertyDescriptor, null, null, item.getSpecVersion(), null));
        }
        return Optional.ofNullable(item.getValue(propertyDescriptor));
    }

    public synchronized String getNextId(IModelStore.IdType idType) throws InvalidSPDXAnalysisException {
        switch (idType) {
            case Anonymous: {
                return "__anon__gnrtd" + this.nextAnonId++;
            }
            case LicenseRef: {
                return SpdxConstantsCompatV2.NON_STD_LICENSE_ID_PRENUM + GENERATED + this.nextNextLicenseId++;
            }
            case DocumentRef: {
                return SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PRENUM + GENERATED + this.nextNextDocumentId++;
            }
            case SpdxId: {
                return SpdxConstantsCompatV2.SPDX_ELEMENT_REF_PRENUM + GENERATED + this.nextNextSpdxId++;
            }
            case ListedLicense: {
                throw new InvalidSPDXAnalysisException("Can not generate a license ID for a Listed License");
            }
        }
        throw new InvalidSPDXAnalysisException("Unknown ID type for next ID: " + idType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        this.referenceCountLock.writeLock().lock();
        try {
            Object itemToBeRemoved = this.getItem(objectUri).getValue(propertyDescriptor);
            this.getItem(objectUri).removeProperty(propertyDescriptor);
            if (itemToBeRemoved instanceof TypedValue) {
                this.getItem(((TypedValue)itemToBeRemoved).getObjectUri()).decReferenceCount();
            }
        }
        finally {
            this.referenceCountLock.writeLock().unlock();
        }
    }

    public Stream<TypedValue> getAllItems(@Nullable String nameSpace, @Nullable String typeFilter) {
        Iterator<StoredTypedItem> valueIter = this.typedValueMap.values().iterator();
        ArrayList<StoredTypedItem> allItems = new ArrayList<StoredTypedItem>();
        while (valueIter.hasNext()) {
            StoredTypedItem item = valueIter.next();
            if (!Objects.isNull(typeFilter) && !typeFilter.equals(item.getType()) || !Objects.isNull(nameSpace) && !item.getObjectUri().startsWith(nameSpace)) continue;
            allItems.add(item);
        }
        return Collections.unmodifiableList(allItems).stream();
    }

    public int collectionSize(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.getItem(objectUri).collectionSize(propertyDescriptor);
    }

    public boolean collectionContains(String objectUri, PropertyDescriptor propertyDescriptor, Object value) throws InvalidSPDXAnalysisException {
        return this.getItem(objectUri).collectionContains(propertyDescriptor, value);
    }

    public boolean isCollectionMembersAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz) throws InvalidSPDXAnalysisException {
        return this.getItem(objectUri).isCollectionMembersAssignableTo(propertyDescriptor, clazz);
    }

    public boolean isPropertyValueAssignableTo(String objectUri, PropertyDescriptor propertyDescriptor, Class<?> clazz, String specVersion) throws InvalidSPDXAnalysisException {
        return this.getItem(objectUri).isPropertyValueAssignableTo(propertyDescriptor, clazz, specVersion);
    }

    public boolean isCollectionProperty(String objectUri, PropertyDescriptor propertyDescriptor) throws InvalidSPDXAnalysisException {
        return this.getItem(objectUri).isCollectionProperty(propertyDescriptor);
    }

    public boolean isAnon(String objectUri) {
        return objectUri.startsWith("__anon__gnrtd");
    }

    public IModelStore.IdType getIdType(String objectUri) {
        if (this.isAnon(objectUri)) {
            return IModelStore.IdType.Anonymous;
        }
        if (objectUri.contains(SpdxConstantsCompatV2.NON_STD_LICENSE_ID_PRENUM)) {
            return IModelStore.IdType.LicenseRef;
        }
        if (objectUri.contains(SpdxConstantsCompatV2.EXTERNAL_DOC_REF_PRENUM)) {
            return IModelStore.IdType.DocumentRef;
        }
        if (objectUri.contains(SpdxConstantsCompatV2.SPDX_ELEMENT_REF_PRENUM)) {
            return IModelStore.IdType.SpdxId;
        }
        if (objectUri.contains("://spdx.org/licenses/") || LicenseInfoFactory.isSpdxListedLicenseId(objectUri) || LicenseInfoFactory.isSpdxListedExceptionId(objectUri)) {
            return IModelStore.IdType.ListedLicense;
        }
        return IModelStore.IdType.Unknown;
    }

    public IModelStore.IModelStoreLock enterCriticalSection(boolean readLockRequested) {
        if (readLockRequested) {
            this.transactionLock.readLock().lock();
            return this.readLock;
        }
        this.transactionLock.writeLock().lock();
        return this.writeLock;
    }

    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        lock.unlock();
    }

    public Optional<String> getCaseSensitiveId(String nameSpace, String caseInsensitiveId) {
        Objects.requireNonNull(nameSpace, "Namespace can not be null");
        Objects.requireNonNull(caseInsensitiveId, "CaseInsensitiveId can not be null");
        String objectUri = nameSpace + "#" + caseInsensitiveId;
        StoredTypedItem item = this.typedValueMap.get(objectUri.toLowerCase());
        if (Objects.isNull((Object)item)) {
            return Optional.empty();
        }
        return Optional.of(item.getObjectUri().substring(nameSpace.length() + 1));
    }

    public Optional<TypedValue> getTypedValue(String objectUri) throws InvalidSPDXAnalysisException {
        try {
            return Optional.of(this.getItem(objectUri));
        }
        catch (SpdxIdNotFoundException ex) {
            return Optional.empty();
        }
    }

    public void clear() {
        this.typedValueMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String objectUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(objectUri, "Missing object URI");
        if (!this.typedValueMap.containsKey(objectUri.toLowerCase())) {
            return;
        }
        this.referenceCountLock.writeLock().lock();
        try {
            if (this.getItem(objectUri).getReferenceCount() > 0) {
                logger.error("Can not object URI {}.  It is in use", (Object)objectUri);
                throw new SpdxIdInUseException("Can not object URI " + objectUri + ".  It is in use");
            }
            List<PropertyDescriptor> propertyDescriptors = this.getPropertyValueDescriptors(objectUri);
            for (PropertyDescriptor property : propertyDescriptors) {
                if (this.isCollectionProperty(objectUri, property)) {
                    Iterator<Object> iter = this.listValues(objectUri, property);
                    while (iter.hasNext()) {
                        Object val = iter.next();
                        if (!(val instanceof TypedValue)) continue;
                        this.getItem(((TypedValue)val).getObjectUri()).decReferenceCount();
                    }
                    continue;
                }
                Optional<Object> val = this.getValue(objectUri, property);
                if (!val.isPresent() || !(val.get() instanceof TypedValue)) continue;
                this.getItem(((TypedValue)val.get()).getObjectUri()).decReferenceCount();
            }
            if (Objects.isNull((Object)this.typedValueMap.remove(objectUri.toLowerCase()))) {
                logger.error("Error deleting - object URI {} does not exist.", (Object)objectUri);
                throw new SpdxIdNotFoundException("Error deleting - object URI " + objectUri + " does not exist.");
            }
        }
        finally {
            this.referenceCountLock.writeLock().unlock();
        }
    }

    public void close() throws Exception {
    }
}

