/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelRegistry;
import org.spdx.core.ModelRegistryException;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.core.TypedValue;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;

public class StoredTypedItem
extends TypedValue {
    static final Logger logger = LoggerFactory.getLogger(StoredTypedItem.class);
    private static final String NO_ID_ID = "__NO_ID__";
    private final ConcurrentHashMap<PropertyDescriptor, Object> properties = new ConcurrentHashMap();
    private int referenceCount = 0;
    private final ReadWriteLock countLock = new ReentrantReadWriteLock();

    public StoredTypedItem(String objectUri, String type, String specVersion) throws InvalidSPDXAnalysisException {
        super(objectUri, type, specVersion);
    }

    public List<PropertyDescriptor> getPropertyValueDescriptors() {
        Iterator<Map.Entry<PropertyDescriptor, Object>> iter = this.properties.entrySet().iterator();
        ArrayList<PropertyDescriptor> retval = new ArrayList<PropertyDescriptor>();
        while (iter.hasNext()) {
            Map.Entry<PropertyDescriptor, Object> entry = iter.next();
            retval.add(entry.getKey());
        }
        return Collections.unmodifiableList(retval);
    }

    public int incReferenceCount() {
        this.countLock.writeLock().lock();
        try {
            ++this.referenceCount;
            int n = this.referenceCount;
            return n;
        }
        finally {
            this.countLock.writeLock().unlock();
        }
    }

    public int decReferenceCount() throws SpdxInvalidTypeException {
        this.countLock.writeLock().lock();
        try {
            if (this.referenceCount < 1) {
                throw new SpdxInvalidTypeException("Usage count underflow - usage count decremented more than incremented");
            }
            --this.referenceCount;
            int n = this.referenceCount;
            return n;
        }
        finally {
            this.countLock.writeLock().unlock();
        }
    }

    public int getReferenceCount() {
        this.countLock.readLock().lock();
        try {
            int n = this.referenceCount;
            return n;
        }
        finally {
            this.countLock.readLock().unlock();
        }
    }

    public void setValue(PropertyDescriptor propertyDescriptor, Object value) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyDescriptor, "Property descriptor can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        if (value instanceof CoreModelObject) {
            throw new SpdxInvalidTypeException("Can not store Model Object in store.  Convert to TypedValue first");
        }
        if (value instanceof Collection) {
            throw new SpdxInvalidTypeException("Can not store list values directly.  Use addValueToCollection.");
        }
        if (!(value.getClass().isPrimitive() || String.class.isAssignableFrom(value.getClass()) || Boolean.class.isAssignableFrom(value.getClass()) || Integer.class.isAssignableFrom(value.getClass()) || Double.class.isAssignableFrom(value.getClass()) || Float.class.isAssignableFrom(value.getClass()) || TypedValue.class.isAssignableFrom(value.getClass()) || value instanceof IndividualUriValue)) {
            throw new SpdxInvalidTypeException(value.getClass() + " is not a supported class to be stored.");
        }
        this.properties.put(propertyDescriptor, value);
    }

    public void clearPropertyValueList(PropertyDescriptor propertyDescriptor) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyDescriptor, "property descriptor can not be null");
        Object value = this.properties.get(propertyDescriptor);
        if (value == null) {
            return;
        }
        if (!(value instanceof ConcurrentHashMap)) {
            throw new SpdxInvalidTypeException("Trying to clear a list for non list type for property " + propertyDescriptor);
        }
        ((ConcurrentHashMap)value).clear();
    }

    public boolean addValueToList(PropertyDescriptor propertyDescriptor, Object value) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyDescriptor, "Property descriptor can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        if (value instanceof CoreModelObject) {
            throw new SpdxInvalidTypeException("Can not store Model Object in store.  Convert to TypedValue first");
        }
        if (!(value.getClass().isPrimitive() || String.class.isAssignableFrom(value.getClass()) || Boolean.class.isAssignableFrom(value.getClass()) || Integer.class.isAssignableFrom(value.getClass()) || TypedValue.class.isAssignableFrom(value.getClass()) || value instanceof IndividualUriValue)) {
            throw new SpdxInvalidTypeException(value.getClass() + " is not a supported class to be stored.");
        }
        Object map = this.properties.get(propertyDescriptor);
        if (map == null) {
            this.properties.putIfAbsent(propertyDescriptor, new ConcurrentHashMap());
            map = this.properties.get(propertyDescriptor);
            if (map == null) {
                return true;
            }
        }
        if (!(map instanceof ConcurrentHashMap)) {
            throw new SpdxInvalidTypeException("Trying to add a list for non list type for property " + propertyDescriptor);
        }
        try {
            ConcurrentHashMap idValueMap = (ConcurrentHashMap)map;
            String id = value instanceof TypedValue ? ((TypedValue)value).getObjectUri() : NO_ID_ID;
            idValueMap.putIfAbsent(id, new ArrayList());
            ArrayList<Object> list = (ArrayList<Object>)idValueMap.get(id);
            if (list == null) {
                list = new ArrayList<Object>();
                idValueMap.putIfAbsent(id, list);
            }
            return list.add(value);
        }
        catch (Exception ex) {
            throw new SpdxInvalidTypeException("Invalid list type for " + propertyDescriptor);
        }
    }

    public boolean removeTypedValueFromList(PropertyDescriptor propertyDescriptor, TypedValue value) throws SpdxInvalidTypeException {
        Object map = this.properties.get(propertyDescriptor);
        if (map == null) {
            return false;
        }
        if (!(map instanceof ConcurrentHashMap)) {
            throw new SpdxInvalidTypeException("Trying to remove from a list for non typed value list type for property " + propertyDescriptor);
        }
        try {
            ConcurrentHashMap typedValueMap = (ConcurrentHashMap)map;
            List list = (List)typedValueMap.get(value.getObjectUri());
            if (list == null) {
                return false;
            }
            return list.remove(value);
        }
        catch (Exception ex) {
            throw new SpdxInvalidTypeException("Invalid list type for " + propertyDescriptor);
        }
    }

    public boolean removeValueFromList(PropertyDescriptor propertyDescriptor, Object value) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyDescriptor, "property descriptor can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        Object map = this.properties.get(propertyDescriptor);
        if (map == null) {
            return false;
        }
        if (!(map instanceof ConcurrentHashMap)) {
            throw new SpdxInvalidTypeException("Trying to remove from a list for non list type for property " + propertyDescriptor);
        }
        try {
            ConcurrentHashMap idValueMap = (ConcurrentHashMap)map;
            String id = value instanceof TypedValue ? ((TypedValue)value).getObjectUri() : NO_ID_ID;
            List list = (List)idValueMap.get(id);
            if (list == null) {
                return false;
            }
            return list.remove(value);
        }
        catch (Exception ex) {
            throw new SpdxInvalidTypeException("Invalid list type for " + propertyDescriptor);
        }
    }

    public Iterator<Object> getValueList(PropertyDescriptor propertyDescriptor) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyDescriptor, "property descriptor can not be null");
        Object list = this.properties.get(propertyDescriptor);
        if (list == null) {
            return Collections.emptyIterator();
        }
        if (list instanceof ConcurrentHashMap) {
            ArrayList valueList = new ArrayList();
            for (Object value : ((ConcurrentHashMap)list).values()) {
                if (value instanceof Collection) {
                    valueList.addAll((Collection)value);
                    continue;
                }
                valueList.add(value);
            }
            return valueList.iterator();
        }
        throw new SpdxInvalidTypeException("Trying to get a list for non list type for property " + propertyDescriptor);
    }

    public Object getValue(PropertyDescriptor propertyDescriptor) {
        Objects.requireNonNull(propertyDescriptor, "property descriptor can not be null");
        return this.properties.get(propertyDescriptor);
    }

    public void removeProperty(PropertyDescriptor propertyDescriptor) {
        Objects.requireNonNull(propertyDescriptor, "property descriptor can not be null");
        this.properties.remove(propertyDescriptor);
    }

    public void copyValuesFrom(IModelStore store) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(store, "Store can not be null");
        List propertyDescriptors = store.getPropertyValueDescriptors(this.getObjectUri());
        for (PropertyDescriptor propertydescriptor : propertyDescriptors) {
            Optional value = store.getValue(this.getObjectUri(), propertydescriptor);
            if (!value.isPresent()) continue;
            this.setValue(propertydescriptor, value.get());
        }
    }

    public int collectionSize(PropertyDescriptor propertyDescriptor) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyDescriptor, "property descriptor can not be null");
        Object map = this.properties.get(propertyDescriptor);
        if (map == null) {
            this.properties.putIfAbsent(propertyDescriptor, new ConcurrentHashMap());
            map = this.properties.get(propertyDescriptor);
            if (map == null) {
                return 0;
            }
        }
        if (map instanceof ConcurrentHashMap) {
            int count = 0;
            for (Object value : ((ConcurrentHashMap)map).values()) {
                if (value instanceof Collection) {
                    count += ((Collection)value).size();
                    continue;
                }
                ++count;
            }
            return count;
        }
        throw new SpdxInvalidTypeException("Trying to get size for a non list type for property " + propertyDescriptor);
    }

    public boolean collectionContains(PropertyDescriptor propertyDescriptor, Object value) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyDescriptor, "property descriptor can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        Object map = this.properties.get(propertyDescriptor);
        if (map == null) {
            this.properties.putIfAbsent(propertyDescriptor, new ConcurrentHashMap());
            map = this.properties.get(propertyDescriptor);
            if (map == null) {
                return false;
            }
        }
        if (map instanceof ConcurrentHashMap) {
            ConcurrentHashMap typedValueMap = (ConcurrentHashMap)map;
            String id = value instanceof TypedValue ? ((TypedValue)value).getObjectUri() : NO_ID_ID;
            List valueList = (List)typedValueMap.get(id);
            if (valueList == null) {
                return false;
            }
            return valueList.contains(value);
        }
        throw new SpdxInvalidTypeException("Trying to find contains for non list type for property " + propertyDescriptor);
    }

    public boolean isCollectionMembersAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz) throws ModelRegistryException {
        Objects.requireNonNull(propertyDescriptor, "Property descriptor can not be null");
        Objects.requireNonNull(clazz, "Class can not be null");
        Object map = this.properties.get(propertyDescriptor);
        if (map == null) {
            return true;
        }
        if (!(map instanceof ConcurrentHashMap)) {
            logger.warn("Checking collection properties on a non-collection stored item");
            return false;
        }
        ConcurrentHashMap idValueMap = (ConcurrentHashMap)map;
        for (List valueList : idValueMap.values()) {
            for (Object value : valueList) {
                if (this.isAssignableTo(value, clazz, this.getSpecVersion())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAssignableTo(Object value, Class<?> clazz, String specVersion) throws ModelRegistryException {
        if (clazz.isAssignableFrom(value.getClass())) {
            return true;
        }
        if (value instanceof TypedValue) {
            TypedValue typedValue = (TypedValue)value;
            try {
                Class type = ModelRegistry.getModelRegistry().typeToClass(typedValue.getType(), typedValue.getSpecVersion());
                return Objects.nonNull(type) && clazz.isAssignableFrom(type);
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Error converting typed value to class", (Throwable)e);
                return false;
            }
        }
        if (value instanceof IndividualUriValue) {
            String uri = ((IndividualUriValue)value).getIndividualURI();
            Enum spdxEnum = ModelRegistry.getModelRegistry().uriToEnum(uri, this.getSpecVersion());
            if (Objects.nonNull(spdxEnum)) {
                return clazz.isAssignableFrom(spdxEnum.getClass());
            }
            Object individual = ModelRegistry.getModelRegistry().uriToIndividual(uri, this.getSpecVersion(), clazz);
            if (Objects.nonNull(individual)) {
                return clazz.isAssignableFrom(individual.getClass());
            }
            return ModelRegistry.getModelRegistry().canBeExternal(clazz, specVersion);
        }
        return false;
    }

    public boolean isPropertyValueAssignableTo(PropertyDescriptor propertyDescriptor, Class<?> clazz, String specVersion) throws ModelRegistryException {
        Objects.requireNonNull(propertyDescriptor, "Property descriptor can not be null");
        Objects.requireNonNull(clazz, "Class can not be null");
        Object value = this.properties.get(propertyDescriptor);
        if (value == null) {
            return false;
        }
        return this.isAssignableTo(value, clazz, specVersion);
    }

    public boolean isCollectionProperty(PropertyDescriptor propertyDescriptor) {
        Objects.requireNonNull(propertyDescriptor, "Property descriptor can not be null");
        Object value = this.properties.get(propertyDescriptor);
        return value instanceof ConcurrentHashMap;
    }

    public boolean usesId(String elementId) {
        if (Objects.isNull(elementId)) {
            return false;
        }
        for (Object value : this.properties.values()) {
            if (value instanceof List && !((List)value).isEmpty() && ((List)value).get(0) instanceof TypedValue) {
                for (Object listValue : (List)value) {
                    if (!(listValue instanceof TypedValue) || !((TypedValue)listValue).getObjectUri().equalsIgnoreCase(elementId)) continue;
                    return true;
                }
                continue;
            }
            if (!(value instanceof TypedValue) || !((TypedValue)value).getObjectUri().equalsIgnoreCase(elementId)) continue;
            return true;
        }
        return false;
    }
}

