/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.Objects;
import java.util.Optional;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.ExternalRef;
import org.spdx.library.model.v2.ReferenceType;
import org.spdx.library.model.v2.enumerations.ReferenceCategory;
import org.spdx.utility.compare.SpdxComparer;

public class SpdxExternalRefDifference {
    String commentA;
    String commentB;
    ReferenceCategory catA;
    ReferenceCategory catB;
    private final String referenceLocator;
    private final ReferenceType referenceType;

    SpdxExternalRefDifference(ExternalRef externalRefA, ExternalRef externalRefB) throws InvalidSPDXAnalysisException {
        Optional oCommentA = externalRefA.getComment();
        this.commentA = oCommentA.orElse("");
        Optional oCommentB = externalRefB.getComment();
        this.commentB = oCommentB.orElse("");
        this.catA = externalRefA.getReferenceCategory();
        this.catB = externalRefB.getReferenceCategory();
        this.referenceLocator = externalRefA.getReferenceLocator();
        this.referenceType = externalRefA.getReferenceType();
    }

    public boolean isCommentsEqual() {
        return SpdxComparer.stringsEqual(this.commentA, this.commentB);
    }

    public boolean isReferenceCategoriesEqual() {
        return Objects.equals(this.catA, this.catB);
    }

    public String getCommentA() {
        return this.commentA;
    }

    public String getCommentB() {
        return this.commentB;
    }

    public ReferenceCategory getCatA() {
        return this.catA;
    }

    public ReferenceCategory getCatB() {
        return this.catB;
    }

    public String getReferenceLocator() {
        return this.referenceLocator;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }
}

