/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.Annotation;
import org.spdx.library.model.v2.Checksum;
import org.spdx.library.model.v2.Relationship;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxFile;
import org.spdx.library.model.v2.SpdxItem;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;
import org.spdx.utility.compare.SpdxFileDifference;
import org.spdx.utility.compare.SpdxItemComparer;

public class SpdxFileComparer
extends SpdxItemComparer {
    private boolean inProgress = false;
    private boolean differenceFound = false;
    private boolean contributorsEquals = true;
    private boolean noticeTextEquals = true;
    private final Map<SpdxDocument, Map<SpdxDocument, List<Checksum>>> uniqueChecksums = new HashMap<SpdxDocument, Map<SpdxDocument, List<Checksum>>>();
    private boolean checksumsEquals = true;
    private boolean typesEquals = true;

    public SpdxFileComparer(Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) {
        super(extractedLicenseIdMap);
    }

    public void addDocumentFile(SpdxDocument spdxDocument, SpdxFile spdxFile) throws SpdxCompareException, InvalidSPDXAnalysisException {
        this.checkInProgress();
        this.inProgress = true;
        Iterator iter = this.documentItem.entrySet().iterator();
        SpdxFile filesB = null;
        while (iter.hasNext() && filesB == null) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof SpdxFile)) continue;
            filesB = (SpdxFile)entry.getValue();
        }
        if (filesB != null) {
            this.compareNewFileChecksums(spdxDocument, spdxFile.getChecksums());
            if (!SpdxComparer.collectionsEquals(spdxFile.getFileTypes(), filesB.getFileTypes())) {
                this.typesEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringCollectionsEqual(spdxFile.getFileContributors(), filesB.getFileContributors())) {
                this.contributorsEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxFile.getNoticeText(), filesB.getNoticeText())) {
                this.noticeTextEquals = false;
                this.differenceFound = true;
            }
        }
        super.addDocumentItem(spdxDocument, (SpdxItem)spdxFile);
        this.inProgress = false;
    }

    private void compareNewFileChecksums(SpdxDocument spdxDocument, Collection<Checksum> checksums) throws InvalidSPDXAnalysisException {
        HashMap<SpdxDocument, List<Checksum>> docUniqueChecksums = new HashMap<SpdxDocument, List<Checksum>>();
        this.uniqueChecksums.put(spdxDocument, docUniqueChecksums);
        for (Map.Entry entry : this.documentItem.entrySet()) {
            if (!(entry.getValue() instanceof SpdxFile)) continue;
            Collection compareChecksums = ((SpdxFile)entry.getValue()).getChecksums();
            List<Checksum> uniqueChecksums = SpdxComparer.findUniqueChecksums(checksums, compareChecksums);
            if (!uniqueChecksums.isEmpty()) {
                this.checksumsEquals = false;
                this.differenceFound = true;
            }
            docUniqueChecksums.put((SpdxDocument)entry.getKey(), uniqueChecksums);
            Map compareUniqueChecksums = this.uniqueChecksums.computeIfAbsent((SpdxDocument)entry.getKey(), k -> new HashMap());
            uniqueChecksums = SpdxComparer.findUniqueChecksums(compareChecksums, checksums);
            if (!uniqueChecksums.isEmpty()) {
                this.checksumsEquals = false;
                this.differenceFound = true;
            }
            compareUniqueChecksums.put(spdxDocument, uniqueChecksums);
        }
    }

    public SpdxFile getFile(SpdxDocument spdxDocument) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        SpdxItem item = this.getItem(spdxDocument);
        if (item instanceof SpdxFile) {
            return (SpdxFile)item;
        }
        return null;
    }

    public boolean isChecksumsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.checksumsEquals;
    }

    public List<Checksum> getUniqueChecksums(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, List<Checksum>> uniqueMap = this.uniqueChecksums.get(docA);
        if (uniqueMap == null) {
            return new ArrayList<Checksum>();
        }
        List<Checksum> retval = uniqueMap.get(docB);
        if (retval == null) {
            return new ArrayList<Checksum>();
        }
        return retval;
    }

    public boolean isTypesEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.typesEquals;
    }

    @Override
    protected void checkInProgress() throws SpdxCompareException {
        super.checkInProgress();
        if (this.inProgress) {
            throw new SpdxCompareException("File compare in progress - can not obtain compare results until compare has completed");
        }
    }

    public boolean isContributorsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.contributorsEquals;
    }

    public boolean isNoticeTextEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.noticeTextEquals;
    }

    @Override
    public boolean isDifferenceFound() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.differenceFound || super.isDifferenceFound();
    }

    public SpdxFileDifference getFileDifference(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        try {
            SpdxItem itemA = (SpdxItem)this.documentItem.get(docA);
            if (!(itemA instanceof SpdxFile)) {
                throw new SpdxCompareException("No SPDX File associated with " + docA.getName());
            }
            SpdxFile fileA = (SpdxFile)itemA;
            SpdxItem itemB = (SpdxItem)this.documentItem.get(docB);
            if (!(itemB instanceof SpdxFile)) {
                throw new SpdxCompareException("No SPDX File associated with " + docB.getName());
            }
            SpdxFile fileB = (SpdxFile)itemB;
            List<AnyLicenseInfo> uniqueLicenseInfoInFilesA = this.getUniqueSeenLicenses(docA, docB);
            List<AnyLicenseInfo> uniqueLicenseInfoInFilesB = this.getUniqueSeenLicenses(docB, docA);
            boolean licenseInfoInFilesEquals = uniqueLicenseInfoInFilesA.isEmpty() && uniqueLicenseInfoInFilesB.isEmpty();
            List<Checksum> uniqueChecksumsA = this.getUniqueChecksums(docA, docB);
            List<Checksum> uniqueChecksumsB = this.getUniqueChecksums(docB, docA);
            boolean checksumsEquals = uniqueChecksumsA.isEmpty() && uniqueChecksumsB.isEmpty();
            List<Relationship> uniqueRelationshipA = this.getUniqueRelationship(docA, docB);
            List<Relationship> uniqueRelationshipB = this.getUniqueRelationship(docB, docA);
            boolean relationshipsEquals = uniqueRelationshipA.isEmpty() && uniqueRelationshipB.isEmpty();
            List<Annotation> uniqueAnnotationsA = this.getUniqueAnnotations(docA, docB);
            List<Annotation> uniqueAnnotationsB = this.getUniqueAnnotations(docB, docA);
            boolean annotationsEquals = uniqueAnnotationsA.isEmpty() && uniqueAnnotationsB.isEmpty();
            return new SpdxFileDifference(fileA, fileB, fileA.getLicenseConcluded().equals((Object)fileB.getLicenseConcluded()), licenseInfoInFilesEquals, uniqueLicenseInfoInFilesA, uniqueLicenseInfoInFilesB, checksumsEquals, uniqueChecksumsA, uniqueChecksumsB, relationshipsEquals, uniqueRelationshipB, uniqueRelationshipB, annotationsEquals, uniqueAnnotationsA, uniqueAnnotationsB);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpdxCompareException("Error reading SPDX file properties: " + e.getMessage(), e);
        }
    }
}

