/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.List;
import java.util.Optional;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.Annotation;
import org.spdx.library.model.v2.Relationship;
import org.spdx.library.model.v2.SpdxItem;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.utility.compare.SpdxComparer;

public class SpdxItemDifference {
    private final String name;
    private final String commentA;
    private final String commentB;
    private final String concludedLicenseA;
    private final String concludedLicenseB;
    private final boolean concludedLicenseEquals;
    private String copyrightA;
    private String copyrightB;
    private final String licenseCommentsA;
    private final String licenseCommentsB;
    private final boolean seenLicensesEqual;
    private final List<AnyLicenseInfo> uniqueSeenLicensesA;
    private final List<AnyLicenseInfo> uniqueSeenLicensesB;
    private final boolean relationshipsEquals;
    private final List<Relationship> uniqueRelationshipA;
    private final List<Relationship> uniqueRelationshipB;
    private final boolean annotationsEquals;
    private final List<Annotation> uniqueAnnotationsA;
    private final List<Annotation> uniqueAnnotationsB;

    public SpdxItemDifference(SpdxItem itemA, SpdxItem itemB, boolean concludedLicensesEqual, boolean seenLicensesEqual, List<AnyLicenseInfo> uniqueSeenLicensesA, List<AnyLicenseInfo> uniqueSeenLicensesB, boolean relationshipsEquals, List<Relationship> uniqueRelationshipA, List<Relationship> uniqueRelationshipB, boolean annotationsEquals, List<Annotation> uniqueAnnotationsA, List<Annotation> uniqueAnnotationsB) throws InvalidSPDXAnalysisException {
        Optional oNameA = itemA.getName();
        this.name = oNameA.orElse("");
        Optional oCommentA = itemA.getComment();
        this.commentA = oCommentA.orElse("");
        Optional oCommentB = itemB.getComment();
        this.commentB = oCommentB.orElse("");
        this.concludedLicenseA = itemA.getLicenseConcluded().toString();
        this.concludedLicenseB = itemB.getLicenseConcluded().toString();
        this.concludedLicenseEquals = concludedLicensesEqual;
        this.copyrightA = itemA.getCopyrightText();
        if (this.copyrightA == null) {
            this.copyrightA = "";
        }
        this.copyrightB = itemB.getCopyrightText();
        if (this.copyrightB == null) {
            this.copyrightB = "";
        }
        Optional oLicenseCommentsA = itemA.getLicenseComments();
        this.licenseCommentsA = oLicenseCommentsA.orElse("");
        Optional oLicenseCommentsB = itemB.getLicenseComments();
        this.licenseCommentsB = oLicenseCommentsB.orElse("");
        this.seenLicensesEqual = seenLicensesEqual;
        this.uniqueSeenLicensesA = uniqueSeenLicensesA;
        this.uniqueSeenLicensesB = uniqueSeenLicensesB;
        this.relationshipsEquals = relationshipsEquals;
        this.uniqueRelationshipA = uniqueRelationshipA;
        this.uniqueRelationshipB = uniqueRelationshipB;
        this.annotationsEquals = annotationsEquals;
        this.uniqueAnnotationsA = uniqueAnnotationsA;
        this.uniqueAnnotationsB = uniqueAnnotationsB;
    }

    public String getName() {
        return this.name;
    }

    public String getCommentA() {
        return this.commentA;
    }

    public String getCommentB() {
        return this.commentB;
    }

    public String getConcludedLicenseA() {
        return this.concludedLicenseA;
    }

    public String getConcludedLicenseB() {
        return this.concludedLicenseB;
    }

    public boolean isConcludedLicenseEquals() {
        return this.concludedLicenseEquals;
    }

    public String getCopyrightA() {
        return this.copyrightA;
    }

    public String getCopyrightB() {
        return this.copyrightB;
    }

    public String getLicenseCommentsA() {
        return this.licenseCommentsA;
    }

    public String getLicenseCommentsB() {
        return this.licenseCommentsB;
    }

    public boolean isSeenLicensesEquals() {
        return this.seenLicensesEqual;
    }

    public List<AnyLicenseInfo> getUniqueSeenLicensesA() {
        return this.uniqueSeenLicensesA;
    }

    public List<AnyLicenseInfo> getUniqueSeenLicensesB() {
        return this.uniqueSeenLicensesB;
    }

    public boolean isCommentsEquals() {
        return SpdxComparer.stringsEqual(this.commentA, this.commentB);
    }

    public boolean isCopyrightsEqual() {
        return SpdxComparer.stringsEqual(this.copyrightA, this.copyrightB);
    }

    public boolean isLicenseCommentsEqual() {
        return SpdxComparer.stringsEqual(this.licenseCommentsA, this.licenseCommentsB);
    }

    public boolean isRelationshipsEquals() {
        return this.relationshipsEquals;
    }

    public List<Relationship> getUniqueRelationshipA() {
        return this.uniqueRelationshipA;
    }

    public List<Relationship> getUniqueRelationshipB() {
        return this.uniqueRelationshipB;
    }

    public boolean isAnnotationsEquals() {
        return this.annotationsEquals;
    }

    public List<Annotation> getUniqueAnnotationsA() {
        return this.uniqueAnnotationsA;
    }

    public List<Annotation> getUniqueAnnotationsB() {
        return this.uniqueAnnotationsB;
    }
}

