/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxModelFactoryCompatV2;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.DisjunctiveLicenseSet;
import org.spdx.library.model.v2.license.ExternalExtractedLicenseInfo;
import org.spdx.library.model.v2.license.ExtractedLicenseInfo;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.OrLaterOperator;
import org.spdx.library.model.v2.license.SimpleLicensingInfo;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v2.license.SpdxNoAssertionLicense;
import org.spdx.library.model.v2.license.SpdxNoneLicense;
import org.spdx.library.model.v2.license.WithExceptionOperator;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.expandedlicensing.ConjunctiveLicenseSet;
import org.spdx.library.model.v3_0_1.expandedlicensing.CustomLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.CustomLicenseAddition;
import org.spdx.library.model.v3_0_1.expandedlicensing.ExtendableLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ExternalCustomLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ExternalCustomLicenseAddition;
import org.spdx.library.model.v3_0_1.expandedlicensing.License;
import org.spdx.library.model.v3_0_1.expandedlicensing.LicenseAddition;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.NoAssertionLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.NoneLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.WithAdditionOperator;
import org.spdx.storage.IModelStore;
import org.spdx.utility.license.LicenseParserException;

public class LicenseExpressionParser {
    static final String LEFT_PAREN = "(";
    static final String RIGHT_PAREN = ")";
    static final Map<String, Operator> OPERATOR_MAP = new HashMap<String, Operator>();
    public static final String UNINITIALIZED_LICENSE_TEXT = "[Initialized with license Parser.  The actual license text is not available]";

    public static org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo parseLicenseExpression(String expression, IModelStore store, String customLicenseUriPrefix, @Nullable IModelCopyManager copyManager, @Nullable List<DictionaryEntry> customIdToUri) throws InvalidSPDXAnalysisException {
        String[] tokens;
        if (expression == null || expression.trim().isEmpty()) {
            throw new LicenseParserException("Empty license expression");
        }
        Objects.requireNonNull(store, "Model store can not be null");
        if (Objects.isNull(customLicenseUriPrefix)) {
            customLicenseUriPrefix = DefaultModelStore.getDefaultDocumentUri() + "#";
        }
        if ((tokens = LicenseExpressionParser.tokenizeExpression(expression)).length == 1 && tokens[0].equals(SpdxConstantsCompatV2.NOASSERTION_VALUE)) {
            return new NoAssertionLicense();
        }
        if (tokens.length == 1 && tokens[0].equals(SpdxConstantsCompatV2.NONE_VALUE)) {
            return new NoneLicense();
        }
        try {
            return LicenseExpressionParser.parseLicenseExpression(tokens, store, customLicenseUriPrefix, copyManager, customIdToUri);
        }
        catch (LicenseParserException ex) {
            throw new LicenseParserException(ex.getMessage() + " License expression: '" + expression + "'", (Throwable)((Object)ex));
        }
        catch (EmptyStackException ex) {
            throw new LicenseParserException("Invalid license expression: '" + expression + "' - check that every operator (e.g. AND and OR) has operators and that parenthesis are matched");
        }
    }

    public static AnyLicenseInfo parseLicenseExpressionCompatV2(String expression, IModelStore store, String documentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (expression == null || expression.trim().isEmpty()) {
            throw new LicenseParserException("Empty license expression");
        }
        Objects.requireNonNull(store, "Model store can not be null");
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        String[] tokens = LicenseExpressionParser.tokenizeExpression(expression);
        if (tokens.length == 1 && tokens[0].equals(SpdxConstantsCompatV2.NOASSERTION_VALUE)) {
            return new SpdxNoAssertionLicense(store, documentUri);
        }
        if (tokens.length == 1 && tokens[0].equals(SpdxConstantsCompatV2.NONE_VALUE)) {
            return new SpdxNoneLicense(store, documentUri);
        }
        try {
            return LicenseExpressionParser.parseLicenseExpressionCompatV2(tokens, store, documentUri, copyManager);
        }
        catch (LicenseParserException ex) {
            throw new LicenseParserException(ex.getMessage() + " License expression: '" + expression + "'", (Throwable)((Object)ex));
        }
        catch (EmptyStackException ex) {
            throw new LicenseParserException("Invalid license expression: '" + expression + "' - check that every operator (e.g. AND and OR) has operators and that parenthesis are matched");
        }
    }

    private static String[] tokenizeExpression(String expression) {
        String[] startTokens = expression.split("\\s");
        ArrayList<String> endTokens = new ArrayList<String>();
        for (String token : startTokens) {
            LicenseExpressionParser.processPreToken(token, endTokens);
        }
        return endTokens.toArray(new String[0]);
    }

    private static void processPreToken(String preToken, List<String> tokenList) {
        if (preToken.isEmpty()) {
            return;
        }
        if (preToken.startsWith(LEFT_PAREN)) {
            tokenList.add(LEFT_PAREN);
            LicenseExpressionParser.processPreToken(preToken.substring(1), tokenList);
        } else if (preToken.endsWith(RIGHT_PAREN)) {
            LicenseExpressionParser.processPreToken(preToken.substring(0, preToken.length() - 1), tokenList);
            tokenList.add(RIGHT_PAREN);
        } else if (preToken.endsWith("+")) {
            LicenseExpressionParser.processPreToken(preToken.substring(0, preToken.length() - 1), tokenList);
            tokenList.add("+");
        } else {
            tokenList.add(preToken);
        }
    }

    private static org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo parseLicenseExpression(String[] tokens, IModelStore store, String customLicenseUriPrefix, @Nullable IModelCopyManager copyManager, @Nullable List<DictionaryEntry> customIdToUri) throws InvalidSPDXAnalysisException {
        if (tokens == null || tokens.length == 0) {
            throw new LicenseParserException("Expected license expression");
        }
        Stack<org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo> operandStack = new Stack<org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo>();
        Stack<Operator> operatorStack = new Stack<Operator>();
        int tokenIndex = 0;
        while (tokenIndex < tokens.length) {
            Operator tosOperator;
            String token;
            if (LEFT_PAREN.equals(token = tokens[tokenIndex++])) {
                int rightParenIndex = LicenseExpressionParser.findMatchingParen(tokens, tokenIndex);
                if (rightParenIndex < 0) {
                    throw new LicenseParserException("Missing right parenthesis");
                }
                String[] nestedTokens = Arrays.copyOfRange(tokens, tokenIndex, rightParenIndex);
                operandStack.push(LicenseExpressionParser.parseLicenseExpression(nestedTokens, store, customLicenseUriPrefix, copyManager, customIdToUri));
                tokenIndex = rightParenIndex + 1;
                continue;
            }
            if (OPERATOR_MAP.get(token) == null) {
                operandStack.push(LicenseExpressionParser.parseSimpleLicenseToken(token, store, customLicenseUriPrefix, copyManager, customIdToUri));
                continue;
            }
            Operator operator = OPERATOR_MAP.get(token);
            if (operator == Operator.WITH) {
                if (!operatorStack.isEmpty() && Operator.OR_LATER.equals(operatorStack.peek())) {
                    tosOperator = (Operator)((Object)operatorStack.pop());
                    LicenseExpressionParser.evaluateExpression(tosOperator, operandStack, store, customLicenseUriPrefix, copyManager);
                }
                if (tokenIndex >= tokens.length) {
                    throw new LicenseParserException("Missing exception clause");
                }
                token = tokens[tokenIndex++];
                LicenseAddition licenseAddition = LicenseExpressionParser.parseSimpleLicenseAdditionToken(token, store, customLicenseUriPrefix, copyManager, customIdToUri);
                org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo operand = operandStack.pop();
                if (operand == null) {
                    throw new LicenseParserException("Missing license for with clause");
                }
                if (!(operand instanceof ExtendableLicense)) {
                    throw new LicenseParserException("License with exception is not of type License or OrLaterOperator");
                }
                WithAdditionOperator weo = new WithAdditionOperator(store, store.getNextId(IModelStore.IdType.Anonymous), copyManager, true, customLicenseUriPrefix);
                weo.setSubjectExtendableLicense((ExtendableLicense)operand);
                weo.setSubjectAddition(licenseAddition);
                operandStack.push((org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo)weo);
                continue;
            }
            while (!operatorStack.isEmpty() && ((Operator)((Object)operatorStack.peek())).ordinal() <= operator.ordinal()) {
                tosOperator = (Operator)((Object)operatorStack.pop());
                LicenseExpressionParser.evaluateExpression(tosOperator, operandStack, store, customLicenseUriPrefix, copyManager);
            }
            operatorStack.push(operator);
        }
        while (!operatorStack.isEmpty()) {
            Operator tosOperator = (Operator)((Object)operatorStack.pop());
            LicenseExpressionParser.evaluateExpression(tosOperator, operandStack, store, customLicenseUriPrefix, copyManager);
        }
        org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo retval = (org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo)operandStack.pop();
        if (!operandStack.isEmpty()) {
            throw new LicenseParserException("Invalid license expression.  Expecting more operands.");
        }
        return retval;
    }

    private static AnyLicenseInfo parseLicenseExpressionCompatV2(String[] tokens, IModelStore store, String documentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (tokens == null || tokens.length == 0) {
            throw new LicenseParserException("Expected license expression");
        }
        Stack<AnyLicenseInfo> operandStack = new Stack<AnyLicenseInfo>();
        Stack<Operator> operatorStack = new Stack<Operator>();
        int tokenIndex = 0;
        while (tokenIndex < tokens.length) {
            Operator tosOperator;
            String token;
            if (LEFT_PAREN.equals(token = tokens[tokenIndex++])) {
                int rightParenIndex = LicenseExpressionParser.findMatchingParen(tokens, tokenIndex);
                if (rightParenIndex < 0) {
                    throw new LicenseParserException("Missing right parenthesis");
                }
                String[] nestedTokens = Arrays.copyOfRange(tokens, tokenIndex, rightParenIndex);
                operandStack.push(LicenseExpressionParser.parseLicenseExpressionCompatV2(nestedTokens, store, documentUri, copyManager));
                tokenIndex = rightParenIndex + 1;
                continue;
            }
            if (OPERATOR_MAP.get(token) == null) {
                operandStack.push(LicenseExpressionParser.parseSimpleLicenseTokenCompatV2(token, store, documentUri, copyManager));
                continue;
            }
            Operator operator = OPERATOR_MAP.get(token);
            if (operator == Operator.WITH) {
                ListedLicenseException licenseException;
                if (!operatorStack.isEmpty() && Operator.OR_LATER.equals(operatorStack.peek())) {
                    tosOperator = (Operator)((Object)operatorStack.pop());
                    LicenseExpressionParser.evaluateExpressionCompatV2(tosOperator, operandStack, store, documentUri, copyManager);
                }
                if (tokenIndex >= tokens.length) {
                    throw new LicenseParserException("Missing exception clause");
                }
                token = tokens[tokenIndex++];
                Optional<Object> exceptionId = Optional.empty();
                if (LicenseInfoFactory.isSpdxListedExceptionId(token)) {
                    exceptionId = LicenseInfoFactory.listedExceptionIdCaseSensitive(token);
                }
                if (exceptionId.isPresent()) {
                    licenseException = LicenseInfoFactory.getListedExceptionV2ById((String)exceptionId.get());
                } else {
                    if (token.startsWith(SpdxConstantsCompatV2.NON_STD_LICENSE_ID_PRENUM)) {
                        throw new LicenseParserException("WITH must be followed by a license exception. " + token + " is a Listed License type.");
                    }
                    licenseException = (ListedLicenseException)SpdxModelFactoryCompatV2.createModelObjectV2((IModelStore)store, (String)documentUri, (String)token, (String)"ListedLicenseException", (IModelCopyManager)copyManager);
                }
                AnyLicenseInfo operand = operandStack.pop();
                if (operand == null) {
                    throw new LicenseParserException("Missing license for with clause");
                }
                if (!(operand instanceof SimpleLicensingInfo) && !(operand instanceof OrLaterOperator)) {
                    throw new LicenseParserException("License with exception is not of type SimpleLicensingInfo or OrLaterOperator");
                }
                WithExceptionOperator weo = new WithExceptionOperator(store, documentUri, store.getNextId(IModelStore.IdType.Anonymous), copyManager, true);
                weo.setLicense(operand);
                weo.setException((LicenseException)licenseException);
                operandStack.push((AnyLicenseInfo)weo);
                continue;
            }
            while (!operatorStack.isEmpty() && ((Operator)((Object)operatorStack.peek())).ordinal() <= operator.ordinal()) {
                tosOperator = (Operator)((Object)operatorStack.pop());
                LicenseExpressionParser.evaluateExpressionCompatV2(tosOperator, operandStack, store, documentUri, copyManager);
            }
            operatorStack.push(operator);
        }
        while (!operatorStack.isEmpty()) {
            Operator tosOperator = (Operator)((Object)operatorStack.pop());
            LicenseExpressionParser.evaluateExpressionCompatV2(tosOperator, operandStack, store, documentUri, copyManager);
        }
        AnyLicenseInfo retval = (AnyLicenseInfo)operandStack.pop();
        if (!operandStack.isEmpty()) {
            throw new LicenseParserException("Invalid license expression.  Expecting more operands.");
        }
        return retval;
    }

    private static int findMatchingParen(String[] tokens, int startToken) {
        if (tokens == null) {
            return -1;
        }
        int nestCount = 0;
        for (int i = startToken; i < tokens.length; ++i) {
            if (LEFT_PAREN.equals(tokens[i])) {
                ++nestCount;
                continue;
            }
            if (!RIGHT_PAREN.equals(tokens[i])) continue;
            if (nestCount == 0) {
                return i;
            }
            --nestCount;
        }
        return -1;
    }

    private static LicenseAddition parseSimpleLicenseAdditionToken(String token, IModelStore store, String customLicenseUriPrefix, @Nullable IModelCopyManager copyManager, @Nullable List<DictionaryEntry> customIdToUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(token, "Token can not be null");
        Objects.requireNonNull(store, "Model store can not be null");
        Objects.requireNonNull(customLicenseUriPrefix, "URI Prefix can not be null");
        if (token.contains(":")) {
            return new ExternalCustomLicenseAddition(LicenseExpressionParser.convertToExternalObjectUri(token, customIdToUri));
        }
        Optional<Object> exceptionId = Optional.empty();
        if (LicenseInfoFactory.isSpdxListedExceptionId(token)) {
            exceptionId = LicenseInfoFactory.listedExceptionIdCaseSensitive(token);
        }
        if (exceptionId.isPresent()) {
            org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException listedException = LicenseInfoFactory.getListedExceptionById((String)exceptionId.get());
            if (!store.exists("http://spdx.org/licenses/" + (String)exceptionId.get()) && Objects.nonNull(copyManager)) {
                copyManager.copy(store, listedException.getObjectUri(), listedException.getModelStore(), listedException.getObjectUri(), SpdxModelFactory.getLatestSpecVersion(), null);
            }
            return new org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException(store, listedException.getObjectUri(), copyManager, true, customLicenseUriPrefix);
        }
        if (token.toLowerCase().startsWith("additionref-")) {
            CustomLicenseAddition localAddition;
            String objectUri = customLicenseUriPrefix + token;
            if (store.exists(objectUri)) {
                localAddition = new CustomLicenseAddition(store, objectUri, copyManager, false, customLicenseUriPrefix);
            } else {
                localAddition = new CustomLicenseAddition(store, objectUri, copyManager, true, customLicenseUriPrefix);
                localAddition.setAdditionText(UNINITIALIZED_LICENSE_TEXT);
            }
            return localAddition;
        }
        throw new LicenseParserException(String.format("Invalid license addition %s.  Must be either a listed license exception or be prefixed with 'AdditionRef-'", token));
    }

    private static org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo parseSimpleLicenseToken(String token, IModelStore store, String customLicenseUriPrefix, @Nullable IModelCopyManager copyManager, @Nullable List<DictionaryEntry> customIdToUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(token, "Token can not be null");
        Objects.requireNonNull(store, "Model store can not be null");
        Objects.requireNonNull(customLicenseUriPrefix, "URI Prefix can not be null");
        if (token.contains(":")) {
            return new ExternalCustomLicense(LicenseExpressionParser.convertToExternalObjectUri(token, customIdToUri));
        }
        Optional<Object> licenseId = Optional.empty();
        if (LicenseInfoFactory.isSpdxListedLicenseId(token)) {
            licenseId = LicenseInfoFactory.listedLicenseIdCaseSensitive(token);
        }
        if (licenseId.isPresent()) {
            ListedLicense listedLicense = LicenseInfoFactory.getListedLicenseById((String)licenseId.get());
            if (!store.exists("http://spdx.org/licenses/" + (String)licenseId.get()) && Objects.nonNull(copyManager)) {
                copyManager.copy(store, listedLicense.getObjectUri(), listedLicense.getModelStore(), listedLicense.getObjectUri(), SpdxModelFactory.getLatestSpecVersion(), null);
            }
            return new ListedLicense(store, listedLicense.getObjectUri(), copyManager, true, "http://spdx.org/licenses/");
        }
        if (token.toLowerCase().startsWith("licenseref-")) {
            CustomLicense localLicense;
            String objectUri = customLicenseUriPrefix + token;
            if (store.exists(objectUri)) {
                localLicense = new CustomLicense(store, objectUri, copyManager, false, customLicenseUriPrefix);
            } else {
                localLicense = new CustomLicense(store, objectUri, copyManager, true, customLicenseUriPrefix);
                localLicense.setLicenseText(UNINITIALIZED_LICENSE_TEXT);
            }
            return localLicense;
        }
        if (LicenseInfoFactory.isSpdxListedExceptionId(token)) {
            throw new LicenseParserException(String.format("Unexpected listed license exception %s.  Must be a listed license or a LicenseRef", token));
        }
        throw new LicenseParserException(String.format("Unknown license %s.  Must be a listed license or have the syntax %s", token, SpdxConstantsCompatV2.LICENSE_ID_PATTERN));
    }

    private static String convertToExternalObjectUri(String externalReference, @Nullable List<DictionaryEntry> customIdToUri) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(customIdToUri)) {
            throw new LicenseParserException("References to external custom additions or external custom licenses must include the customIdToUri parameter");
        }
        String[] refParts = externalReference.split(":");
        if (refParts.length != 2 || refParts[0].isEmpty() || refParts[1].isEmpty()) {
            throw new LicenseParserException("Invalid external ID: " + externalReference);
        }
        String namespace = null;
        for (DictionaryEntry entry : customIdToUri) {
            if (!refParts[0].equals(entry.getIdPrefix())) continue;
            Optional entryValue = entry.getValue();
            if (!entryValue.isPresent()) {
                throw new LicenseParserException("No associated namespace for license ID prefix " + entry.getIdPrefix());
            }
            namespace = (String)entryValue.get();
        }
        if (Objects.isNull(namespace)) {
            throw new LicenseParserException("No ID Prefix " + refParts[0] + " found in the customIdToUri map");
        }
        return namespace + refParts[1];
    }

    private static AnyLicenseInfo parseSimpleLicenseTokenCompatV2(String token, IModelStore store, String documentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(token, "Token can not be null");
        Objects.requireNonNull(store, "Model store can not be null");
        Objects.requireNonNull(documentUri, "URI prefix can not be null");
        if (token.contains(":")) {
            return new ExternalExtractedLicenseInfo(store, documentUri, token, copyManager);
        }
        Optional<Object> licenseId = Optional.empty();
        if (LicenseInfoFactory.isSpdxListedLicenseId(token)) {
            licenseId = LicenseInfoFactory.listedLicenseIdCaseSensitive(token);
        }
        if (licenseId.isPresent()) {
            if (!store.exists("http://spdx.org/licenses/" + (String)licenseId.get())) {
                SpdxListedLicense listedLicense = LicenseInfoFactory.getListedLicenseByIdCompatV2((String)licenseId.get());
                if (Objects.nonNull(copyManager)) {
                    copyManager.copy(store, listedLicense.getObjectUri(), listedLicense.getModelStore(), listedLicense.getObjectUri(), "SPDX-2.3", listedLicense.getDocumentUri());
                }
            }
            return (AnyLicenseInfo)SpdxModelFactoryCompatV2.getModelObjectV2((IModelStore)store, (String)"http://spdx.org/licenses/", (String)((String)licenseId.get()), (String)"ListedLicense", (IModelCopyManager)copyManager, (boolean)true);
        }
        if (token.toLowerCase().startsWith("licenseref-")) {
            ExtractedLicenseInfo localLicense;
            Optional caseSensitiveId = store.getCaseSensitiveId(documentUri, token);
            if (caseSensitiveId.isPresent()) {
                localLicense = new ExtractedLicenseInfo(store, documentUri, (String)caseSensitiveId.get(), copyManager, false);
            } else {
                localLicense = (ExtractedLicenseInfo)SpdxModelFactoryCompatV2.createModelObjectV2((IModelStore)store, (String)documentUri, (String)token, (String)"ExtractedLicensingInfo", (IModelCopyManager)copyManager);
                localLicense.setExtractedText(UNINITIALIZED_LICENSE_TEXT);
            }
            return localLicense;
        }
        if (LicenseInfoFactory.isSpdxListedExceptionId(token)) {
            throw new LicenseParserException(String.format("Unexpected listed license exception %s.  Must be a listed license or a LicenseRef", token));
        }
        throw new LicenseParserException(String.format("Unknown license %s.  Must be a listed license or have the syntax %s", token, SpdxConstantsCompatV2.LICENSE_ID_PATTERN));
    }

    private static void evaluateExpression(Operator operator, Stack<org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo> operandStack, IModelStore store, String customLicenseUriPrefix, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (operator == Operator.OR_LATER) {
            org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo license = operandStack.pop();
            if (!(license instanceof License)) {
                throw new LicenseParserException("Missing license for the '+' or later operator");
            }
            org.spdx.library.model.v3_0_1.expandedlicensing.OrLaterOperator olo = new org.spdx.library.model.v3_0_1.expandedlicensing.OrLaterOperator(store, store.getNextId(IModelStore.IdType.Anonymous), copyManager, true, customLicenseUriPrefix);
            olo.setSubjectLicense((License)license);
            operandStack.push((org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo)olo);
        } else {
            org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo operand2 = operandStack.pop();
            org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo operand1 = operandStack.pop();
            if (operand1 == null || operand2 == null) {
                throw new LicenseParserException("Missing operands for the " + operator.toString() + " operator");
            }
            operandStack.push(LicenseExpressionParser.evaluateBinary(operator, operand1, operand2, store, customLicenseUriPrefix, copyManager));
        }
    }

    private static void evaluateExpressionCompatV2(Operator operator, Stack<AnyLicenseInfo> operandStack, IModelStore store, String documentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (operator == Operator.OR_LATER) {
            AnyLicenseInfo license = operandStack.pop();
            if (!(license instanceof SimpleLicensingInfo)) {
                throw new LicenseParserException("Missing license for the '+' or later operator");
            }
            OrLaterOperator olo = new OrLaterOperator(store, documentUri, store.getNextId(IModelStore.IdType.Anonymous), copyManager, true);
            olo.setLicense((SimpleLicensingInfo)license);
            operandStack.push((AnyLicenseInfo)olo);
        } else {
            AnyLicenseInfo operand2 = operandStack.pop();
            AnyLicenseInfo operand1 = operandStack.pop();
            if (operand1 == null || operand2 == null) {
                throw new LicenseParserException("Missing operands for the " + operator.toString() + " operator");
            }
            operandStack.push(LicenseExpressionParser.evaluateBinaryCompatV2(operator, operand1, operand2, store, documentUri, copyManager));
        }
    }

    private static org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo evaluateBinary(Operator tosOperator, org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo operand1, org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo operand2, IModelStore store, String customLicenseUriPrefix, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (tosOperator == Operator.AND) {
            if (operand1 instanceof ConjunctiveLicenseSet) {
                ((ConjunctiveLicenseSet)operand1).getMembers().add(operand2);
                return operand1;
            }
            ConjunctiveLicenseSet retval = new ConjunctiveLicenseSet(store, store.getNextId(IModelStore.IdType.Anonymous), copyManager, true, customLicenseUriPrefix);
            retval.getMembers().add(operand1);
            retval.getMembers().add(operand2);
            return retval;
        }
        if (tosOperator == Operator.OR) {
            if (operand1 instanceof org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet) {
                ((org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet)operand1).getMembers().add(operand2);
                return operand1;
            }
            org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet retval = new org.spdx.library.model.v3_0_1.expandedlicensing.DisjunctiveLicenseSet(store, store.getNextId(IModelStore.IdType.Anonymous), copyManager, true, customLicenseUriPrefix);
            retval.getMembers().add(operand1);
            retval.getMembers().add(operand2);
            return retval;
        }
        throw new LicenseParserException("Unknown operator " + tosOperator.toString());
    }

    private static AnyLicenseInfo evaluateBinaryCompatV2(Operator tosOperator, AnyLicenseInfo operand1, AnyLicenseInfo operand2, IModelStore store, String documentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (tosOperator == Operator.AND) {
            if (operand1 instanceof org.spdx.library.model.v2.license.ConjunctiveLicenseSet) {
                ((org.spdx.library.model.v2.license.ConjunctiveLicenseSet)operand1).addMember(operand2);
                return operand1;
            }
            org.spdx.library.model.v2.license.ConjunctiveLicenseSet retval = new org.spdx.library.model.v2.license.ConjunctiveLicenseSet(store, documentUri, store.getNextId(IModelStore.IdType.Anonymous), copyManager, true);
            retval.addMember(operand1);
            retval.addMember(operand2);
            return retval;
        }
        if (tosOperator == Operator.OR) {
            if (operand1 instanceof DisjunctiveLicenseSet) {
                ((DisjunctiveLicenseSet)operand1).addMember(operand2);
                return operand1;
            }
            DisjunctiveLicenseSet retval = new DisjunctiveLicenseSet(store, documentUri, store.getNextId(IModelStore.IdType.Anonymous), copyManager, true);
            retval.addMember(operand1);
            retval.addMember(operand2);
            return retval;
        }
        throw new LicenseParserException("Unknown operator " + tosOperator.toString());
    }

    static {
        OPERATOR_MAP.put("+", Operator.OR_LATER);
        OPERATOR_MAP.put("AND", Operator.AND);
        OPERATOR_MAP.put("OR", Operator.OR);
        OPERATOR_MAP.put("WITH", Operator.WITH);
        OPERATOR_MAP.put("and", Operator.AND);
        OPERATOR_MAP.put("or", Operator.OR);
        OPERATOR_MAP.put("with", Operator.WITH);
    }

    static enum Operator {
        OR_LATER,
        WITH,
        AND,
        OR;

    }
}

