/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.jacksonstore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.spdx.library.InvalidSPDXAnalysisException;

public class SpdxJsonLDContext {
    static Set<String> LIST_CONTAINER_TYPES;
    public static Map<String, Class<? extends Object>> XMLSCHEMA_TYPE_TO_JAVA_CLASS;
    private static SpdxJsonLDContext instance;
    static final String JSON_LD_PATH = "/resources/spdx-2-2-revision-16-onotology.context.json";
    static final ObjectMapper JSON_MAPPER;
    private JsonNode contexts;

    static {
        HashSet<String> listContainerTypes = new HashSet<String>();
        listContainerTypes.add("@list");
        listContainerTypes.add("@set");
        listContainerTypes.add("@index");
        LIST_CONTAINER_TYPES = Collections.unmodifiableSet(listContainerTypes);
        HashMap<String, Class<Integer>> schemaToClass = new HashMap<String, Class<Integer>>();
        schemaToClass.put("string", String.class);
        schemaToClass.put("boolean", Boolean.class);
        schemaToClass.put("decimal", String.class);
        schemaToClass.put("float", String.class);
        schemaToClass.put("double", String.class);
        schemaToClass.put("duration", String.class);
        schemaToClass.put("dateTime", String.class);
        schemaToClass.put("time", String.class);
        schemaToClass.put("date", String.class);
        schemaToClass.put("gYearMonth", String.class);
        schemaToClass.put("gYear", String.class);
        schemaToClass.put("gMonthDay", String.class);
        schemaToClass.put("gDay", String.class);
        schemaToClass.put("gMonth", String.class);
        schemaToClass.put("hexBinary", String.class);
        schemaToClass.put("base64Binary", String.class);
        schemaToClass.put("anyURI", String.class);
        schemaToClass.put("3QName", String.class);
        schemaToClass.put("NOTATION", String.class);
        schemaToClass.put("normalizedString", String.class);
        schemaToClass.put("token", String.class);
        schemaToClass.put("language", String.class);
        schemaToClass.put("NMTOKEN", String.class);
        schemaToClass.put("NMTOKENS", String.class);
        schemaToClass.put("Name", String.class);
        schemaToClass.put("NCName", String.class);
        schemaToClass.put("ID", String.class);
        schemaToClass.put("IDREF", String.class);
        schemaToClass.put("IDREFS", String.class);
        schemaToClass.put("ENTITY", String.class);
        schemaToClass.put("ENTITIES", String.class);
        schemaToClass.put("integer", Integer.class);
        schemaToClass.put("nonPositiveInteger", Integer.class);
        schemaToClass.put("negativeInteger", Integer.class);
        schemaToClass.put("long", Integer.class);
        schemaToClass.put("int", Integer.class);
        schemaToClass.put("short", Integer.class);
        schemaToClass.put("byte", Integer.class);
        schemaToClass.put("nonNegativeInteger", Integer.class);
        schemaToClass.put("unsignedLong", Integer.class);
        schemaToClass.put("unsignedInt", Integer.class);
        schemaToClass.put("unsignedShort", Integer.class);
        schemaToClass.put("unsignedByte", Integer.class);
        schemaToClass.put("positiveInteger", Integer.class);
        XMLSCHEMA_TYPE_TO_JAVA_CLASS = Collections.unmodifiableMap(schemaToClass);
        JSON_MAPPER = new ObjectMapper();
    }

    private SpdxJsonLDContext() throws InvalidSPDXAnalysisException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = SpdxJsonLDContext.class.getResourceAsStream(JSON_LD_PATH);){
                JsonNode root;
                if (Objects.isNull(is)) {
                    throw new RuntimeException("Unable to open JSON LD context file");
                }
                try {
                    root = JSON_MAPPER.readTree(is);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                JsonNode contexts = root.get("@context");
                if (Objects.isNull(contexts)) {
                    throw new InvalidSPDXAnalysisException("Missing contexts");
                }
                if (!contexts.isObject()) {
                    throw new InvalidSPDXAnalysisException("Contexts is not an object");
                }
                this.contexts = contexts;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static synchronized SpdxJsonLDContext getInstance() throws InvalidSPDXAnalysisException {
        if (Objects.isNull(instance)) {
            instance = new SpdxJsonLDContext();
        }
        return instance;
    }

    public Optional<String> getType(String propertyName) {
        JsonNode propContext = this.contexts.get(propertyName);
        if (Objects.isNull(propContext)) {
            return Optional.empty();
        }
        JsonNode jnType = propContext.get("@type");
        if (Objects.isNull(jnType)) {
            return Optional.empty();
        }
        String type = null;
        if (jnType.isArray()) {
            Iterator iter = jnType.iterator();
            while (iter.hasNext() && Objects.isNull(type)) {
                String stTypeElement;
                JsonNode jnTypeElement = (JsonNode)iter.next();
                if (!Objects.nonNull(jnTypeElement) || !Objects.nonNull(stTypeElement = jnType.asText()) || stTypeElement.startsWith("@")) continue;
                type = stTypeElement;
            }
        } else {
            type = jnType.asText();
        }
        if (Objects.isNull(type)) {
            return Optional.empty();
        }
        int indexOfColon = type.lastIndexOf(58);
        if (indexOfColon > 0) {
            type = type.substring(indexOfColon + 1);
        }
        return Optional.of(type);
    }

    public boolean isList(String property) {
        JsonNode propContext = this.contexts.get(property);
        if (Objects.isNull(propContext)) {
            return false;
        }
        JsonNode jnContainer = propContext.get("@container");
        if (Objects.isNull(jnContainer)) {
            return false;
        }
        if (jnContainer.isArray()) {
            Iterator iter = jnContainer.iterator();
            while (iter.hasNext()) {
                if (!LIST_CONTAINER_TYPES.contains(((JsonNode)iter.next()).asText())) continue;
                return true;
            }
            return false;
        }
        return LIST_CONTAINER_TYPES.contains(jnContainer.asText());
    }
}

