/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.jacksonstore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.jacksonstore.PropertyComparator;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.ExternalSpdxElement;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.TypedValue;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.enumerations.SpdxEnumFactory;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.SimpleLicensingInfo;
import org.spdx.storage.IModelStore;

public class JacksonSerializer {
    static final Logger logger = LoggerFactory.getLogger(JacksonSerializer.class);
    private ObjectMapper mapper;
    private IModelStore store;
    private MultiFormatStore.Format format;
    private MultiFormatStore.Verbose verbose;

    public JacksonSerializer(ObjectMapper mapper, MultiFormatStore.Format format, MultiFormatStore.Verbose verbose, IModelStore store) {
        Objects.requireNonNull(mapper, "Null required Jackson mapper");
        Objects.requireNonNull(format, "Null required format");
        Objects.requireNonNull(verbose, "Null required verbose");
        Objects.requireNonNull(store, "Null required store");
        this.mapper = mapper;
        this.store = store;
        this.format = format;
        this.verbose = verbose;
    }

    public ObjectNode docToJsonNode(String documentUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Null Document URI");
        IModelStore.IModelStoreLock lock = this.store.enterCriticalSection(documentUri, false);
        try {
            ObjectNode output;
            ArrayNode snippets;
            ArrayNode files;
            TypedValue document = new TypedValue("SPDXRef-DOCUMENT", "SpdxDocument");
            ArrayNode relationships = this.mapper.createArrayNode();
            ObjectNode doc = this.typedValueToObjectNode(documentUri, document, relationships);
            doc.put("documentNamespace", documentUri);
            ArrayNode packages = this.getDocElements(documentUri, "Package", relationships);
            if (packages.size() > 0) {
                doc.set("packages", (JsonNode)packages);
            }
            if ((files = this.getDocElements(documentUri, "File", relationships)).size() > 0) {
                doc.set("files", (JsonNode)files);
            }
            if ((snippets = this.getDocElements(documentUri, "Snippet", relationships)).size() > 0) {
                doc.set("snippets", (JsonNode)snippets);
            }
            HashMap iDRelTypeRelatediDMap = new HashMap();
            Iterator relIter = relationships.elements();
            ArrayNode deDupedRelationships = new ArrayNode(JsonNodeFactory.instance);
            while (relIter.hasNext()) {
                HashSet<String> relatedIds;
                JsonNode relationship = (JsonNode)relIter.next();
                String id = relationship.get("spdxElementId").asText();
                String relType = relationship.get("relationshipType").asText();
                String relatedID = relationship.get("relatedSpdxElement").asText();
                HashMap relTypeRelatedIdMap = (HashMap)iDRelTypeRelatediDMap.get(id);
                if (Objects.isNull(relTypeRelatedIdMap)) {
                    relTypeRelatedIdMap = new HashMap();
                    iDRelTypeRelatediDMap.put(id, relTypeRelatedIdMap);
                }
                if (Objects.isNull(relatedIds = (HashSet<String>)relTypeRelatedIdMap.get(relType))) {
                    relatedIds = new HashSet<String>();
                    relTypeRelatedIdMap.put(relType, relatedIds);
                }
                if (relatedIds.contains(relatedID)) continue;
                deDupedRelationships.add(relationship);
                relatedIds.add(relatedID);
            }
            doc.set("relationships", (JsonNode)deDupedRelationships);
            switch (this.format) {
                case YAML: {
                    output = doc;
                    break;
                }
                case XML: {
                    output = new Document(JsonNodeFactory.instance);
                    output.setAll(doc);
                    break;
                }
                case JSON: {
                    output = doc;
                    break;
                }
                default: {
                    output = doc;
                }
            }
            ObjectNode objectNode = output;
            return objectNode;
        }
        finally {
            this.store.leaveCriticalSection(lock);
        }
    }

    private ObjectNode typedValueToObjectNode(String documentUri, TypedValue storedItem, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        ObjectNode retval = this.mapper.createObjectNode();
        HashSet<String> hasFileIds = new HashSet<String>();
        HashSet<String> documentDescribesIds = new HashSet<String>();
        ArrayList<String> docPropNames = new ArrayList<String>(this.store.getPropertyValueNames(documentUri, storedItem.getId()));
        docPropNames.sort(new PropertyComparator(storedItem.getType()));
        Class clazz = (Class)SpdxModelFactory.SPDX_TYPE_TO_CLASS.get(storedItem.getType());
        IModelStore.IdType idType = this.store.getIdType(storedItem.getId());
        if (SpdxElement.class.isAssignableFrom(clazz)) {
            if (IModelStore.IdType.SpdxId.equals((Object)idType)) {
                retval.put("SPDXID", storedItem.getId());
            } else if (!IModelStore.IdType.Anonymous.equals((Object)idType)) {
                logger.error("Invalid ID " + storedItem.getId() + ".  Must be an SPDX Identifier or Anonymous");
                throw new InvalidSPDXAnalysisException("Invalid ID " + storedItem.getId() + ".  Must be an SPDX Identifier or Anonymous");
            }
        } else if (ExternalDocumentRef.class.isAssignableFrom(clazz)) {
            retval.put("externalDocumentId", storedItem.getId());
        } else if (SimpleLicensingInfo.class.isAssignableFrom(clazz)) {
            retval.put("licenseId", storedItem.getId());
        }
        for (String propertyName : docPropNames) {
            if ("relationship".equals(propertyName)) {
                this.addJsonRelationships(documentUri, storedItem, retval, relationships, hasFileIds, documentDescribesIds);
                continue;
            }
            if ("hasExtractedLicensingInfo".equals(propertyName)) {
                retval.set(MultiFormatStore.propertyNameToCollectionPropertyName(propertyName), (JsonNode)this.toExtractedLicensesArrayNode(documentUri, storedItem.getId(), propertyName, relationships));
                continue;
            }
            if (this.store.isCollectionProperty(documentUri, storedItem.getId(), propertyName)) {
                ArrayNode valuesArray;
                Iterator propertyValues = this.store.listValues(documentUri, storedItem.getId(), propertyName);
                if ("hasFile".equals(propertyName) && hasFileIds.size() > 0) {
                    ArrayList hasFilesToAdd = new ArrayList();
                    while (propertyValues.hasNext()) {
                        Object fileToAdd = propertyValues.next();
                        if (fileToAdd instanceof TypedValue) {
                            String fileToAddId = ((TypedValue)fileToAdd).getId();
                            if (hasFileIds.contains(fileToAddId)) continue;
                            hasFilesToAdd.add(fileToAdd);
                            hasFileIds.add(fileToAddId);
                            continue;
                        }
                        hasFilesToAdd.add(fileToAdd);
                    }
                    valuesArray = this.toArrayNode(documentUri, hasFilesToAdd.iterator(), relationships);
                } else if ("documentDescribes".equals(propertyName) && documentDescribesIds.size() > 0) {
                    ArrayList describesToAdd = new ArrayList();
                    while (propertyValues.hasNext()) {
                        Object describedElementToAdd = propertyValues.next();
                        if (describedElementToAdd instanceof TypedValue) {
                            String describedElementToAddId = ((TypedValue)describedElementToAdd).getId();
                            if (hasFileIds.contains(describedElementToAddId)) continue;
                            describesToAdd.add(describedElementToAdd);
                            hasFileIds.add(describedElementToAddId);
                            continue;
                        }
                        describesToAdd.add(describedElementToAdd);
                    }
                    valuesArray = this.toArrayNode(documentUri, describesToAdd.iterator(), relationships);
                } else {
                    valuesArray = this.toArrayNode(documentUri, propertyValues, relationships);
                }
                retval.set(MultiFormatStore.propertyNameToCollectionPropertyName(propertyName), (JsonNode)valuesArray);
                continue;
            }
            Optional value = this.store.getValue(documentUri, storedItem.getId(), propertyName);
            if (!value.isPresent()) continue;
            this.setValueField(retval, propertyName, documentUri, value.get(), relationships);
        }
        return retval;
    }

    private ArrayNode getDocElements(String documentUri, String type, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        return this.store.getAllItems(documentUri, type).collect(() -> this.mapper.createArrayNode(), (an, item) -> {
            try {
                an.add((JsonNode)this.typedValueToObjectNode(documentUri, (TypedValue)item, relationships));
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
        }, (an1, an2) -> an1.addAll(an2));
    }

    private ArrayNode toExtractedLicensesArrayNode(String documentUri, String id, String propertyName, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        ArrayNode retval = this.mapper.createArrayNode();
        Iterator extractedLicenses = this.store.listValues(documentUri, id, propertyName);
        while (extractedLicenses.hasNext()) {
            Object extractedLicense = extractedLicenses.next();
            if (!(extractedLicense instanceof TypedValue) || !"ExtractedLicensingInfo".equals(((TypedValue)extractedLicense).getType())) {
                throw new SpdxInvalidTypeException("Extracted License Infos not of type ExtractedLicensingInfo");
            }
            retval.add((JsonNode)this.typedValueToObjectNode(documentUri, (TypedValue)extractedLicense, relationships));
        }
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addJsonRelationships(String documentUri, TypedValue element, ObjectNode elementNode, ArrayNode relationships, Set<String> hasFileIds, Set<String> documentDescribesIds) throws InvalidSPDXAnalysisException {
        Iterator valueList = this.store.listValues(documentUri, element.getId(), "relationship");
        ArrayList<String> hasFileIdsToAdd = new ArrayList<String>();
        ArrayList<String> documentDescribesIdsToAdd = new ArrayList<String>();
        while (valueList.hasNext()) {
            String relatedElementType;
            String relatedElementId;
            Object value = valueList.next();
            if (!(value instanceof TypedValue)) {
                throw new SpdxInvalidTypeException("Expected relationship type, value list element was of type " + value.getClass().toString());
            }
            TypedValue tvValue = (TypedValue)value;
            if (!"Relationship".equals(tvValue.getType())) {
                throw new SpdxInvalidTypeException("Expected relationship type, value list element was of type " + tvValue.getType());
            }
            Optional relatedSpdxElement = this.store.getValue(documentUri, tvValue.getId(), "relatedSpdxElement");
            if (!relatedSpdxElement.isPresent()) {
                logger.warn("Missing related SPDX element for a relationship for " + element.getId() + ".  Skipping the serialization of this relationship.");
                continue;
            }
            Optional relationshipComment = this.store.getValue(documentUri, tvValue.getId(), "comment");
            if (relatedSpdxElement.get() instanceof TypedValue) {
                relatedElementId = ((TypedValue)relatedSpdxElement.get()).getId();
                relatedElementType = ((TypedValue)relatedSpdxElement.get()).getType();
            } else {
                if (!(relatedSpdxElement.get() instanceof IndividualUriValue)) throw new SpdxInvalidTypeException("SPDX element must be of SpdxElement or external SPDX element type.  Found type " + relatedSpdxElement.get().getClass().toString());
                String externalUri = ((IndividualUriValue)relatedSpdxElement.get()).getIndividualURI();
                if ("http://spdx.org/rdf/terms#none".equals(externalUri)) {
                    relatedElementId = SpdxConstants.NONE_VALUE;
                    relatedElementType = "SpdxNoneElement";
                } else if ("http://spdx.org/rdf/terms#noassertion".equals(externalUri)) {
                    relatedElementId = SpdxConstants.NOASSERTION_VALUE;
                    relatedElementType = "SpdxNoAssertionElement";
                } else {
                    if (!SpdxConstants.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(externalUri).matches()) throw new SpdxInvalidTypeException("SPDX element must be of SpdxElement, SpdxNoneElement, SpdxNoAssertionElement or external SPDX element type.  URI does not match pattern for external element: " + externalUri);
                    ExternalSpdxElement externalElement = ExternalSpdxElement.uriToExternalSpdxElement((String)externalUri, (IModelStore)this.store, (String)documentUri, null);
                    relatedElementId = String.valueOf(externalElement.getExternalDocumentId()) + ":" + externalElement.getExternalElementId();
                    relatedElementType = "ExternalSpdxElement";
                }
            }
            Optional relationshipType = this.store.getValue(documentUri, tvValue.getId(), "relationshipType");
            if (!relationshipType.isPresent()) {
                logger.warn("Missing type for a relationship for " + element.getId() + ".  Skipping the serialization of this relationship.");
                continue;
            }
            if (!(relationshipType.get() instanceof IndividualUriValue)) {
                throw new SpdxInvalidTypeException("Expected RelationshipType type for relationshipType property.  Unexpected type " + relatedSpdxElement.get().getClass().toString());
            }
            String relationshipTypeStr = this.individualUriToString(documentUri, ((IndividualUriValue)relationshipType.get()).getIndividualURI());
            if (RelationshipType.DESCRIBES.toString().equals(relationshipTypeStr) && "SpdxDocument".equals(element.getType()) && !documentDescribesIds.contains(relatedElementId)) {
                documentDescribesIdsToAdd.add(relatedElementId);
                documentDescribesIds.add(relatedElementId);
                continue;
            }
            if (RelationshipType.CONTAINS.toString().equals(relationshipTypeStr) && "Package".equals(element.getType()) && "File".equals(relatedElementType) && !hasFileIds.contains(relatedElementId)) {
                hasFileIdsToAdd.add(relatedElementId);
                hasFileIds.add(relatedElementId);
                continue;
            }
            ObjectNode relationship = this.mapper.createObjectNode();
            relationship.put("spdxElementId", element.getId());
            relationship.put("relationshipType", relationshipTypeStr);
            relationship.put("relatedSpdxElement", relatedElementId);
            if (relationshipComment.isPresent()) {
                relationship.put("comment", (String)relationshipComment.get());
            }
            relationships.add((JsonNode)relationship);
        }
        if (hasFileIdsToAdd.size() > 0) {
            JsonNode jnFiles = elementNode.get(MultiFormatStore.propertyNameToCollectionPropertyName("hasFile"));
            if (Objects.isNull(jnFiles)) {
                jnFiles = this.mapper.createArrayNode();
                elementNode.set(MultiFormatStore.propertyNameToCollectionPropertyName("hasFile"), jnFiles);
            }
            if (!(jnFiles instanceof ArrayNode)) {
                throw new InvalidSPDXAnalysisException("hasFile is not an array");
            }
            for (String hasFileId : hasFileIdsToAdd) {
                ((ArrayNode)jnFiles).add(hasFileId);
            }
        }
        if (documentDescribesIdsToAdd.size() <= 0) return;
        JsonNode jnDescribes = elementNode.get("documentDescribes");
        if (Objects.isNull(jnDescribes)) {
            jnDescribes = this.mapper.createArrayNode();
            elementNode.set("documentDescribes", jnDescribes);
        }
        if (!(jnDescribes instanceof ArrayNode)) {
            throw new InvalidSPDXAnalysisException("Describes is not an array");
        }
        for (String describesId : documentDescribesIdsToAdd) {
            ((ArrayNode)jnDescribes).add(describesId);
        }
    }

    private ArrayNode toArrayNode(String documentUri, Iterator<Object> valueList, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        ArrayNode retval = this.mapper.createArrayNode();
        while (valueList.hasNext()) {
            Object value = valueList.next();
            this.addValueToArrayNode(retval, documentUri, value, relationships);
        }
        return retval;
    }

    private void setValueField(ObjectNode node, String field, String documentUri, Object value, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        Object nodeValue = this.toSerializable(documentUri, value, relationships);
        if (nodeValue instanceof JsonNode) {
            node.set(field, (JsonNode)nodeValue);
        } else if (nodeValue instanceof String) {
            node.put(field, (String)nodeValue);
        } else if (nodeValue instanceof Integer) {
            node.put(field, (Integer)nodeValue);
        } else if (nodeValue instanceof Boolean) {
            node.put(field, (Boolean)nodeValue);
        } else {
            throw new SpdxInvalidTypeException("Can not serialize the JSON type for " + nodeValue.getClass().toString());
        }
    }

    private Object toSerializable(String documentUri, Object value, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        if (value instanceof IndividualUriValue) {
            return this.individualUriToString(documentUri, ((IndividualUriValue)value).getIndividualURI());
        }
        if (value instanceof TypedValue) {
            TypedValue tvStoredValue = (TypedValue)value;
            Class clazz = (Class)SpdxModelFactory.SPDX_TYPE_TO_CLASS.get(tvStoredValue.getType());
            if (AnyLicenseInfo.class.isAssignableFrom(clazz) && (MultiFormatStore.Verbose.STANDARD.equals((Object)this.verbose) || MultiFormatStore.Verbose.COMPACT.equals((Object)this.verbose))) {
                AnyLicenseInfo ali = (AnyLicenseInfo)SpdxModelFactory.createModelObject((IModelStore)this.store, (String)documentUri, (String)tvStoredValue.getId(), (String)tvStoredValue.getType(), null);
                return ali.toString();
            }
            if (SpdxElement.class.isAssignableFrom(clazz) && MultiFormatStore.Verbose.COMPACT.equals((Object)this.verbose) && !IModelStore.IdType.Anonymous.equals((Object)this.store.getIdType(tvStoredValue.getId()))) {
                return tvStoredValue.getId();
            }
            return this.typedValueToObjectNode(documentUri, (TypedValue)value, relationships);
        }
        return value;
    }

    private String individualUriToString(String documentUri, String uri) throws InvalidSPDXAnalysisException {
        Object enumval = SpdxEnumFactory.uriToEnum.get(uri);
        if (Objects.nonNull(enumval)) {
            if (enumval instanceof RelationshipType) {
                return enumval.toString();
            }
            return enumval.toString().replaceAll("_", "-");
        }
        if (SpdxConstants.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(uri).matches()) {
            ExternalSpdxElement externalElement = ExternalSpdxElement.uriToExternalSpdxElement((String)uri, (IModelStore)this.store, (String)documentUri, null);
            return String.valueOf(externalElement.getExternalDocumentId()) + ":" + externalElement.getExternalElementId();
        }
        if ("http://spdx.org/rdf/terms#none".equals(uri)) {
            return SpdxConstants.NONE_VALUE;
        }
        if ("http://spdx.org/rdf/terms#noassertion".equals(uri)) {
            return SpdxConstants.NOASSERTION_VALUE;
        }
        if (uri.startsWith("http://spdx.org/rdf/references/")) {
            return uri.substring("http://spdx.org/rdf/references/".length());
        }
        return uri;
    }

    private void addValueToArrayNode(ArrayNode node, String documentUri, Object value, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        Object nodeValue = this.toSerializable(documentUri, value, relationships);
        if (nodeValue instanceof JsonNode) {
            node.add((JsonNode)nodeValue);
        } else if (nodeValue instanceof String) {
            node.add((String)nodeValue);
        } else if (nodeValue instanceof Integer) {
            node.add((Integer)nodeValue);
        } else if (nodeValue instanceof Boolean) {
            node.add((Boolean)nodeValue);
        } else {
            throw new SpdxInvalidTypeException("Can not serialize the JSON type for " + nodeValue.getClass().toString());
        }
    }

    class Document
    extends ObjectNode {
        private static final long serialVersionUID = 1L;

        public Document(JsonNodeFactory nc) {
            super(nc);
        }
    }
}

