/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.jacksonstore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelObjectHelper;
import org.spdx.core.SimpleUriValue;
import org.spdx.core.TypedValue;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.jacksonstore.SpdxJsonLDContext;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.model.v2.ExternalSpdxElement;
import org.spdx.library.model.v2.ReferenceType;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxModelFactoryCompatV2;
import org.spdx.library.model.v2.enumerations.RelationshipType;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.referencetype.ListedReferenceTypes;
import org.spdx.storage.IModelStore;
import org.spdx.storage.compatv2.CompatibleModelStoreWrapper;

public class JacksonDeSerializer {
    static final Set<String> SKIPPED_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SpdxConstantsCompatV2.PROP_DOCUMENT_PACKAGES.getName(), SpdxConstantsCompatV2.PROP_DOCUMENT_FILES.getName(), SpdxConstantsCompatV2.PROP_DOCUMENT_SNIPPETS.getName(), "SPDXID", SpdxConstantsCompatV2.PROP_DOCUMENT_RELATIONSHIPS.getName(), SpdxConstantsCompatV2.PROP_DOCUMENT_NAMESPACE.getName())));
    private final CompatibleModelStoreWrapper store;
    private final MultiFormatStore.Format format;
    private IModelCopyManager modelCopyManager;
    private final Map<String, Map<String, Map<SimpleUriValue, String>>> addedRelationships = new HashMap<String, Map<String, Map<SimpleUriValue, String>>>();

    public JacksonDeSerializer(IModelStore store, MultiFormatStore.Format format) {
        Objects.requireNonNull(store, "Model store can not be null");
        Objects.requireNonNull(format, "Format can not be null");
        this.store = new CompatibleModelStoreWrapper(store);
        this.format = format;
    }

    public JacksonDeSerializer(IModelStore store, IModelCopyManager modelCopyManager, MultiFormatStore.Format format) {
        Objects.requireNonNull(store, "Model store can not be null");
        Objects.requireNonNull(modelCopyManager, "Model copy manager can not be null");
        Objects.requireNonNull(format, "Format can not be null");
        this.store = new CompatibleModelStoreWrapper(store);
        this.modelCopyManager = modelCopyManager;
        this.format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDocument(String documentNamespace, JsonNode doc) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentNamespace, "Null required document namespace");
        Objects.requireNonNull(doc, "Null document JSON Node");
        IModelStore.IModelStoreLock lock = this.store.enterCriticalSection(documentNamespace, false);
        try {
            HashMap<String, String> spdxIdProperties = new HashMap<String, String>();
            this.store.create(documentNamespace, "SPDXRef-DOCUMENT", "SpdxDocument");
            this.restoreObjectPropertyValues(documentNamespace, "SPDXRef-DOCUMENT", doc, spdxIdProperties);
            HashMap<String, TypedValue> addedElements = new HashMap<String, TypedValue>();
            addedElements.put("SPDXRef-DOCUMENT", CompatibleModelStoreWrapper.typedValueFromDocUri((String)documentNamespace, (String)"SPDXRef-DOCUMENT", (boolean)false, (String)"SpdxDocument"));
            this.restoreElements(documentNamespace, "Package", doc.get(SpdxConstantsCompatV2.PROP_DOCUMENT_PACKAGES.getName()), addedElements, spdxIdProperties);
            this.restoreElements(documentNamespace, "File", doc.get(SpdxConstantsCompatV2.PROP_DOCUMENT_FILES.getName()), addedElements, spdxIdProperties);
            this.restoreElements(documentNamespace, "Snippet", doc.get(SpdxConstantsCompatV2.PROP_DOCUMENT_SNIPPETS.getName()), addedElements, spdxIdProperties);
            this.restoreRelationships(documentNamespace, doc.get(SpdxConstantsCompatV2.PROP_DOCUMENT_RELATIONSHIPS.getName()), addedElements);
            for (Map.Entry propertyToFix : spdxIdProperties.entrySet()) {
                Optional idToReplace = this.store.getValue(documentNamespace, (String)propertyToFix.getKey(), (String)propertyToFix.getValue());
                if (!idToReplace.isPresent()) {
                    throw new InvalidSPDXAnalysisException("Missing SPDX ID for " + (String)propertyToFix.getKey() + " " + (String)propertyToFix.getValue());
                }
                if (idToReplace.get() instanceof Collection) {
                    HashSet<Object> replacements = new HashSet<Object>();
                    for (Object e : (Collection)idToReplace.get()) {
                        if (!(e instanceof String)) {
                            throw new InvalidSPDXAnalysisException("Can not replace the SPDX ID with value due to invalid type for " + (String)propertyToFix.getKey() + " " + (String)propertyToFix.getValue());
                        }
                        replacements.add(this.idToObjectValue(documentNamespace, (String)e, addedElements));
                    }
                    this.store.clearValueCollection(documentNamespace, (String)propertyToFix.getKey(), (String)propertyToFix.getValue());
                    for (Object e : replacements) {
                        this.store.addValueToCollection(documentNamespace, (String)propertyToFix.getKey(), (String)propertyToFix.getValue(), e);
                    }
                    continue;
                }
                if (!(idToReplace.get() instanceof String)) {
                    throw new InvalidSPDXAnalysisException("Can not replace the SPDX ID with value due to invalid type for " + (String)propertyToFix.getKey() + " " + (String)propertyToFix.getValue());
                }
                String spdxId = (String)idToReplace.get();
                this.store.setValue(documentNamespace, (String)propertyToFix.getKey(), (String)propertyToFix.getValue(), this.idToObjectValue(documentNamespace, spdxId, addedElements));
            }
        }
        finally {
            this.store.leaveCriticalSection(lock);
        }
    }

    private void restoreElement(String documentUri, String type, @Nullable JsonNode jsonNode, Map<String, TypedValue> addedElements, Map<String, String> spdxIdProperties) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(jsonNode)) {
            return;
        }
        if (!jsonNode.isObject()) {
            throw new InvalidSPDXAnalysisException("Invalid JSON node type for SPDX element");
        }
        JsonNode idNode = jsonNode.get("SPDXID");
        if (Objects.isNull(idNode) || !idNode.isTextual()) {
            throw new InvalidSPDXAnalysisException("Missing SPDX ID for type " + type);
        }
        String id = idNode.asText();
        if (Objects.isNull(id) || id.isEmpty()) {
            throw new InvalidSPDXAnalysisException("Empty SPDX ID for type " + type);
        }
        if (addedElements.containsKey(id)) {
            throw new InvalidSPDXAnalysisException("Duplicate SPDX ID: " + id);
        }
        this.store.create(documentUri, id, type);
        try {
            this.restoreObjectPropertyValues(documentUri, id, jsonNode, spdxIdProperties);
        }
        catch (InvalidSPDXAnalysisException ex) {
            throw new InvalidSPDXAnalysisException("Error parsing JSON field for ID " + id + ": " + ex.getMessage(), (Throwable)ex);
        }
        addedElements.put(id, CompatibleModelStoreWrapper.typedValueFromDocUri((String)documentUri, (String)id, (IModelStore)this.store, (String)type));
    }

    private void restoreElements(String documentUri, String type, @Nullable JsonNode jsonNode, Map<String, TypedValue> addedElements, Map<String, String> spdxIdProperties) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(jsonNode)) {
            return;
        }
        if (jsonNode.isArray()) {
            Iterator iter = jsonNode.elements();
            while (iter.hasNext()) {
                this.restoreElement(documentUri, type, (JsonNode)iter.next(), addedElements, spdxIdProperties);
            }
        } else {
            this.restoreElement(documentUri, type, jsonNode, addedElements, spdxIdProperties);
        }
    }

    private void restoreRelationships(String documentNamespace, JsonNode jsonNode, Map<String, TypedValue> addedElements) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(jsonNode)) {
            return;
        }
        if (jsonNode.isArray()) {
            Iterator iter = jsonNode.elements();
            while (iter.hasNext()) {
                this.restoreRelationship(documentNamespace, (JsonNode)iter.next(), addedElements);
            }
        } else {
            this.restoreRelationship(documentNamespace, jsonNode, addedElements);
        }
    }

    private void restoreRelationship(String documentNamespace, JsonNode relationship, Map<String, TypedValue> addedElements) throws InvalidSPDXAnalysisException {
        String relationshipTypeUri;
        JsonNode elementIdNode = relationship.get(SpdxConstantsCompatV2.PROP_SPDX_ELEMENTID.getName());
        if (Objects.isNull(elementIdNode) || !elementIdNode.isTextual()) {
            throw new InvalidSPDXAnalysisException("Missing SPDX element ID");
        }
        TypedValue element = addedElements.get(elementIdNode.asText());
        if (Objects.isNull(element)) {
            throw new InvalidSPDXAnalysisException("Missing SPDX element for ID " + elementIdNode.asText());
        }
        JsonNode relationshipTypeNode = relationship.get(SpdxConstantsCompatV2.PROP_RELATIONSHIP_TYPE.getName());
        if (Objects.isNull(relationshipTypeNode) || !relationshipTypeNode.isTextual()) {
            throw new InvalidSPDXAnalysisException("Missing required relationship type");
        }
        try {
            relationshipTypeUri = RelationshipType.valueOf((String)relationshipTypeNode.asText()).getIndividualURI();
        }
        catch (Exception ex) {
            throw new InvalidSPDXAnalysisException("Unknown relationship type: " + relationshipTypeNode.asText());
        }
        SimpleUriValue relationshipType = new SimpleUriValue(relationshipTypeUri);
        JsonNode relatedElementNode = relationship.get(SpdxConstantsCompatV2.PROP_RELATED_SPDX_ELEMENT.getName());
        if (Objects.isNull(relatedElementNode) || !relatedElementNode.isTextual()) {
            throw new InvalidSPDXAnalysisException("Missing required related element");
        }
        Object relatedElement = this.idToObjectValue(documentNamespace, relatedElementNode.asText(), addedElements);
        JsonNode commentNode = relationship.get(SpdxConstantsCompatV2.RDFS_PROP_COMMENT.getName());
        Optional<Object> relationshipComment = Objects.isNull(commentNode) || !commentNode.isTextual() ? Optional.empty() : Optional.of(commentNode.asText());
        this.addRelationship(documentNamespace, CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)element.getObjectUri(), (String)documentNamespace), relationshipType, relatedElement, relationshipComment);
    }

    private String addRelationship(String documentNamespace, String elementId, SimpleUriValue relationshipType, Object relatedElement, Optional<String> relationshipComment) throws InvalidSPDXAnalysisException {
        String relationshipId;
        Map<SimpleUriValue, String> relatedElementRelationships;
        String relatedElementId;
        if (relatedElement instanceof TypedValue) {
            relatedElementId = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)((TypedValue)relatedElement).getObjectUri(), (String)documentNamespace);
        } else if (relatedElement instanceof String) {
            relatedElementId = (String)relatedElement;
        } else if (relatedElement instanceof IndividualUriValue) {
            relatedElementId = ((IndividualUriValue)relatedElement).getIndividualURI();
        } else {
            throw new InvalidSPDXAnalysisException("Related element is not of an Element type for relationship to element " + elementId);
        }
        Map<String, Map<SimpleUriValue, String>> elementRelationships = this.addedRelationships.get(elementId);
        if (Objects.nonNull(elementRelationships)) {
            relatedElementRelationships = elementRelationships.get(relatedElementId);
            if (Objects.nonNull(relatedElementRelationships)) {
                relationshipId = relatedElementRelationships.get(relationshipType);
                if (Objects.nonNull(relationshipId)) {
                    return relationshipId;
                }
            } else {
                relatedElementRelationships = new HashMap<SimpleUriValue, String>();
                elementRelationships.put(relatedElementId, relatedElementRelationships);
            }
        } else {
            elementRelationships = new HashMap<String, Map<SimpleUriValue, String>>();
            relatedElementRelationships = new HashMap<SimpleUriValue, String>();
            elementRelationships.put(relatedElementId, relatedElementRelationships);
            this.addedRelationships.put(elementId, elementRelationships);
        }
        relationshipId = this.store.getNextId(IModelStore.IdType.Anonymous, documentNamespace);
        this.store.create(documentNamespace, relationshipId, "Relationship");
        this.store.setValue(documentNamespace, relationshipId, SpdxConstantsCompatV2.PROP_RELATIONSHIP_TYPE, (Object)relationshipType);
        this.store.setValue(documentNamespace, relationshipId, SpdxConstantsCompatV2.PROP_RELATED_SPDX_ELEMENT, relatedElement);
        this.store.addValueToCollection(documentNamespace, elementId, SpdxConstantsCompatV2.PROP_RELATIONSHIP, (Object)CompatibleModelStoreWrapper.typedValueFromDocUri((String)documentNamespace, (String)relationshipId, (IModelStore)this.store, (String)"Relationship"));
        if (relationshipComment.isPresent()) {
            this.store.setValue(documentNamespace, relationshipId, SpdxConstantsCompatV2.RDFS_PROP_COMMENT, (Object)relationshipComment.get());
        }
        relatedElementRelationships.put(relationshipType, relationshipId);
        return relationshipId;
    }

    private void restoreObjectPropertyValues(String documentUri, String id, JsonNode node, Map<String, String> spdxIdProperties) throws InvalidSPDXAnalysisException {
        Iterator fieldIterator = node.fields();
        while (fieldIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIterator.next();
            if (SKIPPED_PROPERTIES.contains(field.getKey())) continue;
            if (SpdxConstantsCompatV2.PROP_DOCUMENT_DESCRIBES.getName().equals(field.getKey())) {
                this.convertFieldToRelationship(documentUri, id, (JsonNode)field.getValue(), RelationshipType.DESCRIBES, spdxIdProperties);
                continue;
            }
            if (SpdxConstantsCompatV2.PROP_PACKAGE_FILE.getName().equals(MultiFormatStore.collectionPropertyNameToPropertyName((String)field.getKey()))) {
                this.convertFieldToRelationship(documentUri, id, (JsonNode)field.getValue(), RelationshipType.CONTAINS, spdxIdProperties);
                continue;
            }
            this.setPropertyValueForJsonNode(documentUri, id, (String)field.getKey(), (JsonNode)field.getValue(), spdxIdProperties, false);
        }
    }

    private void convertFieldToRelationship(String documentUri, String id, JsonNode spdxIdField, RelationshipType relationshipType, Map<String, String> spdxIdProperties) throws InvalidSPDXAnalysisException {
        if (spdxIdField instanceof ArrayNode) {
            for (JsonNode spdxIdNode : spdxIdField) {
                String relationshipId = this.addRelationship(documentUri, id, new SimpleUriValue(relationshipType.getIndividualURI()), spdxIdNode.asText(), Optional.empty());
                spdxIdProperties.put(relationshipId, SpdxConstantsCompatV2.PROP_RELATED_SPDX_ELEMENT.getName());
            }
        } else {
            String relationshipId = this.addRelationship(documentUri, id, new SimpleUriValue(relationshipType.getIndividualURI()), spdxIdField.asText(), Optional.empty());
            spdxIdProperties.put(relationshipId, SpdxConstantsCompatV2.PROP_RELATED_SPDX_ELEMENT.getName());
        }
    }

    private void setPropertyValueForJsonNode(String documentUri, String id, String property, JsonNode value, Map<String, String> spdxIdProperties, boolean list) throws InvalidSPDXAnalysisException {
        if (SpdxJsonLDContext.getInstance().isList(property)) {
            list = true;
        }
        if (JsonNodeType.ARRAY.equals((Object)value.getNodeType())) {
            Iterator iter = value.elements();
            while (iter.hasNext()) {
                this.setPropertyValueForJsonNode(documentUri, id, property, (JsonNode)iter.next(), spdxIdProperties, true);
            }
        } else if (!JsonNodeType.NULL.equals((Object)value.getNodeType())) {
            Optional<String> propertyType = SpdxJsonLDContext.getInstance().getType(property);
            if (list) {
                this.store.addValueToCollection(documentUri, id, MultiFormatStore.collectionPropertyNameToPropertyName(property), this.toStoredObject(documentUri, id, property, value, propertyType, spdxIdProperties, true));
            } else {
                this.store.setValue(documentUri, id, property, this.toStoredObject(documentUri, id, property, value, propertyType, spdxIdProperties, false));
            }
        }
    }

    private Object toStoredObject(String documentUri, String id, String property, JsonNode value, Optional<String> propertyType, Map<String, String> spdxIdProperties, boolean list) throws InvalidSPDXAnalysisException {
        switch (value.getNodeType()) {
            case ARRAY: {
                throw new InvalidSPDXAnalysisException("Can not convert a JSON array to a stored object");
            }
            case BOOLEAN: {
                if (propertyType.isPresent()) {
                    Class<?> toStoreClass = SpdxJsonLDContext.XMLSCHEMA_TYPE_TO_JAVA_CLASS.get(propertyType.get());
                    if (Objects.isNull(toStoreClass)) {
                        return value.asBoolean();
                    }
                    if (String.class.equals(toStoreClass)) {
                        return Boolean.toString(value.asBoolean());
                    }
                    if (Boolean.class.equals(toStoreClass)) {
                        return value.asBoolean();
                    }
                    throw new InvalidSPDXAnalysisException("Can not convert a JSON BOOLEAN to a " + toStoreClass);
                }
                return value.asBoolean();
            }
            case NULL: {
                throw new InvalidSPDXAnalysisException("Can not convert a JSON NULL to a stored object");
            }
            case NUMBER: {
                if (propertyType.isPresent()) {
                    Class<?> toStoreClass = SpdxJsonLDContext.XMLSCHEMA_TYPE_TO_JAVA_CLASS.get(propertyType.get());
                    if (Objects.isNull(toStoreClass)) {
                        return value.asInt();
                    }
                    if (String.class.equals(toStoreClass)) {
                        return Double.toString(value.asDouble());
                    }
                    if (Integer.class.equals(toStoreClass)) {
                        return value.asInt();
                    }
                    throw new InvalidSPDXAnalysisException("Can not convert a JSON NUMBER to a " + toStoreClass);
                }
                return value.asInt();
            }
            case OBJECT: {
                if (!propertyType.isPresent()) {
                    throw new InvalidSPDXAnalysisException("Unknown type for property " + property);
                }
                if ("SinglePointer".equals(propertyType.get())) {
                    if (Objects.nonNull(value.get(SpdxConstantsCompatV2.PROP_POINTER_OFFSET.getName()))) {
                        propertyType = Optional.of("ByteOffsetPointer");
                    } else if (Objects.nonNull(value.get(SpdxConstantsCompatV2.PROP_POINTER_LINE_NUMBER.getName()))) {
                        propertyType = Optional.of("LineCharPointer");
                    } else {
                        throw new InvalidSPDXAnalysisException("Can not determine type for snippet pointer");
                    }
                }
                String objectId = this.findObjectIdInJsonObject(documentUri, value);
                this.store.create(documentUri, objectId, propertyType.get());
                this.restoreObjectPropertyValues(documentUri, objectId, value, spdxIdProperties);
                return CompatibleModelStoreWrapper.typedValueFromDocUri((String)documentUri, (String)objectId, (IModelStore)this.store, (String)propertyType.get());
            }
            case STRING: {
                return this.getStringPropertyValueForJsonNode(documentUri, id, property, value, propertyType, spdxIdProperties, list);
            }
        }
        throw new InvalidSPDXAnalysisException("Unsupported JSON node type: " + value);
    }

    private Object getStringPropertyValueForJsonNode(String documentUri, String id, String property, JsonNode value, Optional<String> propertyType, Map<String, String> spdxIdProperties, boolean list) throws InvalidSPDXAnalysisException {
        Class<?> clazz = null;
        if (propertyType.isPresent() && Objects.isNull(clazz = (Class<?>)SpdxModelFactoryCompatV2.SPDX_TYPE_TO_CLASS_V2.get(propertyType.get()))) {
            clazz = SpdxJsonLDContext.XMLSCHEMA_TYPE_TO_JAVA_CLASS.get(propertyType.get());
        }
        if (Objects.isNull(clazz)) {
            return value.asText();
        }
        if (AnyLicenseInfo.class.isAssignableFrom(clazz)) {
            AnyLicenseInfo parsedLicense = LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)value.asText(), (IModelStore)this.store, (String)documentUri, (IModelCopyManager)this.modelCopyManager);
            return ModelObjectHelper.modelObjectToStoredObject((Object)parsedLicense, (IModelStore)this.store, (IModelCopyManager)this.modelCopyManager, null);
        }
        if (SpdxDocument.class.isAssignableFrom(clazz)) {
            String uriValue = value.asText();
            return () -> uriValue;
        }
        if (ReferenceType.class.isAssignableFrom(clazz)) {
            String referenceTypeValue = value.asText();
            try {
                ReferenceType referenceType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(referenceTypeValue);
                if (Objects.nonNull(referenceType)) {
                    return referenceType;
                }
            }
            catch (InvalidSPDXAnalysisException referenceType) {
                // empty catch block
            }
            String uriValue = referenceTypeValue;
            return () -> uriValue;
        }
        if (SpdxElement.class.isAssignableFrom(clazz)) {
            if (list) {
                spdxIdProperties.put(id, MultiFormatStore.collectionPropertyNameToPropertyName(property));
            } else {
                spdxIdProperties.put(id, property);
            }
            return value.asText();
        }
        if (clazz.isEnum()) {
            for (Object enumConst : clazz.getEnumConstants()) {
                if (!(enumConst instanceof IndividualUriValue) || !value.asText().replaceAll("-", "_").equals(enumConst.toString())) continue;
                return new SimpleUriValue((IndividualUriValue)enumConst);
            }
            throw new InvalidSPDXAnalysisException("Could not find enum constants for " + value.asText() + " property " + property);
        }
        if (String.class.equals(clazz)) {
            return value.asText();
        }
        if (Boolean.class.equals(clazz)) {
            try {
                return Boolean.parseBoolean(value.asText());
            }
            catch (Exception ex) {
                throw new InvalidSPDXAnalysisException("Unable to convert " + value.asText() + " to boolean for property " + property);
            }
        }
        if (Integer.class.equals(clazz)) {
            try {
                return Integer.parseInt(value.asText());
            }
            catch (Exception ex) {
                throw new InvalidSPDXAnalysisException("Unable to convert " + value.asText() + " to integer for property " + property);
            }
        }
        throw new InvalidSPDXAnalysisException("Unknown type: " + propertyType.get() + " for property " + property);
    }

    private String findObjectIdInJsonObject(String documentUri, JsonNode jsonObject) throws InvalidSPDXAnalysisException {
        JsonNode retval = jsonObject.get("SPDXID");
        if (Objects.isNull(retval) || !retval.isTextual()) {
            retval = jsonObject.get(SpdxConstantsCompatV2.PROP_LICENSE_ID.getName());
        }
        if (Objects.isNull(retval) || !retval.isTextual()) {
            retval = jsonObject.get(SpdxConstantsCompatV2.PROP_LICENSE_EXCEPTION_ID.getName());
        }
        if (Objects.isNull(retval) || !retval.isTextual()) {
            retval = jsonObject.get("externalDocumentId");
        }
        if (Objects.isNull(retval) || !retval.isTextual()) {
            return this.store.getNextId(IModelStore.IdType.Anonymous, documentUri);
        }
        return retval.asText();
    }

    private Object idToObjectValue(String documentNamespace, String spdxId, Map<String, TypedValue> addedElements) throws InvalidSPDXAnalysisException {
        TypedValue fixedValue = addedElements.get(spdxId);
        if (Objects.isNull(fixedValue)) {
            if (spdxId.equals(SpdxConstantsCompatV2.NONE_VALUE)) {
                return () -> SpdxConstantsCompatV2.URI_VALUE_NONE;
            }
            if (spdxId.equals(SpdxConstantsCompatV2.NOASSERTION_VALUE)) {
                return () -> SpdxConstantsCompatV2.URI_VALUE_NOASSERTION;
            }
            if (spdxId.startsWith("DocumentRef-")) {
                CompatibleModelStoreWrapper modelStore = this.store;
                return () -> this.lambda$idToObjectValue$4(spdxId, (IModelStore)modelStore, documentNamespace);
            }
            throw new InvalidSPDXAnalysisException("No SPDX element found for SPDX ID " + spdxId);
        }
        return fixedValue;
    }

    private /* synthetic */ String lambda$idToObjectValue$4(String spdxId, IModelStore modelStore, String documentNamespace) {
        try {
            return ExternalSpdxElement.externalSpdxElementIdToURI((String)spdxId, (IModelStore)modelStore, (String)documentNamespace, (IModelCopyManager)this.modelCopyManager);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }
}

