/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.library.model.v2.enumerations.AnnotationType;
import org.spdx.storage.IModelStore;

public class Annotation
extends ModelObjectV2
implements Comparable<Annotation> {
    public Annotation() throws InvalidSPDXAnalysisException {
    }

    public Annotation(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public Annotation(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public String getType() {
        return "Annotation";
    }

    public AnnotationType getAnnotationType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsCompatV2.PROP_ANNOTATION_TYPE);
        if (retval.isPresent() && !(retval.get() instanceof AnnotationType)) {
            throw new SpdxInvalidTypeException("Invalid enum type for " + ((Enum)retval.get()).toString());
        }
        if (retval.isPresent()) {
            if (!(retval.get() instanceof AnnotationType)) {
                throw new SpdxInvalidTypeException("Invalid enum type for " + ((Enum)retval.get()).toString());
            }
            return (AnnotationType)((Object)retval.get());
        }
        logger.warn("Missing required annotation type, returning type missing for " + this.getId());
        return AnnotationType.MISSING;
    }

    public Annotation setAnnotationType(AnnotationType type) throws InvalidSPDXAnalysisException {
        if (this.strict && type == null) {
            throw new InvalidSPDXAnalysisException("Annotation type is required - null value for type is not accepted");
        }
        if (AnnotationType.MISSING.equals((Object)type)) {
            throw new InvalidSPDXAnalysisException("Can not set value to MISSING for annotation type.  This is reserved for when the value is not present in the store.");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_ANNOTATION_TYPE, (Object)type);
        return this;
    }

    public String getAnnotator() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_ANNOTATOR);
        if (retval.isPresent()) {
            return (String)retval.get();
        }
        logger.warn("Missing required annotator for " + this.getId());
        return "";
    }

    public Annotation setAnnotator(String annotator) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (annotator == null || annotator.isEmpty()) {
                throw new InvalidSPDXAnalysisException("Annotator is required - can not be null or empty");
            }
            String verify = SpdxVerificationHelper.verifyAnnotator(annotator);
            if (verify != null && !verify.isEmpty()) {
                throw new InvalidSPDXAnalysisException(verify);
            }
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_ANNOTATOR, annotator);
        return this;
    }

    public String getComment() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT);
        if (retval.isPresent()) {
            return (String)retval.get();
        }
        logger.warn("Missing required comment for " + this.getId());
        return "";
    }

    public Annotation setComment(String comment) throws InvalidSPDXAnalysisException {
        if (this.strict && (comment == null || comment.isEmpty())) {
            throw new InvalidSPDXAnalysisException("Comment is required - can not be null or empty");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT, comment);
        return this;
    }

    public String getAnnotationDate() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_ANNOTATION_DATE);
        if (retval.isPresent()) {
            return (String)retval.get();
        }
        logger.warn("Missing required annotation date for " + this.getId());
        return "";
    }

    public Annotation setAnnotationDate(String date) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (date == null || date.isEmpty()) {
                throw new InvalidSPDXAnalysisException("Date is required - can not be null or empty");
            }
            String dateVerify = SpdxVerificationHelper.verifyDate(date);
            if (dateVerify != null && !dateVerify.isEmpty()) {
                throw new InvalidSPDXAnalysisException(dateVerify);
            }
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_ANNOTATION_DATE, date);
        return this;
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            if (AnnotationType.MISSING.equals((Object)this.getAnnotationType())) {
                retval.add("Missing annotationtype for Annotation");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting annotationtype for Annotation: " + e.getMessage());
        }
        try {
            String annotator = this.getAnnotator();
            String v = SpdxVerificationHelper.verifyAnnotator(annotator);
            if (v != null && !v.isEmpty()) {
                retval.add(v + ":" + annotator);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting annotator for Annotation: " + e.getMessage());
        }
        try {
            if (this.getComment().isEmpty()) {
                retval.add("Missing required comment for Annotation");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting comment for Annotation: " + e.getMessage());
        }
        try {
            String date = this.getAnnotationDate();
            if (date.isEmpty()) {
                retval.add("Missing required date for Annotation");
            } else {
                String dateVerify = SpdxVerificationHelper.verifyDate(date);
                if (dateVerify != null && !dateVerify.isEmpty()) {
                    retval.add(dateVerify);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting date for Annotation: " + e.getMessage());
        }
        return retval;
    }

    @Override
    public int compareTo(Annotation o) {
        try {
            if (o == null) {
                return 1;
            }
            if (o.getAnnotationDate() == null && this.getAnnotationDate() != null) {
                return 1;
            }
            if (this.getAnnotationDate() == null) {
                return -1;
            }
            int retval = this.getAnnotationDate().compareTo(o.getAnnotationDate());
            if (retval != 0) {
                return retval;
            }
            if (o.getAnnotator() == null && this.getAnnotator() != null) {
                return 1;
            }
            if (this.getAnnotator() == null) {
                return -1;
            }
            retval = this.getAnnotator().compareToIgnoreCase(o.getAnnotator());
            if (retval != 0) {
                return retval;
            }
            if (o.getAnnotationType() == null && this.getAnnotationType() != null) {
                return 1;
            }
            if (this.getAnnotationType() == null) {
                return -1;
            }
            return this.getAnnotationType().compareTo(o.getAnnotationType());
        }
        catch (InvalidSPDXAnalysisException ex) {
            logger.warn("Error when comparing", (Throwable)ex);
            return -1;
        }
    }
}

