/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SimpleUriValue;
import org.spdx.library.model.v2.Annotation;
import org.spdx.library.model.v2.ExternalDocumentRef;
import org.spdx.library.model.v2.Relationship;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.storage.IModelStore;
import org.spdx.storage.compatv2.CompatibleModelStoreWrapper;

public class ExternalSpdxElement
extends SpdxElement
implements IndividualUriValue {
    static final Logger logger = LoggerFactory.getLogger(ExternalSpdxElement.class);
    private Collection<Relationship> relationships = new ArrayList<Relationship>();

    public ExternalSpdxElement(String documentUri, String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), ExternalSpdxElement.checkConvertDocumentUri(documentUri, id, DefaultModelStore.getDefaultModelStore()), ExternalSpdxElement.checkConvertId(id), DefaultModelStore.getDefaultCopyManager());
    }

    public ExternalSpdxElement(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, ExternalSpdxElement.checkConvertDocumentUri(documentUri, id, modelStore), ExternalSpdxElement.checkConvertId(id), copyManager, true);
    }

    public ExternalSpdxElement(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        super(modelStore, ExternalSpdxElement.checkConvertDocumentUri(documentUri, id, modelStore), ExternalSpdxElement.checkConvertId(id), copyManager, true);
    }

    private static String checkConvertDocumentUri(String documentUri, String id, IModelStore modelStore) throws InvalidSPDXAnalysisException {
        if (id.contains(":")) {
            String externalUri = ExternalSpdxElement.externalSpdxElementIdToURI(id, modelStore, documentUri, null);
            return externalUri.substring(0, externalUri.indexOf(35));
        }
        return documentUri;
    }

    private static String checkConvertId(String id) {
        if (id.contains(":")) {
            return id.substring(id.lastIndexOf(58) + 1);
        }
        return id;
    }

    public String getExternalDocumentId(SpdxDocument documentReferencingExternal) throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(this.getObjectUri());
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid URI format: " + this.getObjectUri() + ".  Expects namespace#SPDXRef-XXX");
        }
        Optional<ExternalDocumentRef> externalDocRef = ExternalDocumentRef.getExternalDocRefByDocNamespace(documentReferencingExternal.getModelStore(), documentReferencingExternal.getDocumentUri(), matcher.group(1), documentReferencingExternal.getCopyManager(), documentReferencingExternal.getSpecVersion());
        if (!externalDocRef.isPresent()) {
            logger.error("Could not find or create the external document reference for document namespace " + matcher.group(1));
            throw new InvalidSPDXAnalysisException("Could not find or create the external document reference for document namespace " + matcher.group(1));
        }
        return externalDocRef.get().getId();
    }

    public boolean isExternal() {
        return true;
    }

    public String getExternalElementId() throws InvalidSPDXAnalysisException {
        return this.getId();
    }

    public String getType() {
        return "ExternalSpdxElement";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        String objectUri = this.getObjectUri();
        Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(objectUri);
        if (!matcher.matches()) {
            retval.add("Invalid objectUri format for an external document reference.  Must be of the form " + SpdxConstantsCompatV2.EXTERNAL_ELEMENT_REF_PATTERN.pattern());
        }
        return retval;
    }

    public String referenceElementId(SpdxDocument documentReferencingExternal) throws InvalidSPDXAnalysisException {
        return ExternalSpdxElement.uriToExternalSpdxElementReference(this.getObjectUri(), documentReferencingExternal.getModelStore(), documentReferencingExternal.getDocumentUri(), documentReferencingExternal.getCopyManager(), documentReferencingExternal.getSpecVersion());
    }

    public static String externalSpdxElementIdToURI(String externalSpdxElementId, IModelStore stModelStore, String stDocumentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_ELEMENT_REF_PATTERN.matcher(externalSpdxElementId);
        if (!matcher.matches()) {
            logger.error("Invalid objectUri format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
            throw new InvalidSPDXAnalysisException("Invalid objectUri format for an external document reference.  Must be of the form ExternalSPDXRef:SPDXID");
        }
        String externalDocumentUri = ExternalSpdxElement.externalDocumentIdToNamespace(matcher.group(1), stModelStore, stDocumentUri, copyManager);
        if (externalDocumentUri.endsWith("#")) {
            return externalDocumentUri + matcher.group(2);
        }
        return externalDocumentUri + "#" + matcher.group(2);
    }

    public static String uriToExternalSpdxElementReference(String uri, IModelStore stModelStore, String stDocumentUri, IModelCopyManager copyManager, String specVersion) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(uri, "URI can not be null");
        Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(uri);
        if (!matcher.matches()) {
            throw new InvalidSPDXAnalysisException("Invalid URI format: " + uri + ".  Expects namespace#SPDXRef-XXX");
        }
        Optional<ExternalDocumentRef> externalDocRef = ExternalDocumentRef.getExternalDocRefByDocNamespace(stModelStore, stDocumentUri, matcher.group(1), copyManager, specVersion);
        if (!externalDocRef.isPresent()) {
            logger.error("Could not find or create the external document reference for document namespace " + matcher.group(1));
            throw new InvalidSPDXAnalysisException("Could not find or create the external document reference for document namespace " + matcher.group(1));
        }
        return externalDocRef.get().getId() + ":" + matcher.group(2);
    }

    public static String externalDocumentIdToNamespace(String externalDocumentId, IModelStore stModelStore, String stDocumentUri, IModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Optional retval = stModelStore.getValue(CompatibleModelStoreWrapper.documentUriIdToUri(stDocumentUri, externalDocumentId, false), SpdxConstantsCompatV2.PROP_EXTERNAL_SPDX_DOCUMENT);
        if (!retval.isPresent()) {
            throw new InvalidSPDXAnalysisException("No external document reference exists for document ID " + externalDocumentId);
        }
        if (!(retval.get() instanceof IndividualUriValue)) {
            logger.error("Invalid type returned for external document.  Expected IndividualValue, actual " + retval.get().getClass().toString());
            throw new InvalidSPDXAnalysisException("Invalid type returned for external document.");
        }
        return ((IndividualUriValue)retval.get()).getIndividualURI();
    }

    public boolean equivalent(CoreModelObject compare) {
        if (!(compare instanceof ExternalSpdxElement)) {
            return false;
        }
        return this.getObjectUri().equals(compare.getObjectUri());
    }

    public boolean equivalent(CoreModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        return this.equivalent(compare);
    }

    public String getIndividualURI() {
        return this.getObjectUri();
    }

    @Override
    public boolean addAnnotation(Annotation annotation) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not add annotations to an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public boolean addRelationship(Relationship relationship) throws InvalidSPDXAnalysisException {
        logger.warn("Adding a relationship to an external SPDX element will not be preserved during serialization");
        return this.relationships.add(relationship);
    }

    @Override
    public void setComment(String comment) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set comment on an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public ExternalSpdxElement setName(String name) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set the name on an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public Collection<Annotation> getAnnotations() throws InvalidSPDXAnalysisException {
        return new ArrayList<Annotation>();
    }

    @Override
    public SpdxElement setAnnotations(Collection<Annotation> annotations) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can not set annotations to an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public boolean removeAnnotation(Annotation annotation) throws InvalidSPDXAnalysisException {
        throw new InvalidSPDXAnalysisException("Can remove set annotations to an ExternalSpdxElement.  These changes must be done to the local SPDX element in the document which defines the SPDX element.");
    }

    @Override
    public Collection<Relationship> getRelationships() throws InvalidSPDXAnalysisException {
        return this.relationships;
    }

    @Override
    public SpdxElement setRelationships(Collection<Relationship> relationships) throws InvalidSPDXAnalysisException {
        logger.warn("Setting relationships on an external SPDX element will not be preserved during serialization");
        this.relationships = relationships;
        return this;
    }

    @Override
    public boolean removeRelationship(Relationship relationship) throws InvalidSPDXAnalysisException {
        logger.warn("Removing a relationship on an external SPDX element will not be preserved during serialization");
        return this.relationships.remove(relationship);
    }

    @Override
    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return Optional.empty();
    }

    @Override
    public Optional<String> getName() throws InvalidSPDXAnalysisException {
        return Optional.empty();
    }

    @Override
    public boolean equals(Object comp) {
        return SimpleUriValue.isIndividualUriValueEquals((IndividualUriValue)this, (Object)comp);
    }

    @Override
    public int hashCode() {
        return SimpleUriValue.getIndividualUriValueHash((IndividualUriValue)this);
    }
}

