/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelRegistry;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.library.model.v2.ExternalDocumentRef;
import org.spdx.library.model.v2.RelatedElementCollection;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxCreatorInformation;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxItem;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.library.model.v2.enumerations.RelationshipType;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.ExtractedLicenseInfo;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v2.license.SpdxNoneLicense;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;

public class SpdxDocument
extends SpdxElement {
    Collection<SpdxElement> documentDescribes;
    Collection<ExternalDocumentRef> externalDocumentRefs;
    Collection<ExtractedLicenseInfo> extractedLicenseInfos;

    public SpdxDocument(IModelStore modelStore, String documentUri, IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, "SPDXRef-DOCUMENT", copyManager, create);
        Optional docSpecVersion = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_SPDX_SPEC_VERSION);
        if (docSpecVersion.isPresent()) {
            this.specVersion = (String)docSpecVersion.get();
        }
        this.externalDocumentRefs = this.getObjectPropertyValueSet(SpdxConstantsCompatV2.PROP_SPDX_EXTERNAL_DOC_REF, ExternalDocumentRef.class);
        HashMap<String, ExternalDocumentRef> documentUrisToExternalDocRef = new HashMap<String, ExternalDocumentRef>();
        for (ExternalDocumentRef docRef : this.externalDocumentRefs) {
            documentUrisToExternalDocRef.put(docRef.getSpdxDocumentNamespace(), docRef);
        }
        this.documentDescribes = new RelatedElementCollection(this, RelationshipType.DESCRIBES, null, this.specVersion);
        this.extractedLicenseInfos = this.getObjectPropertyValueSet(SpdxConstantsCompatV2.PROP_SPDX_EXTRACTED_LICENSES, ExtractedLicenseInfo.class);
    }

    public SpdxDocument(String documentUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), documentUri, DefaultModelStore.getDefaultCopyManager(), true);
    }

    public String getType() {
        return "SpdxDocument";
    }

    @Override
    protected PropertyDescriptor getNamePropertyDescriptor() {
        return SpdxConstantsCompatV2.PROP_NAME;
    }

    public Collection<SpdxElement> getDocumentDescribes() throws InvalidSPDXAnalysisException {
        return this.documentDescribes;
    }

    public SpdxDocument setDocumentDescribes(List<SpdxItem> documentDescribes) {
        Objects.requireNonNull(documentDescribes, "Document describes can not be null");
        this.documentDescribes.clear();
        this.documentDescribes.addAll(documentDescribes);
        return this;
    }

    @Nullable
    public SpdxCreatorInformation getCreationInfo() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsCompatV2.PROP_SPDX_CREATION_INFO);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof SpdxCreatorInformation)) {
                throw new SpdxInvalidTypeException("Invalid tpe for CreationInfo: " + retval.get().getClass().toString());
            }
            return (SpdxCreatorInformation)((Object)retval.get());
        }
        return null;
    }

    public void setCreationInfo(SpdxCreatorInformation creationInfo) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull((Object)creationInfo)) {
            throw new InvalidSPDXAnalysisException("Can not set required creation info to null");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_SPDX_CREATION_INFO, (Object)creationInfo);
    }

    public AnyLicenseInfo getDataLicense() throws InvalidSPDXAnalysisException {
        Optional<AnyLicenseInfo> retval = this.getAnyLicenseInfoPropertyValue(SpdxConstantsCompatV2.PROP_SPDX_DATA_LICENSE);
        if (retval.isPresent()) {
            return retval.get();
        }
        logger.warn("No data license for " + this.getName());
        return new SpdxNoneLicense(this.getModelStore(), this.getDocumentUri());
    }

    public void setDataLicense(AnyLicenseInfo dataLicense) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (Objects.isNull((Object)dataLicense)) {
                throw new InvalidSPDXAnalysisException("Can not set required data license to null");
            }
            if (!(dataLicense instanceof SpdxListedLicense)) {
                throw new InvalidSPDXAnalysisException("Invalid license type for data license - must be an SPDX Listed license");
            }
            if (!((SpdxListedLicense)dataLicense).getLicenseId().equals("CC0-1.0")) {
                throw new InvalidSPDXAnalysisException("Incorrect data license.  Must be CC0-1.0");
            }
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_SPDX_DATA_LICENSE, (Object)dataLicense);
    }

    public Collection<ExternalDocumentRef> getExternalDocumentRefs() throws InvalidSPDXAnalysisException {
        return this.externalDocumentRefs;
    }

    public Collection<ExtractedLicenseInfo> getExtractedLicenseInfos() throws InvalidSPDXAnalysisException {
        return this.extractedLicenseInfos;
    }

    public boolean addExtractedLicenseInfos(ExtractedLicenseInfo licenseInfo) {
        Objects.requireNonNull(licenseInfo, "License info can not be null");
        return this.extractedLicenseInfos.add(licenseInfo);
    }

    public SpdxDocument setExtractedLicenseInfos(List<ExtractedLicenseInfo> extractedLicenseInfos) {
        Objects.requireNonNull(extractedLicenseInfos, "Extracted license infos can not be null");
        this.extractedLicenseInfos.clear();
        this.extractedLicenseInfos.addAll(extractedLicenseInfos);
        return this;
    }

    public void setSpecVersion(String specVersion) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(specVersion)) {
            throw new InvalidSPDXAnalysisException("Can not set required spec version to null");
        }
        String verify = SpdxVerificationHelper.verifySpdxVersion(specVersion);
        if (Objects.nonNull(verify) && !verify.isEmpty()) {
            throw new InvalidSPDXAnalysisException(verify);
        }
        if (!ModelRegistry.getModelRegistry().containsSpecVersion(specVersion)) {
            throw new InvalidSPDXAnalysisException("Spec version " + specVersion + " is not implemented");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_SPDX_SPEC_VERSION, specVersion);
        this.specVersion = specVersion;
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String verifySpecVersion) {
        String specVersion;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            specVersion = this.getSpecVersion();
            if (specVersion.isEmpty()) {
                retval.add("Missing required SPDX version");
                specVersion = verifySpecVersion;
            } else {
                String verify = SpdxVerificationHelper.verifySpdxVersion(specVersion);
                if (verify != null) {
                    retval.add(verify);
                    specVersion = verifySpecVersion;
                }
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Exception getting specVersion: " + e2.getMessage());
            specVersion = "SPDX-2.3";
        }
        retval.addAll(super._verify(verifiedIds, specVersion));
        try {
            Optional<String> name = this.getName();
            if (!name.isPresent() || name.get().isEmpty()) {
                retval.add("Missing required document name");
            }
        }
        catch (InvalidSPDXAnalysisException e1) {
            retval.add("Error getting document name");
        }
        try {
            SpdxCreatorInformation creator = this.getCreationInfo();
            if (Objects.isNull((Object)creator)) {
                retval.add("Missing required Creator");
            } else {
                retval.addAll(creator.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting creator information: " + e.getMessage());
        }
        try {
            for (ExtractedLicenseInfo licInfo : this.getExtractedLicenseInfos()) {
                retval.addAll(licInfo.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting extracted licensing info: " + e.getMessage());
        }
        try {
            AnyLicenseInfo dataLicense = this.getDataLicense();
            if (dataLicense.toString().equals("NONE")) {
                retval.add("Missing required data license");
            } else if (!(dataLicense instanceof SpdxListedLicense)) {
                retval.add("Invalid license type for data license - must be an SPDX Listed license");
            } else if (!((SpdxListedLicense)dataLicense).getLicenseId().equals("CC0-1.0")) {
                retval.add("Incorrect data license for SPDX version 1.0 document - found " + ((SpdxListedLicense)dataLicense).getLicenseId() + ", expected " + "CC0-1.0");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting data license: " + e.getMessage());
        }
        try {
            for (ExternalDocumentRef externalRef : this.getExternalDocumentRefs()) {
                retval.addAll(externalRef.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting external document references: " + e.getMessage());
        }
        try {
            if (this.getDocumentDescribes().size() == 0 && this.getModelStore().getAllItems(this.getDocumentUri(), "Package").count() != 1L) {
                retval.add("Document must have at least one relationship of type DOCUMENT_DESCRIBES or contain only a single SpdxPackage");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting document describes: " + e.getMessage());
        }
        try {
            URI e = new URI(this.getDocumentUri());
        }
        catch (URISyntaxException e) {
            retval.add(String.format("Document namespace %s is not a valid URI", this.getDocumentUri()));
        }
        return retval;
    }

    public SpdxDocument setExternalDocumentRefs(Collection<ExternalDocumentRef> externalDocumentRefs) {
        Objects.requireNonNull(externalDocumentRefs, "External document refs can not be null");
        this.externalDocumentRefs.clear();
        this.externalDocumentRefs.addAll(externalDocumentRefs);
        return this;
    }
}

