/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.Annotation;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.Relationship;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxVerificationHelper;
import org.spdx.storage.IModelStore;
import org.spdx.storage.PropertyDescriptor;

public abstract class SpdxElement
extends ModelObjectV2 {
    static final Logger logger = LoggerFactory.getLogger(SpdxElement.class);
    private Collection<Annotation> annotations = null;
    private Collection<Relationship> relationships = null;

    public SpdxElement() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public SpdxElement(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    public SpdxElement(IModelStore modelStore, String documentUri, String id, IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedElementIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        if (verifiedElementIds.contains(this.objectUri)) {
            return retval;
        }
        verifiedElementIds.add(this.getId());
        IModelStore.IdType idType = this.getModelStore().getIdType(this.getObjectUri());
        if (IModelStore.IdType.SpdxId.equals((Object)idType)) {
            if (!SpdxVerificationHelper.verifySpdxId(this.getId())) {
                retval.add("Invalid SPDX ID: " + this.getId() + ".  Must match the pattern " + SpdxConstantsCompatV2.SPDX_ELEMENT_REF_PATTERN);
            }
        } else if (!IModelStore.IdType.Anonymous.equals((Object)idType)) {
            retval.add("Invalid ID for SPDX Element: " + this.getId() + ".  Must be either a valid SPDX ID or Anonymous.");
        }
        try {
            retval.addAll(this.verifyCollection(this.getAnnotations(), "Annotation Error: ", verifiedElementIds, specVersion));
        }
        catch (InvalidSPDXAnalysisException e1) {
            retval.add("Error getting annotation: " + e1.getMessage());
        }
        try {
            retval.addAll(this.verifyCollection(this.getRelationships(), "Relationship error: ", verifiedElementIds, specVersion));
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting relationships: " + e.getMessage());
        }
        this.addNameToWarnings(retval);
        return retval;
    }

    private synchronized void checkCreateAnnotations() throws InvalidSPDXAnalysisException {
        if (Objects.isNull(this.annotations)) {
            this.annotations = this.getObjectPropertyValueSet(SpdxConstantsCompatV2.PROP_ANNOTATION, Annotation.class);
        }
    }

    private synchronized void checkCreateRelationships() throws InvalidSPDXAnalysisException {
        if (Objects.isNull(this.relationships)) {
            this.relationships = this.getObjectPropertyValueSet(SpdxConstantsCompatV2.PROP_RELATIONSHIP, Relationship.class);
        }
    }

    protected List<String> addNameToWarnings(List<String> warnings) {
        if (warnings == null) {
            return new ArrayList<String>();
        }
        if (warnings.isEmpty()) {
            return warnings;
        }
        String localName = "[UNKNOWN]";
        try {
            Optional<String> name = this.getName();
            if (name.isPresent()) {
                localName = name.get();
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting name", (Throwable)e);
        }
        for (int i = 0; i < warnings.size(); ++i) {
            warnings.set(i, warnings.get(i) + " in " + localName);
        }
        return warnings;
    }

    public Collection<Annotation> getAnnotations() throws InvalidSPDXAnalysisException {
        this.checkCreateAnnotations();
        return this.annotations;
    }

    public SpdxElement setAnnotations(Collection<Annotation> annotations) throws InvalidSPDXAnalysisException {
        this.checkCreateAnnotations();
        Objects.requireNonNull(annotations, "Annotations can not be null");
        this.annotations.clear();
        this.annotations.addAll(annotations);
        return this;
    }

    public boolean addAnnotation(Annotation annotation) throws InvalidSPDXAnalysisException {
        this.checkCreateAnnotations();
        return this.annotations.add(annotation);
    }

    public boolean removeAnnotation(Annotation annotation) throws InvalidSPDXAnalysisException {
        this.checkCreateAnnotations();
        return this.annotations.remove(annotation);
    }

    public Collection<Relationship> getRelationships() throws InvalidSPDXAnalysisException {
        this.checkCreateRelationships();
        return this.relationships;
    }

    public SpdxElement setRelationships(Collection<Relationship> relationships) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(relationships, "Relationships can not be null");
        this.checkCreateRelationships();
        this.relationships.clear();
        this.relationships.addAll(relationships);
        return this;
    }

    public boolean addRelationship(Relationship relationship) throws InvalidSPDXAnalysisException {
        this.checkCreateRelationships();
        return this.relationships.add(relationship);
    }

    public boolean removeRelationship(Relationship relationship) throws InvalidSPDXAnalysisException {
        this.checkCreateRelationships();
        return this.relationships.remove(relationship);
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT);
    }

    public void setComment(String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.RDFS_PROP_COMMENT, comment);
    }

    protected PropertyDescriptor getNamePropertyDescriptor() {
        return SpdxConstantsCompatV2.PROP_NAME;
    }

    public Optional<String> getName() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(this.getNamePropertyDescriptor());
    }

    public SpdxElement setName(String name) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(this.getNamePropertyDescriptor(), name);
        return this;
    }
}

