/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.ISpdxModelInfo;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.ExternalSpdxElement;
import org.spdx.library.model.v2.ReferenceType;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxModelFactoryCompatV2;
import org.spdx.library.model.v2.SpdxNoAssertion;
import org.spdx.library.model.v2.SpdxNoAssertionElement;
import org.spdx.library.model.v2.SpdxNone;
import org.spdx.library.model.v2.SpdxNoneElement;
import org.spdx.library.model.v2.enumerations.SpdxEnumFactoryCompatV2;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.ExternalExtractedLicenseInfo;
import org.spdx.library.model.v2.license.ExtractedLicenseInfo;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v2.license.SpdxNoAssertionLicense;
import org.spdx.library.model.v2.license.SpdxNoneLicense;
import org.spdx.storage.IModelStore;

public class SpdxModelInfoV2_X
implements ISpdxModelInfo {
    static final Logger logger = LoggerFactory.getLogger(SpdxModelInfoV2_X.class);

    @Nullable
    public CoreModelObject createExternalElement(IModelStore store, String uri, IModelCopyManager copyManager, Class<?> type, String specVersion) throws InvalidSPDXAnalysisException {
        Matcher licenseMatcher = SpdxConstantsCompatV2.EXTERNAL_EXTRACTED_LICENSE_URI_PATTERN.matcher(uri);
        if (licenseMatcher.matches()) {
            return new ExternalExtractedLicenseInfo(store, licenseMatcher.group(1), licenseMatcher.group(2), copyManager);
        }
        Matcher elementMatcher = SpdxConstantsCompatV2.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(uri);
        if (elementMatcher.matches()) {
            return new ExternalSpdxElement(store, elementMatcher.group(1), elementMatcher.group(2), copyManager);
        }
        return null;
    }

    public List<String> getSpecVersions() {
        return Arrays.asList("SPDX-2.0", "SPDX-2.1", "SPDX-2.2", "SPDX-2.2.1", "SPDX-2.3");
    }

    public Map<String, Enum<?>> getUriToEnumMap() {
        return SpdxEnumFactoryCompatV2.uriToEnum;
    }

    @Nullable
    public Object uriToIndividual(String uri, @Nullable Class<?> type) {
        if (SpdxConstantsCompatV2.URI_VALUE_NONE.equals(uri)) {
            if (Objects.nonNull(type)) {
                if (type.isAssignableFrom(AnyLicenseInfo.class)) {
                    try {
                        return new SpdxNoneLicense();
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        logger.warn("Error creating SPDX None License", (Throwable)e);
                        return new SpdxNone();
                    }
                }
                if (type.isAssignableFrom(SpdxElement.class)) {
                    try {
                        return new SpdxNoneElement();
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        logger.warn("Error creating SPDX None Element", (Throwable)e);
                        return new SpdxNone();
                    }
                }
            }
            return new SpdxNone();
        }
        if (SpdxConstantsCompatV2.URI_VALUE_NOASSERTION.equals(uri)) {
            if (Objects.nonNull(type)) {
                if (type.isAssignableFrom(AnyLicenseInfo.class)) {
                    try {
                        return new SpdxNoAssertionLicense();
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        logger.warn("Error creating SPDX NoAssertion License", (Throwable)e);
                        return new SpdxNone();
                    }
                }
                if (type.isAssignableFrom(SpdxElement.class)) {
                    try {
                        return new SpdxNoAssertionElement();
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        logger.warn("Error creating SPDX NoAssertion Element", (Throwable)e);
                        return new SpdxNone();
                    }
                }
            }
            return new SpdxNoAssertion();
        }
        if (SpdxConstantsCompatV2.REFERENCE_TYPE_URI_PATTERN.matcher(uri).matches()) {
            try {
                return new ReferenceType(uri);
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.error("Error converting URI to reference type", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public CoreModelObject createModelObject(IModelStore modelStore, String objectUri, String type, IModelCopyManager copyManager, String specVersion, boolean create, String prefix) throws InvalidSPDXAnalysisException {
        String id;
        String documentUri;
        if (!SpdxModelFactoryCompatV2.SPDX_TYPE_TO_CLASS_V2.containsKey(type)) {
            logger.error(type + " not a supported type for SPDX spec version 2.X");
            throw new InvalidSPDXAnalysisException(type + " not a supported type for SPDX spec version 2.X");
        }
        Class<?> typeClass = SpdxModelFactoryCompatV2.SPDX_TYPE_TO_CLASS_V2.get(type);
        if (SpdxListedLicense.class.isAssignableFrom(typeClass)) {
            String id2;
            if (objectUri.startsWith("http://spdx.org/licenses/")) {
                id2 = objectUri.substring("http://spdx.org/licenses/".length());
            } else if (objectUri.startsWith("https://spdx.org/licenses/")) {
                logger.warn("Incorrect namespace for Listed License - 'https:' is used rather than 'http:'");
                id2 = objectUri.substring("https://spdx.org/licenses/".length());
            } else {
                logger.error("'" + objectUri + "' Listed license URI does not start with " + "http://spdx.org/licenses/" + ".");
                throw new InvalidSPDXAnalysisException("'" + objectUri + "' Listed license URI does not start with " + "http://spdx.org/licenses/" + ".");
            }
            return SpdxModelFactoryCompatV2.getModelObjectV2(modelStore, "http://spdx.org/licenses/", id2, "ListedLicense", copyManager, true);
        }
        if (LicenseException.class.isAssignableFrom(typeClass)) {
            if (!objectUri.startsWith("http://spdx.org/licenses/")) {
                logger.error("'" + objectUri + "' Listed license exception URI does not start with " + "http://spdx.org/licenses/" + ".");
                throw new InvalidSPDXAnalysisException("'" + objectUri + "' Listed exception license URI does not start with " + "http://spdx.org/licenses/" + ".");
            }
            String id3 = objectUri.substring("http://spdx.org/licenses/".length());
            return SpdxModelFactoryCompatV2.getModelObjectV2(modelStore, "http://spdx.org/licenses/", id3, "ListedLicenseException", copyManager, true);
        }
        if (SpdxElement.class.isAssignableFrom(typeClass)) {
            if (modelStore.isAnon(objectUri)) {
                logger.error("SPDX elements must not be anonymous types - missing ID for " + objectUri);
                throw new InvalidSPDXAnalysisException("SPDX elements must not be anonymous types - missing ID for " + objectUri);
            }
            Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(objectUri);
            if (!matcher.matches()) {
                throw new InvalidSPDXAnalysisException("Element object URI does not follow the SPDX V2.X required pattern" + SpdxConstantsCompatV2.EXTERNAL_SPDX_ELEMENT_URI_PATTERN);
            }
            return SpdxModelFactoryCompatV2.getModelObjectV2(modelStore, matcher.group(1), matcher.group(2), type, copyManager, create);
        }
        if (ExtractedLicenseInfo.class.isAssignableFrom(typeClass)) {
            if (IModelStore.IdType.Anonymous.equals((Object)modelStore.getIdType(objectUri))) {
                logger.error("Extracted licenses must not be anonymous types - missing ID for " + objectUri);
                throw new InvalidSPDXAnalysisException("Extracted licenses must not be anonymous types - missing ID for " + objectUri);
            }
            Matcher matcher = SpdxConstantsCompatV2.EXTERNAL_EXTRACTED_LICENSE_URI_PATTERN.matcher(objectUri);
            if (!matcher.matches()) {
                throw new InvalidSPDXAnalysisException("ExtractedLicenseInfo object URI does not follow the SPDX V2.X required pattern" + SpdxConstantsCompatV2.EXTERNAL_EXTRACTED_LICENSE_URI_PATTERN);
            }
            return SpdxModelFactoryCompatV2.getModelObjectV2(modelStore, matcher.group(1), matcher.group(2), type, copyManager, create);
        }
        if (objectUri.contains("#")) {
            int index = objectUri.lastIndexOf(35);
            documentUri = objectUri.substring(0, index);
            id = objectUri.substring(index + 1);
        } else if (Objects.nonNull(prefix)) {
            documentUri = prefix.endsWith("#") ? prefix.substring(0, prefix.length() - 1) : prefix;
            id = objectUri;
        } else {
            documentUri = DefaultModelStore.getDefaultDocumentUri();
            id = objectUri;
        }
        return SpdxModelFactoryCompatV2.getModelObjectV2(modelStore, documentUri, id, type, copyManager, create);
    }

    public Map<String, Class<?>> getTypeToClassMap() {
        return SpdxModelFactoryCompatV2.SPDX_TYPE_TO_CLASS_V2;
    }

    public boolean canBeExternal(Class<?> clazz) {
        return AnyLicenseInfo.class.isAssignableFrom(clazz) || Element.class.isAssignableFrom(clazz);
    }
}

