/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.ModelObjectV2;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.storage.IModelStore;

public class CrossRef
extends ModelObjectV2 {
    public CrossRef() throws InvalidSPDXAnalysisException {
    }

    public CrossRef(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public CrossRef(IModelStore modelStore, String documentUri, String id, IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    protected CrossRef(CrossRefBuilder builder) throws InvalidSPDXAnalysisException {
        this(builder.modelStore, builder.documentUri, builder.id, builder.copyManager, true);
        this.setLive(builder.live);
        this.setMatch(builder.match);
        this.setOrder(builder.order);
        this.setTimestamp(builder.timestamp);
        this.setUrl(builder.url);
        this.setValid(builder.valid);
        this.setIsWayBackLink(builder.wayBackLink);
    }

    public String getType() {
        return "CrossRef";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Optional url = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_URL);
            if (!url.isPresent()) {
                retval.add("Missing required URL");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting URL property value: " + e.getMessage());
        }
        return retval;
    }

    public Optional<String> getMatch() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_MATCH);
    }

    public void setMatch(@Nullable String match) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_MATCH, match);
    }

    public Optional<String> getUrl() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_URL);
    }

    public void setUrl(String url) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            Objects.requireNonNull(url, "URL must not be null");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_URL, url);
    }

    public Optional<Boolean> getValid() throws InvalidSPDXAnalysisException {
        return this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_IS_VALID);
    }

    public void setValid(@Nullable Boolean isValid) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_IS_VALID, isValid);
    }

    public Optional<Boolean> getLive() throws InvalidSPDXAnalysisException {
        return this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_IS_LIVE);
    }

    public void setLive(Boolean isLive) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_IS_LIVE, isLive);
    }

    public Optional<String> getTimestamp() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_TIMESTAMP);
    }

    public void setTimestamp(String timestamp) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_TIMESTAMP, timestamp);
    }

    public Optional<Boolean> getIsWayBackLink() throws InvalidSPDXAnalysisException {
        return this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_WAYBACK_LINK);
    }

    public void setIsWayBackLink(Boolean isWayBackLink) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_WAYBACK_LINK, isWayBackLink);
    }

    public Optional<Integer> getOrder() throws InvalidSPDXAnalysisException {
        return this.getIntegerPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_ORDER);
    }

    public void setOrder(Integer order) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_ORDER, order);
    }

    public void setDetails(@Nullable Boolean isValid, @Nullable Boolean isLive, @Nullable Boolean isWayBackLink, @Nullable String match, @Nullable String timestamp) throws InvalidSPDXAnalysisException {
        this.setValid(isValid);
        this.setLive(isLive);
        this.setIsWayBackLink(isWayBackLink);
        this.setMatch(match);
        this.setTimestamp(timestamp);
    }

    @Override
    public String toString() {
        String timestamp;
        String match;
        String isWayBackLink;
        String isLive;
        String isValid;
        String url;
        try {
            Optional oUrl = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_URL);
            url = oUrl.isPresent() ? (String)oUrl.get() : "N/A";
        }
        catch (InvalidSPDXAnalysisException e) {
            url = "N/A";
        }
        try {
            Optional oIsValid = this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_IS_VALID);
            isValid = oIsValid.isPresent() ? ((Boolean)oIsValid.get()).toString() : "N/A";
        }
        catch (InvalidSPDXAnalysisException e) {
            isValid = "N/A";
        }
        try {
            Optional oIsLive = this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_IS_LIVE);
            isLive = oIsLive.isPresent() ? ((Boolean)oIsLive.get()).toString() : "N/A";
        }
        catch (InvalidSPDXAnalysisException e) {
            isLive = "N/A";
        }
        try {
            Optional oWayback = this.getBooleanPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_WAYBACK_LINK);
            isWayBackLink = oWayback.isPresent() ? ((Boolean)oWayback.get()).toString() : "N/A";
        }
        catch (InvalidSPDXAnalysisException e) {
            isWayBackLink = "N/A";
        }
        try {
            Optional oMatch = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_MATCH);
            match = oMatch.isPresent() ? (String)oMatch.get() : "N/A";
        }
        catch (InvalidSPDXAnalysisException e) {
            match = "N/A";
        }
        try {
            Optional oTimestamp = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_CROSS_REF_TIMESTAMP);
            timestamp = oTimestamp.isPresent() ? (String)oTimestamp.get() : "N/A";
        }
        catch (InvalidSPDXAnalysisException e) {
            timestamp = "N/A";
        }
        String crossRefDetails = String.format("{%s: %s,%s: %s,%s: %s,%s: %s,%s: %s,%s: %s}", SpdxConstantsCompatV2.PROP_CROSS_REF_URL, url, SpdxConstantsCompatV2.PROP_CROSS_REF_IS_VALID, isValid, SpdxConstantsCompatV2.PROP_CROSS_REF_IS_LIVE, isLive, SpdxConstantsCompatV2.PROP_CROSS_REF_WAYBACK_LINK, isWayBackLink, SpdxConstantsCompatV2.PROP_CROSS_REF_MATCH, match, SpdxConstantsCompatV2.PROP_CROSS_REF_TIMESTAMP, timestamp);
        return crossRefDetails;
    }

    public static class CrossRefBuilder {
        IModelStore modelStore;
        String documentUri;
        String id;
        IModelCopyManager copyManager;
        String url;
        String match;
        Boolean valid;
        Boolean live;
        String timestamp;
        Boolean wayBackLink;
        Integer order;

        public CrossRefBuilder(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, String url) {
            Objects.requireNonNull(modelStore, "Model store can not be null");
            Objects.requireNonNull(documentUri, "Document URI can not be null");
            Objects.requireNonNull(id, "ID can not be null");
            Objects.requireNonNull(url, "URL can not be null");
            this.modelStore = modelStore;
            this.documentUri = documentUri;
            this.id = id;
            this.url = url;
            this.copyManager = copyManager;
        }

        public CrossRefBuilder setMatch(@Nullable String match) {
            this.match = match;
            return this;
        }

        public CrossRefBuilder setUrl(String url) {
            Objects.requireNonNull(url, "URL must not be null");
            this.url = url;
            return this;
        }

        public CrossRefBuilder setValid(@Nullable Boolean valid) {
            this.valid = valid;
            return this;
        }

        public CrossRefBuilder setLive(@Nullable Boolean live) {
            this.live = live;
            return this;
        }

        public CrossRefBuilder setTimestamp(@Nullable String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public CrossRefBuilder setWayBackLink(@Nullable Boolean wayBackLink) {
            this.wayBackLink = wayBackLink;
            return this;
        }

        public CrossRefBuilder setOrder(@Nullable Integer order) {
            this.order = order;
            return this;
        }

        public CrossRef build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.modelStore.enterCriticalSection(false);
            try {
                CrossRef crossRef = new CrossRef(this);
                return crossRef;
            }
            finally {
                this.modelStore.leaveCriticalSection(lock);
            }
        }
    }
}

