/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.library.model.v2.license.License;
import org.spdx.licenseTemplate.InvalidLicenseTemplateException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.storage.IModelStore;

public class SpdxListedLicense
extends License {
    Collection<CrossRef> crossRef = this.getObjectPropertyValueSet(SpdxConstantsCompatV2.PROP_CROSS_REF, CrossRef.class);

    public SpdxListedLicense(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), "http://spdx.org/licenses/", id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    public SpdxListedLicense(IModelStore modelStore, String documentUri, String id, @Nullable IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, "http://spdx.org/licenses/", id, copyManager, create);
    }

    public SpdxListedLicense(String name, String id, String text, Collection<String> sourceUrl, String comments, String standardLicenseHeader, String template, boolean osiApproved, Boolean fsfLibre, String licenseTextHtml, boolean isDeprecated, String deprecatedVersion) throws InvalidSPDXAnalysisException {
        this(id);
        this.setName(name);
        this.setLicenseText(text);
        this.setSeeAlso(sourceUrl);
        this.setComment(comments);
        this.setStandardLicenseHeader(standardLicenseHeader);
        this.setStandardLicenseTemplate(template);
        this.setOsiApproved(osiApproved);
        this.setFsfLibre(fsfLibre);
        this.setLicenseTextHtml(licenseTextHtml);
        this.setDeprecated(isDeprecated);
        this.setDeprecatedVersion(deprecatedVersion);
        this.crossRef = this.getObjectPropertyValueSet(SpdxConstantsCompatV2.PROP_CROSS_REF, CrossRef.class);
    }

    public SpdxListedLicense(Builder builder) throws InvalidSPDXAnalysisException {
        this(builder.name, builder.id, builder.text, builder.sourceUrl, builder.comments, builder.standardLicenseHeader, builder.template, builder.osiApproved, builder.fsfLibre, builder.licenseTextHtml, builder.isDeprecated, builder.deprecatedVersion);
        this.crossRef.addAll(builder.crossRefs);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        List<String> retval = super._verify(verifiedIds, specVersion);
        try {
            if (this.isDeprecated()) {
                retval.add(this.getLicenseId() + " is deprecated.");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid type for SPDX license isDeprecated");
        }
        return retval;
    }

    public String getLicenseTextHtml() throws InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        Optional licenseTextHtml = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_TEXT_HTML);
        if (licenseTextHtml.isPresent()) {
            return (String)licenseTextHtml.get();
        }
        String templateText = this.getStandardLicenseTemplate();
        if (templateText != null && !templateText.trim().isEmpty()) {
            try {
                return SpdxLicenseTemplateHelper.templateTextToHtml((String)templateText);
            }
            catch (LicenseTemplateRuleException ex) {
                throw new InvalidLicenseTemplateException("Invalid license expression found in license text for license " + this.getName() + ":" + ex.getMessage());
            }
        }
        return SpdxLicenseTemplateHelper.formatEscapeHTML((String)this.getLicenseText());
    }

    public void setLicenseTextHtml(String licenseTextHtml) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_TEXT_HTML, licenseTextHtml);
    }

    public String getLicenseHeaderHtml() throws InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        Optional licenseHeaderHtml = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_HEADER_HTML);
        if (licenseHeaderHtml.isPresent()) {
            return (String)licenseHeaderHtml.get();
        }
        String templateText = this.getStandardLicenseHeaderTemplate();
        if (templateText != null && !templateText.trim().isEmpty()) {
            try {
                return SpdxLicenseTemplateHelper.templateTextToHtml((String)templateText);
            }
            catch (LicenseTemplateRuleException ex) {
                throw new InvalidLicenseTemplateException("Invalid license expression found in standard license header for license " + this.getName() + ":" + ex.getMessage());
            }
        }
        return SpdxLicenseTemplateHelper.formatEscapeHTML((String)this.getStandardLicenseHeader());
    }

    public void setLicenseHeaderHtml(String licenseHeaderHtml) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LICENSE_HEADER_HTML, licenseHeaderHtml);
    }

    public String getDeprecatedVersion() throws InvalidSPDXAnalysisException {
        Optional depVersion = this.getStringPropertyValue(SpdxConstantsCompatV2.PROP_LIC_DEPRECATED_VERSION);
        if (depVersion.isPresent()) {
            return (String)depVersion.get();
        }
        return "";
    }

    public void setDeprecatedVersion(String deprecatedVersion) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_LIC_DEPRECATED_VERSION, deprecatedVersion);
    }

    public Collection<CrossRef> getCrossRef() throws InvalidSPDXAnalysisException {
        return this.crossRef;
    }

    public String getType() {
        return "ListedLicense";
    }

    public boolean equivalent(CoreModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        if (compare instanceof SpdxListedLicense) {
            return this.getLicenseId().equals(((SpdxListedLicense)compare).getLicenseId());
        }
        return super.equivalent(compare, ignoreRelatedElements);
    }

    @Override
    public boolean equals(Object compare) {
        if (!(compare instanceof SpdxListedLicense)) {
            return false;
        }
        return Objects.equals(this.getLicenseId(), ((SpdxListedLicense)((Object)compare)).getLicenseId());
    }

    @Override
    public int hashCode() {
        String licId = this.getLicenseId();
        if (Objects.isNull(licId)) {
            return 91;
        }
        return 0x5B ^ licId.hashCode();
    }

    public static class Builder {
        private String id;
        private String name;
        private String text;
        private Collection<String> sourceUrl;
        private String comments;
        private String standardLicenseHeader;
        private String template;
        private boolean osiApproved;
        private Boolean fsfLibre;
        private String licenseTextHtml;
        private boolean isDeprecated;
        private String deprecatedVersion;
        private List<CrossRef> crossRefs = new ArrayList<CrossRef>();

        public Builder(String id, String name, String text) {
            this.id = id;
            this.name = name;
            this.text = text;
        }

        public Builder setSourceUrl(Collection<String> sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public Builder setComments(String comments) {
            this.comments = comments;
            return this;
        }

        public Builder setStandardLicenseHeader(String standardLicenseHeader) {
            this.standardLicenseHeader = standardLicenseHeader;
            return this;
        }

        public Builder setTemplate(String template) {
            this.template = template;
            return this;
        }

        public Builder setOsiApproved(boolean osiApproved) {
            this.osiApproved = osiApproved;
            return this;
        }

        public Builder setFsfLibre(Boolean fsfLibre) {
            this.fsfLibre = fsfLibre;
            return this;
        }

        public Builder setLicenseTextHtml(String licenseTextHtml) {
            this.licenseTextHtml = licenseTextHtml;
            return this;
        }

        public Builder setIsDeprecated(boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        public Builder setDeprecatedVersion(String deprecatedVersion) {
            this.deprecatedVersion = deprecatedVersion;
            return this;
        }

        public Builder addCrossRefs(CrossRef crossRef) {
            this.crossRefs.add(crossRef);
            return this;
        }
    }
}

